/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.device;

import java.awt.Component;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.util.List;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.util.KeySensorDevice;
import org.xj3d.core.eventmodel.DeviceFactory;
import org.xj3d.device.DeviceManager;
import org.xj3d.device.InputDevice;
import org.xj3d.ui.awt.device.AWTKeySensorDevice;

public class AWTDeviceFactory
extends DeviceFactory {
    public AWTDeviceFactory(Object object, String string, Object object2, ErrorReporter errorReporter) {
        if (!(object instanceof Component)) {
            throw new IllegalArgumentException("canvas object is not a subclass of java.awt.Component");
        }
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.toolkitID = "awt";
        this.canvas = object;
        this.rendererID = string;
        this.surface = object2;
    }

    public DeviceManager[] getDeviceManagers() {
        List list = this.createDevices();
        DeviceManager[] deviceManagerArray = list.toArray(new DeviceManager[list.size()]);
        Component component = (Component)this.canvas;
        for (int i = 0; i < deviceManagerArray.length; ++i) {
            InputDevice[] inputDeviceArray = deviceManagerArray[i].getDevices();
            for (int j = 0; j < inputDeviceArray.length; ++j) {
                InputDevice inputDevice = inputDeviceArray[j];
                if (inputDevice instanceof MouseListener) {
                    component.addMouseListener((MouseListener)inputDevice);
                }
                if (inputDevice instanceof MouseMotionListener) {
                    component.addMouseMotionListener((MouseMotionListener)inputDevice);
                }
                if (inputDevice instanceof MouseWheelListener) {
                    component.addMouseWheelListener((MouseWheelListener)inputDevice);
                }
                if (!(inputDevice instanceof KeyListener)) continue;
                component.addKeyListener((KeyListener)inputDevice);
            }
        }
        return deviceManagerArray;
    }

    public KeySensorDevice getKeySensorDevice() {
        AWTKeySensorDevice aWTKeySensorDevice = new AWTKeySensorDevice();
        Component component = (Component)this.canvas;
        component.addKeyListener(aWTKeySensorDevice);
        return aWTKeySensorDevice;
    }
}

