/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.browser.ogl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.media.opengl.GLCapabilities;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.j3d.aviatrix3d.output.graphics.PbufferSurface;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsOutputDevice;
import org.web3d.browser.BrowserCore;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.protocol.X3DResourceFactory;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.renderer.ogl.browser.OGLBrowserCanvas;
import org.web3d.vrml.renderer.ogl.browser.OGLStandardBrowserCore;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.browser.X3DCommonBrowser;
import org.web3d.vrml.scripting.ecmascript.ECMAScriptEngine;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.SAIBrowser;
import org.web3d.vrml.scripting.sai.JavaSAIScriptEngine;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.X3DComponent;
import org.xj3d.core.eventmodel.ExternalView;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.ScriptManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.ScriptLoader;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.sai.BrowserConfig;
import org.xj3d.ui.awt.net.content.AWTContentHandlerFactory;

public class X3DOffscreenSurface
implements X3DComponent {
    private static final String PROPERTY_SETUP_ERR = "Error setting up system properties in X3DOffscreenSurface";
    private SAIBrowser saiBrowser;
    private PbufferSurface renderSurface;
    private OGLBrowserCanvas mainCanvas;
    private OGLStandardBrowserCore universe;

    public X3DOffscreenSurface(BrowserConfig browserConfig) {
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setDoubleBuffered(false);
        gLCapabilities.setHardwareAccelerated(true);
        this.renderSurface = new PbufferSurface(gLCapabilities, browserConfig.preferredWidth, browserConfig.preferredHeight);
        this.mainCanvas = new OGLBrowserCanvas((GraphicsOutputDevice)this.renderSurface, null, browserConfig);
        this.mainCanvas.initialize();
        this.universe = this.mainCanvas.getUniverse();
        this.setupProperties(browserConfig.textureQuality);
        this.universe = this.mainCanvas.getUniverse();
        RouteManager routeManager = this.mainCanvas.getRouteManager();
        FrameStateManager frameStateManager = this.mainCanvas.getFrameStateManager();
        WorldLoaderManager worldLoaderManager = this.mainCanvas.getWorldLoaderManager();
        ViewpointManager viewpointManager = this.mainCanvas.getViewpointManager();
        ScriptManager scriptManager = this.mainCanvas.getScriptManager();
        ScriptLoader scriptLoader = scriptManager.getScriptLoader();
        JavaSAIScriptEngine javaSAIScriptEngine = new JavaSAIScriptEngine((BrowserCore)this.universe, viewpointManager, routeManager, frameStateManager, worldLoaderManager);
        ECMAScriptEngine eCMAScriptEngine = new ECMAScriptEngine((BrowserCore)this.universe, viewpointManager, routeManager, frameStateManager, worldLoaderManager);
        scriptLoader.registerScriptingEngine((ScriptEngine)javaSAIScriptEngine);
        scriptLoader.registerScriptingEngine((ScriptEngine)eCMAScriptEngine);
        X3DCommonBrowser x3DCommonBrowser = new X3DCommonBrowser((BrowserCore)this.universe, viewpointManager, routeManager, frameStateManager, worldLoaderManager);
        ExternalEventQueue externalEventQueue = new ExternalEventQueue(null);
        this.mainCanvas.getEventModelEvaluator().addExternalView((ExternalView)externalEventQueue);
        this.saiBrowser = new SAIBrowser((BrowserCore)this.universe, x3DCommonBrowser, routeManager, frameStateManager, externalEventQueue, null, null);
        this.mainCanvas.setEnabled(true);
    }

    public ExternalBrowser getBrowser() {
        return this.saiBrowser;
    }

    public Object getImplementation() {
        return this.renderSurface;
    }

    public void shutdown() {
        try {
            this.saiBrowser.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.universe != null) {
            this.universe.dispose();
        }
    }

    private void setupProperties(final String string) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    FileNameMap fileNameMap;
                    Object object;
                    Object object2;
                    String string2 = System.getProperty("uri.content.handler.pkgs", "");
                    if (string2.indexOf("vlc.net.content") == -1) {
                        System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
                    }
                    if ((string2 = System.getProperty("uri.protocol.handler.pkgs", "")).indexOf("vlc.net.protocol") == -1) {
                        System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
                    }
                    try {
                        object2 = Class.forName("vlc.net.content.image.ImageDecoder");
                        object = ((Class)object2).newInstance();
                        string2 = System.getProperty("java.content.handler.pkgs", "");
                        if (string2.indexOf("vlc.net.content") == -1) {
                            System.setProperty("java.content.handler.pkgs", "vlc.net.content");
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    object2 = X3DOffscreenSurface.this.mainCanvas.getUniverse();
                    object = X3DOffscreenSurface.this.mainCanvas.getWorldLoaderManager();
                    Object object3 = URI.getContentHandlerFactory();
                    URIResourceStreamFactory uRIResourceStreamFactory = URI.getURIResourceStreamFactory();
                    if (!(uRIResourceStreamFactory instanceof X3DResourceFactory)) {
                        uRIResourceStreamFactory = new X3DResourceFactory(uRIResourceStreamFactory);
                        URI.setURIResourceStreamFactory((URIResourceStreamFactory)uRIResourceStreamFactory);
                    }
                    if (!(object3 instanceof AWTContentHandlerFactory)) {
                        object3 = new AWTContentHandlerFactory((BrowserCore)object2, (WorldLoaderManager)object);
                        URI.setContentHandlerFactory((ContentHandlerFactory)object3);
                    }
                    if (!((fileNameMap = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
                        fileNameMap = new VRMLFileNameMap(fileNameMap);
                        URI.setFileNameMap((FileNameMap)fileNameMap);
                    }
                    if (string.equals("medium")) {
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", "2");
                    } else if (string.equals("high")) {
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", "16");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
    }
}

