/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.browser.ogl;

import java.applet.Applet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.web3d.browser.BrowserCore;
import org.web3d.net.content.VRMLContentHandlerFactory;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.protocol.X3DResourceFactory;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.renderer.ogl.browser.OGLBrowserCanvas;
import org.web3d.vrml.renderer.ogl.browser.OGLStandardBrowserCore;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.browser.X3DCommonBrowser;
import org.web3d.vrml.scripting.ecmascript.ECMAScriptEngine;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.SAIBrowser;
import org.web3d.vrml.scripting.sai.JavaSAIScriptEngine;
import org.web3d.x3d.sai.BrowserFactoryImpl;
import org.web3d.x3d.sai.ConnectionException;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.NoSuchBrowserException;
import org.web3d.x3d.sai.NotSupportedException;
import org.web3d.x3d.sai.X3DComponent;
import org.xj3d.core.eventmodel.ExternalView;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.ScriptManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.ScriptLoader;
import org.xj3d.core.loading.WorldLoader;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.sai.BrowserConfig;

public class X3DNRBrowserFactoryImpl
implements BrowserFactoryImpl,
X3DComponent {
    private static final String NULL_PARAMETER_ERROR = "Null parameter strings not allowed.";
    private static final String MALFORMED_PARAMETER_STRING_ERROR = "Malformed parameter string.  Expecting strings of the form A=B";
    private OGLBrowserCanvas mainCanvas;
    private WorldLoaderManager worldLoader;
    private HashMap viewpointDefMap;
    private SAIBrowser saiBrowser;
    private VRMLClock clock;
    private OGLStandardBrowserCore universe;

    public X3DNRBrowserFactoryImpl() {
    }

    public X3DComponent createComponent(Map map) throws NotSupportedException {
        return new X3DNRBrowserFactoryImpl(true);
    }

    private X3DNRBrowserFactoryImpl(boolean bl) {
        this.mainCanvas = new OGLBrowserCanvas(null, null, new BrowserConfig());
        this.mainCanvas.initialize();
        this.mainCanvas.setMinimumFrameInterval(20, false);
        RouteManager routeManager = this.mainCanvas.getRouteManager();
        ViewpointManager viewpointManager = this.mainCanvas.getViewpointManager();
        this.universe = this.mainCanvas.getUniverse();
        FrameStateManager frameStateManager = this.mainCanvas.getFrameStateManager();
        this.worldLoader = this.mainCanvas.getWorldLoaderManager();
        ScriptManager scriptManager = this.mainCanvas.getScriptManager();
        ScriptLoader scriptLoader = scriptManager.getScriptLoader();
        JavaSAIScriptEngine javaSAIScriptEngine = new JavaSAIScriptEngine((BrowserCore)this.universe, viewpointManager, routeManager, frameStateManager, this.worldLoader);
        ECMAScriptEngine eCMAScriptEngine = new ECMAScriptEngine((BrowserCore)this.universe, viewpointManager, routeManager, frameStateManager, this.worldLoader);
        scriptLoader.registerScriptingEngine((ScriptEngine)javaSAIScriptEngine);
        scriptLoader.registerScriptingEngine((ScriptEngine)eCMAScriptEngine);
        this.setupProperties(this.universe, this.worldLoader);
        X3DCommonBrowser x3DCommonBrowser = new X3DCommonBrowser((BrowserCore)this.universe, viewpointManager, routeManager, frameStateManager, this.worldLoader);
        ExternalEventQueue externalEventQueue = new ExternalEventQueue(null);
        this.mainCanvas.getEventModelEvaluator().addExternalView((ExternalView)externalEventQueue);
        this.saiBrowser = new SAIBrowser((BrowserCore)this.universe, x3DCommonBrowser, routeManager, frameStateManager, externalEventQueue, null, null);
        this.clock = this.universe.getVRMLClock();
        this.mainCanvas.setEnabled(true);
    }

    public ExternalBrowser getBrowser(Applet applet) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        throw new NotSupportedException();
    }

    public ExternalBrowser getBrowser(Applet applet, String string, int n) throws NotSupportedException, NoSuchBrowserException, ConnectionException {
        throw new NotSupportedException();
    }

    public ExternalBrowser getBrowser(InetAddress inetAddress, int n) throws NotSupportedException, NoSuchBrowserException, UnknownHostException, ConnectionException {
        throw new NotSupportedException();
    }

    public ExternalBrowser getBrowser() {
        return this.saiBrowser;
    }

    public Object getImplementation() {
        return this;
    }

    public void shutdown() {
        this.saiBrowser.dispose();
    }

    public VRMLScene getScene() {
        return this.universe.getScene();
    }

    public OGLStandardBrowserCore getUniverse() {
        return this.universe;
    }

    public void loadURL(String string) throws IOException {
        URL uRL = new URL(string);
        WorldLoader worldLoader = this.worldLoader.fetchLoader();
        InputSource inputSource = new InputSource(string);
        VRMLScene vRMLScene = worldLoader.loadNow((BrowserCore)this.universe, inputSource);
        this.universe.setScene(vRMLScene, uRL.getRef());
    }

    public void loadURL(InputSource inputSource) throws IOException {
        WorldLoader worldLoader = this.worldLoader.fetchLoader();
        VRMLScene vRMLScene = worldLoader.loadNow((BrowserCore)this.universe, inputSource);
        URL uRL = new URL(inputSource.getBaseURL());
        this.universe.setScene(vRMLScene, uRL.getRef());
    }

    private void setupProperties(final BrowserCore browserCore, final WorldLoaderManager worldLoaderManager) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    FileNameMap fileNameMap;
                    ContentHandlerFactory contentHandlerFactory;
                    URIResourceStreamFactory uRIResourceStreamFactory;
                    String string = System.getProperty("uri.content.handler.pkgs", "");
                    if (string.indexOf("vlc.net.content") == -1) {
                        System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
                    }
                    if ((string = System.getProperty("uri.protocol.handler.pkgs", "")).indexOf("vlc.net.protocol") == -1) {
                        System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
                    }
                    if (!((uRIResourceStreamFactory = URI.getURIResourceStreamFactory()) instanceof X3DResourceFactory)) {
                        uRIResourceStreamFactory = new X3DResourceFactory(uRIResourceStreamFactory);
                        URI.setURIResourceStreamFactory((URIResourceStreamFactory)uRIResourceStreamFactory);
                    }
                    if (!((contentHandlerFactory = URI.getContentHandlerFactory()) instanceof VRMLContentHandlerFactory)) {
                        contentHandlerFactory = new VRMLContentHandlerFactory(browserCore, worldLoaderManager);
                        URI.setContentHandlerFactory((ContentHandlerFactory)contentHandlerFactory);
                    }
                    if (!((fileNameMap = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
                        fileNameMap = new VRMLFileNameMap(fileNameMap);
                        URI.setFileNameMap((FileNameMap)fileNameMap);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Error setting Properties in BrowserJPanel");
        }
    }
}

