/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.browser.ogl;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.media.opengl.GLCapabilities;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.ietf.uri.URL;
import org.j3d.aviatrix3d.output.graphics.ElumensAWTSurface;
import org.j3d.aviatrix3d.output.graphics.SimpleAWTSurface;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsOutputDevice;
import org.web3d.browser.BrowserComponent;
import org.web3d.browser.BrowserCore;
import org.web3d.net.content.VRMLContentHandlerFactory;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.protocol.X3DResourceFactory;
import org.web3d.util.ErrorReporter;
import org.web3d.util.FileHandler;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.renderer.ogl.browser.OGLBrowserCanvas;
import org.web3d.vrml.renderer.ogl.browser.OGLStandardBrowserCore;
import org.web3d.vrml.sav.VRMLParseException;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.browser.X3DCommonBrowser;
import org.web3d.vrml.scripting.ecmascript.ECMAScriptEngine;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.sai.SAIBrowser;
import org.web3d.vrml.scripting.sai.JavaSAIScriptEngine;
import org.web3d.x3d.sai.ExternalBrowser;
import org.web3d.x3d.sai.X3DComponent;
import org.xj3d.core.eventmodel.ExternalView;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.ScriptManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.ScriptLoader;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.sai.BrowserConfig;
import org.xj3d.ui.awt.browser.ogl.SampleChooser;
import org.xj3d.ui.awt.device.AWTDeviceFactory;
import org.xj3d.ui.awt.widgets.AWTConsoleWindow;
import org.xj3d.ui.awt.widgets.CursorManager;
import org.xj3d.ui.awt.widgets.LoadURLAction;

public class X3DBrowserAWTPanel
extends Panel
implements X3DComponent,
BrowserComponent,
KeyListener,
ComponentListener,
WindowListener,
Runnable,
FileHandler {
    private static final String BROWSER_BUTTON_PROPERTY = "CONSOLE.button";
    private static final String DEFAULT_BROWSER_BUTTON = "images/navigation/ButtonConsole.gif";
    private static final String BROWSER_OPEN_PROPERTY = "OPEN.button";
    private static final String DEFAULT_OPEN_BUTTON = "images/locationbar/openIcon32x32.gif";
    private static final String BROWSER_RELOAD_PROPERTY = "RELOAD.button";
    private static final String DEFAULT_RELOAD_BUTTON = "images/locationbar/reloadIcon32x32.gif";
    private static final int PAUSED_FPS = 1;
    private SAIBrowser saiBrowser;
    private GLCapabilities caps;
    private Canvas glCanvas;
    private OGLBrowserCanvas mainCanvas;
    private OGLStandardBrowserCore universe;
    protected CursorManager cursorManager;
    private ViewpointManager vpManager;
    private WorldLoaderManager worldLoader;
    private TextField urlTextField;
    private Button locationGoButton;
    private Button openButton;
    private Button reloadButton;
    private Label statusLabel;
    private Label descriptionLabel;
    private Label urlLabel;
    private Label fpsLabel;
    private AWTConsoleWindow console;
    private int numSamples;
    private boolean maxChooserStarted;
    private SampleChooser sampleChooser;
    private boolean wireframe;
    private boolean pointrender;
    private boolean showFPS;
    private int frameMillis;
    private float lastFPS;
    private boolean elumensMode;
    private boolean firstFocused;

    public X3DBrowserAWTPanel(BrowserConfig browserConfig) {
        super(new BorderLayout());
        Properties properties = browserConfig.browserSkin == null ? new Properties() : browserConfig.browserSkin;
        this.numSamples = 1;
        this.firstFocused = false;
        this.frameMillis = -1;
        this.wireframe = false;
        this.maxChooserStarted = false;
        this.elumensMode = false;
        this.showFPS = this.showFPS;
        this.setSize(800, 600);
        this.caps = new GLCapabilities();
        this.caps.setDoubleBuffered(true);
        this.caps.setHardwareAccelerated(true);
        if (browserConfig.antialiased) {
            this.caps.setSampleBuffers(true);
            if (browserConfig.antialiasingQuality.equals("low")) {
                this.numSamples = 2;
                this.caps.setNumSamples(this.numSamples);
            } else if (browserConfig.antialiasingQuality.equals("medium")) {
                System.out.println("Trying for 4 samples of antialiasing.");
                this.numSamples = 4;
                this.caps.setNumSamples(this.numSamples);
            } else if (browserConfig.antialiasingQuality.equals("high")) {
                System.out.println("Trying for 8 samples of antialiasing.");
                this.numSamples = 8;
                this.caps.setNumSamples(this.numSamples);
            }
        }
        this.console = new AWTConsoleWindow();
        this.console.messageReport("Initializing OpenGL X3D browser.\n");
        SimpleAWTSurface simpleAWTSurface = new SimpleAWTSurface(this.caps);
        this.glCanvas = (Canvas)simpleAWTSurface.getSurfaceObject();
        AWTDeviceFactory aWTDeviceFactory = new AWTDeviceFactory(this.glCanvas, "aviatrix3d", simpleAWTSurface, (ErrorReporter)this.console);
        this.mainCanvas = new OGLBrowserCanvas((GraphicsOutputDevice)simpleAWTSurface, aWTDeviceFactory, browserConfig);
        this.mainCanvas.initialize();
        this.mainCanvas.setErrorReporter((ErrorReporter)this.console);
        this.glCanvas.addComponentListener(this);
        this.glCanvas.addKeyListener(this);
        this.descriptionLabel = new Label();
        this.urlLabel = new Label();
        this.add((Component)this.glCanvas, "Center");
        RouteManager routeManager = this.mainCanvas.getRouteManager();
        this.vpManager = this.mainCanvas.getViewpointManager();
        this.cursorManager = new CursorManager(this.glCanvas, properties, (ErrorReporter)this.console);
        this.universe = this.mainCanvas.getUniverse();
        this.universe.addSensorStatusListener(this.cursorManager);
        this.universe.addNavigationStateListener(this.cursorManager);
        FrameStateManager frameStateManager = this.mainCanvas.getFrameStateManager();
        this.worldLoader = this.mainCanvas.getWorldLoaderManager();
        ScriptManager scriptManager = this.mainCanvas.getScriptManager();
        ScriptLoader scriptLoader = scriptManager.getScriptLoader();
        JavaSAIScriptEngine javaSAIScriptEngine = new JavaSAIScriptEngine((BrowserCore)this.universe, this.vpManager, routeManager, frameStateManager, this.worldLoader);
        javaSAIScriptEngine.setErrorReporter((ErrorReporter)this.console);
        ECMAScriptEngine eCMAScriptEngine = new ECMAScriptEngine((BrowserCore)this.universe, this.vpManager, routeManager, frameStateManager, this.worldLoader);
        eCMAScriptEngine.setErrorReporter((ErrorReporter)this.console);
        scriptLoader.registerScriptingEngine((ScriptEngine)javaSAIScriptEngine);
        scriptLoader.registerScriptingEngine((ScriptEngine)eCMAScriptEngine);
        this.setupProperties(this.universe, this.worldLoader, browserConfig.textureQuality);
        X3DCommonBrowser x3DCommonBrowser = new X3DCommonBrowser((BrowserCore)this.universe, this.vpManager, routeManager, frameStateManager, this.worldLoader);
        x3DCommonBrowser.setErrorReporter((ErrorReporter)this.console);
        ExternalEventQueue externalEventQueue = new ExternalEventQueue((ErrorReporter)this.console);
        this.mainCanvas.getEventModelEvaluator().addExternalView((ExternalView)externalEventQueue);
        this.saiBrowser = new SAIBrowser((BrowserCore)this.universe, x3DCommonBrowser, routeManager, frameStateManager, externalEventQueue, (org.xj3d.core.eventmodel.CursorManager)this.cursorManager, (ErrorReporter)this.console);
        this.urlTextField = new TextField();
        this.statusLabel = new Label();
        this.fpsLabel = new Label();
        if (browserConfig.showUrl) {
            Object object;
            Label label = new Label(" Location: ");
            this.locationGoButton = new Button(" Go! ");
            this.locationGoButton.setEnabled(!browserConfig.urlReadOnly);
            this.urlTextField.setEditable(!browserConfig.urlReadOnly);
            if (!browserConfig.urlReadOnly) {
                object = new LoadURLAction((FileHandler)this, this.urlTextField);
                this.locationGoButton.addActionListener((ActionListener)object);
                this.urlTextField.addActionListener((ActionListener)object);
            }
            object = new Panel(new BorderLayout());
            ((Container)object).add((Component)label, "West");
            ((Container)object).add((Component)this.locationGoButton, "East");
            ((Container)object).add((Component)this.urlTextField, "Center");
            if (browserConfig.showOpenButton || browserConfig.showReloadButton) {
                Panel panel = new Panel(new BorderLayout());
                Panel panel2 = new Panel(new BorderLayout());
                if (browserConfig.showOpenButton) {
                    this.openButton = new Button("Open");
                    panel.add((Component)this.openButton, "West");
                }
                if (browserConfig.showReloadButton) {
                    this.reloadButton = new Button("Reload");
                    panel.add((Component)this.reloadButton, "East");
                }
                panel2.add((Component)panel, "West");
                panel2.add((Component)object, "Center");
                if (browserConfig.urlTop) {
                    this.add((Component)panel2, "North");
                } else {
                    this.add((Component)panel2, "South");
                }
            } else if (browserConfig.urlTop) {
                this.add((Component)object, "North");
            } else {
                this.add((Component)object, "South");
            }
        }
        if (browserConfig.showDash) {
            this.add((Component)this.descriptionLabel, "South");
            this.add((Component)this.urlLabel, "North");
        }
        if (browserConfig.showConsole) {
            this.console.setVisible(true);
        }
        if (browserConfig.showFPS) {
            new Thread(this).start();
        }
        this.getMaximumNumSamples();
    }

    public ExternalBrowser getBrowser() {
        return this.saiBrowser;
    }

    public Object getImplementation() {
        return this;
    }

    public void shutdown() {
        this.saiBrowser.dispose();
    }

    public int supportedSpecificationVersion() {
        return 3;
    }

    public Object getCanvas() {
        return this.glCanvas;
    }

    public int getRendererType() {
        return this.universe.getRendererType();
    }

    public BrowserCore getBrowserCore() {
        return this.universe;
    }

    public ErrorReporter getErrorReporter() {
        return this.console;
    }

    public void setMinimumFrameInterval(int n, boolean bl) {
        this.mainCanvas.setMinimumFrameInterval(n, bl);
    }

    public void start() {
        this.mainCanvas.setEnabled(true);
    }

    public void stop() {
        this.mainCanvas.setEnabled(false);
    }

    public void destroy() {
        this.mainCanvas.setEnabled(false);
        this.mainCanvas.browserShutdown();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 65: {
                if ((keyEvent.getModifiers() & 8) == 0) break;
                this.numSamples *= 2;
                int n = this.getMaximumNumSamples();
                while (n < 0) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    n = this.getMaximumNumSamples();
                }
                if (this.numSamples > n) {
                    this.numSamples = 1;
                }
                this.statusLabel.setText("Antialiasing samples: " + this.numSamples + " out of max: " + n);
                this.caps.setSampleBuffers(true);
                this.caps.setNumSamples(this.numSamples);
                this.resetSurface();
                break;
            }
            case 34: {
                this.vpManager.nextViewpoint();
                break;
            }
            case 33: {
                this.vpManager.previousViewpoint();
                break;
            }
            case 36: {
                this.vpManager.firstViewpoint();
                break;
            }
            case 35: {
                this.vpManager.lastViewpoint();
                break;
            }
            case 70: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.universe.setNavigationMode("FLY");
                break;
            }
            case 80: {
                if ((keyEvent.getModifiers() & 8) == 0) break;
                boolean bl = this.pointrender = !this.pointrender;
                if (this.pointrender) {
                    this.statusLabel.setText("Point rendering mode enabled");
                    this.universe.setRenderingStyle(1);
                    break;
                }
                if (this.wireframe) {
                    this.statusLabel.setText("Wireframe rendering mode enabled");
                    this.universe.setRenderingStyle(2);
                    break;
                }
                this.statusLabel.setText("Shaded rendering mode disabled");
                this.universe.setRenderingStyle(4);
                break;
            }
            case 87: {
                if ((keyEvent.getModifiers() & 2) != 0) {
                    this.universe.setNavigationMode("WALK");
                    break;
                }
                if ((keyEvent.getModifiers() & 8) == 0) break;
                boolean bl = this.wireframe = !this.wireframe;
                if (this.wireframe) {
                    this.statusLabel.setText("Wireframe rendering mode enabled");
                    this.universe.setRenderingStyle(2);
                    break;
                }
                if (this.pointrender) {
                    this.statusLabel.setText("Point rendering mode enabled");
                    this.universe.setRenderingStyle(1);
                    break;
                }
                this.statusLabel.setText("Shaded rendering mode disabled");
                this.universe.setRenderingStyle(4);
                break;
            }
            case 69: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.universe.setNavigationMode("EXAMINE");
                break;
            }
            case 90: {
                if ((keyEvent.getModifiers() & 8) == 0) break;
                this.elumensMode = !this.elumensMode;
                this.resetSurface();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.mainCanvas.setMinimumFrameInterval(1000, false);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        Container container;
        Container container2 = this.getParent();
        while ((container = container2.getParent()) != null) {
            container2 = container;
        }
        ((Window)container2).addWindowListener(this);
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (this.frameMillis < 0) {
            this.mainCanvas.setMinimumFrameInterval(0, false);
        } else {
            this.mainCanvas.setMinimumFrameInterval(this.frameMillis, false);
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        if (this.frameMillis < 0) {
            this.mainCanvas.setMinimumFrameInterval(0, false);
        } else {
            this.mainCanvas.setMinimumFrameInterval(this.frameMillis, false);
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.mainCanvas.setMinimumFrameInterval(1000, false);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void loadURL(String string) throws IOException {
        Object object;
        this.urlTextField.setText(string);
        URL uRL = new URL(string);
        VRMLScene vRMLScene = null;
        long l = System.currentTimeMillis();
        try {
            object = uRL.getResource();
            Object object2 = object.getContent();
            if (!(object2 instanceof VRMLScene)) {
                if (object2 != null) {
                    System.out.println("Type: " + object2.getClass().toString());
                }
                return;
            }
            vRMLScene = (VRMLScene)object2;
        }
        catch (IOException iOException) {
            return;
        }
        catch (VRMLParseException vRMLParseException) {
            this.console.errorReport("Exception parsing file at line: " + vRMLParseException.getLineNumber() + " col: " + vRMLParseException.getColumnNumber() + "\n" + vRMLParseException.getMessage(), (Exception)((Object)vRMLParseException));
        }
        catch (Exception exception) {
            this.console.errorReport("Unexpected exception during parsing", exception);
        }
        if (vRMLScene == null) {
            return;
        }
        object = uRL.getRef();
        this.universe.setScene(vRMLScene, (String)object);
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.firstFocused) {
                this.glCanvas.requestFocus();
                this.firstFocused = this.glCanvas.isFocusOwner();
            }
            this.displayFPS();
        }
    }

    private int getMaximumNumSamples() {
        int n = -1;
        if (!this.maxChooserStarted) {
            this.sampleChooser = new SampleChooser();
            Thread thread = new Thread(this.sampleChooser);
            thread.start();
            n = this.sampleChooser.getMaxSamples();
            this.maxChooserStarted = true;
        } else {
            n = this.sampleChooser.getMaxSamples();
        }
        return n;
    }

    private void resetSurface() {
        ElumensAWTSurface elumensAWTSurface;
        this.remove(this.glCanvas);
        this.glCanvas.removeComponentListener(this);
        this.glCanvas.removeKeyListener(this);
        if (this.elumensMode) {
            elumensAWTSurface = new ElumensAWTSurface(this.caps);
            elumensAWTSurface.setNumberOfChannels(3);
            this.universe.setHardwareFOV(180.0f);
        } else {
            elumensAWTSurface = new SimpleAWTSurface(this.caps);
            this.universe.setHardwareFOV(0.0f);
        }
        this.glCanvas = (Canvas)elumensAWTSurface.getSurfaceObject();
        AWTDeviceFactory aWTDeviceFactory = new AWTDeviceFactory(this.glCanvas, "aviatrix3d", elumensAWTSurface, (ErrorReporter)this.console);
        this.mainCanvas.setSurface((GraphicsOutputDevice)elumensAWTSurface, aWTDeviceFactory);
        this.add(this.glCanvas);
        this.glCanvas.addComponentListener(this);
        this.glCanvas.addKeyListener(this);
        this.firstFocused = false;
    }

    private void displayFPS() {
        float f = this.universe.getCurrentFrameRate();
        if ((double)Math.abs(this.lastFPS - f) > 0.01) {
            String string = Float.toString(this.universe.getCurrentFrameRate());
            int n = string.length();
            if (n > 0) {
                this.fpsLabel.setText(string.substring(0, Math.min(5, n)));
            }
            this.lastFPS = f;
        }
    }

    private void setupProperties(final BrowserCore browserCore, final WorldLoaderManager worldLoaderManager, final String string) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    FileNameMap fileNameMap;
                    ContentHandlerFactory contentHandlerFactory;
                    URIResourceStreamFactory uRIResourceStreamFactory;
                    String string2 = System.getProperty("uri.content.handler.pkgs", "");
                    if (string2.indexOf("vlc.net.content") == -1) {
                        System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
                    }
                    if ((string2 = System.getProperty("uri.protocol.handler.pkgs", "")).indexOf("vlc.net.protocol") == -1) {
                        System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
                    }
                    if (!((uRIResourceStreamFactory = URI.getURIResourceStreamFactory()) instanceof X3DResourceFactory)) {
                        uRIResourceStreamFactory = new X3DResourceFactory(uRIResourceStreamFactory);
                        URI.setURIResourceStreamFactory((URIResourceStreamFactory)uRIResourceStreamFactory);
                    }
                    if (!((contentHandlerFactory = URI.getContentHandlerFactory()) instanceof VRMLContentHandlerFactory)) {
                        contentHandlerFactory = new VRMLContentHandlerFactory(browserCore, worldLoaderManager);
                        URI.setContentHandlerFactory((ContentHandlerFactory)contentHandlerFactory);
                    }
                    if (!((fileNameMap = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
                        fileNameMap = new VRMLFileNameMap(fileNameMap);
                        URI.setFileNameMap((FileNameMap)fileNameMap);
                    }
                    if (string.equals("medium")) {
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", "2");
                    } else if (string.equals("high")) {
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", "16");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Error setting Properties in BrowserJPanel");
        }
    }

    public void addNotify() {
        super.addNotify();
        this.mainCanvas.setEnabled(true);
    }
}

