/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.browser.ogl;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.web3d.browser.BrowserCore;
import org.web3d.net.protocol.VRML97ResourceFactory;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.renderer.DefaultNodeFactory;
import org.web3d.vrml.renderer.ogl.browser.OGLStandardBrowserCore;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.browser.VRML97CommonBrowser;
import org.web3d.vrml.scripting.ecmascript.JavascriptScriptEngine;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.eai.EAIBrowser;
import org.web3d.vrml.scripting.jsai.VRML97ScriptEngine;
import org.xj3d.core.eventmodel.ExternalView;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.ScriptManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.ScriptLoader;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.impl.core.loading.FramerateThrottle;
import org.xj3d.sai.BrowserConfig;
import org.xj3d.ui.awt.browser.ogl.BrowserJPanel;
import vrml.eai.Browser;
import vrml.eai.VrmlComponent;

public class VRMLBrowserJPanel
extends BrowserJPanel
implements VrmlComponent {
    private static final String PROPERTY_SETUP_ERR = "Error setting up system properties in VRMLBrowserJPanel";
    private EAIBrowser eaiBrowser;

    public VRMLBrowserJPanel(BrowserConfig browserConfig) {
        super(browserConfig);
        VRMLNodeFactory vRMLNodeFactory;
        this.setupProperties();
        RouteManager routeManager = this.mainCanvas.getRouteManager();
        FrameStateManager frameStateManager = this.mainCanvas.getFrameStateManager();
        WorldLoaderManager worldLoaderManager = this.mainCanvas.getWorldLoaderManager();
        ViewpointManager viewpointManager = this.mainCanvas.getViewpointManager();
        ScriptManager scriptManager = this.mainCanvas.getScriptManager();
        ScriptLoader scriptLoader = scriptManager.getScriptLoader();
        VRML97ScriptEngine vRML97ScriptEngine = new VRML97ScriptEngine((BrowserCore)this.universe, routeManager, frameStateManager, worldLoaderManager);
        vRML97ScriptEngine.setErrorReporter((ErrorReporter)this.console);
        JavascriptScriptEngine javascriptScriptEngine = new JavascriptScriptEngine((BrowserCore)this.universe, routeManager, frameStateManager, worldLoaderManager);
        javascriptScriptEngine.setErrorReporter((ErrorReporter)this.console);
        scriptLoader.registerScriptingEngine((ScriptEngine)vRML97ScriptEngine);
        scriptLoader.registerScriptingEngine((ScriptEngine)javascriptScriptEngine);
        switch (this.universe.getRendererType()) {
            case 3: {
                vRMLNodeFactory = DefaultNodeFactory.newInstance("ogl");
                break;
            }
            default: {
                vRMLNodeFactory = DefaultNodeFactory.newInstance("null");
            }
        }
        vRMLNodeFactory.setSpecVersion(2, 0);
        vRMLNodeFactory.setProfile("VRML97");
        VRML97CommonBrowser vRML97CommonBrowser = new VRML97CommonBrowser((BrowserCore)this.universe, routeManager, frameStateManager, worldLoaderManager, vRMLNodeFactory);
        vRML97CommonBrowser.setErrorReporter((ErrorReporter)this.console);
        ExternalEventQueue externalEventQueue = new ExternalEventQueue((ErrorReporter)this.console);
        this.mainCanvas.getEventModelEvaluator().addExternalView((ExternalView)externalEventQueue);
        this.eaiBrowser = new EAIBrowser((BrowserCore)this.universe, vRML97CommonBrowser, externalEventQueue, (ErrorReporter)this.console);
        this.eaiBrowser.initializeWorld();
        if (this.locToolbar != null) {
            FramerateThrottle framerateThrottle = new FramerateThrottle((BrowserCore)this.universe, (ErrorReporter)this.console);
            framerateThrottle.setScriptLoader(scriptLoader);
            framerateThrottle.setLoadManager(this.mainCanvas.getContentLoadManager());
            this.locToolbar.setThrottle(framerateThrottle);
        }
    }

    public Browser getBrowser() {
        return this.eaiBrowser;
    }

    private void setupProperties() {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    OGLStandardBrowserCore oGLStandardBrowserCore = VRMLBrowserJPanel.this.mainCanvas.getUniverse();
                    WorldLoaderManager worldLoaderManager = VRMLBrowserJPanel.this.mainCanvas.getWorldLoaderManager();
                    URIResourceStreamFactory uRIResourceStreamFactory = URI.getURIResourceStreamFactory();
                    if (!(uRIResourceStreamFactory instanceof VRML97ResourceFactory)) {
                        uRIResourceStreamFactory = new VRML97ResourceFactory(uRIResourceStreamFactory);
                        URI.setURIResourceStreamFactory((URIResourceStreamFactory)uRIResourceStreamFactory);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.console.warningReport(PROPERTY_SETUP_ERR, null);
        }
    }
}

