/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.browser.ogl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.NumberFormat;
import javax.imageio.ImageIO;
import javax.media.opengl.GLDrawable;
import org.web3d.browser.ScreenCaptureListener;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.time.BaseTimeSensor;
import org.web3d.vrml.renderer.ogl.browser.OGLStandardBrowserCore;
import org.xj3d.core.eventmodel.TimeSensorManager;
import org.xj3d.impl.core.eventmodel.VirtualTimeSensorManager;
import org.xj3d.ui.construct.event.RecorderEvent;
import org.xj3d.ui.construct.event.RecorderListener;
import org.xj3d.ui.construct.ogl.OGLConstruct;

public class TimeSensorSceneRecorder
implements ScreenCaptureListener,
VRMLNodeListener {
    private static final String LOG_NAME = "TimeSensorSceneRecorder";
    protected OGLConstruct construct;
    protected OGLStandardBrowserCore core;
    protected VirtualTimeSensorManager clock;
    protected ErrorReporter errorReporter;
    protected Object canvas;
    protected int number;
    protected NumberFormat fmt;
    protected BaseTimeSensor timeSensor;
    protected String timeSensorName = "TIME";
    protected int fraction_changed_index;
    protected File outputDir;
    protected RecorderListener listener;
    protected boolean recordingComplete;
    protected int width;
    protected int height;
    protected String type = "png";
    protected long fileTime;
    protected long renderTime;
    protected long startFrameTime;

    public TimeSensorSceneRecorder(OGLConstruct oGLConstruct) {
        if (oGLConstruct == null) {
            throw new IllegalArgumentException("TimeSensorSceneRecorder: construct instance must be non-null");
        }
        TimeSensorManager timeSensorManager = oGLConstruct.getTimeSensorManager();
        if (!(timeSensorManager instanceof VirtualTimeSensorManager)) {
            throw new IllegalArgumentException("TimeSensorSceneRecorder: TimeSensorManager must be an instanceof VirtualTimeSensorManager");
        }
        this.construct = oGLConstruct;
        this.errorReporter = oGLConstruct.getErrorReporter();
        this.core = oGLConstruct.getBrowserCore();
        this.clock = (VirtualTimeSensorManager)timeSensorManager;
        this.canvas = oGLConstruct.getGraphicsObject();
        this.fmt = NumberFormat.getIntegerInstance();
        this.fmt.setMinimumIntegerDigits(5);
        this.fmt.setGroupingUsed(false);
    }

    public void screenCaptured(Buffer buffer, int n, int n2) {
        this.renderTime += System.nanoTime() - this.startFrameTime;
        String string = this.fmt.format(this.number);
        this.saveScreen(buffer, string, n, n2);
        ++this.number;
        if (this.recordingComplete) {
            this.stop();
            this.timeSensor.removeNodeListener((VRMLNodeListener)this);
            if (this.listener != null) {
                this.listener.recorderStatusChanged(new RecorderEvent(this, 1380253697, this.number));
            }
        } else {
            this.startFrameTime = System.nanoTime();
            this.clock.tick();
        }
    }

    public void fieldChanged(int n) {
        float f;
        if (n == this.fraction_changed_index && (f = this.timeSensor.getFraction()) == 1.0f && this.number != 0) {
            this.recordingComplete = true;
        }
    }

    public double getAverageRenderTime() {
        return (double)(this.renderTime / (long)this.number) / 1000000.0;
    }

    public double getAverageFileTime() {
        return (double)(this.fileTime / (long)this.number) / 1000000.0;
    }

    public void setEncoding(String string) {
        boolean bl = false;
        String[] stringArray = ImageIO.getWriterFormatNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            this.type = string;
            bl = true;
            break;
        }
        if (!bl) {
            this.errorReporter.errorReport("TimeSensorSceneRecorder: Unknown image encoding type: " + string + ", defaulting to: " + this.type, null);
        }
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setFrameRate(int n) {
        int n2 = (int)(1000.0 / (double)n);
        this.clock.setTickIncrement(n2);
    }

    public void setOutputDirectory(File file) {
        this.outputDir = file;
    }

    public void setTimeSensorName(String string) {
        this.timeSensorName = string;
    }

    public void start(RecorderListener recorderListener) {
        Dimension dimension;
        this.fileTime = 0L;
        this.renderTime = 0L;
        if (this.outputDir == null) {
            this.errorReporter.warningReport("TimeSensorSceneRecorder: Unable to record, output directory is not initialized.", null);
            return;
        }
        this.listener = recorderListener;
        int n = 0;
        int n2 = 0;
        if (this.canvas instanceof Component) {
            dimension = ((Component)this.canvas).getSize();
            n = (int)dimension.getWidth();
            n2 = (int)dimension.getHeight();
        } else if (this.canvas instanceof GLDrawable) {
            n = ((GLDrawable)this.canvas).getWidth();
            n2 = ((GLDrawable)this.canvas).getHeight();
        }
        if (n > 0 && n2 > 0) {
            this.width = n;
            this.height = n2;
        }
        this.number = 0;
        this.recordingComplete = false;
        dimension = this.core.getScene();
        VRMLNodeType vRMLNodeType = (VRMLNodeType)dimension.getDEFNodes().get(this.timeSensorName);
        if (vRMLNodeType != null) {
            this.timeSensor = (BaseTimeSensor)vRMLNodeType;
            this.fraction_changed_index = this.timeSensor.getFieldIndex("fraction_changed");
            this.timeSensor.addNodeListener((VRMLNodeListener)this);
            this.startFrameTime = System.nanoTime();
            this.core.captureScreenStart(this);
            if (recorderListener != null) {
                recorderListener.recorderStatusChanged(new RecorderEvent(this, 1380253696, this.number));
            }
        } else {
            this.errorReporter.warningReport("TimeSensorSceneRecorder: Unable to record, No TimeSensor named " + this.timeSensorName + " found.", null);
        }
    }

    public void stop() {
        this.core.captureScreenEnd();
    }

    public void saveScreen(Buffer buffer, String string, int n, int n2) {
        String string2 = string;
        ByteBuffer byteBuffer = (ByteBuffer)buffer;
        int[] nArray = new int[n * n2];
        int n3 = n * n2 * 3;
        int n4 = 0;
        int n5 = n * 3;
        for (int i = 0; i < n2; ++i) {
            int n6 = n3 -= n5;
            for (int j = 0; j < n; ++j) {
                byte by = byteBuffer.get(n6++);
                byte by2 = byteBuffer.get(n6++);
                byte by3 = byteBuffer.get(n6++);
                nArray[n4++] = 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
            }
        }
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        File file = new File(this.outputDir, string2 + "." + this.type);
        try {
            this.errorReporter.messageReport("TimeSensorSceneRecorder: Writing image file: " + file);
            long l = System.nanoTime();
            ImageIO.write((RenderedImage)bufferedImage, this.type, file);
            this.fileTime += System.nanoTime() - l;
        }
        catch (IOException iOException) {
            this.errorReporter.errorReport("TimeSensorSceneRecorder: Error writing image file: " + file, (Exception)iOException);
        }
    }
}

