/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.browser.ogl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import javax.media.opengl.GLDrawable;
import org.web3d.browser.ScreenCaptureListener;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.renderer.common.nodes.navigation.BaseViewpoint;
import org.web3d.vrml.renderer.ogl.browser.OGLStandardBrowserCore;
import org.web3d.vrml.renderer.ogl.nodes.navigation.OGLNavigationInfo;
import org.xj3d.ui.construct.event.RecorderEvent;
import org.xj3d.ui.construct.event.RecorderListener;
import org.xj3d.ui.construct.ogl.AutoConfigureViewpoint;
import org.xj3d.ui.construct.ogl.OGLConstruct;

public class ThumbnailRecorder
implements ScreenCaptureListener,
VRMLNodeListener,
FrameStateListener {
    private static final String DEFAULT_VIEWPOINT = "ICON_VIEWPOINT";
    private static final String LOG_NAME = "ThumbnailRecorder";
    private static final double NANOS_PER_MILLI = 1000000.0;
    protected OGLConstruct construct;
    protected OGLStandardBrowserCore core;
    protected ErrorReporter errorReporter;
    protected Object canvas;
    protected OGLNavigationInfo navInfo;
    protected VRMLWorldRootNodeType root;
    protected boolean addNodes;
    protected FrameStateManager fsm;
    protected boolean configComplete;
    protected int number;
    protected String viewpointName = "ICON_VIEWPOINT";
    protected BaseViewpoint viewpoint;
    protected int isBound_index;
    protected File outputFile;
    protected RecorderListener listener;
    protected boolean replaceNavInfo;
    protected boolean headlight;
    protected int width;
    protected int height;
    protected String type = "png";
    protected boolean hasAlpha;
    protected String[] alphaTypes = new String[]{"png", "gif"};
    protected long fileTime;
    protected long renderTime;
    protected long startFrameTime;
    protected boolean postProcess;
    protected int snapRGB;
    protected int imageARGB;

    public ThumbnailRecorder(OGLConstruct oGLConstruct, boolean bl, boolean bl2) {
        if (oGLConstruct == null) {
            throw new IllegalArgumentException("ThumbnailRecorder: construct instance must be non-null");
        }
        this.headlight = bl2;
        this.replaceNavInfo = bl;
        this.construct = oGLConstruct;
        this.fsm = oGLConstruct.getFrameStateManager();
        this.errorReporter = oGLConstruct.getErrorReporter();
        this.core = oGLConstruct.getBrowserCore();
        this.canvas = oGLConstruct.getGraphicsObject();
    }

    public void screenCaptured(Buffer buffer, int n, int n2) {
        this.renderTime += System.nanoTime() - this.startFrameTime;
        this.saveScreen(buffer, n, n2);
        ++this.number;
        if (this.listener != null) {
            this.listener.recorderStatusChanged(new RecorderEvent(this, 1380253697, this.number));
        }
    }

    public void fieldChanged(int n) {
        if (n == this.isBound_index) {
            this.initiateCapture();
            this.viewpoint.removeNodeListener((VRMLNodeListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allEventsComplete() {
        if (this.addNodes) {
            this.root.addChild((VRMLNodeType)this.navInfo);
            int n = this.navInfo.getFieldIndex("set_bind");
            this.navInfo.setValue(n, true);
            this.navInfo.setupFinished();
            this.addNodes = false;
            this.fsm.addEndOfThisFrameListener((FrameStateListener)this);
        } else {
            ThumbnailRecorder thumbnailRecorder = this;
            synchronized (thumbnailRecorder) {
                this.configComplete = true;
                this.notify();
            }
        }
    }

    public double getRenderTime() {
        return (double)(this.renderTime / (long)this.number) / 1000000.0;
    }

    public double getFileTime() {
        return (double)(this.fileTime / (long)this.number) / 1000000.0;
    }

    public boolean setEncoding(String string) {
        int n;
        boolean bl = false;
        String[] stringArray = ImageIO.getWriterFormatNames();
        for (n = 0; n < stringArray.length; ++n) {
            if (!string.equals(stringArray[n])) continue;
            this.type = string;
            bl = true;
            break;
        }
        this.hasAlpha = false;
        if (!bl) {
            this.errorReporter.errorReport("ThumbnailRecorder: Unknown image encoding type: " + string, null);
        } else {
            for (n = 0; n < this.alphaTypes.length; ++n) {
                if (!string.equalsIgnoreCase(this.alphaTypes[n])) continue;
                this.hasAlpha = true;
                break;
            }
        }
        return bl;
    }

    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public void setBackgroundColor(Color color, Color color2) {
        this.postProcess = color != null & color2 != null;
        if (this.postProcess) {
            this.snapRGB = 0xFFFFFF & color.getRGB();
            this.imageARGB = color2.getRGB();
        }
    }

    public boolean setOutputFile(File file) {
        this.outputFile = null;
        String string = file.toString();
        int n = string.lastIndexOf(".");
        if (n == -1) {
            this.errorReporter.errorReport("ThumbnailRecorder: Invalid output file: Unknown image encoding type for file name: " + string, null);
        } else if (this.setEncoding(string.substring(n + 1))) {
            this.outputFile = file;
        }
        return this.outputFile != null;
    }

    public void setViewpointName(String string) {
        this.viewpointName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(RecorderListener recorderListener) {
        Object object;
        VRMLNodeFactory vRMLNodeFactory;
        Object object2;
        this.fileTime = 0L;
        this.renderTime = 0L;
        if (this.outputFile == null) {
            this.errorReporter.warningReport("ThumbnailRecorder: Unable to record, output file is not initialized.", null);
            return;
        }
        this.listener = recorderListener;
        int n = 0;
        int n2 = 0;
        if (this.canvas instanceof Component) {
            object2 = ((Component)this.canvas).getSize();
            n = (int)((Dimension)object2).getWidth();
            n2 = (int)((Dimension)object2).getHeight();
        } else if (this.canvas instanceof GLDrawable) {
            n = ((GLDrawable)this.canvas).getWidth();
            n2 = ((GLDrawable)this.canvas).getHeight();
        }
        if (n > 0 && n2 > 0) {
            this.width = n;
            this.height = n2;
        }
        this.number = 0;
        if (this.replaceNavInfo) {
            object2 = this.core.getScene();
            vRMLNodeFactory = object2.getNodeFactory();
            object = (VRMLNodeType)object2.getDEFNodes().get(DEFAULT_VIEWPOINT);
            if (object != null) {
                this.headlight = true;
            } else {
                this.navInfo = (OGLNavigationInfo)vRMLNodeFactory.createVRMLNode("NavigationInfo", false);
                this.navInfo.setHeadlight(this.headlight);
                this.root = (VRMLWorldRootNodeType)object2.getRootNode();
                this.addNodes = true;
                ThumbnailRecorder thumbnailRecorder = this;
                synchronized (thumbnailRecorder) {
                    this.fsm.addEndOfThisFrameListener((FrameStateListener)this);
                    this.configComplete = false;
                    while (!this.configComplete) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        if (this.viewpointName != null) {
            if (this.viewpointName.equalsIgnoreCase("FIT")) {
                object2 = new AutoConfigureViewpoint(this.construct, this.headlight);
                boolean bl = ((AutoConfigureViewpoint)object2).configure();
                this.initiateCapture();
            } else if (this.viewpointName.equalsIgnoreCase("AUTO")) {
                object2 = this.core.getScene();
                vRMLNodeFactory = (VRMLNodeType)object2.getDEFNodes().get(DEFAULT_VIEWPOINT);
                if (vRMLNodeFactory != null) {
                    this.viewpoint = (BaseViewpoint)vRMLNodeFactory;
                    if (this.viewpoint.getIsBound()) {
                        this.initiateCapture();
                    } else {
                        this.isBound_index = this.viewpoint.getFieldIndex("isBound");
                        this.viewpoint.addNodeListener((VRMLNodeListener)this);
                        this.construct.getViewpointManager().setViewpoint((VRMLViewpointNodeType)this.viewpoint);
                    }
                } else {
                    object = new AutoConfigureViewpoint(this.construct, this.headlight);
                    boolean bl = ((AutoConfigureViewpoint)object).configure();
                    this.initiateCapture();
                }
            } else {
                object2 = this.core.getScene();
                vRMLNodeFactory = (VRMLNodeType)object2.getDEFNodes().get(this.viewpointName);
                if (vRMLNodeFactory != null) {
                    this.viewpoint = (BaseViewpoint)vRMLNodeFactory;
                    if (this.viewpoint.getIsBound()) {
                        this.initiateCapture();
                    } else {
                        this.isBound_index = this.viewpoint.getFieldIndex("isBound");
                        this.viewpoint.addNodeListener((VRMLNodeListener)this);
                        this.construct.getViewpointManager().setViewpoint((VRMLViewpointNodeType)this.viewpoint);
                    }
                } else {
                    this.initiateCapture();
                }
            }
        } else {
            this.initiateCapture();
        }
    }

    public void saveScreen(Buffer buffer, int n, int n2) {
        int n3;
        int n4;
        ByteBuffer byteBuffer = (ByteBuffer)buffer;
        int[] nArray = new int[n * n2];
        int n5 = n * n2 * 3;
        int n6 = 0;
        int n7 = n * 3;
        if (this.postProcess) {
            for (n4 = 0; n4 < n2; ++n4) {
                int n8 = n5 -= n7;
                for (n3 = 0; n3 < n; ++n3) {
                    byte by;
                    byte by2;
                    int n9;
                    byte by3 = byteBuffer.get(n8++);
                    nArray[n6++] = (n9 = (by3 & 0xFF) << 16 | ((by2 = byteBuffer.get(n8++)) & 0xFF) << 8 | (by = byteBuffer.get(n8++)) & 0xFF) == this.snapRGB ? this.imageARGB : 0xFF000000 | n9;
                }
            }
        } else {
            for (n4 = 0; n4 < n2; ++n4) {
                int n10 = n5 -= n7;
                for (n3 = 0; n3 < n; ++n3) {
                    byte by = byteBuffer.get(n10++);
                    byte by4 = byteBuffer.get(n10++);
                    byte by5 = byteBuffer.get(n10++);
                    nArray[n6++] = 0xFF000000 | (by & 0xFF) << 16 | (by4 & 0xFF) << 8 | by5 & 0xFF;
                }
            }
        }
        BufferedImage bufferedImage = null;
        bufferedImage = this.hasAlpha ? new BufferedImage(n, n2, 2) : new BufferedImage(n, n2, 1);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        try {
            this.errorReporter.messageReport("ThumbnailRecorder: Writing image file: " + this.outputFile);
            long l = System.nanoTime();
            ImageIO.write((RenderedImage)bufferedImage, this.type, this.outputFile);
            this.fileTime += System.nanoTime() - l;
        }
        catch (IOException iOException) {
            this.errorReporter.errorReport("ThumbnailRecorder: Error writing image file: " + this.outputFile, (Exception)iOException);
        }
    }

    private void initiateCapture() {
        this.startFrameTime = System.nanoTime();
        this.core.captureScreenOnce(this);
        if (this.listener != null) {
            this.listener.recorderStatusChanged(new RecorderEvent(this, 1380253696, this.number));
        }
    }
}

