/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.browser.ogl;

import java.awt.Component;
import java.awt.Frame;
import javax.media.opengl.DefaultGLCapabilitiesChooser;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;

class SampleChooser
implements Runnable {
    private static final String NO_PIXEL_FORMATS_MSG = "WARNING: antialiasing will be disabled because none of the available pixel formats had it to offer";
    private static final String NO_AA_REQUEST_MSG = "WARNING: antialiasing will be disabled because the DefaultGLCapabilitiesChooser didn't supply it";
    private int maxSamples = -1;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();

    SampleChooser() {
    }

    public void run() {
        GLCapabilities gLCapabilities = new GLCapabilities();
        MultisampleChooser multisampleChooser = new MultisampleChooser();
        gLCapabilities.setSampleBuffers(true);
        GLCanvas gLCanvas = new GLCanvas(gLCapabilities, (GLCapabilitiesChooser)multisampleChooser, null, null);
        Frame frame = new Frame();
        gLCanvas.setSize(16, 16);
        frame.add((Component)gLCanvas, "Center");
        frame.pack();
        frame.show();
        while (this.maxSamples < 0) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        frame.hide();
        frame.dispose();
    }

    void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    int getMaxSamples() {
        return this.maxSamples;
    }

    class MultisampleChooser
    extends DefaultGLCapabilitiesChooser {
        MultisampleChooser() {
        }

        public int chooseCapabilities(GLCapabilities gLCapabilities, GLCapabilities[] gLCapabilitiesArray, int n) {
            int n2;
            boolean bl = false;
            for (n2 = 0; n2 < gLCapabilitiesArray.length; ++n2) {
                GLCapabilities gLCapabilities2 = gLCapabilitiesArray[n2];
                if (gLCapabilities2 == null) continue;
                if (gLCapabilities2.getNumSamples() > SampleChooser.this.maxSamples) {
                    SampleChooser.this.maxSamples = gLCapabilities2.getNumSamples();
                }
                if (!gLCapabilities2.getSampleBuffers()) continue;
                bl = true;
            }
            n2 = super.chooseCapabilities(gLCapabilities, gLCapabilitiesArray, n);
            if (!bl) {
                SampleChooser.this.errorReporter.messageReport(SampleChooser.NO_PIXEL_FORMATS_MSG);
            } else if (!gLCapabilitiesArray[n2].getSampleBuffers()) {
                SampleChooser.this.errorReporter.messageReport(SampleChooser.NO_AA_REQUEST_MSG);
            }
            return n2;
        }
    }
}

