/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.ui.awt.browser.ogl;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.media.opengl.GLCapabilities;
import javax.swing.JPanel;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.URI;
import org.ietf.uri.URIResourceStreamFactory;
import org.j3d.aviatrix3d.output.graphics.ElumensAWTSurface;
import org.j3d.aviatrix3d.output.graphics.SimpleAWTSurface;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsOutputDevice;
import org.web3d.browser.BrowserComponent;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.protocol.Web3DResourceFactory;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.renderer.ogl.browser.OGLBrowserCanvas;
import org.web3d.vrml.renderer.ogl.browser.OGLStandardBrowserCore;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.sai.BrowserConfig;
import org.xj3d.sai.BrowserInterfaceTypes;
import org.xj3d.ui.awt.browser.ogl.SampleChooser;
import org.xj3d.ui.awt.device.AWTDeviceFactory;
import org.xj3d.ui.awt.net.content.AWTContentHandlerFactory;
import org.xj3d.ui.awt.widgets.CursorManager;
import org.xj3d.ui.awt.widgets.SwingConsoleButton;
import org.xj3d.ui.awt.widgets.SwingConsoleWindow;
import org.xj3d.ui.awt.widgets.SwingLocationToolbar;
import org.xj3d.ui.awt.widgets.SwingNavigationToolbar;
import org.xj3d.ui.awt.widgets.SwingStatusBar;
import org.xj3d.ui.awt.widgets.SwingViewpointToolbar;

public abstract class BrowserJPanel
extends JPanel
implements BrowserComponent,
BrowserCoreListener,
ComponentListener,
WindowListener,
KeyListener {
    private static final String PROPERTY_SETUP_ERR = "Error setting up system properties in BrowserJPanel";
    private static final String WIREFRAME_RENDERING_MODE_MSG = "Wireframe rendering mode enabled";
    private static final String POINT_RENDERING_MODE_MSG = "Point rendering mode enabled";
    private static final String SHADED_RENDERING_MODE_MSG = "Shaded rendering mode enabled";
    private static final int PAUSED_FPS = 1;
    private Window window;
    private Component glCanvas;
    private ViewpointManager vpManager;
    protected SwingNavigationToolbar navToolbar;
    protected SwingLocationToolbar locToolbar;
    protected SwingStatusBar statusBar;
    protected SwingConsoleWindow console;
    protected OGLBrowserCanvas mainCanvas;
    protected CursorManager cursorManager;
    protected OGLStandardBrowserCore universe;
    private int frameMillis;
    private boolean wireframe;
    private boolean pointrender;
    private boolean elumensMode;
    private GLCapabilities caps;
    private int numSamples;
    private boolean maxChooserStarted;
    private SampleChooser sampleChooser;

    protected BrowserJPanel(BrowserConfig browserConfig) {
        super(new BorderLayout());
        Properties properties = browserConfig.browserSkin == null ? new Properties() : browserConfig.browserSkin;
        this.numSamples = 1;
        this.frameMillis = -1;
        this.wireframe = false;
        this.pointrender = false;
        this.maxChooserStarted = false;
        this.setSize(800, 600);
        this.console = new SwingConsoleWindow();
        String string = null;
        string = browserConfig.vrml97Only ? "VRML" : "X3D";
        this.console.messageReport("Initializing OpenGL " + string + " browser.\n");
        this.caps = new GLCapabilities();
        this.caps.setDoubleBuffered(true);
        this.caps.setHardwareAccelerated(true);
        if (browserConfig.antialiased) {
            this.caps.setSampleBuffers(true);
            if (browserConfig.antialiasingQuality.equals("low")) {
                this.numSamples = 2;
                this.caps.setNumSamples(this.numSamples);
            } else if (browserConfig.antialiasingQuality.equals("medium")) {
                this.console.messageReport("Trying for 4 samples of antialiasing.");
                this.numSamples = 4;
                this.caps.setNumSamples(this.numSamples);
            } else if (browserConfig.antialiasingQuality.equals("high")) {
                this.console.messageReport("Trying for 8 samples of antialiasing.");
                this.numSamples = 8;
                this.caps.setNumSamples(this.numSamples);
            }
        }
        boolean bl = browserConfig.interfaceType == BrowserInterfaceTypes.LIGHTWEIGHT;
        SimpleAWTSurface simpleAWTSurface = new SimpleAWTSurface(this.caps, bl);
        this.glCanvas = (Component)simpleAWTSurface.getSurfaceObject();
        AWTDeviceFactory aWTDeviceFactory = new AWTDeviceFactory(this.glCanvas, "aviatrix3d", simpleAWTSurface, this.console);
        this.mainCanvas = new OGLBrowserCanvas((GraphicsOutputDevice)simpleAWTSurface, aWTDeviceFactory, browserConfig);
        this.mainCanvas.initialize();
        this.mainCanvas.setErrorReporter(this.console);
        this.glCanvas.addComponentListener(this);
        this.glCanvas.addKeyListener(this);
        this.cursorManager = new CursorManager(this.glCanvas, properties, this.console);
        this.universe = this.mainCanvas.getUniverse();
        this.universe.addCoreListener(this);
        this.universe.addSensorStatusListener(this.cursorManager);
        this.universe.addNavigationStateListener(this.cursorManager);
        this.vpManager = this.mainCanvas.getViewpointManager();
        this.setupProperties(browserConfig.textureQuality);
        this.add(this.glCanvas, "Center");
        if (browserConfig.showDash && browserConfig.showUrl && browserConfig.dashTop == browserConfig.urlTop) {
            browserConfig.urlTop = true;
            browserConfig.dashTop = false;
        }
        if (browserConfig.showUrl) {
            this.locToolbar = new SwingLocationToolbar(this.universe, this.mainCanvas.getWorldLoaderManager(), browserConfig.urlReadOnly, browserConfig.showOpenButton, browserConfig.showReloadButton, browserConfig.contentDirectory, properties, this.console);
            if (browserConfig.urlTop) {
                this.add((Component)this.locToolbar, "North");
            } else {
                this.add((Component)this.locToolbar, "South");
            }
        }
        if (browserConfig.showDash) {
            JPanel jPanel = new JPanel(new BorderLayout());
            if (browserConfig.dashTop) {
                this.add((Component)jPanel, "North");
            } else {
                this.add((Component)jPanel, "South");
            }
            this.navToolbar = new SwingNavigationToolbar((BrowserCore)this.universe, properties, (ErrorReporter)this.console);
            SwingViewpointToolbar swingViewpointToolbar = new SwingViewpointToolbar(this.universe, this.vpManager, properties, this.console);
            SwingConsoleButton swingConsoleButton = new SwingConsoleButton(this.console, properties);
            jPanel.add((Component)this.navToolbar, "West");
            jPanel.add((Component)swingViewpointToolbar, "Center");
            jPanel.add((Component)swingConsoleButton, "East");
            if (browserConfig.showFPS || browserConfig.showStatusBar) {
                this.statusBar = new SwingStatusBar(this.universe, browserConfig.showStatusBar, browserConfig.showFPS, properties, this.console);
                if (this.locToolbar != null) {
                    this.locToolbar.setProgressListener(this.statusBar.getProgressListener());
                }
                jPanel.add((Component)this.statusBar, "South");
            }
        }
        if (browserConfig.showConsole) {
            this.console.setVisible(true);
        }
    }

    public void removeNotify() {
        this.stop();
        if (this.window != null) {
            this.window.removeWindowListener(this);
            this.window = null;
        }
        super.removeNotify();
    }

    public void addNotify() {
        this.start();
        super.addNotify();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 65: {
                if ((keyEvent.getModifiers() & 8) == 0) break;
                this.numSamples *= 2;
                int n = this.getMaximumNumSamples();
                while (n < 0) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    n = this.getMaximumNumSamples();
                }
                if (this.numSamples > n) {
                    this.numSamples = 1;
                }
                this.setStatusText("Antialiasing samples: " + this.numSamples + " out of max: " + n);
                this.caps.setSampleBuffers(true);
                this.caps.setNumSamples(this.numSamples);
                this.resetSurface();
                break;
            }
            case 34: {
                this.vpManager.nextViewpoint();
                break;
            }
            case 33: {
                this.vpManager.previousViewpoint();
                break;
            }
            case 36: {
                this.vpManager.firstViewpoint();
                break;
            }
            case 35: {
                this.vpManager.lastViewpoint();
                break;
            }
            case 70: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.universe.setNavigationMode("FLY");
                break;
            }
            case 80: {
                if ((keyEvent.getModifiers() & 8) == 0) break;
                boolean bl = this.pointrender = !this.pointrender;
                if (this.pointrender) {
                    this.setStatusText(POINT_RENDERING_MODE_MSG);
                    this.universe.setRenderingStyle(1);
                    break;
                }
                if (this.wireframe) {
                    this.setStatusText(WIREFRAME_RENDERING_MODE_MSG);
                    this.universe.setRenderingStyle(2);
                    break;
                }
                this.setStatusText(SHADED_RENDERING_MODE_MSG);
                this.universe.setRenderingStyle(4);
                break;
            }
            case 87: {
                if ((keyEvent.getModifiers() & 2) != 0) {
                    this.universe.setNavigationMode("WALK");
                    break;
                }
                if ((keyEvent.getModifiers() & 8) == 0) break;
                boolean bl = this.wireframe = !this.wireframe;
                if (this.wireframe) {
                    this.setStatusText(WIREFRAME_RENDERING_MODE_MSG);
                    this.universe.setRenderingStyle(2);
                    break;
                }
                if (this.pointrender) {
                    this.setStatusText(POINT_RENDERING_MODE_MSG);
                    this.universe.setRenderingStyle(1);
                    break;
                }
                this.setStatusText(SHADED_RENDERING_MODE_MSG);
                this.universe.setRenderingStyle(4);
                break;
            }
            case 69: {
                if ((keyEvent.getModifiers() & 2) == 0) break;
                this.universe.setNavigationMode("EXAMINE");
                break;
            }
            case 90: {
                if ((keyEvent.getModifiers() & 8) == 0) break;
                this.elumensMode = !this.elumensMode;
                this.resetSurface();
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.glCanvas.requestFocusInWindow();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
        if (this.frameMillis < 0) {
            this.mainCanvas.setMinimumFrameInterval(0, false);
        } else {
            this.mainCanvas.setMinimumFrameInterval(this.frameMillis, false);
        }
        this.glCanvas.requestFocusInWindow();
    }

    public void windowIconified(WindowEvent windowEvent) {
        this.mainCanvas.setMinimumFrameInterval(1000, false);
    }

    public void windowOpened(WindowEvent windowEvent) {
        this.glCanvas.requestFocusInWindow();
    }

    public void componentHidden(ComponentEvent componentEvent) {
        this.mainCanvas.setMinimumFrameInterval(1000, false);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        if (this.window == null) {
            Container container = this;
            while (true) {
                Container container2;
                if ((container2 = container.getParent()) == null) {
                    this.window = (Window)container;
                    this.window.addWindowListener(this);
                    break;
                }
                container = container2;
            }
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (this.frameMillis < 0) {
            this.mainCanvas.setMinimumFrameInterval(0, false);
        } else {
            this.mainCanvas.setMinimumFrameInterval(this.frameMillis, false);
        }
    }

    public int supportedSpecificationVersion() {
        return 3;
    }

    public Object getCanvas() {
        return this.glCanvas;
    }

    public int getRendererType() {
        return this.universe.getRendererType();
    }

    public BrowserCore getBrowserCore() {
        return this.universe;
    }

    public ErrorReporter getErrorReporter() {
        return this.console;
    }

    public void setMinimumFrameInterval(int n, boolean bl) {
        this.mainCanvas.setMinimumFrameInterval(n, bl);
    }

    public void start() {
        this.mainCanvas.setEnabled(true);
    }

    public void stop() {
        this.mainCanvas.setEnabled(false);
    }

    public void destroy() {
        if (this.universe != null) {
            this.universe.dispose();
        }
    }

    public void browserShutdown() {
    }

    public void browserDisposed() {
        this.universe = null;
        this.console.dispose();
        URI.setContentHandlerFactory(null);
    }

    public void urlLoadFailed(String string) {
    }

    public void browserInitialized(VRMLScene vRMLScene) {
    }

    public void setElumensMode(boolean bl) {
        this.elumensMode = bl;
        this.resetSurface();
    }

    public boolean getElumensMode() {
        return this.elumensMode;
    }

    private void resetSurface() {
        ElumensAWTSurface elumensAWTSurface;
        this.remove(this.glCanvas);
        this.glCanvas.removeComponentListener(this);
        this.glCanvas.removeKeyListener(this);
        if (this.elumensMode) {
            elumensAWTSurface = new ElumensAWTSurface(this.caps);
            elumensAWTSurface.setNumberOfChannels(3);
            this.universe.setHardwareFOV(180.0f);
        } else {
            elumensAWTSurface = new SimpleAWTSurface(this.caps);
            this.universe.setHardwareFOV(0.0f);
        }
        this.glCanvas = (Canvas)elumensAWTSurface.getSurfaceObject();
        AWTDeviceFactory aWTDeviceFactory = new AWTDeviceFactory(this.glCanvas, "aviatrix3d", elumensAWTSurface, this.console);
        this.mainCanvas.setSurface((GraphicsOutputDevice)elumensAWTSurface, aWTDeviceFactory);
        this.add(this.glCanvas);
        this.glCanvas.addComponentListener(this);
        this.glCanvas.addKeyListener(this);
        this.glCanvas.requestFocusInWindow();
    }

    private int getMaximumNumSamples() {
        int n = -1;
        if (!this.maxChooserStarted) {
            this.sampleChooser = new SampleChooser();
            Thread thread = new Thread(this.sampleChooser);
            thread.start();
            n = this.sampleChooser.getMaxSamples();
            this.maxChooserStarted = true;
        } else {
            n = this.sampleChooser.getMaxSamples();
        }
        return n;
    }

    private void setupProperties(final String string) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    FileNameMap fileNameMap;
                    Object object;
                    Object object2;
                    String string2 = System.getProperty("uri.content.handler.pkgs", "");
                    if (string2.indexOf("vlc.net.content") == -1) {
                        System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
                    }
                    if ((string2 = System.getProperty("uri.protocol.handler.pkgs", "")).indexOf("vlc.net.protocol") == -1) {
                        System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
                    }
                    try {
                        object2 = Class.forName("vlc.net.content.image.ImageDecoder");
                        object = ((Class)object2).newInstance();
                        string2 = System.getProperty("java.content.handler.pkgs", "");
                        if (string2.indexOf("vlc.net.content") == -1) {
                            System.setProperty("java.content.handler.pkgs", "vlc.net.content");
                        }
                    }
                    catch (Throwable throwable) {
                        BrowserJPanel.this.console.warningReport("Image loaders not available", null);
                    }
                    object2 = BrowserJPanel.this.mainCanvas.getUniverse();
                    object = BrowserJPanel.this.mainCanvas.getWorldLoaderManager();
                    Object object3 = URI.getContentHandlerFactory();
                    URIResourceStreamFactory uRIResourceStreamFactory = URI.getURIResourceStreamFactory();
                    if (!(uRIResourceStreamFactory instanceof Web3DResourceFactory)) {
                        uRIResourceStreamFactory = new Web3DResourceFactory(uRIResourceStreamFactory);
                        URI.setURIResourceStreamFactory((URIResourceStreamFactory)uRIResourceStreamFactory);
                    }
                    if (!(object3 instanceof AWTContentHandlerFactory)) {
                        object3 = new AWTContentHandlerFactory((BrowserCore)object2, (WorldLoaderManager)object);
                        URI.setContentHandlerFactory((ContentHandlerFactory)object3);
                    }
                    if (!((fileNameMap = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
                        fileNameMap = new VRMLFileNameMap(fileNameMap);
                        URI.setFileNameMap((FileNameMap)fileNameMap);
                    }
                    if (string.equals("medium")) {
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", "2");
                    } else if (string.equals("high")) {
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.useMipMaps", "true");
                        System.setProperty("org.web3d.vrml.renderer.common.nodes.shape.anisotropicDegree", "16");
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            this.console.warningReport(PROPERTY_SETUP_ERR, null);
        }
    }

    private void setStatusText(String string) {
        if (this.statusBar != null) {
            this.statusBar.setStatusText(string);
        }
    }
}

