/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.loaders.ogl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.j3d.aviatrix3d.Group;
import org.j3d.renderer.aviatrix3d.loader.AVModel;
import org.j3d.renderer.aviatrix3d.loader.AVRuntimeComponent;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLSingleExternalNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.renderer.ogl.nodes.OGLViewpointNodeType;

class Xj3DModel
implements AVModel {
    private Group modelRoot;
    private VRMLScene realScene;
    private HashMap namedObjects;
    private HashMap externalObjects;
    private ArrayList layers;
    private ArrayList lights;
    private ArrayList viewpoints;
    private ArrayList backgrounds;
    private ArrayList fogs;
    private ArrayList runtimes;

    Xj3DModel(VRMLScene vRMLScene) {
        this.realScene = vRMLScene;
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLScene.getRootNode();
        this.modelRoot = (Group)oGLVRMLNode.getSceneGraphObject();
        this.namedObjects = new HashMap();
        this.externalObjects = new HashMap();
        this.layers = new ArrayList();
        this.lights = new ArrayList();
        this.viewpoints = new ArrayList();
        this.backgrounds = new ArrayList();
        this.fogs = new ArrayList();
        this.runtimes = new ArrayList();
    }

    public Group getModelRoot() {
        return this.modelRoot;
    }

    public Object getRawModel() {
        return this.realScene;
    }

    public Map getNamedObjects() {
        return this.namedObjects;
    }

    public Map getExternallyDefinedFiles() {
        return this.externalObjects;
    }

    public List getViewpoints() {
        return this.viewpoints;
    }

    public List getBackgrounds() {
        return this.backgrounds;
    }

    public List getFogs() {
        return this.fogs;
    }

    public List getLayers() {
        return this.layers;
    }

    public List getLights() {
        return this.lights;
    }

    public List getRuntimeComponents() {
        return this.runtimes;
    }

    void addRuntimeComponent(AVRuntimeComponent aVRuntimeComponent) {
        this.runtimes.add(aVRuntimeComponent);
    }

    void setValues(boolean bl) {
        int n;
        ArrayList arrayList;
        OGLVRMLNode oGLVRMLNode;
        Map map = this.realScene.getDEFNodes();
        Set set = map.keySet();
        for (Object k : set) {
            oGLVRMLNode = (OGLVRMLNode)map.get(k);
            arrayList = oGLVRMLNode.getSceneGraphObject();
            if (arrayList == null) continue;
            this.namedObjects.put(k, arrayList);
        }
        arrayList = this.realScene.getBySecondaryType(5);
        int n2 = arrayList.size();
        block6: for (n = 0; n < n2; ++n) {
            oGLVRMLNode = (OGLVRMLNode)arrayList.get(n);
            int n3 = oGLVRMLNode.getPrimaryType();
            switch (n3) {
                case 4: {
                    this.backgrounds.add(oGLVRMLNode.getSceneGraphObject());
                    continue block6;
                }
                case 18: {
                    this.fogs.add(oGLVRMLNode.getSceneGraphObject());
                    continue block6;
                }
                case 55: {
                    OGLViewpointNodeType oGLViewpointNodeType = (OGLViewpointNodeType)oGLVRMLNode;
                    this.viewpoints.add(oGLViewpointNodeType.getPlatformGroup());
                }
            }
        }
        arrayList = this.realScene.getByPrimaryType(27);
        n2 = arrayList.size();
        this.lights.ensureCapacity(n2);
        for (n = 0; n < n2; ++n) {
            oGLVRMLNode = (OGLVRMLNode)arrayList.get(n);
            this.lights.add(oGLVRMLNode.getSceneGraphObject());
        }
        arrayList = this.realScene.getByPrimaryType(89);
        n2 = arrayList.size();
        this.layers.ensureCapacity(n2);
        for (n = 0; n < n2; ++n) {
            oGLVRMLNode = (OGLVRMLNode)arrayList.get(n);
            this.layers.add(oGLVRMLNode.getSceneGraphObject());
        }
        arrayList = this.realScene.getBySecondaryType(44);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            oGLVRMLNode = (OGLVRMLNode)arrayList.get(n);
            if (oGLVRMLNode instanceof VRMLSingleExternalNodeType) {
                String[] stringArray = ((VRMLSingleExternalNodeType)oGLVRMLNode).getUrl();
                this.externalObjects.put(oGLVRMLNode.getSceneGraphObject(), stringArray);
                continue;
            }
            System.out.println("Aviatrix3D loader not handling multi-external node types");
        }
        if (!bl) {
            this.realScene = null;
        }
    }
}

