/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.loaders.ogl;

import java.util.ArrayList;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphPath;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SimpleLayer;
import org.j3d.aviatrix3d.SimpleScene;
import org.j3d.aviatrix3d.SimpleViewport;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.ViewEnvironment;
import org.j3d.aviatrix3d.Viewport;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.aviatrix3d.rendering.RenderEffectsProcessor;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.VRMLNodeFactory;
import org.web3d.vrml.nodes.LayerListener;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLLayerNodeType;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.VRMLViewportNodeType;
import org.web3d.vrml.nodes.VRMLWorldRootNodeType;
import org.web3d.vrml.renderer.DefaultNodeFactory;
import org.web3d.vrml.renderer.ogl.browser.GlobalEffectsGroup;
import org.web3d.vrml.renderer.ogl.browser.OGLRenderingEffects;
import org.web3d.vrml.renderer.ogl.input.DefaultLayerSensorManager;
import org.web3d.vrml.renderer.ogl.input.OGLUserInputHandler;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.renderer.ogl.nodes.OGLViewpointNodeType;
import org.xj3d.core.eventmodel.BindableNodeListener;
import org.xj3d.core.eventmodel.BindableNodeManager;
import org.xj3d.core.eventmodel.LayerManager;
import org.xj3d.core.eventmodel.LayerSensorManager;
import org.xj3d.core.eventmodel.SensorManager;

class NullLayerManager
implements LayerManager,
NodeUpdateListener,
BindableNodeListener,
LayerListener {
    private static final String NODE_PROFILE_ERR = "LayerManager is unable to initialise the default bindables due to missing node factory configurations.";
    private static final String UNKNOWN_PROJ_TYPE_MSG = "A viewpoint has been provided with an unknown projection type. The code can only deal with perspective and orthographic projections. We'll default to perspective now.";
    private static final String VP_ADD_ERR = "Error sending viewpoint addition notification.";
    private static final String VP_REMOVE_ERR = "Error sending viewpoint removed notification.";
    private static final String VP_BOUND_ERR = "Error sending viewpoint binding notification.";
    private static final String VP_ACTIVATE_ERR = "Error sending viewpoint layer activation notification.";
    private static final String VP_LAYER_ADD_ERR = "Error sending viewpoint layer addtion notification.";
    private static final String VP_LAYER_REMOVE_ERR = "Error sending viewpoint layer removal notification.";
    private static final int VP_TRANSITION_TIME = 2000;
    private static final String NAV_COMPONENT = "Navigation";
    private static final String ENV_COMPONENT = "EnvironmentalEffects";
    private ErrorReporter errorReporter;
    private ViewEnvironment viewEnvironment;
    private OGLViewpointNodeType currentViewpoint;
    private VRMLNavigationInfoNodeType currentNavInfo;
    private OGLViewpointNodeType defaultViewpoint;
    private VRMLNavigationInfoNodeType defaultNavInfo;
    private VRMLBackgroundNodeType defaultBackground;
    private VRMLFogNodeType defaultFog;
    private BindableNodeManager viewpointStack;
    private BindableNodeManager navInfoStack;
    private BindableNodeManager backgroundStack;
    private BindableNodeManager fogStack;
    private IntHashMap bindablesMap;
    private VRMLClock clock;
    private GlobalEffectsGroup globalEffects;
    private SensorManager sensorManager;
    private DefaultLayerSensorManager layerSensorManager;
    private boolean navigationEnabled;
    private int projectionType = 1;
    private OGLUserInputHandler userInput;
    private ArrayList viewpointStatusListeners;
    private OGLRenderingEffects renderEffects;
    private SimpleLayer implLayer;
    private SimpleScene implScene;
    private Group worldGroup;
    private TransformGroup sgTransformGroup;
    private TransformGroup vpTransformGroup;
    private Group worldRoot;
    private Group pendingWorldGeom;
    private Matrix4f vpMatrix;
    private Matrix4f worldScaleMatrix;
    private Matrix4f pathMatrix;
    private int layerId = -1;
    private int viewportType = 1;
    private VRMLViewportNodeType viewport;
    private ArrayList pathList = new ArrayList();
    private Node[] pathNodes = new Node[20];

    NullLayerManager() {
        this.implScene = new SimpleScene();
        this.viewEnvironment = this.implScene.getViewEnvironment();
        SimpleViewport simpleViewport = new SimpleViewport();
        simpleViewport.setScene(this.implScene);
        this.implLayer = new SimpleLayer();
        this.implLayer.setViewport((Viewport)simpleViewport);
        this.globalEffects = new GlobalEffectsGroup(this.implScene);
        this.renderEffects = new OGLRenderingEffects(this.implScene);
        this.implScene.setRenderEffectsProcessor((RenderEffectsProcessor)this.renderEffects);
        this.layerSensorManager = new DefaultLayerSensorManager();
        this.layerSensorManager.setViewEnvironment(this.viewEnvironment);
        this.layerSensorManager.setGlobalEffectsHandler(this.globalEffects);
        this.userInput = (OGLUserInputHandler)this.layerSensorManager.getUserInputHandler();
        Group group = new Group();
        group.addChild((Node)this.globalEffects);
        this.worldGroup = new Group();
        this.sgTransformGroup = new TransformGroup();
        this.sgTransformGroup.addChild(null);
        this.sgTransformGroup.addChild(null);
        this.worldGroup.addChild((Node)group);
        this.worldGroup.addChild((Node)this.sgTransformGroup);
        this.implScene.setRenderedGeometry(this.worldGroup);
        this.globalEffects.initialize();
        this.bindablesMap = new IntHashMap();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.worldScaleMatrix = new Matrix4f();
        this.worldScaleMatrix.setIdentity();
        this.pathMatrix = new Matrix4f();
        this.viewpointStatusListeners = new ArrayList();
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        int[] nArray = this.bindablesMap.keySet();
        for (int i = 0; i < nArray.length; ++i) {
            BindableNodeManager bindableNodeManager = (BindableNodeManager)this.bindablesMap.get(nArray[i]);
            bindableNodeManager.setErrorReporter(this.errorReporter);
        }
    }

    public void initialise(SensorManager sensorManager) {
        this.sensorManager = sensorManager;
        this.clock = this.sensorManager.getVRMLClock();
        BindableNodeManager bindableNodeManager = new BindableNodeManager();
        bindableNodeManager.setVRMLClock(this.clock);
        bindableNodeManager.setErrorReporter(this.errorReporter);
        bindableNodeManager.setNodeChangeListener((BindableNodeListener)this);
        this.bindablesMap.put(55, (Object)bindableNodeManager);
        this.viewpointStack = bindableNodeManager;
        BindableNodeManager bindableNodeManager2 = new BindableNodeManager();
        bindableNodeManager2.setVRMLClock(this.clock);
        bindableNodeManager2.setErrorReporter(this.errorReporter);
        this.bindablesMap.put(31, (Object)bindableNodeManager2);
        this.navInfoStack = bindableNodeManager2;
        BindableNodeManager bindableNodeManager3 = new BindableNodeManager();
        bindableNodeManager3.setVRMLClock(this.clock);
        bindableNodeManager3.setErrorReporter(this.errorReporter);
        this.bindablesMap.put(4, (Object)bindableNodeManager3);
        this.backgroundStack = bindableNodeManager3;
        BindableNodeManager bindableNodeManager4 = new BindableNodeManager();
        bindableNodeManager4.setVRMLClock(this.clock);
        bindableNodeManager4.setErrorReporter(this.errorReporter);
        this.bindablesMap.put(18, (Object)bindableNodeManager4);
        this.fogStack = bindableNodeManager4;
        this.layerSensorManager.setNavigationStacks(bindableNodeManager, bindableNodeManager2, bindableNodeManager3, bindableNodeManager4);
        this.layerSensorManager.setVRMLClock(this.clock);
        this.sensorManager.addLayerSensorManager((LayerSensorManager)this.layerSensorManager);
        VRMLNodeFactory vRMLNodeFactory = DefaultNodeFactory.createFactory("ogl");
        vRMLNodeFactory.setSpecVersion(3, 2);
        this.defaultViewpoint = (OGLViewpointNodeType)vRMLNodeFactory.createVRMLNode(NAV_COMPONENT, "Viewpoint", false);
        this.defaultViewpoint.setDescription("Default viewpoint");
        this.defaultViewpoint.setupFinished();
        this.defaultNavInfo = (VRMLNavigationInfoNodeType)vRMLNodeFactory.createVRMLNode(NAV_COMPONENT, "NavigationInfo", false);
        this.defaultNavInfo.setupFinished();
        this.defaultBackground = (VRMLBackgroundNodeType)vRMLNodeFactory.createVRMLNode(ENV_COMPONENT, "Background", false);
        this.defaultBackground.setupFinished();
        this.defaultFog = (VRMLFogNodeType)vRMLNodeFactory.createVRMLNode(ENV_COMPONENT, "Fog", false);
        this.defaultFog.setFogType(0);
        this.defaultFog.setupFinished();
        Node node = (Node)this.defaultViewpoint.getSceneGraphObject();
        Node node2 = (Node)((OGLVRMLNode)this.defaultBackground).getSceneGraphObject();
        Node node3 = (Node)((OGLVRMLNode)this.defaultFog).getSceneGraphObject();
        Group group = new Group();
        group.addChild(node);
        group.addChild(node2);
        group.addChild(node3);
        this.sgTransformGroup.setChild((Node)group, 1);
    }

    public void setLayerId(int n) {
        this.layerId = n;
        this.layerSensorManager.setLayerId(n);
        this.globalEffects.setLayerId(n);
    }

    public void setSpecVersion(int n, int n2) {
    }

    public void setRenderingStyle(int n) throws IllegalArgumentException {
        this.renderEffects.setRenderingStyle(n);
    }

    public int getRenderingStyle() {
        return this.renderEffects.getRenderingStyle();
    }

    public void initialBind() {
        double d = this.clock.getTime();
        this.viewpointStack.addNode((VRMLBindableNodeType)this.defaultViewpoint, true);
        this.navInfoStack.addNode((VRMLBindableNodeType)this.defaultNavInfo, true);
        this.backgroundStack.addNode((VRMLBindableNodeType)this.defaultBackground, true);
        this.fogStack.addNode((VRMLBindableNodeType)this.defaultFog, true);
        VRMLViewpointNodeType vRMLViewpointNodeType = (VRMLViewpointNodeType)this.viewpointStack.getFirstNode();
        VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType = (VRMLNavigationInfoNodeType)this.navInfoStack.getFirstNode();
        VRMLBackgroundNodeType vRMLBackgroundNodeType = (VRMLBackgroundNodeType)this.backgroundStack.getFirstNode();
        VRMLFogNodeType vRMLFogNodeType = (VRMLFogNodeType)this.fogStack.getFirstNode();
        vRMLViewpointNodeType.setBind(true, true, d);
        vRMLNavigationInfoNodeType.setBind(true, true, d);
        vRMLBackgroundNodeType.setBind(true, true, d);
        ((VRMLBindableNodeType)vRMLFogNodeType).setBind(true, true, d);
        this.currentNavInfo = vRMLNavigationInfoNodeType;
        SceneGraphPath sceneGraphPath = this.generatePath((Node)this.vpTransformGroup);
        if (this.sgTransformGroup.isLive()) {
            this.sgTransformGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.sgTransformGroup);
        }
    }

    public BindableNodeManager getBindableManager(int n) {
        BindableNodeManager bindableNodeManager = (BindableNodeManager)this.bindablesMap.get(n);
        if (bindableNodeManager == null) {
            bindableNodeManager = new BindableNodeManager();
            bindableNodeManager.setErrorReporter(this.errorReporter);
            bindableNodeManager.setVRMLClock(this.sensorManager.getVRMLClock());
            this.bindablesMap.put(n, (Object)bindableNodeManager);
        }
        return bindableNodeManager;
    }

    public void setActiveNavigationLayer(boolean bl) {
        this.navigationEnabled = bl;
        this.layerSensorManager.setNavigationEnabled(bl);
        this.userInput.sendCurrentNavState();
        if (bl) {
            int n = this.viewpointStatusListeners.size();
            for (int i = 0; i < n; ++i) {
                try {
                    ViewpointStatusListener viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(i);
                    viewpointStatusListener.viewpointLayerActive(this.layerId);
                    continue;
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport(VP_ACTIVATE_ERR, exception);
                }
            }
        }
    }

    public boolean isActiveNavigationLayer() {
        return this.navigationEnabled;
    }

    public boolean setNavigationMode(String string) {
        return this.userInput.setNavigationMode(string);
    }

    public void getUserPosition(Vector3f vector3f, AxisAngle4f axisAngle4f) {
        this.userInput.getPosition(vector3f);
        this.userInput.getOrientation(axisAngle4f);
    }

    public void fitToWorld(boolean bl) {
        this.vpMatrix.setIdentity();
        float[] fArray = new float[3];
        BoundingVolume boundingVolume = this.worldRoot.getBounds();
        boundingVolume.getCenter(fArray);
        float[] fArray2 = new float[3];
        float[] fArray3 = new float[3];
        boundingVolume.getExtents(fArray2, fArray3);
        float f = Math.abs(fArray3[2] - fArray2[2]);
        float f2 = 1.0f;
        f2 = f > 1000.0f ? 1.25f : 2.0f;
        float f3 = fArray[2] + f * f2;
        this.vpMatrix.setTranslation(new Vector3f(fArray[0], fArray[1], f3));
        if (this.vpTransformGroup.isLive()) {
            this.vpTransformGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.vpTransformGroup);
        }
    }

    public void setManagedNodes(VRMLWorldRootNodeType vRMLWorldRootNodeType) {
        this.viewportType = 1;
        this.viewport = null;
        int n = this.viewpointStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                ViewpointStatusListener viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(i);
                viewpointStatusListener.viewpointLayerAdded(this.layerId);
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.warningReport(VP_LAYER_ADD_ERR, exception);
            }
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLWorldRootNodeType;
        this.pendingWorldGeom = (Group)oGLVRMLNode.getSceneGraphObject();
        this.layerSensorManager.setWorldRoot(this.pendingWorldGeom);
    }

    public void setManagedLayer(VRMLLayerNodeType vRMLLayerNodeType) {
        this.viewportType = vRMLLayerNodeType.getViewportType();
        VRMLNodeType vRMLNodeType = vRMLLayerNodeType.getViewport();
        VRMLNodeType vRMLNodeType2 = null;
        if (vRMLNodeType instanceof VRMLProtoInstance) {
            vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (vRMLNodeType2 != null && vRMLNodeType2 instanceof VRMLProtoInstance) {
                vRMLNodeType2 = ((VRMLProtoInstance)vRMLNodeType2).getImplementationNode();
            }
            if (vRMLNodeType2 != null && !(vRMLNodeType2 instanceof VRMLViewportNodeType)) {
                this.viewportType = 1;
                this.viewport = null;
                vRMLNodeType2 = null;
            }
        } else if (vRMLNodeType != null && !(vRMLNodeType instanceof VRMLViewportNodeType)) {
            this.viewportType = 1;
            this.viewport = null;
            vRMLNodeType2 = null;
        } else {
            vRMLNodeType2 = vRMLNodeType;
        }
        this.viewport = (VRMLViewportNodeType)vRMLNodeType2;
        int n = this.viewpointStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                ViewpointStatusListener viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(i);
                viewpointStatusListener.viewpointLayerAdded(this.layerId);
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.warningReport(VP_LAYER_ADD_ERR, exception);
            }
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLLayerNodeType;
        this.pendingWorldGeom = (Group)oGLVRMLNode.getSceneGraphObject();
        this.layerSensorManager.setWorldRoot(this.pendingWorldGeom);
        this.layerSensorManager.setIsPickable(vRMLLayerNodeType.isPickable());
        vRMLLayerNodeType.addLayerListener((LayerListener)this);
    }

    public void setHardwareFOV(float f) {
    }

    public void setStereoEnabled(boolean bl) {
        this.viewEnvironment.setStereoEnabled(bl);
    }

    public void shutdown() {
        this.sensorManager.removeLayerSensorManager((LayerSensorManager)this.layerSensorManager);
    }

    public void updateViewMatrix() {
        this.layerSensorManager.updateViewMatrix();
    }

    public void clear() {
        ViewpointStatusListener viewpointStatusListener;
        int n;
        this.viewport = null;
        int n2 = this.viewpointStatusListeners.size();
        if (this.navigationEnabled) {
            for (n = 0; n < n2; ++n) {
                try {
                    viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(n);
                    if (this.layerId == 0) {
                        viewpointStatusListener.viewpointLayerActive(-1);
                        continue;
                    }
                    viewpointStatusListener.viewpointLayerActive(0);
                    continue;
                }
                catch (Exception exception) {
                    this.errorReporter.warningReport(VP_ACTIVATE_ERR, exception);
                }
            }
        }
        for (n = 0; n < n2; ++n) {
            try {
                viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(n);
                viewpointStatusListener.viewpointLayerRemoved(this.layerId);
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.warningReport(VP_LAYER_REMOVE_ERR, exception);
            }
        }
        this.layerSensorManager.clear();
        this.layerSensorManager.setNavigationEnabled(false);
        this.vpTransformGroup = null;
        this.pendingWorldGeom = null;
        this.worldRoot = null;
        this.currentViewpoint = null;
        this.currentNavInfo = null;
        this.userInput.clear();
    }

    public int getViewportType() {
        return this.viewportType;
    }

    public VRMLViewportNodeType getViewport() {
        return this.viewport;
    }

    public void addNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.userInput.addNavigationStateListener(navigationStateListener);
    }

    public void removeNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.userInput.removeNavigationStateListener(navigationStateListener);
    }

    public void addSensorStatusListener(SensorStatusListener sensorStatusListener) {
        this.userInput.addSensorStatusListener(sensorStatusListener);
    }

    public void removeSensorStatusListener(SensorStatusListener sensorStatusListener) {
        this.userInput.removeSensorStatusListener(sensorStatusListener);
    }

    public void addViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        if (viewpointStatusListener != null && !this.viewpointStatusListeners.contains(viewpointStatusListener)) {
            this.viewpointStatusListeners.add(viewpointStatusListener);
            viewpointStatusListener.viewpointLayerAdded(this.layerId);
            if (this.navigationEnabled) {
                viewpointStatusListener.viewpointLayerActive(this.layerId);
            }
        }
    }

    public void removeViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        if (viewpointStatusListener == null) {
            return;
        }
        this.viewpointStatusListeners.remove(viewpointStatusListener);
    }

    public void newNodeBound(VRMLBindableNodeType vRMLBindableNodeType) {
        OGLViewpointNodeType oGLViewpointNodeType = (OGLViewpointNodeType)vRMLBindableNodeType;
        this.changeViewpoints(oGLViewpointNodeType);
        int n = this.viewpointStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                ViewpointStatusListener viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(i);
                viewpointStatusListener.viewpointBound((VRMLViewpointNodeType)oGLViewpointNodeType, this.layerId);
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.warningReport(VP_BOUND_ERR, exception);
            }
        }
    }

    public void bindableAdded(VRMLBindableNodeType vRMLBindableNodeType, boolean bl) {
        int n = this.viewpointStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                ViewpointStatusListener viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(i);
                viewpointStatusListener.viewpointAdded((VRMLViewpointNodeType)vRMLBindableNodeType, this.layerId, bl);
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.warningReport(VP_ADD_ERR, exception);
            }
        }
    }

    public void bindableRemoved(VRMLBindableNodeType vRMLBindableNodeType) {
        int n = this.viewpointStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                ViewpointStatusListener viewpointStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(i);
                viewpointStatusListener.viewpointRemoved((VRMLViewpointNodeType)vRMLBindableNodeType, this.layerId);
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.warningReport(VP_REMOVE_ERR, exception);
            }
        }
    }

    public Matrix4f getTransform() {
        return this.worldScaleMatrix;
    }

    public void updateNodeBoundsChanges(Object object) {
        if (object == this.sgTransformGroup) {
            this.sgTransformGroup.setTransform(this.worldScaleMatrix);
            if (this.pendingWorldGeom != null) {
                this.worldRoot = this.pendingWorldGeom;
                this.pendingWorldGeom = null;
            }
            this.userInput.setPickableScene((Group)this.sgTransformGroup);
            this.layerSensorManager.setWorldRoot((Group)this.sgTransformGroup);
        } else if (this.vpTransformGroup == object) {
            this.vpTransformGroup.setTransform(this.vpMatrix);
        } else {
            ((Group)object).removeAllChildren();
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void pickableStateChanged(boolean bl) {
        this.layerSensorManager.setIsPickable(bl);
    }

    SimpleLayer getLayer() {
        return this.implLayer;
    }

    private void changeViewpoints(OGLViewpointNodeType oGLViewpointNodeType) {
        if (oGLViewpointNodeType.getJump()) {
            this.currentViewpoint = oGLViewpointNodeType;
            this.vpTransformGroup = this.currentViewpoint.getPlatformGroup();
            this.vpMatrix = this.currentViewpoint.getViewTransform();
            SceneGraphPath sceneGraphPath = this.generatePath((Node)this.vpTransformGroup);
            this.userInput.setViewInfo(this.currentViewpoint, this.vpTransformGroup, sceneGraphPath);
            if (this.vpTransformGroup.isLive()) {
                this.vpTransformGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.vpTransformGroup.setTransform(this.vpMatrix);
            }
            switch (this.currentViewpoint.getProjectionType()) {
                case 0: {
                    this.projectionType = 1;
                    break;
                }
                case 1: {
                    this.projectionType = 2;
                    break;
                }
                default: {
                    this.errorReporter.warningReport(UNKNOWN_PROJ_TYPE_MSG, null);
                    this.projectionType = 1;
                }
            }
            this.viewEnvironment.setProjectionType(this.projectionType);
        } else {
            System.out.println("non-jump transistions not handled yet");
            this.currentViewpoint = oGLViewpointNodeType;
            this.vpTransformGroup = this.currentViewpoint.getPlatformGroup();
            this.vpMatrix = this.currentViewpoint.getViewTransform();
            SceneGraphPath sceneGraphPath = this.generatePath((Node)this.vpTransformGroup);
            this.userInput.setViewInfo(this.currentViewpoint, this.vpTransformGroup, sceneGraphPath);
            if (this.vpTransformGroup.isLive()) {
                this.vpTransformGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.vpTransformGroup.setTransform(this.vpMatrix);
            }
            switch (this.currentViewpoint.getProjectionType()) {
                case 0: {
                    this.projectionType = 1;
                    break;
                }
                case 1: {
                    this.projectionType = 2;
                    break;
                }
                default: {
                    this.errorReporter.warningReport(UNKNOWN_PROJ_TYPE_MSG, null);
                    this.projectionType = 1;
                }
            }
            this.viewEnvironment.setProjectionType(this.projectionType);
        }
        if (this.currentNavInfo != null) {
            this.globalEffects.useHeadlight(this.currentNavInfo.getHeadlight());
        }
    }

    private SceneGraphPath generatePath(Node node) {
        Node node2 = node.getParent();
        this.pathList.clear();
        if (node == null || node2 == null) {
            return null;
        }
        while (node2 != null) {
            if (node2 instanceof SharedGroup) {
                SharedGroup sharedGroup = (SharedGroup)node2;
                if (sharedGroup.numParents() == 0) break;
                sharedGroup.getParents(this.pathNodes);
                node2 = this.pathNodes[0];
                this.pathList.add(node2);
                continue;
            }
            this.pathList.add(node2);
            node2 = node2.getParent();
        }
        this.pathMatrix.setIdentity();
        int n = this.pathList.size();
        if (this.pathNodes.length < n) {
            this.pathNodes = new Node[n];
        }
        for (int i = 0; i < n; ++i) {
            this.pathNodes[i] = (Node)this.pathList.get(n - i - 1);
        }
        return new SceneGraphPath(this.pathNodes, n, this.pathMatrix, this.pathMatrix);
    }

    private void getLocalToVworld(Node node, Matrix4f matrix4f) {
        int n;
        Node node2 = node.getParent();
        this.pathList.clear();
        if (node2 instanceof TransformGroup) {
            this.pathList.add(node2);
        }
        while (node2 != null) {
            if (node2 instanceof SharedGroup) {
                SharedGroup sharedGroup = (SharedGroup)node2;
                n = sharedGroup.numParents();
                if (n == 0) break;
                if (n > this.pathNodes.length) {
                    this.pathNodes = new Node[n];
                }
                sharedGroup.getParents(this.pathNodes);
                node2 = this.pathNodes[0];
                continue;
            }
            if (node2 instanceof TransformGroup) {
                this.pathList.add(node2);
            }
            node2 = node2.getParent();
        }
        int n2 = this.pathList.size();
        matrix4f.setIdentity();
        this.pathMatrix.setIdentity();
        for (n = n2 - 1; n >= 0; --n) {
            TransformGroup transformGroup = (TransformGroup)this.pathList.get(n);
            transformGroup.getTransform(this.pathMatrix);
            matrix4f.mul(this.pathMatrix);
        }
    }
}

