/*
 * Decompiled with CFR 0.152.
 */
package org.xj3d.loaders.ogl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.ietf.uri.ContentHandlerFactory;
import org.ietf.uri.FileNameMap;
import org.ietf.uri.URI;
import org.ietf.uri.URN;
import org.ietf.uri.URNResolverService;
import org.j3d.renderer.aviatrix3d.loader.AVLoader;
import org.j3d.renderer.aviatrix3d.loader.AVModel;
import org.web3d.browser.BrowserCore;
import org.web3d.net.content.VRMLContentHandlerFactory;
import org.web3d.net.content.VRMLFileNameMap;
import org.web3d.net.resolve.Web3DURNResolver;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.parser.FactoryConfigurationError;
import org.web3d.vrml.parser.VRMLParserFactory;
import org.web3d.vrml.renderer.common.input.DefaultSensorManager;
import org.web3d.vrml.renderer.common.input.dis.DISProtocolHandler;
import org.web3d.vrml.renderer.ogl.OGLSceneBuilderFactory;
import org.web3d.vrml.renderer.ogl.browser.OGLMinimalBrowserCore;
import org.web3d.vrml.sav.InputSource;
import org.web3d.vrml.scripting.ScriptEngine;
import org.web3d.vrml.scripting.ecmascript.ECMAScriptEngine;
import org.web3d.vrml.scripting.ecmascript.JavascriptScriptEngine;
import org.web3d.vrml.scripting.jsai.VRML97ScriptEngine;
import org.web3d.vrml.scripting.sai.JavaSAIScriptEngine;
import org.xj3d.core.eventmodel.EventModelEvaluator;
import org.xj3d.core.eventmodel.LayerManagerFactory;
import org.xj3d.core.eventmodel.LayerRenderingManager;
import org.xj3d.core.eventmodel.NetworkProtocolHandler;
import org.xj3d.core.eventmodel.NodeManager;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.RouterFactory;
import org.xj3d.core.eventmodel.ScriptManager;
import org.xj3d.core.eventmodel.SensorManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.ContentLoadManager;
import org.xj3d.core.loading.SceneBuilderFactory;
import org.xj3d.core.loading.ScriptLoader;
import org.xj3d.core.loading.WorldLoader;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.impl.core.eventmodel.DefaultEventModelEvaluator;
import org.xj3d.impl.core.eventmodel.DefaultFrameStateManager;
import org.xj3d.impl.core.eventmodel.DefaultHumanoidManager;
import org.xj3d.impl.core.eventmodel.DefaultNetworkManager;
import org.xj3d.impl.core.eventmodel.DefaultParticleSystemManager;
import org.xj3d.impl.core.eventmodel.DefaultRigidBodyPhysicsManager;
import org.xj3d.impl.core.eventmodel.DefaultRouteManager;
import org.xj3d.impl.core.eventmodel.DefaultScriptManager;
import org.xj3d.impl.core.eventmodel.DefaultViewpointManager;
import org.xj3d.impl.core.eventmodel.ListsRouterFactory;
import org.xj3d.impl.core.loading.DefaultScriptLoader;
import org.xj3d.impl.core.loading.DefaultWorldLoaderManager;
import org.xj3d.impl.core.loading.MemCacheLoadManager;
import org.xj3d.loaders.ogl.NullLayerManagerFactory;
import org.xj3d.loaders.ogl.NullLayerRenderingManager;
import org.xj3d.loaders.ogl.StaticBrowserCore;
import org.xj3d.loaders.ogl.Xj3DClockRuntime;
import org.xj3d.loaders.ogl.Xj3DModel;

public abstract class BaseLoader
implements AVLoader {
    private static boolean setupComplete = false;
    protected boolean vrml97Only = false;
    private int loadFlags = -1;
    private boolean keepModel = false;
    protected ErrorReporter errorReporter;
    private boolean navigationEnabled = false;
    private Web3DURNResolver resolver = new Web3DURNResolver();

    protected BaseLoader() {
    }

    public AVModel load(URL uRL) throws IOException {
        InputSource inputSource = new InputSource(uRL);
        return this.load(inputSource);
    }

    public AVModel load(InputStream inputStream) throws IOException {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return System.getProperty("user.dir");
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            System.out.println("Cannot get user dir in BaseLoader");
        }
        InputSource inputSource = new InputSource(string, inputStream);
        return this.load(inputSource);
    }

    public AVModel load(File file) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException("File does not exist");
        }
        if (file.isDirectory()) {
            throw new FileNotFoundException("File is a directory");
        }
        InputSource inputSource = new InputSource(file);
        return this.load(inputSource);
    }

    public void setLoadFlags(int n) {
        this.loadFlags = n;
    }

    public int getLoadFlags() {
        return this.loadFlags;
    }

    public void keepInternalModel(boolean bl) {
        this.keepModel = bl;
    }

    public boolean isInternalModelKept() {
        return this.keepModel;
    }

    public boolean getNavigationEnabled() {
        return this.navigationEnabled;
    }

    public void setNavigationEnabled(boolean bl) {
        this.navigationEnabled = bl;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void registerURNLocation(String string, String string2) throws IllegalArgumentException {
        this.resolver.registerPrefixLocation(string, string2);
    }

    private AVModel load(InputSource inputSource) throws IOException {
        boolean bl = (this.loadFlags & 2) != 0;
        boolean bl2 = (this.loadFlags & 0x10) != 0;
        boolean bl3 = (this.loadFlags & 0x20) != 0;
        boolean bl4 = true;
        boolean bl5 = (this.loadFlags & 4) != 0;
        boolean bl6 = (this.loadFlags & 8) != 0;
        OGLSceneBuilderFactory oGLSceneBuilderFactory = new OGLSceneBuilderFactory(this.vrml97Only, bl, bl2, bl3, bl4, bl5, bl6);
        VRMLParserFactory vRMLParserFactory = null;
        try {
            vRMLParserFactory = VRMLParserFactory.newVRMLParserFactory();
            this.setupParserFactory(vRMLParserFactory);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException("Failed to load factory");
        }
        DefaultFrameStateManager defaultFrameStateManager = new DefaultFrameStateManager();
        Xj3DModel xj3DModel = null;
        if (bl6) {
            DefaultRouteManager defaultRouteManager = new DefaultRouteManager();
            defaultRouteManager.setRouterFactory((RouterFactory)new ListsRouterFactory());
            DefaultScriptManager defaultScriptManager = new DefaultScriptManager();
            DefaultSensorManager defaultSensorManager = new DefaultSensorManager();
            DefaultEventModelEvaluator defaultEventModelEvaluator = new DefaultEventModelEvaluator();
            MemCacheLoadManager memCacheLoadManager = new MemCacheLoadManager();
            DefaultHumanoidManager defaultHumanoidManager = new DefaultHumanoidManager();
            DefaultNetworkManager defaultNetworkManager = new DefaultNetworkManager();
            DefaultRigidBodyPhysicsManager defaultRigidBodyPhysicsManager = new DefaultRigidBodyPhysicsManager();
            DefaultParticleSystemManager defaultParticleSystemManager = new DefaultParticleSystemManager();
            DISProtocolHandler dISProtocolHandler = new DISProtocolHandler();
            defaultNetworkManager.addProtocolHandler((NetworkProtocolHandler)dISProtocolHandler);
            NodeManager[] nodeManagerArray = new NodeManager[]{defaultNetworkManager, defaultHumanoidManager, defaultRigidBodyPhysicsManager, defaultParticleSystemManager};
            OGLMinimalBrowserCore oGLMinimalBrowserCore = new OGLMinimalBrowserCore((EventModelEvaluator)defaultEventModelEvaluator);
            DefaultViewpointManager defaultViewpointManager = new DefaultViewpointManager((BrowserCore)oGLMinimalBrowserCore);
            NullLayerManagerFactory nullLayerManagerFactory = new NullLayerManagerFactory();
            nullLayerManagerFactory.setErrorReporter(this.errorReporter);
            defaultEventModelEvaluator.initialize((ScriptManager)defaultScriptManager, (RouteManager)defaultRouteManager, (SensorManager)defaultSensorManager, (FrameStateManager)defaultFrameStateManager, (ContentLoadManager)memCacheLoadManager, (ViewpointManager)defaultViewpointManager, (LayerManagerFactory)nullLayerManagerFactory, (LayerRenderingManager)new NullLayerRenderingManager(), nodeManagerArray);
            defaultEventModelEvaluator.setErrorReporter(this.errorReporter);
            DefaultWorldLoaderManager defaultWorldLoaderManager = new DefaultWorldLoaderManager((BrowserCore)oGLMinimalBrowserCore, (FrameStateManager)defaultFrameStateManager, (RouteManager)defaultRouteManager);
            defaultWorldLoaderManager.setErrorReporter(this.errorReporter);
            defaultWorldLoaderManager.registerBuilderFactory(3, (SceneBuilderFactory)oGLSceneBuilderFactory);
            defaultWorldLoaderManager.registerParserFactory(3, vRMLParserFactory);
            Xj3DClockRuntime xj3DClockRuntime = new Xj3DClockRuntime((EventModelEvaluator)defaultEventModelEvaluator, oGLMinimalBrowserCore);
            oGLMinimalBrowserCore.setPerFrameManager(xj3DClockRuntime);
            this.setupProperties(oGLMinimalBrowserCore, (WorldLoaderManager)defaultWorldLoaderManager);
            WorldLoader worldLoader = defaultWorldLoaderManager.fetchLoader();
            VRMLScene vRMLScene = worldLoader.loadNow((BrowserCore)oGLMinimalBrowserCore, inputSource);
            defaultWorldLoaderManager.releaseLoader(worldLoader);
            xj3DModel = new Xj3DModel(vRMLScene);
            DefaultScriptLoader defaultScriptLoader = new DefaultScriptLoader();
            defaultScriptManager.setScriptLoader((ScriptLoader)defaultScriptLoader);
            VRML97ScriptEngine vRML97ScriptEngine = new VRML97ScriptEngine((BrowserCore)oGLMinimalBrowserCore, (RouteManager)defaultRouteManager, (FrameStateManager)defaultFrameStateManager, (WorldLoaderManager)defaultWorldLoaderManager);
            JavascriptScriptEngine javascriptScriptEngine = new JavascriptScriptEngine((BrowserCore)oGLMinimalBrowserCore, (RouteManager)defaultRouteManager, (FrameStateManager)defaultFrameStateManager, (WorldLoaderManager)defaultWorldLoaderManager);
            JavaSAIScriptEngine javaSAIScriptEngine = new JavaSAIScriptEngine((BrowserCore)oGLMinimalBrowserCore, (ViewpointManager)defaultViewpointManager, (RouteManager)defaultRouteManager, (FrameStateManager)defaultFrameStateManager, (WorldLoaderManager)defaultWorldLoaderManager);
            ECMAScriptEngine eCMAScriptEngine = new ECMAScriptEngine((BrowserCore)oGLMinimalBrowserCore, (ViewpointManager)defaultViewpointManager, (RouteManager)defaultRouteManager, (FrameStateManager)defaultFrameStateManager, (WorldLoaderManager)defaultWorldLoaderManager);
            vRML97ScriptEngine.setErrorReporter(this.errorReporter);
            javascriptScriptEngine.setErrorReporter(this.errorReporter);
            eCMAScriptEngine.setErrorReporter(this.errorReporter);
            javaSAIScriptEngine.setErrorReporter(this.errorReporter);
            defaultScriptLoader.registerScriptingEngine((ScriptEngine)vRML97ScriptEngine);
            defaultScriptLoader.registerScriptingEngine((ScriptEngine)javascriptScriptEngine);
            defaultScriptLoader.registerScriptingEngine((ScriptEngine)javaSAIScriptEngine);
            defaultScriptLoader.registerScriptingEngine((ScriptEngine)eCMAScriptEngine);
            oGLMinimalBrowserCore.setScene(vRMLScene, null);
            xj3DModel.addRuntimeComponent(xj3DClockRuntime);
        } else {
            DefaultRouteManager defaultRouteManager = new DefaultRouteManager();
            StaticBrowserCore staticBrowserCore = new StaticBrowserCore();
            DefaultWorldLoaderManager defaultWorldLoaderManager = new DefaultWorldLoaderManager((BrowserCore)staticBrowserCore, (FrameStateManager)defaultFrameStateManager, (RouteManager)defaultRouteManager);
            defaultWorldLoaderManager.setErrorReporter(this.errorReporter);
            defaultWorldLoaderManager.registerBuilderFactory(3, (SceneBuilderFactory)oGLSceneBuilderFactory);
            defaultWorldLoaderManager.registerParserFactory(3, vRMLParserFactory);
            this.setupProperties(staticBrowserCore, (WorldLoaderManager)defaultWorldLoaderManager);
            WorldLoader worldLoader = defaultWorldLoaderManager.fetchLoader();
            VRMLScene vRMLScene = worldLoader.loadNow((BrowserCore)staticBrowserCore, inputSource);
            defaultWorldLoaderManager.releaseLoader(worldLoader);
            xj3DModel = new Xj3DModel(vRMLScene);
        }
        xj3DModel.setValues(this.keepModel);
        return xj3DModel;
    }

    private void setupProperties(final BrowserCore browserCore, final WorldLoaderManager worldLoaderManager) {
        if (setupComplete) {
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileNameMap fileNameMap;
                ContentHandlerFactory contentHandlerFactory;
                System.setProperty("sun.awt.font.advancecache", "off");
                if (System.getProperty("uri.content.handler.pkgs") == null) {
                    System.setProperty("uri.content.handler.pkgs", "vlc.net.content");
                }
                if (System.getProperty("uri.protocol.handler.pkgs") == null) {
                    System.setProperty("uri.protocol.handler.pkgs", "vlc.net.protocol");
                }
                if (!((contentHandlerFactory = URI.getContentHandlerFactory()) instanceof VRMLContentHandlerFactory)) {
                    contentHandlerFactory = new VRMLContentHandlerFactory(browserCore, worldLoaderManager);
                    URI.setContentHandlerFactory((ContentHandlerFactory)contentHandlerFactory);
                }
                if (!((fileNameMap = URI.getFileNameMap()) instanceof VRMLFileNameMap)) {
                    fileNameMap = new VRMLFileNameMap(fileNameMap);
                    URI.setFileNameMap((FileNameMap)fileNameMap);
                }
                URN.addResolver((URNResolverService)BaseLoader.this.resolver);
                BaseLoader.this.setupPropertiesProtected();
                return null;
            }
        });
        setupComplete = true;
    }

    void setupPropertiesProtected() {
    }

    void setupParserFactory(VRMLParserFactory vRMLParserFactory) {
    }
}

