/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.texture;

import java.util.ArrayList;
import javax.media.opengl.GLCapabilities;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.OffscreenTexture2D;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SimpleLayer;
import org.j3d.aviatrix3d.SimpleScene;
import org.j3d.aviatrix3d.SimpleViewport;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.Texture2D;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.Viewport;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLExternalSynchronizedNodeType;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.texture.BaseRenderedTexture;
import org.web3d.vrml.renderer.ogl.browser.GlobalEffectsGroup;
import org.web3d.vrml.renderer.ogl.nodes.OGLBackgroundNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.renderer.ogl.nodes.OGLViewpointNodeType;

public class OGLRenderedTexture
extends BaseRenderedTexture
implements OGLTextureNodeType,
FrameStateListener,
VRMLExternalSynchronizedNodeType,
NodeUpdateListener {
    private static final int[] SECONDARY_TYPE = new int[]{74};
    private static final int SCENE_CHILD_IDX = 1;
    private static final int FOG_CHILD_IDX = 2;
    private static final int VIEW_CHILD_IDX = 3;
    private static final int BG_CHILD_IDX = 4;
    private SimpleScene avScene;
    private OffscreenTexture2D avTexture;
    private GlobalEffectsGroup localGlobals;
    private Group rootGroup;
    private Matrix4f vpMatrix;
    private Matrix4f localMatrix;
    private Texture2D[] tmpTextures;
    private boolean[] tmpTextureFlags;
    private float[] tmpColor;
    private float[] tmpAngle;
    private ArrayList pathList;
    private Node[] pathNodes;
    private boolean fogChanged;
    private boolean backgroundChanged;
    private boolean viewpointChanged;
    private boolean fogTypeChanged;
    private boolean fogDetailsChanged;
    private boolean backgroundSkyChanged;
    private boolean backgroundGroundChanged;
    private BackgroundListener backgroundListener;
    private FogListener fogListener;
    private boolean initialPaint;

    public OGLRenderedTexture() {
        this.init();
    }

    public OGLRenderedTexture(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void setTexture(int n, Texture texture) {
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.avTexture;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public void setupFinished() {
        Node node;
        OGLVRMLNode oGLVRMLNode;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.createFogListener();
        this.createBackgroundListener();
        if (this.vfScene != null) {
            oGLVRMLNode = (OGLVRMLNode)this.vfScene;
            node = (Node)oGLVRMLNode.getSceneGraphObject();
            this.rootGroup.setChild(node, 1);
        }
        if (this.vfViewpoint != null) {
            oGLVRMLNode = (Node)((OGLVRMLNode)this.vfViewpoint).getSceneGraphObject();
            this.rootGroup.setChild((Node)oGLVRMLNode, 3);
        }
        if (this.vfBackground != null) {
            oGLVRMLNode = (Node)((OGLVRMLNode)this.vfBackground).getSceneGraphObject();
            this.rootGroup.setChild((Node)oGLVRMLNode, 4);
        }
        if (this.vfFog != null) {
            oGLVRMLNode = (Node)((OGLVRMLNode)this.vfFog).getSceneGraphObject();
            this.rootGroup.setChild((Node)oGLVRMLNode, 2);
        }
        oGLVRMLNode = new GLCapabilities();
        oGLVRMLNode.setDoubleBuffered(false);
        oGLVRMLNode.setPbufferRenderToTexture(true);
        oGLVRMLNode.setPbufferRenderToTextureRectangle(true);
        this.avTexture = new OffscreenTexture2D((GLCapabilities)oGLVRMLNode, this.vfDimensions[0], this.vfDimensions[1]);
        node = new SimpleViewport();
        node.setDimensions(0, 0, this.vfDimensions[0], this.vfDimensions[1]);
        node.setScene(this.avScene);
        SimpleLayer simpleLayer = new SimpleLayer();
        simpleLayer.setViewport((Viewport)node);
        Layer[] layerArray = new Layer[]{simpleLayer};
        this.avTexture.setLayers(layerArray, 1);
        this.postEventEvaluation();
        if (this.updateFlag != 1) {
            this.avTexture.setRepaintRequired(true);
        }
    }

    public void updateNodeBoundsChanges(Object object) {
        if (object != this.rootGroup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfScene;
        Group group = (Group)oGLVRMLNode.getSceneGraphObject();
        this.rootGroup.setChild((Node)group, 1);
        group = null;
        if (this.vfViewpoint != null) {
            group = (Node)((OGLVRMLNode)this.vfViewpoint).getSceneGraphObject();
        }
        this.rootGroup.setChild((Node)group, 3);
        group = null;
        if (this.vfBackground != null) {
            group = (Node)((OGLVRMLNode)this.vfBackground).getSceneGraphObject();
        }
        this.rootGroup.setChild((Node)group, 4);
        group = null;
        if (this.vfFog != null) {
            group = (Node)((OGLVRMLNode)this.vfFog).getSceneGraphObject();
        }
        this.rootGroup.setChild((Node)group, 2);
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void preEventEvaluation() {
        if (!this.initialPaint && this.updateFlag == 2) {
            this.avTexture.setRepaintRequired(false);
            this.vfUpdate = "NONE";
            this.updateFlag = 1;
            this.initialPaint = false;
            this.hasChanged[4] = true;
            this.fireFieldChanged(4);
        }
    }

    public void postEventEvaluation() {
        if (this.updateFlag == 1) {
            return;
        }
        if (this.vfBackground != null) {
            Group group;
            OGLBackgroundNodeType oGLBackgroundNodeType = (OGLBackgroundNodeType)this.vfBackground;
            if (this.backgroundChanged) {
                group = oGLBackgroundNodeType.getBackgroundTextures();
                for (int i = 0; i < 6; ++i) {
                    this.tmpTextureFlags[i] = true;
                }
                this.localGlobals.updateBackgroundTextures((Texture2D[])group, this.tmpTextureFlags);
            } else if (oGLBackgroundNodeType.getChangedTextures(this.tmpTextures, this.tmpTextureFlags)) {
                this.localGlobals.updateBackgroundTextures(this.tmpTextures, this.tmpTextureFlags);
            }
            this.backgroundSkyChanged = true;
            this.backgroundGroundChanged = true;
            this.updateBackgroundSphere();
            this.backgroundChanged = false;
            group = (Group)((OGLVRMLNode)this.vfBackground).getSceneGraphObject();
            this.getLocalToVworld((Node)group, this.vpMatrix);
            this.localGlobals.setBackgroundMatrix(this.vpMatrix);
        } else if (this.backgroundChanged) {
            for (int i = 0; i < 6; ++i) {
                this.tmpTextures[i] = null;
                this.tmpTextureFlags[i] = true;
            }
            this.localGlobals.updateBackgroundTextures(this.tmpTextures, this.tmpTextureFlags);
            this.vpMatrix.setIdentity();
            this.localGlobals.setBackgroundMatrix(this.vpMatrix);
            this.backgroundChanged = false;
        }
        if (this.vfFog != null) {
            float f = this.vfFog.getVisibilityRange();
            this.vfFog.getColor(this.tmpColor);
            int n = this.vfFog.getFogType();
            if (this.fogChanged) {
                this.localGlobals.enableFog(n);
                this.localGlobals.setFogDetails(f, this.tmpColor[0], this.tmpColor[1], this.tmpColor[2]);
                this.fogChanged = false;
            } else {
                if (this.fogTypeChanged) {
                    this.localGlobals.enableFog(n);
                    this.fogTypeChanged = false;
                }
                if (this.fogDetailsChanged) {
                    this.localGlobals.setFogDetails(f, this.tmpColor[0], this.tmpColor[1], this.tmpColor[2]);
                    this.fogDetailsChanged = false;
                }
            }
            Group group = (Group)((OGLVRMLNode)this.vfFog).getSceneGraphObject();
            this.getLocalToVworld((Node)group, this.vpMatrix);
            this.localGlobals.setFogMatrix(this.vpMatrix);
            this.fogChanged = false;
        } else if (this.fogChanged) {
            this.vpMatrix.setIdentity();
            this.localGlobals.setFogMatrix(this.vpMatrix);
            this.localGlobals.enableFog(0);
            this.localGlobals.setFogDetails(1.0f, 0.0f, 0.0f, 0.0f);
            this.fogChanged = false;
        }
        if (this.vfViewpoint != null) {
            TransformGroup transformGroup = ((OGLViewpointNodeType)this.vfViewpoint).getPlatformGroup();
            this.getLocalToVworld((Node)transformGroup, this.vpMatrix);
            this.localGlobals.setViewMatrix(this.vpMatrix);
            this.viewpointChanged = false;
        } else if (this.viewpointChanged) {
            this.vpMatrix.setIdentity();
            this.vpMatrix.m23 = 10.0f;
            this.localGlobals.setViewMatrix(this.vpMatrix);
            this.viewpointChanged = false;
        }
    }

    protected void setUpdate(String string) {
        super.setUpdate(string);
        if (!this.inSetup) {
            this.avTexture.setRepaintRequired(this.updateFlag != 1);
        }
    }

    protected void setBackground(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.vfBackground != null) {
            this.vfBackground.removeNodeListener((VRMLNodeListener)this.backgroundListener);
        }
        super.setBackground(vRMLNodeType);
        if (this.backgroundListener == null) {
            this.createBackgroundListener();
        }
        this.vfBackground.addNodeListener((VRMLNodeListener)this.backgroundListener);
        if (this.inSetup) {
            return;
        }
        this.backgroundChanged = true;
        if (this.rootGroup.isLive()) {
            this.rootGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.rootGroup);
        }
    }

    protected void setFog(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.vfFog != null) {
            this.vfFog.removeNodeListener((VRMLNodeListener)this.fogListener);
        }
        super.setFog(vRMLNodeType);
        if (this.fogListener == null) {
            this.createFogListener();
        }
        this.vfFog.addNodeListener((VRMLNodeListener)this.fogListener);
        if (this.inSetup) {
            return;
        }
        this.fogChanged = true;
        if (this.rootGroup.isLive()) {
            this.rootGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.rootGroup);
        }
    }

    protected void setViewpoint(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setViewpoint(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        this.viewpointChanged = true;
        if (this.rootGroup.isLive()) {
            this.rootGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.rootGroup);
        }
    }

    protected void setScene(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setScene(vRMLNodeType);
        if (this.rootGroup.isLive()) {
            this.rootGroup.boundsChanged((NodeUpdateListener)this);
        } else if (this.vfScene != null) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfScene;
            Group group = (Group)oGLVRMLNode.getSceneGraphObject();
            this.rootGroup.setChild((Node)group, 1);
        }
    }

    private void getLocalToVworld(Node node, Matrix4f matrix4f) {
        int n;
        OGLUserData oGLUserData;
        Node node2 = node.getParent();
        this.pathList.clear();
        if (node instanceof TransformGroup && (oGLUserData = (OGLUserData)((Object)node.getUserData())) != null) {
            this.pathList.add(oGLUserData.owner);
        }
        while (node2 != null) {
            if (node2 instanceof SharedGroup) {
                SharedGroup sharedGroup = (SharedGroup)node2;
                n = sharedGroup.numParents();
                if (n == 0) break;
                if (n > this.pathNodes.length) {
                    this.pathNodes = new Node[n];
                }
                sharedGroup.getParents(this.pathNodes);
                node2 = this.pathNodes[0];
                continue;
            }
            if (node2 instanceof TransformGroup && (oGLUserData = (OGLUserData)((Object)node2.getUserData())) != null) {
                this.pathList.add(oGLUserData.owner);
            }
            node2 = node2.getParent();
        }
        int n2 = this.pathList.size();
        matrix4f.setIdentity();
        for (n = n2 - 1; n >= 0; --n) {
            OGLTransformNodeType oGLTransformNodeType = (OGLTransformNodeType)this.pathList.get(n);
            this.localMatrix.set(oGLTransformNodeType.getTransform());
            matrix4f.mul(this.localMatrix);
        }
    }

    private void updateBackgroundSphere() {
        int n;
        if (this.backgroundGroundChanged) {
            this.backgroundGroundChanged = false;
            n = this.vfBackground.getNumGroundColors();
            if (n * 3 > this.tmpColor.length) {
                this.tmpColor = new float[n * 3];
                this.tmpAngle = new float[n - 1];
            }
            if (n != 0) {
                this.vfBackground.getGroundValues(this.tmpColor, this.tmpAngle);
            }
            this.localGlobals.updateBackgroundGround(this.tmpColor, this.tmpAngle, n);
        }
        if (this.backgroundSkyChanged) {
            this.backgroundSkyChanged = false;
            n = this.vfBackground.getNumSkyColors();
            if (n * 3 > this.tmpColor.length) {
                this.tmpColor = new float[n * 3];
                this.tmpAngle = new float[n - 1];
            }
            if (n != 0) {
                this.vfBackground.getSkyValues(this.tmpColor, this.tmpAngle);
            }
            this.localGlobals.updateBackgroundSky(this.tmpColor, this.tmpAngle, n);
        }
    }

    private void createFogListener() {
        if (this.vfFog != null) {
            int n = this.vfFog.getFieldIndex("fogType");
            int n2 = this.vfFog.getFieldIndex("visibilityRange");
            int n3 = this.vfFog.getFieldIndex("color");
            this.fogListener = new FogListener(n, n2, n3);
        }
    }

    private void createBackgroundListener() {
        if (this.vfBackground != null) {
            int n = this.vfBackground.getFieldIndex("groundAngle");
            int n2 = this.vfBackground.getFieldIndex("groundColor");
            int n3 = this.vfBackground.getFieldIndex("skyAngle");
            int n4 = this.vfBackground.getFieldIndex("skyColor");
            this.backgroundListener = new BackgroundListener(n, n2, n3, n4);
        }
    }

    private void init() {
        this.avScene = new SimpleScene();
        this.localGlobals = new GlobalEffectsGroup(this.avScene);
        this.localGlobals.initialize();
        this.localGlobals.useHeadlight(true);
        this.rootGroup = new Group();
        this.rootGroup.addChild((Node)this.localGlobals);
        this.rootGroup.addChild(null);
        this.rootGroup.addChild(null);
        this.rootGroup.addChild(null);
        this.rootGroup.addChild(null);
        this.avScene.setRenderedGeometry(this.rootGroup);
        this.vpMatrix = new Matrix4f();
        this.localMatrix = new Matrix4f();
        this.pathList = new ArrayList();
        this.pathNodes = new Node[20];
        this.tmpTextures = new Texture2D[6];
        this.tmpTextureFlags = new boolean[6];
        this.tmpColor = new float[24];
        this.tmpAngle = new float[7];
        this.fogChanged = false;
        this.fogTypeChanged = false;
        this.fogDetailsChanged = false;
        this.backgroundChanged = false;
        this.backgroundSkyChanged = false;
        this.backgroundGroundChanged = false;
        this.vpMatrix.setIdentity();
        this.vpMatrix.m23 = 10.0f;
        this.localGlobals.setViewMatrix(this.vpMatrix);
        this.localGlobals.updateBackgroundSky(this.tmpColor, this.tmpAngle, 1);
        this.initialPaint = true;
    }

    private class FogListener
    implements VRMLNodeListener {
        private int typeField;
        private int visibilityField;
        private int colourField;

        FogListener(int n, int n2, int n3) {
            this.typeField = n;
            this.visibilityField = n2;
            this.colourField = n3;
        }

        public void fieldChanged(int n) {
            if (n == this.typeField) {
                OGLRenderedTexture.this.fogTypeChanged = true;
            }
            if (n == this.visibilityField || n == this.colourField) {
                OGLRenderedTexture.this.fogDetailsChanged = true;
            }
        }
    }

    private class BackgroundListener
    implements VRMLNodeListener {
        private int gndAngleField;
        private int gndColorField;
        private int skyAngleField;
        private int skyColorField;

        BackgroundListener(int n, int n2, int n3, int n4) {
            this.gndAngleField = n;
            this.gndColorField = n2;
            this.skyAngleField = n3;
            this.skyColorField = n4;
        }

        public void fieldChanged(int n) {
            if (n == this.gndAngleField || n == this.gndColorField) {
                OGLRenderedTexture.this.backgroundGroundChanged = true;
            }
            if (n == this.skyAngleField || n == this.skyColorField) {
                OGLRenderedTexture.this.backgroundSkyChanged = true;
            }
        }
    }
}

