/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.texture;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Texture;
import org.web3d.image.NIOBufferImage;
import org.web3d.image.NIOBufferImageType;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.texture.BasePixelTexture;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureNodeType;

public class OGLPixelTexture
extends BasePixelTexture
implements OGLTextureNodeType {
    private int texHeight;
    private int texWidth;
    private Texture texture;

    public OGLPixelTexture() {
    }

    public OGLPixelTexture(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void setTexture(int n, Texture texture) {
        this.texture = texture;
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.texture;
    }

    protected void processImageData() {
        if (this.vfImage == null) {
            return;
        }
        int n = this.vfImage[0];
        int n2 = this.vfImage[1];
        int n3 = this.vfImage[2];
        if (n * n2 != this.vfImageLen - 3) {
            throw new InvalidFieldValueException("Incorrect number of pixels. Expecting " + n * n2 + " and got " + (this.vfImageLen - 3) + ".");
        }
        ByteBuffer byteBuffer = null;
        NIOBufferImageType nIOBufferImageType = null;
        this.implImage = null;
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                nIOBufferImageType = NIOBufferImageType.INTENSITY;
                break;
            }
            case 2: {
                nIOBufferImageType = NIOBufferImageType.INTENSITY_ALPHA;
                break;
            }
            case 3: {
                nIOBufferImageType = NIOBufferImageType.RGB;
                break;
            }
            case 4: {
                nIOBufferImageType = NIOBufferImageType.RGBA;
                break;
            }
            default: {
                throw new InvalidFieldValueException("PixelTexture: Unsupported #components: " + n3, null);
            }
        }
        if (nIOBufferImageType != null) {
            int n4 = nIOBufferImageType.size;
            byteBuffer = ByteBuffer.allocateDirect(n * n2 * n4);
            byteBuffer.order(ByteOrder.nativeOrder());
            switch (n4) {
                case 4: {
                    for (int i = 3; i < this.vfImageLen; ++i) {
                        int n5 = this.vfImage[i];
                        byteBuffer.put((byte)(n5 >> 24 & 0xFF));
                        byteBuffer.put((byte)(n5 >> 16 & 0xFF));
                        byteBuffer.put((byte)(n5 >> 8 & 0xFF));
                        byteBuffer.put((byte)(n5 & 0xFF));
                    }
                    break;
                }
                case 3: {
                    for (int i = 3; i < this.vfImageLen; ++i) {
                        int n6 = this.vfImage[i];
                        byteBuffer.put((byte)(n6 >> 16 & 0xFF));
                        byteBuffer.put((byte)(n6 >> 8 & 0xFF));
                        byteBuffer.put((byte)(n6 & 0xFF));
                    }
                    break;
                }
                case 2: {
                    for (int i = 3; i < this.vfImageLen; ++i) {
                        int n7 = this.vfImage[i];
                        byteBuffer.put((byte)(n7 >> 8 & 0xFF));
                        byteBuffer.put((byte)(n7 & 0xFF));
                    }
                    break;
                }
                case 1: {
                    for (int i = 3; i < this.vfImageLen; ++i) {
                        int n8 = this.vfImage[i];
                        byteBuffer.put((byte)(n8 & 0xFF));
                    }
                    break;
                }
                default: {
                    System.out.println("Unhandled NIOBufferImageType: " + nIOBufferImageType);
                }
            }
            this.implImage = new NIOBufferImage(n, n2, nIOBufferImageType, byteBuffer);
        }
        if (!this.inSetup) {
            this.fireTextureImageChanged(0, this, this.implImage, null);
        }
    }
}

