/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.sound;

import org.j3d.aviatrix3d.AudioComponent;
import org.j3d.aviatrix3d.ConeSound;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTimeListener;
import org.web3d.vrml.renderer.common.nodes.sound.BaseSound;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.renderer.ogl.nodes.sound.OGLAudioClip;

public class OGLSound
extends BaseSound
implements OGLVRMLNode,
VRMLTimeListener,
NodeUpdateListener {
    private boolean isActive = false;
    private boolean loop = false;
    private float pitch = 1.0f;
    private ConeSound impl = new ConeSound();
    private AudioComponent newSource;
    private boolean sourceChanged = false;
    private boolean playStateChanged = false;
    private boolean playSound = false;

    public OGLSound() {
    }

    public OGLSound(VRMLNodeType vRMLNodeType) {
        this();
        this.copy(vRMLNodeType);
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.impl;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (!this.vfSpatialize) {
            this.impl.setRefDistance(Float.MAX_VALUE);
        }
    }

    public void updateNodeBoundsChanges(Object object) {
    }

    public void updateNodeDataChanges(Object object) {
        if (this.sourceChanged) {
            this.impl.setAudioSource(this.newSource);
            this.sourceChanged = false;
            if (this.newSource == null) {
                this.impl.setEnabled(false);
            } else {
                this.impl.setEnabled(true);
            }
        }
        if (this.playStateChanged) {
            if (this.playSound) {
                this.impl.startSound();
            } else {
                this.impl.stopSound();
            }
        }
        this.newSource = null;
    }

    public void allEventsComplete() {
        if (this.impl.isLive()) {
            this.impl.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.impl);
        }
    }

    public void contentStateChanged(VRMLNodeType vRMLNodeType, int n, int n2) {
        super.contentStateChanged(vRMLNodeType, n, n2);
        if (n2 == 3) {
            OGLAudioClip oGLAudioClip = (OGLAudioClip)this.vfSource;
            AudioComponent audioComponent = (AudioComponent)oGLAudioClip.getSceneGraphObject();
            if (this.impl.isLive()) {
                this.newSource = audioComponent;
                this.sourceChanged = true;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            } else {
                this.impl.setAudioSource(audioComponent);
                if (audioComponent == null) {
                    this.impl.setEnabled(false);
                } else {
                    this.impl.setEnabled(true);
                }
            }
        }
    }

    public void soundStateChanged(VRMLNodeType vRMLNodeType, boolean bl, boolean bl2, float f, double d) {
        if (bl2 != this.loop) {
            this.loop = bl2;
            if (this.isActive) {
                if (bl2) {
                    // empty if block
                }
                this.vrmlClock.addTimeListener((VRMLTimeListener)this);
            }
        }
        if (f != this.pitch) {
            this.pitch = f;
        }
        if (bl != this.isActive) {
            this.isActive = bl;
            if (bl) {
                if (this.loop) {
                    if (this.vrmlClock != null) {
                        this.vrmlClock.addTimeListener((VRMLTimeListener)this);
                    }
                } else {
                    this.vrmlClock.addTimeListener((VRMLTimeListener)this);
                }
                if (this.impl.isLive()) {
                    this.playStateChanged = true;
                    this.playSound = true;
                    this.impl.dataChanged((NodeUpdateListener)this);
                } else {
                    this.impl.startSound();
                }
            } else {
                if (this.impl.isLive()) {
                    this.playStateChanged = true;
                    this.playSound = false;
                    this.impl.dataChanged((NodeUpdateListener)this);
                } else {
                    this.impl.stopSound();
                }
                this.vrmlClock.removeTimeListener((VRMLTimeListener)this);
            }
        }
    }

    public void timeClick(long l) {
        boolean bl = this.impl.isPlaying();
        if (!bl && !this.loop) {
            this.vfSource.setIsActive(false);
        }
    }
}

