/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.shape;

import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.PointAttributes;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.shape.BasePointProperties;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLPointProperties
extends BasePointProperties
implements OGLVRMLNode,
NodeUpdateListener {
    private PointAttributes oglAttribs;
    private float defPointSize;
    private float defMinPointSize;
    private float defMaxPointSize;
    private float[] defAttenuationFactors;
    public int defColorMode;

    public OGLPointProperties() {
        this.init();
    }

    public OGLPointProperties(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.oglAttribs;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.updateNodeDataChanges(this.oglAttribs);
    }

    public void updateNodeBoundsChanges(Object object) {
    }

    public void updateNodeDataChanges(Object object) {
        if (this.vfPointsizeScaleFactor <= 0.0f) {
            this.oglAttribs.setPointSize(1.0f);
        } else {
            this.oglAttribs.setPointSize(this.vfPointsizeScaleFactor);
        }
        if (this.vfPointsizeMinValue >= 0.0f) {
            this.oglAttribs.setMinPointSize(this.vfPointsizeMinValue);
        }
        if (this.vfPointsizeMaxValue >= 0.0f) {
            // empty if block
        }
        this.oglAttribs.setMaxPointSize(this.vfPointsizeMaxValue);
        this.oglAttribs.setAttenuationFactors(this.vfPointsizeAttenuation[0], this.vfPointsizeAttenuation[1], this.vfPointsizeAttenuation[2]);
    }

    protected void setPointSizeScale(float f) throws InvalidFieldValueException {
        super.setPointSizeScale(f);
        if (this.inSetup) {
            return;
        }
        if (this.oglAttribs.isLive()) {
            this.oglAttribs.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglAttribs);
        }
    }

    protected void setPointSizeMin(float f) throws InvalidFieldValueException {
        super.setPointSizeMin(f);
        if (this.inSetup) {
            return;
        }
        if (this.oglAttribs.isLive()) {
            this.oglAttribs.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglAttribs);
        }
    }

    protected void setPointSizeMax(float f) throws InvalidFieldValueException {
        super.setPointSizeMax(f);
        if (this.inSetup) {
            return;
        }
        if (this.oglAttribs.isLive()) {
            this.oglAttribs.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglAttribs);
        }
    }

    protected void setPointSizeAttenuation(float[] fArray) throws InvalidFieldValueException {
        super.setPointSizeAttenuation(fArray);
        if (this.inSetup) {
            return;
        }
        if (this.oglAttribs.isLive()) {
            this.oglAttribs.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglAttribs);
        }
    }

    public void setColorMode(String string) throws InvalidFieldValueException {
        super.setColorMode(string);
        if (this.inSetup) {
            return;
        }
        if (this.oglAttribs.isLive()) {
            this.oglAttribs.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglAttribs);
        }
    }

    private void init() {
        this.oglAttribs = new PointAttributes();
        this.oglAttribs.setAntiAliased(true);
        this.defPointSize = this.oglAttribs.getPointSize();
        this.defMinPointSize = this.oglAttribs.getMinPointSize();
        this.defMaxPointSize = this.oglAttribs.getMaxPointSize();
        this.oglAttribs.getAttenuationFactors(this.defAttenuationFactors);
        this.defColorMode = 1;
    }
}

