/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.shape;

import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.shape.BaseMaterial;
import org.web3d.vrml.renderer.ogl.nodes.OGLMaterialNodeType;

public class OGLMaterial
extends BaseMaterial
implements OGLMaterialNodeType,
NodeUpdateListener {
    private static float[] ignoreColor = new float[]{1.0f, 1.0f, 1.0f};
    private float[] lfAmbientColor = new float[]{0.16f, 0.16f, 0.16f};
    private Material material;
    private boolean ambientChanged;
    private boolean diffuseChanged;
    private boolean emissiveChanged;
    private boolean specularChanged;
    private boolean shininessChanged;
    private boolean transparencyChanged;
    private boolean lightingState;
    private boolean lightingChanged;
    private boolean localColor;
    private boolean localColorAlpha = false;
    private boolean localColorChanged;

    public OGLMaterial() {
    }

    public OGLMaterial(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setLightingEnable(boolean bl) {
        this.lightingState = bl;
        if (this.inSetup) {
            return;
        }
        this.lightingChanged = true;
        if (this.material.isLive()) {
            this.material.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.material);
        }
    }

    public void setLocalColor(boolean bl, boolean bl2) {
        this.localColor = bl;
        this.localColorAlpha = bl2;
        if (this.inSetup) {
            return;
        }
        this.localColorChanged = true;
        if (this.material.isLive()) {
            this.material.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.material);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.material = new Material(this.lfAmbientColor, this.vfEmissiveColor, this.vfDiffuseColor, this.vfSpecularColor, this.vfShininess, 1.0f - this.vfTransparency);
        if (this.ignoreDiffuse) {
            this.material.setDiffuseColor(ignoreColor);
        }
        this.material.setSeparateTransparencyEnabled(!this.localColorAlpha);
        this.material.setColorMaterialTarget(4609);
        this.material.setLightingEnabled(this.lightingState);
        this.ambientChanged = false;
        this.diffuseChanged = false;
        this.emissiveChanged = false;
        this.specularChanged = false;
        this.shininessChanged = false;
        this.transparencyChanged = false;
        this.lightingChanged = false;
        this.localColorChanged = false;
    }

    public void allEventsComplete() {
        if (this.diffuseChanged && this.material != null) {
            if (this.material.isLive()) {
                this.material.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.material);
            }
        }
    }

    public void setAmbientIntensity(float f) throws InvalidFieldValueException {
        super.setAmbientIntensity(f);
        this.lfAmbientColor[0] = this.vfDiffuseColor[0] * this.vfAmbientIntensity;
        this.lfAmbientColor[1] = this.vfDiffuseColor[1] * this.vfAmbientIntensity;
        this.lfAmbientColor[2] = this.vfDiffuseColor[2] * this.vfAmbientIntensity;
        if (this.inSetup) {
            return;
        }
        this.ambientChanged = true;
        if (this.material.isLive()) {
            this.material.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.material);
        }
    }

    public void setDiffuseColor(float[] fArray) throws InvalidFieldValueException {
        super.setDiffuseColor(fArray);
        this.lfAmbientColor[0] = this.vfDiffuseColor[0] * this.vfAmbientIntensity;
        this.lfAmbientColor[1] = this.vfDiffuseColor[1] * this.vfAmbientIntensity;
        this.lfAmbientColor[2] = this.vfDiffuseColor[2] * this.vfAmbientIntensity;
        if (this.inSetup) {
            return;
        }
        this.diffuseChanged = true;
        this.ambientChanged = true;
        if (this.material != null) {
            if (this.material.isLive()) {
                this.material.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.material);
            }
        }
    }

    public void setIgnoreDiffuse(boolean bl) {
        super.setIgnoreDiffuse(bl);
        if (this.inSetup) {
            return;
        }
        this.diffuseChanged = true;
        if (this.material.isLive()) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        } else {
            this.updateNodeDataChanges(this.material);
        }
    }

    public void setEmissiveColor(float[] fArray) throws InvalidFieldValueException {
        super.setEmissiveColor(fArray);
        if (this.inSetup) {
            return;
        }
        this.emissiveChanged = true;
        if (this.material.isLive()) {
            this.material.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.material);
        }
    }

    public void setShininess(float f) throws InvalidFieldValueException {
        super.setShininess(f);
        if (this.inSetup) {
            return;
        }
        this.shininessChanged = true;
        if (this.material.isLive()) {
            this.material.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this);
        }
    }

    public void setSpecularColor(float[] fArray) throws InvalidFieldValueException {
        super.setSpecularColor(fArray);
        if (this.inSetup) {
            return;
        }
        this.specularChanged = true;
        if (this.material.isLive()) {
            this.material.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this);
        }
    }

    public void setTransparency(float f) throws InvalidFieldValueException {
        super.setTransparency(f);
        if (this.inSetup) {
            return;
        }
        this.transparencyChanged = true;
        if (this.material.isLive()) {
            this.material.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.material;
    }

    public void updateNodeBoundsChanges(Object object) {
    }

    public void updateNodeDataChanges(Object object) {
        if (this.ambientChanged) {
            this.material.setAmbientColor(this.lfAmbientColor);
            this.ambientChanged = false;
        }
        if (this.diffuseChanged) {
            if (this.ignoreDiffuse) {
                this.material.setDiffuseColor(ignoreColor);
            } else {
                this.material.setDiffuseColor(this.vfDiffuseColor);
            }
            this.diffuseChanged = false;
        }
        if (this.emissiveChanged) {
            this.material.setEmissiveColor(this.vfEmissiveColor);
            this.emissiveChanged = false;
        }
        if (this.specularChanged) {
            this.material.setSpecularColor(this.vfSpecularColor);
            this.specularChanged = false;
        }
        if (this.shininessChanged) {
            this.material.setShininess(this.vfShininess);
            this.shininessChanged = false;
        }
        if (this.transparencyChanged) {
            this.material.setTransparency(1.0f - this.vfTransparency);
            this.transparencyChanged = false;
        }
        if (this.lightingChanged) {
            this.material.setLightingEnabled(this.lightingState);
            this.lightingChanged = false;
        }
        if (this.localColorChanged) {
            this.material.setSeparateTransparencyEnabled(!this.localColorAlpha);
            this.material.setColorMaterialEnabled(this.localColor);
            this.localColorChanged = false;
        }
    }
}

