/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.shape;

import org.j3d.aviatrix3d.LineAttributes;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.shape.BaseLineProperties;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLLineProperties
extends BaseLineProperties
implements OGLVRMLNode,
NodeUpdateListener {
    private LineAttributes oglAttribs;
    private float defLineWidth;
    private short defStipplePattern;

    public OGLLineProperties() {
        this.init();
    }

    public OGLLineProperties(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.oglAttribs;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.updateNodeDataChanges(this.oglAttribs);
    }

    public void updateNodeBoundsChanges(Object object) {
    }

    public void updateNodeDataChanges(Object object) {
        if (!this.vfApplied) {
            this.oglAttribs.setLineWidth(this.defLineWidth);
            this.oglAttribs.setStipplePattern(this.defStipplePattern);
            return;
        }
        if (this.vfLinewidthScaleFactor <= 0.0f) {
            this.oglAttribs.setLineWidth(1.0f);
        } else {
            this.oglAttribs.setLineWidth(this.vfLinewidthScaleFactor);
        }
        switch (this.vfLinetype) {
            case 1: {
                this.oglAttribs.setStipplePattern((short)0);
                break;
            }
            case 2: {
                this.oglAttribs.setStipplePattern((short)-4370);
                break;
            }
            case 3: {
                this.oglAttribs.setStipplePattern((short)-21846);
                break;
            }
            case 4: {
                this.oglAttribs.setStipplePattern((short)-6940);
                break;
            }
            case 5: {
                this.oglAttribs.setStipplePattern((short)-5398);
                break;
            }
            case 10: {
                this.oglAttribs.setStipplePattern((short)-2314);
                break;
            }
            case 11: {
                this.oglAttribs.setStipplePattern((short)-1029);
                break;
            }
            case 13: {
                this.oglAttribs.setStipplePattern((short)-4370);
            }
        }
    }

    protected void setLineWidthScale(float f) throws InvalidFieldValueException {
        super.setLineWidthScale(f);
        if (this.inSetup) {
            return;
        }
        if (this.oglAttribs.isLive()) {
            this.oglAttribs.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglAttribs);
        }
    }

    protected void setLineType(int n) throws InvalidFieldValueException {
        super.setLineType(n);
        if (this.inSetup) {
            return;
        }
        switch (this.vfLinetype) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 13: {
                if (this.oglAttribs.isLive()) {
                    this.oglAttribs.dataChanged((NodeUpdateListener)this);
                    break;
                }
                this.updateNodeDataChanges(this.oglAttribs);
                break;
            }
            default: {
                System.out.println("OGL cannot handle this line style: " + n);
            }
        }
    }

    private void init() {
        this.oglAttribs = new LineAttributes();
        this.oglAttribs.setAntiAliased(true);
        this.defLineWidth = this.oglAttribs.getLineWidth();
        this.defStipplePattern = this.oglAttribs.getStipplePattern();
    }
}

