/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.shape;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.ByteBufferTextureComponent2D;
import org.j3d.aviatrix3d.ByteBufferTextureComponent3D;
import org.j3d.aviatrix3d.LineAttributes;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.PointAttributes;
import org.j3d.aviatrix3d.PolygonAttributes;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TexCoordGeneration;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.Texture2D;
import org.j3d.aviatrix3d.Texture3D;
import org.j3d.aviatrix3d.TextureAttributes;
import org.j3d.aviatrix3d.TextureComponent;
import org.j3d.aviatrix3d.TextureComponent2D;
import org.j3d.aviatrix3d.TextureComponent3D;
import org.j3d.aviatrix3d.TextureSource;
import org.j3d.aviatrix3d.TextureUnit;
import org.web3d.image.NIOBufferImage;
import org.web3d.image.NIOBufferImageType;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLComposedTextureNodeType;
import org.web3d.vrml.nodes.VRMLMultiTextureNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLTexture2DNodeType;
import org.web3d.vrml.nodes.VRMLTexture3DNodeType;
import org.web3d.vrml.nodes.VRMLTextureListener;
import org.web3d.vrml.nodes.VRMLTextureNodeType;
import org.web3d.vrml.nodes.VRMLTextureProperties2DNodeType;
import org.web3d.vrml.renderer.common.nodes.shape.BaseAppearance;
import org.web3d.vrml.renderer.common.nodes.shape.TextureStage;
import org.web3d.vrml.renderer.ogl.nodes.OGLAppearanceNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLMaterialNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureConstConverter;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureCoordinateTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTextureTransformListener;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.renderer.ogl.nodes.TextureCache;

public class OGLAppearance
extends BaseAppearance
implements OGLAppearanceNodeType,
OGLTextureTransformListener,
NodeUpdateListener,
FrameStateListener {
    private static final String TEXTURE_CREATE_FAIL_MSG = "Failed for an unknown reason during the creation of the base texture image in OGLAppearance.createTexture(). URL is: ";
    private static final String NESTED_MULTITEXTURE_ERR = "Discovered a nested MultiTexture node while processing a MultiTexture node. This is not legal. See 19775-1 18.4.3 paragraph 2 for more information";
    private static final int DEFAULT_CLAMP_MODE = 2;
    private Appearance oglImplNode;
    private PolygonAttributes implPA;
    private TextureAttributes[] texAttrs;
    private TextureUnit[] texUnits;
    private HashMap texGenMap;
    private static HashMap texGenModeMap = new HashMap(3);
    private ArrayList listeners;
    private Texture[] texObjs;
    private VRMLTextureNodeType[] vrmlTexs;
    private int[] modes;
    private int[] functions;
    private int[] sources;
    private boolean threadedUnitChanged;
    private boolean materialChanged;
    private boolean fillPropsChanged;
    private boolean linePropsChanged;
    private boolean pointPropsChanged;
    private boolean textureUnitsChanged;
    private boolean textureTransformChanged;
    private HashMap changedTransforms;
    private HashMap changedTexCoordGeneration;
    private boolean textureChanged;
    private boolean savedSolidState;
    private boolean savedCCWState;
    private ConcurrentLinkedQueue<SceneGraphObject> texUnitsChanged;
    private boolean lightingState;
    private boolean localColor;
    private boolean localColorAlpha;
    boolean lightingOverride;
    private TextureCache textureCache;
    private boolean queryPointSprites;
    private static boolean pointSpritesSupported;

    public OGLAppearance() {
        this.init();
    }

    public OGLAppearance(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void allEventsComplete() {
        if (this.materialChanged || this.linePropsChanged || this.pointPropsChanged || this.fillPropsChanged) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else if (this.threadedUnitChanged) {
            while (!this.texUnitsChanged.isEmpty()) {
                SceneGraphObject sceneGraphObject = this.texUnitsChanged.poll();
                if (sceneGraphObject.isLive()) {
                    sceneGraphObject.dataChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeDataChanges(sceneGraphObject);
                }
                this.threadedUnitChanged = false;
            }
        } else if (this.queryPointSprites) {
            OGLVRMLNode oGLVRMLNode;
            PointAttributes pointAttributes;
            this.queryPointSprites = false;
            if (this.vfPointProperties != null && !(pointSpritesSupported = (pointAttributes = (PointAttributes)(oGLVRMLNode = (OGLVRMLNode)this.vfPointProperties).getSceneGraphObject()).isPointSpriteAllowed())) {
                System.out.println("OGL Point sprites not supported, unroll");
                pointAttributes.setPointSpriteEnabled(false);
                pointAttributes.setAntiAliased(true);
                this.vfTexture = null;
                this.textureChanged = true;
                if (this.oglImplNode.isLive()) {
                    this.oglImplNode.dataChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeDataChanges(this.oglImplNode);
                }
            }
        }
    }

    public void setMaterial(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setMaterial(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        this.materialChanged = true;
        if (this.oglImplNode.isLive()) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglImplNode);
        }
    }

    public void setTexture(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        VRMLTextureNodeType vRMLTextureNodeType = this.vfTexture;
        super.setTexture(vRMLNodeType);
        if (vRMLTextureNodeType != null) {
            vRMLTextureNodeType.removeTextureListener((VRMLTextureListener)this);
        }
        if (this.vfTexture != null) {
            this.vfTexture.addTextureListener((VRMLTextureListener)this);
        }
        if (this.inSetup) {
            return;
        }
        this.textureChanged = true;
        if (this.oglImplNode.isLive()) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglImplNode);
        }
    }

    public void setTextureTransform(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        OGLTextureCoordinateTransformNodeType oGLTextureCoordinateTransformNodeType = (OGLTextureCoordinateTransformNodeType)this.vfTextureTransform;
        super.setTextureTransform(vRMLNodeType);
        OGLTextureCoordinateTransformNodeType oGLTextureCoordinateTransformNodeType2 = (OGLTextureCoordinateTransformNodeType)this.vfTextureTransform;
        if (oGLTextureCoordinateTransformNodeType2 != null) {
            oGLTextureCoordinateTransformNodeType2.addTransformListener(this);
        }
        if (oGLTextureCoordinateTransformNodeType != null) {
            oGLTextureCoordinateTransformNodeType.removeTransformListener(this);
        }
        if (this.inSetup) {
            return;
        }
        this.textureTransformChanged = true;
        if (this.oglImplNode.isLive()) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglImplNode);
        }
    }

    public void setLineProperties(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setLineProperties(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        this.linePropsChanged = true;
        if (this.oglImplNode.isLive()) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglImplNode);
        }
    }

    public void setPointProperties(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setPointProperties(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        this.pointPropsChanged = true;
        if (this.oglImplNode.isLive()) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglImplNode);
        }
    }

    public void setFillProperties(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setFillProperties(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        this.fillPropsChanged = true;
        if (this.oglImplNode.isLive()) {
            this.oglImplNode.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.oglImplNode);
        }
    }

    public Appearance getAppearance() {
        return this.oglImplNode;
    }

    public void setTexCoordGenMode(int n, String string) {
        this.texGenMap.put(new Integer(n), string);
        if (this.inSetup) {
            return;
        }
        Integer n2 = (Integer)texGenModeMap.get(string);
        if (n2 != null) {
            TexCoordGeneration texCoordGeneration = new TexCoordGeneration();
            texCoordGeneration.setParameter(8192, 9472, n2.intValue(), null);
            texCoordGeneration.setParameter(8193, 9472, n2.intValue(), null);
            if (this.vfTexture != null && this.vfTexture.getTextureType() == 1) {
                texCoordGeneration.setParameter(8194, 9472, n2.intValue(), null);
            }
            this.stages[n].texCoordGeneration = texCoordGeneration;
            this.changedTexCoordGeneration.put(this.texUnits[n], this.stages[n]);
            if (this.texUnits[n].isLive()) {
                this.texUnits[n].dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.texUnits[n]);
            }
        } else {
            this.stages[n].texCoordGeneration = null;
            this.changedTexCoordGeneration.put(this.texUnits[n], this.stages[n]);
            if (this.texUnits[n].isLive()) {
                this.texUnits[n].dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.texUnits[n]);
            }
        }
    }

    public void setSolid(boolean bl) {
        this.savedSolidState = bl;
        if (this.implPA.isLive()) {
            this.implPA.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implPA);
        }
    }

    public void setLightingEnabled(boolean bl) {
        this.lightingState = bl;
        if (this.vfMaterial != null && !this.lightingOverride) {
            ((OGLMaterialNodeType)this.vfMaterial).setLightingEnable(bl);
        }
    }

    public void setLocalColor(boolean bl, boolean bl2) {
        this.localColor = bl;
        this.localColorAlpha = bl2;
        if (this.vfMaterial != null) {
            ((OGLMaterialNodeType)this.vfMaterial).setLocalColor(bl, bl2);
        }
    }

    public void setCCW(boolean bl) {
        this.savedCCWState = bl;
        if (this.implPA.isLive()) {
            this.implPA.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implPA);
        }
    }

    public void textureTransformChanged(OGLVRMLNode oGLVRMLNode, Matrix4f[] matrix4fArray, boolean[] blArray) {
        int n = matrix4fArray.length;
        this.insureStageSize(n, false);
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            this.changedTransforms.put(this.texUnits[i], this.stages[i]);
            this.stages[i].transform = matrix4fArray[i];
            if (this.texUnits[i].isLive()) {
                this.texUnits[i].dataChanged((NodeUpdateListener)this);
                continue;
            }
            this.updateNodeDataChanges(this.texUnits[i]);
        }
    }

    public void textureImageChanged(int n, VRMLNodeType vRMLNodeType, NIOBufferImage nIOBufferImage, String string) {
        super.textureImageChanged(n, vRMLNodeType, nIOBufferImage, string);
        if (n < this.numStages && this.vrmlTexs != null) {
            int n2 = this.vfTexture.getTextureType();
            switch (n2) {
                case 0: {
                    TextureStage textureStage = this.stages[n];
                    if (textureStage.images != null && textureStage.images.length > 0) {
                        this.setIgnoreDiffuse(textureStage.images[0]);
                    }
                }
                case 2: {
                    this.texObjs[n] = this.createTexture(this.stages[n], string, this.vrmlTexs[n].getTextureType());
                    this.texUnitsChanged.add((SceneGraphObject)this.texUnits[n]);
                    ((OGLTextureNodeType)this.vfTexture).setTexture(n, this.texObjs[n]);
                    this.threadedUnitChanged = true;
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                    break;
                }
                case 1: {
                    this.texObjs[0] = this.createTexture(this.stages[0], string, n2);
                    this.texUnitsChanged.add((SceneGraphObject)this.texUnits[0]);
                    ((OGLTextureNodeType)this.vfTexture).setTexture(0, this.texObjs[0]);
                    this.threadedUnitChanged = true;
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                }
            }
        } else {
            this.createTextureUnits();
        }
    }

    public void textureImageChanged(int n, VRMLNodeType[] vRMLNodeTypeArray, NIOBufferImage[] nIOBufferImageArray, String[] stringArray) {
        super.textureImageChanged(n, vRMLNodeTypeArray, nIOBufferImageArray, stringArray);
        if (n <= this.numStages) {
            int n2 = this.vfTexture.getTextureType();
            if (n2 == 1) {
                this.stages[0].mode = this.getMode(nIOBufferImageArray[0], true);
                this.texObjs[0] = this.createTexture(this.stages[0], null, n2);
                this.texUnits[0].setTexture(this.texObjs[0]);
                ((OGLTextureNodeType)this.vfTexture).setTexture(0, this.texObjs[0]);
            } else {
                for (int i = 0; i < n; ++i) {
                    this.stages[i].mode = this.getMode(nIOBufferImageArray[i], i == 0);
                    this.texObjs[i] = this.createTexture(this.stages[i], stringArray[i], this.vrmlTexs[i].getTextureType());
                    this.texUnits[i].setTexture(this.texObjs[i]);
                    ((OGLTextureNodeType)this.vfTexture).setTexture(i, this.texObjs[i]);
                }
            }
        } else {
            this.createTextureUnits();
        }
    }

    public void textureParamsChanged(int n, int n2, int n3, int n4, float f, float[] fArray) {
        super.textureParamsChanged(n, n2, n3, n4, f, fArray);
    }

    public void textureParamsChanged(int n, int[] nArray, int[] nArray2, int[] nArray3, float f, float[] fArray) {
        super.textureParamsChanged(n, nArray, nArray2, nArray3, f, fArray);
        if (n <= this.numStages) {
            for (int i = 0; i < n; ++i) {
                this.stages[i].mode = nArray[i];
                this.setTextureMode(i, this.stages[i], this.texAttrs[i]);
            }
        } else {
            this.createTextureUnits();
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.oglImplNode;
    }

    public void setupFinished() {
        LineAttributes lineAttributes;
        OGLVRMLNode oGLVRMLNode;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        OGLMaterialNodeType oGLMaterialNodeType = (OGLMaterialNodeType)this.vfMaterial;
        if (this.vfMaterial != null) {
            oGLMaterialNodeType.setLightingEnable(this.lightingState);
            oGLMaterialNodeType.setLocalColor(this.localColor, this.localColorAlpha);
        }
        Material material = oGLMaterialNodeType == null ? null : oGLMaterialNodeType.getMaterial();
        this.oglImplNode.setMaterial(material);
        if (this.vfLineProperties != null) {
            oGLVRMLNode = (OGLVRMLNode)this.vfLineProperties;
            lineAttributes = (LineAttributes)oGLVRMLNode.getSceneGraphObject();
            this.oglImplNode.setLineAttributes(lineAttributes);
        }
        if (this.vfPointProperties != null) {
            this.queryPointSprites = true;
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            oGLVRMLNode = (OGLVRMLNode)this.vfPointProperties;
            lineAttributes = (PointAttributes)oGLVRMLNode.getSceneGraphObject();
            if (pointSpritesSupported && this.vfTexture != null) {
                lineAttributes.setAntiAliased(false);
                lineAttributes.setPointSpriteEnabled(true);
            } else {
                lineAttributes.setPointSpriteEnabled(false);
                lineAttributes.setAntiAliased(true);
                this.vfTexture = null;
            }
            this.oglImplNode.setPointAttributes((PointAttributes)lineAttributes);
        }
        this.createTextureTransform();
        this.createTextureUnits();
        this.materialChanged = false;
        this.fillPropsChanged = false;
        this.linePropsChanged = false;
        this.pointPropsChanged = false;
        this.textureUnitsChanged = false;
        this.textureTransformChanged = false;
        this.textureChanged = false;
        this.threadedUnitChanged = false;
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            return;
        }
        super.notifyExternProtoLoaded(n, vRMLNodeType);
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        switch (n) {
            case 1: {
                if (this.oglImplNode.isLive()) {
                    this.materialChanged = true;
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                    break;
                }
                Material material = (Material)oGLVRMLNode.getSceneGraphObject();
                this.oglImplNode.setMaterial(material);
                break;
            }
            case 2: {
                this.createTextureUnits();
                break;
            }
            case 3: {
                this.createTextureTransform();
                break;
            }
            case 4: {
                if (this.oglImplNode.isLive()) {
                    this.linePropsChanged = true;
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                    break;
                }
                LineAttributes lineAttributes = (LineAttributes)oGLVRMLNode.getSceneGraphObject();
                this.oglImplNode.setLineAttributes(lineAttributes);
                break;
            }
            case 5: {
                if (this.oglImplNode.isLive()) {
                    this.linePropsChanged = true;
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                    break;
                }
                PointAttributes pointAttributes = (PointAttributes)oGLVRMLNode.getSceneGraphObject();
                this.oglImplNode.setPointAttributes(pointAttributes);
                break;
            }
            case 6: {
                if (!this.oglImplNode.isLive()) break;
                this.fillPropsChanged = true;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            }
        }
    }

    public void updateNodeBoundsChanges(Object object) {
    }

    public void updateNodeDataChanges(Object object) {
        if (object == this.oglImplNode) {
            Object object2;
            OGLMaterialNodeType oGLMaterialNodeType;
            if (this.materialChanged) {
                this.materialChanged = false;
                oGLMaterialNodeType = (OGLMaterialNodeType)this.vfMaterial;
                object2 = oGLMaterialNodeType == null ? null : oGLMaterialNodeType.getMaterial();
                this.oglImplNode.setMaterial((Material)object2);
            }
            if (this.textureChanged) {
                this.textureChanged = false;
                this.createTextureUnits();
            }
            if (this.textureTransformChanged) {
                this.textureTransformChanged = false;
                this.createTextureTransform();
            }
            if (this.textureUnitsChanged) {
                this.textureUnitsChanged = false;
                this.oglImplNode.setTextureUnits(this.texUnits, this.numStages);
            }
            if (this.linePropsChanged) {
                this.linePropsChanged = false;
                oGLMaterialNodeType = null;
                if (this.vfLineProperties != null) {
                    object2 = (OGLVRMLNode)this.vfLineProperties;
                    oGLMaterialNodeType = (LineAttributes)object2.getSceneGraphObject();
                }
                this.oglImplNode.setLineAttributes((LineAttributes)oGLMaterialNodeType);
            }
            if (this.pointPropsChanged) {
                this.pointPropsChanged = false;
                oGLMaterialNodeType = null;
                if (this.vfPointProperties != null) {
                    object2 = (OGLVRMLNode)this.vfPointProperties;
                    oGLMaterialNodeType = (PointAttributes)object2.getSceneGraphObject();
                }
                this.oglImplNode.setPointAttributes((PointAttributes)oGLMaterialNodeType);
            }
            if (this.fillPropsChanged) {
                this.fillPropsChanged = false;
            }
        } else if (object == this.implPA) {
            if (this.savedSolidState) {
                this.implPA.setCulledFace(1029);
                this.implPA.setTwoSidedLighting(false);
            } else {
                this.implPA.setCulledFace(0);
                this.implPA.setTwoSidedLighting(true);
            }
            this.implPA.setCCW(this.savedCCWState);
        } else if (object instanceof TextureUnit) {
            TextureUnit textureUnit;
            for (int i = 0; i < this.numStages; ++i) {
                if (this.texUnits[i] != object) continue;
                if (this.stages[i].mode != 15) {
                    this.texUnits[i].setTexture(this.texObjs[i]);
                    break;
                }
                this.texUnits[i].setTexture(null);
                break;
            }
            this.texUnitsChanged.remove(object);
            TextureStage textureStage = (TextureStage)this.changedTransforms.get(object);
            if (textureStage != null) {
                textureUnit = (TextureUnit)object;
                textureUnit.setTextureTransform((Matrix4f)textureStage.transform);
                this.changedTransforms.remove(object);
            }
            if ((textureStage = (TextureStage)this.changedTexCoordGeneration.get(object)) != null) {
                textureUnit = (TextureUnit)object;
                textureUnit.setTexCoordGeneration((TexCoordGeneration)textureStage.texCoordGeneration);
                this.changedTexCoordGeneration.remove(object);
            }
        }
    }

    private void init() {
        this.lightingState = true;
        this.localColor = false;
        this.localColorAlpha = false;
        this.savedSolidState = true;
        this.savedCCWState = true;
        this.lightingOverride = false;
        this.queryPointSprites = false;
        this.oglImplNode = new Appearance();
        this.implPA = new PolygonAttributes();
        this.texGenMap = new HashMap(2);
        this.changedTransforms = new HashMap();
        this.changedTexCoordGeneration = new HashMap();
        this.oglImplNode.setPolygonAttributes(this.implPA);
        if (useTextureCache) {
            this.textureCache = TextureCache.getInstance();
        }
        this.listeners = new ArrayList(1);
        this.numStages = 0;
        this.texUnitsChanged = new ConcurrentLinkedQueue();
    }

    private void createTextureUnits() {
        int n;
        this.numStages = 0;
        if (this.vfTexture != null) {
            switch (this.vfTexture.getTextureType()) {
                case 0: {
                    VRMLComposedTextureNodeType vRMLComposedTextureNodeType;
                    ++this.numStages;
                    this.vrmlTexs = new VRMLTextureNodeType[this.numStages];
                    this.modes = new int[this.numStages];
                    this.sources = new int[this.numStages];
                    this.functions = new int[this.numStages];
                    this.vrmlTexs[this.numStages - 1] = this.vfTexture;
                    this.modes[this.numStages - 1] = this.getMode(((VRMLTexture2DNodeType)this.vfTexture).getImage(), true);
                    if (this.modes[this.numStages - 1] != 1) break;
                    Object object = (OGLMaterialNodeType)this.vfMaterial;
                    Material material = vRMLComposedTextureNodeType = object == null ? null : object.getMaterial();
                    if (vRMLComposedTextureNodeType != null && this.vfMaterial.getTransparency() == 0.0f) {
                        vRMLComposedTextureNodeType.setLightingEnabled(false);
                        this.lightingOverride = true;
                        break;
                    }
                    if (vRMLComposedTextureNodeType != null && this.lightingState) {
                        vRMLComposedTextureNodeType.setLightingEnabled(true);
                    }
                    this.lightingOverride = false;
                    break;
                }
                case 2: {
                    Object object = (VRMLMultiTextureNodeType)this.vfTexture;
                    this.numStages += object.getNumberTextures();
                    this.vrmlTexs = new VRMLTextureNodeType[this.numStages];
                    this.modes = new int[this.numStages];
                    this.sources = new int[this.numStages];
                    this.functions = new int[this.numStages];
                    object.getTextures(0, this.vrmlTexs);
                    object.getTextureParams(0, this.modes, this.functions, this.sources);
                    break;
                }
                case 1: {
                    VRMLComposedTextureNodeType vRMLComposedTextureNodeType = (VRMLComposedTextureNodeType)this.vfTexture;
                    this.vrmlTexs = new VRMLTextureNodeType[this.numStages + vRMLComposedTextureNodeType.getNumberTextures()];
                    ++this.numStages;
                    this.modes = new int[this.numStages];
                    this.sources = new int[this.numStages];
                    this.functions = new int[this.numStages];
                    vRMLComposedTextureNodeType.getTextures(0, this.vrmlTexs);
                    this.modes[this.numStages - 1] = 1;
                    break;
                }
                case 4: {
                    ++this.numStages;
                    this.vrmlTexs = new VRMLTextureNodeType[this.numStages];
                    this.modes = new int[this.numStages];
                    this.sources = new int[this.numStages];
                    this.functions = new int[this.numStages];
                    this.vrmlTexs[this.numStages - 1] = this.vfTexture;
                    this.modes[this.numStages - 1] = 1;
                    break;
                }
            }
        }
        this.texObjs = new Texture[this.numStages];
        this.texUnits = new TextureUnit[this.numStages];
        this.texAttrs = new TextureAttributes[this.numStages];
        this.insureStageSize(this.numStages, true);
        for (int i = n = 0; i < this.numStages; ++i) {
            TextureStage textureStage = this.stages[i];
            TexCoordGeneration texCoordGeneration = null;
            boolean bl = false;
            if (this.vfTextureProperties != null) {
                VRMLTextureProperties2DNodeType vRMLTextureProperties2DNodeType = this.vfTextureProperties;
                textureStage.boundaryModeS = vRMLTextureProperties2DNodeType.getBoundaryModeS();
                textureStage.boundaryModeT = vRMLTextureProperties2DNodeType.getBoundaryModeT();
                textureStage.boundaryColor = new float[4];
                vRMLTextureProperties2DNodeType.getBoundaryColor(textureStage.boundaryColor);
                textureStage.minFilter = vRMLTextureProperties2DNodeType.getMinificationFilter();
                textureStage.magFilter = vRMLTextureProperties2DNodeType.getMagnificationFilter();
            }
            int n2 = this.vrmlTexs[i].getTextureType();
            switch (n2) {
                case 2: {
                    this.errorReporter.warningReport(NESTED_MULTITEXTURE_ERR, null);
                    break;
                }
                case 0: {
                    Object object;
                    n2 = this.vrmlTexs[i].getTextureType();
                    if ((textureStage.images == null || textureStage.images.length == 0) && (object = ((VRMLTexture2DNodeType)this.vrmlTexs[i]).getImage()) != null) {
                        textureStage.images = this.processImage(0, (NIOBufferImage)object, null);
                        this.setIgnoreDiffuse((NIOBufferImage)object);
                    }
                    textureStage.mode = this.modes[i];
                    if (this.vfTextureProperties == null) {
                        object = (VRMLTexture2DNodeType)this.vrmlTexs[i];
                        textureStage.boundaryModeS = object.getRepeatS() ? 0 : 2;
                        int n3 = textureStage.boundaryModeT = object.getRepeatT() ? 0 : 2;
                    }
                    if ((object = (String)this.texGenMap.get(new Integer(n))) == null) break;
                    Object object2 = (Integer)texGenModeMap.get(object);
                    if (object2 != null) {
                        texCoordGeneration = new TexCoordGeneration();
                        texCoordGeneration.setParameter(8192, 9472, ((Integer)object2).intValue(), null);
                        texCoordGeneration.setParameter(8193, 9472, ((Integer)object2).intValue(), null);
                        textureStage.texCoordGeneration = texCoordGeneration;
                        break;
                    }
                    System.out.println("TexCoordGen mode not found: " + object2);
                    textureStage.texCoordGeneration = null;
                    break;
                }
                case 1: {
                    Object object2;
                    textureStage.mode = this.modes[i];
                    if (this.vfTextureProperties != null) {
                        object2 = this.vfTextureProperties;
                    } else {
                        object2 = (VRMLTexture3DNodeType)this.vfTexture;
                        textureStage.boundaryModeS = object2.getRepeatS() ? 0 : 2;
                        textureStage.boundaryModeT = object2.getRepeatT() ? 0 : 2;
                        textureStage.boundaryModeR = object2.getRepeatR() ? 0 : 2;
                        textureStage.depth = object2.getDepth();
                    }
                    Object object = (String)this.texGenMap.get(new Integer(n));
                    if (object == null) break;
                    object2 = (Integer)texGenModeMap.get(object);
                    if (object2 != null) {
                        texCoordGeneration = new TexCoordGeneration();
                        texCoordGeneration.setParameter(8192, 9472, ((Integer)object2).intValue(), null);
                        texCoordGeneration.setParameter(8193, 9472, ((Integer)object2).intValue(), null);
                        texCoordGeneration.setParameter(8194, 9472, ((Integer)object2).intValue(), null);
                        textureStage.texCoordGeneration = texCoordGeneration;
                        break;
                    }
                    System.out.println("TexCoordGen mode not found: " + object2);
                    textureStage.texCoordGeneration = null;
                    break;
                }
                case 4: {
                    bl = true;
                    Object object2 = (OGLVRMLNode)this.vfTexture;
                    this.texObjs[i] = (Texture)object2.getSceneGraphObject();
                    break;
                }
            }
            if (!bl) {
                this.texObjs[i] = this.createTexture(textureStage, this.urls[i], n2);
                ((OGLTextureNodeType)this.vfTexture).setTexture(i, this.texObjs[i]);
            }
            this.texAttrs[i] = this.createTextureAttributes(i, textureStage);
            this.texUnits[i] = new TextureUnit(this.texObjs[i], this.texAttrs[i], texCoordGeneration);
            if (textureStage.transform == null) continue;
            this.texUnits[i].setTextureTransform((Matrix4f)textureStage.transform);
        }
        this.oglImplNode.setTextureUnits(this.texUnits, this.numStages);
    }

    private void createTextureTransform() {
        if (this.vfTextureTransform != null) {
            Matrix4f[] matrix4fArray = ((OGLTextureCoordinateTransformNodeType)this.vfTextureTransform).getTransformMatrix();
            int n = matrix4fArray.length;
            this.insureStageSize(n, false);
            for (int i = 0; i < n; ++i) {
                this.stages[i].transform = matrix4fArray[i];
            }
        }
    }

    private Texture createTexture(TextureStage textureStage, String string, int n) {
        VRMLTexture3DNodeType vRMLTexture3DNodeType;
        VRMLTextureProperties2DNodeType vRMLTextureProperties2DNodeType;
        Texture2D texture2D = null;
        boolean bl = textureStage.images == null || textureStage.images.length < 1 || textureStage.images[0] == null;
        int n2 = 0;
        if (this.vfTextureProperties != null) {
            vRMLTextureProperties2DNodeType = this.vfTextureProperties;
            textureStage.generateMipMaps = vRMLTextureProperties2DNodeType.getGenerateMipMaps();
            textureStage.boundaryModeS = vRMLTextureProperties2DNodeType.getBoundaryModeS();
            textureStage.boundaryModeT = vRMLTextureProperties2DNodeType.getBoundaryModeT();
            textureStage.minFilter = vRMLTextureProperties2DNodeType.getMinificationFilter();
            textureStage.magFilter = vRMLTextureProperties2DNodeType.getMagnificationFilter();
            textureStage.anisotropicMode = vRMLTextureProperties2DNodeType.getAnisotropicMode();
            textureStage.anisotropicDegree = vRMLTextureProperties2DNodeType.getAnisotropicDegree();
        } else {
            switch (n) {
                case 0: {
                    vRMLTextureProperties2DNodeType = (VRMLTexture2DNodeType)this.vrmlTexs[textureStage.stageNumber];
                    textureStage.boundaryModeS = vRMLTextureProperties2DNodeType.getRepeatS() ? 0 : 2;
                    textureStage.boundaryModeT = vRMLTextureProperties2DNodeType.getRepeatT() ? 0 : 2;
                    break;
                }
                case 1: {
                    vRMLTexture3DNodeType = (VRMLTexture3DNodeType)this.vrmlTexs[textureStage.stageNumber];
                    textureStage.boundaryModeS = vRMLTexture3DNodeType.getRepeatS() ? 0 : 2;
                    textureStage.boundaryModeT = vRMLTexture3DNodeType.getRepeatT() ? 0 : 2;
                    int n3 = textureStage.boundaryModeR = vRMLTexture3DNodeType.getRepeatR() ? 0 : 2;
                }
            }
            if (anisotropicDegree > 1) {
                textureStage.anisotropicMode = 1;
                textureStage.anisotropicDegree = anisotropicDegree;
            }
        }
        try {
            switch (n) {
                case 2: {
                    break;
                }
                case 0: {
                    texture2D = new Texture2D();
                    int n4 = OGLTextureConstConverter.convertAnisotropicMode(textureStage.anisotropicMode);
                    texture2D.setAnisotropicFilterMode(n4);
                    texture2D.setAnisotropicFilterDegree(textureStage.anisotropicDegree);
                    n4 = OGLTextureConstConverter.convertBoundary(textureStage.boundaryModeS);
                    texture2D.setBoundaryModeS(n4);
                    n4 = OGLTextureConstConverter.convertBoundary(textureStage.boundaryModeT);
                    texture2D.setBoundaryModeT(n4);
                    n4 = OGLTextureConstConverter.convertMinFilter(textureStage.minFilter);
                    texture2D.setMinFilter(n4);
                    n4 = OGLTextureConstConverter.convertMagFilter(textureStage.magFilter);
                    texture2D.setMagFilter(n4);
                    if (bl) break;
                    vRMLTexture3DNodeType = textureStage.images[0];
                    int n5 = this.getFormat((NIOBufferImage)vRMLTexture3DNodeType);
                    TextureComponent2D[] textureComponent2DArray = new TextureComponent2D[]{new ByteBufferTextureComponent2D(n5, vRMLTexture3DNodeType.getWidth(), vRMLTexture3DNodeType.getHeight(), vRMLTexture3DNodeType.getBuffer(null))};
                    n2 = this.getTextureFormat((TextureComponent)textureComponent2DArray[0]);
                    int n6 = textureStage.images.length;
                    for (int i = 0; i < n6; ++i) {
                        textureStage.images[i] = null;
                    }
                    textureStage.images = null;
                    if (vRMLTexture3DNodeType.getLevels() == 1) {
                        texture2D.setSources(0, n2, (TextureSource[])textureComponent2DArray, 1);
                    } else {
                        texture2D.setSources(1, n2, (TextureSource[])textureComponent2DArray, 1);
                    }
                    textureComponent2DArray[0].clearLocalData();
                    break;
                }
                case 1: {
                    texture2D = new Texture3D();
                    int n7 = OGLTextureConstConverter.convertAnisotropicMode(textureStage.anisotropicMode);
                    texture2D.setAnisotropicFilterMode(1);
                    texture2D.setAnisotropicFilterDegree(textureStage.anisotropicDegree);
                    n7 = OGLTextureConstConverter.convertBoundary(textureStage.boundaryModeS);
                    texture2D.setBoundaryModeS(n7);
                    n7 = OGLTextureConstConverter.convertBoundary(textureStage.boundaryModeT);
                    ((Texture3D)texture2D).setBoundaryModeT(n7);
                    n7 = OGLTextureConstConverter.convertBoundary(textureStage.boundaryModeR);
                    ((Texture3D)texture2D).setBoundaryModeR(n7);
                    n7 = OGLTextureConstConverter.convertMinFilter(textureStage.minFilter);
                    texture2D.setMinFilter(n7);
                    n7 = OGLTextureConstConverter.convertMagFilter(textureStage.magFilter);
                    texture2D.setMagFilter(n7);
                    if (textureStage.images.length < textureStage.depth) {
                        bl = true;
                    }
                    if (!bl) {
                        int n8 = this.getFormat(textureStage.images[0]);
                        for (int i = 0; i < textureStage.depth; ++i) {
                            if (textureStage.images[i] == null) {
                                bl = true;
                            }
                            if (this.getFormat(textureStage.images[i]) == n8) continue;
                            bl = true;
                        }
                    }
                    if (bl) break;
                    int n9 = this.getFormat(textureStage.images[0]);
                    int n10 = textureStage.images[0].getWidth();
                    int n11 = textureStage.images[0].getHeight();
                    TextureComponent3D[] textureComponent3DArray = new TextureComponent3D[1];
                    int n12 = textureStage.images.length;
                    ByteBuffer[] byteBufferArray = new ByteBuffer[n12];
                    for (int i = 0; i < n12; ++i) {
                        byteBufferArray[i] = textureStage.images[i].getBuffer();
                    }
                    textureComponent3DArray[0] = new ByteBufferTextureComponent3D(n10, n11, n9, byteBufferArray);
                    n2 = this.getTextureFormat((TextureComponent)textureComponent3DArray[0]);
                    texture2D.setSources(0, n2, (TextureSource[])textureComponent3DArray, 1);
                    textureStage.images = null;
                }
            }
        }
        catch (Exception exception) {
            this.errorReporter.errorReport(TEXTURE_CREATE_FAIL_MSG + string, exception);
            return texture2D;
        }
        if (useTextureCache) {
            texture2D = this.textureCache.register(string, (Texture)texture2D);
        }
        return texture2D;
    }

    private TextureAttributes createTextureAttributes(int n, TextureStage textureStage) {
        TextureAttributes textureAttributes = new TextureAttributes();
        this.setTextureMode(n, textureStage, textureAttributes);
        if (pointSpritesSupported && this.vfPointProperties != null) {
            textureAttributes.setPointSpriteCoordEnabled(true);
            textureAttributes.setTextureMode(34160);
            textureAttributes.setCombineMode(true, 8448);
            switch (this.vfPointProperties.getColorMode()) {
                case 2: {
                    textureAttributes.setCombineSource(false, 0, 34167);
                    textureAttributes.setCombineMode(false, 7681);
                    break;
                }
                case 3: {
                    textureAttributes.setCombineMode(false, 260);
                    break;
                }
                default: {
                    textureAttributes.setCombineMode(false, 7681);
                    break;
                }
            }
        } else {
            textureAttributes.setPointSpriteCoordEnabled(false);
        }
        return textureAttributes;
    }

    private void setTextureMode(int n, TextureStage textureStage, TextureAttributes textureAttributes) {
        switch (textureStage.mode) {
            case 1: {
                textureAttributes.setTextureMode(7681);
                break;
            }
            case 0: {
                textureAttributes.setTextureMode(8448);
                break;
            }
            case 2: {
                textureAttributes.setTextureMode(8448);
                textureAttributes.setCombineScale(false, 2.0f);
                break;
            }
            case 3: {
                textureAttributes.setTextureMode(8448);
                textureAttributes.setCombineScale(false, 4.0f);
                break;
            }
            case 18: {
                textureAttributes.setTextureMode(34160);
                textureAttributes.setCombineMode(false, 34478);
                textureAttributes.setCombineMode(true, 7681);
                textureAttributes.setCombineSource(false, 0, 5890);
                break;
            }
            case 4: {
                textureAttributes.setTextureMode(34160);
                textureAttributes.setCombineMode(false, 260);
                textureAttributes.setCombineMode(true, 7681);
                break;
            }
            case 5: {
                textureAttributes.setTextureMode(34160);
                textureAttributes.setCombineMode(false, 34164);
                break;
            }
            case 6: {
                textureAttributes.setTextureMode(34160);
                textureAttributes.setCombineMode(false, 34164);
                textureAttributes.setCombineScale(false, 2.0f);
                break;
            }
            case 7: {
                textureAttributes.setTextureMode(34160);
                textureAttributes.setCombineMode(false, 34023);
                break;
            }
            case 15: {
                if (this.texUnits[n] == null) break;
                this.texUnits[n].setTexture(null);
                break;
            }
            default: {
                System.out.println("Unknown TextureConstants.Mode: " + textureStage.mode);
            }
        }
    }

    protected int getTextureFormat(TextureComponent textureComponent) {
        int n = 6407;
        switch (textureComponent.getFormat(0)) {
            case 6: {
                n = 6409;
                break;
            }
            case 5: {
                n = 6410;
                break;
            }
            case 1: {
                n = 6407;
                break;
            }
            case 2: {
                n = 6408;
            }
        }
        return n;
    }

    protected int getFormat(NIOBufferImage nIOBufferImage) {
        int n = 0;
        NIOBufferImageType nIOBufferImageType = nIOBufferImage.getType();
        if (nIOBufferImageType == NIOBufferImageType.INTENSITY) {
            n = 6;
        } else if (nIOBufferImageType == NIOBufferImageType.INTENSITY_ALPHA) {
            n = 5;
        } else if (nIOBufferImageType == NIOBufferImageType.RGB) {
            n = 1;
        } else if (nIOBufferImageType == NIOBufferImageType.RGBA) {
            n = 2;
        } else {
            System.out.println("Unknown NIOBufferImageType: " + nIOBufferImageType.name);
        }
        return n;
    }

    private int getMode(NIOBufferImage nIOBufferImage, boolean bl) {
        int n = 0;
        if (bl) {
            this.setIgnoreDiffuse(nIOBufferImage);
        }
        return n;
    }

    private void setIgnoreDiffuse(NIOBufferImage nIOBufferImage) {
        boolean bl = true;
        if (nIOBufferImage != null) {
            boolean bl2 = bl = !nIOBufferImage.isGrayScale();
        }
        if (this.vfMaterial != null) {
            this.vfMaterial.setIgnoreDiffuse(bl);
        }
    }

    static {
        texGenModeMap.put("SPHERE", new Integer(9218));
        texGenModeMap.put("CAMERASPACENORMAL", new Integer(34065));
        texGenModeMap.put("CAMERASPACEREFLECTIONVECTOR", new Integer(34066));
        texGenModeMap.put("CAMERASPACEPOSITION", new Integer(9216));
    }
}

