/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.render;

import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.PointArray;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.geom.GeometryData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.render.BasePointSet;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;

public class OGLPointSet
extends BasePointSet
implements OGLGeometryNodeType,
NodeUpdateListener {
    private PointArray implGeom;
    private float[] tmpColors;
    private float[] unlitColor;
    private boolean coordChanged;
    private boolean colorChanged;

    public OGLPointSet() {
        this.init();
    }

    public OGLPointSet(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Geometry getGeometry() {
        return this.implGeom;
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public boolean requiresUnlitColor() {
        return true;
    }

    public void setUnlitColor(float[] fArray) {
        this.changeFlags |= 0x40;
        if (this.unlitColor == null) {
            this.unlitColor = new float[3];
        }
        this.unlitColor[0] = fArray[0];
        this.unlitColor[1] = fArray[1];
        this.unlitColor[2] = fArray[2];
        if (this.implGeom.isLive()) {
            this.implGeom.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implGeom);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void updateNodeBoundsChanges(Object object) {
        if (this.coordChanged) {
            if (this.vfCoord == null) {
                this.implGeom.setValidVertexCount(0);
            } else {
                this.implGeom.setVertices(3, this.geomData.coordinates, this.geomData.vertexCount);
            }
            this.coordChanged = false;
        }
    }

    public void updateNodeDataChanges(Object object) {
        if (this.colorChanged) {
            if (this.vfColor == null) {
                this.implGeom.setSingleColor(false, this.unlitColor);
            } else {
                boolean bl = this.vfColor.getNumColorComponents() == 4;
                this.implGeom.setColors(bl, this.geomData.colors);
            }
            this.colorChanged = false;
        }
    }

    protected void buildImpl() {
        boolean bl = false;
        if (this.implGeom == null) {
            this.implGeom = new PointArray(true, 35044);
            bl = true;
        }
        if (bl) {
            this.coordChanged = true;
            this.colorChanged = true;
            this.updateCoordinateArray();
            this.updateColorArray();
            if (this.implGeom.isLive()) {
                this.implGeom.boundsChanged((NodeUpdateListener)this);
                this.implGeom.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(null);
                this.updateNodeDataChanges(null);
            }
        } else {
            if ((this.changeFlags & 1) != 0) {
                this.updateCoordinateArray();
                this.coordChanged = true;
                if (this.implGeom.isLive()) {
                    this.implGeom.boundsChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeBoundsChanges(this.implGeom);
                }
            }
            if ((this.changeFlags & 8) != 0) {
                this.updateColorArray();
                this.colorChanged = true;
                if (this.implGeom.isLive()) {
                    this.implGeom.dataChanged((NodeUpdateListener)this);
                } else {
                    this.updateNodeDataChanges(this.implGeom);
                }
            }
        }
        this.changeFlags = 0;
    }

    private void init() {
        this.geomData = new GeometryData();
        this.coordChanged = false;
        this.colorChanged = false;
    }
}

