/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.picking;

import java.util.ArrayList;
import java.util.HashMap;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.picking.PickableObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPointingDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.picking.BasePickableGroup;
import org.web3d.vrml.renderer.ogl.nodes.OGLPickableTargetNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLPickingFlagConvertor;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLPickableGroup
extends BasePickableGroup
implements OGLVRMLNode,
OGLPickableTargetNodeType,
NodeUpdateListener {
    private static final String BAD_PROTO_MSG = "The resolved proto instance is not a X3DChildNode type. Grouping nodes may only use ChildNode types for the children field.";
    private Group implGroup;
    private Node oglImplGroup;
    private HashMap oglChildMap;
    private ArrayList addedChildren;
    private ArrayList removedChildren;
    private ArrayList sensorList;
    private OGLPickingFlagConvertor typeConvertor;
    private int pickMask;

    public OGLPickableGroup() {
        this.init();
    }

    public OGLPickableGroup(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void setTypeConvertor(OGLPickingFlagConvertor oGLPickingFlagConvertor) {
        if (this.typeConvertor == null && oGLPickingFlagConvertor != null) {
            this.pickMask = 0;
            for (int i = 0; i < this.vfObjectType.length; ++i) {
                this.pickMask |= oGLPickingFlagConvertor.addObjectType(this.vfObjectType[i]);
            }
            if (!this.inSetup) {
                this.implGroup.setPickMask(this.pickMask);
            }
        }
        this.typeConvertor = oGLPickingFlagConvertor;
    }

    public PickableObject getPickableObject() {
        return this.implGroup;
    }

    public void setObjectType(String[] stringArray, int n) {
        int n2;
        if (this.typeConvertor != null) {
            for (n2 = 0; n2 < this.vfObjectType.length; ++n2) {
                this.typeConvertor.removeObjectType(this.vfObjectType[n2]);
            }
        }
        this.pickMask = 0;
        super.setObjectType(stringArray, n);
        if (this.typeConvertor != null) {
            for (n2 = 0; n2 < this.vfObjectType.length; ++n2) {
                this.pickMask |= this.typeConvertor.addObjectType(this.vfObjectType[n2]);
            }
        }
        if (!this.inSetup) {
            this.implGroup.setPickMask(this.pickMask);
        }
    }

    public void updateNodeBoundsChanges(Object object) {
        Node node;
        int n;
        int n2 = this.removedChildren == null ? 0 : this.removedChildren.size();
        for (n = 0; n < n2; ++n) {
            node = (Node)this.removedChildren.get(n);
            this.implGroup.removeChild(node);
        }
        n2 = this.addedChildren == null ? 0 : this.addedChildren.size();
        for (n = 0; n < n2; ++n) {
            node = (Node)this.addedChildren.get(n);
            this.implGroup.addChild(node);
        }
        this.addedChildren.clear();
        this.removedChildren.clear();
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.oglChildMap = new HashMap();
        this.implGroup = new Group();
        this.implGroup.setPickMask(this.pickMask);
        if (this.isStatic && this.shareCount == 0) {
            this.oglImplGroup = this.implGroup;
        } else {
            this.oglImplGroup = new SharedGroup();
            ((SharedGroup)this.oglImplGroup).addChild((Node)this.implGroup);
        }
        if (!this.isStatic && this.sensorList.size() != 0) {
            OGLUserData oGLUserData = new OGLUserData();
            this.implGroup.setUserData((Object)oGLUserData);
            oGLUserData.sensors = new VRMLPointingDeviceSensorNodeType[this.sensorList.size()];
            this.sensorList.toArray(oGLUserData.sensors);
        }
        this.sensorList = null;
        for (int i = 0; i < this.childCount; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(i);
            Node node = (Node)oGLVRMLNode.getSceneGraphObject();
            if (node != null) {
                this.implGroup.addChild(node);
            }
            this.oglChildMap.put(oGLVRMLNode, node);
        }
        if (!this.isStatic) {
            this.removedChildren = new ArrayList();
            this.addedChildren = new ArrayList();
        }
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLChildNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException(BAD_PROTO_MSG);
        }
        if (this.inSetup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        oGLVRMLNode.setupFinished();
        Node node = (Node)oGLVRMLNode.getSceneGraphObject();
        this.oglChildMap.put(vRMLNodeType, node);
        if (node != null) {
            if (this.implGroup.isLive()) {
                this.addedChildren.add(node);
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.implGroup.addChild(node);
            }
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.oglImplGroup;
    }

    protected void clearChildren() {
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(i);
            Node node = (Node)this.oglChildMap.get(oGLVRMLNode);
            this.removedChildren.add(node);
            this.oglChildMap.remove(oGLVRMLNode);
        }
        if (!this.inSetup) {
            if (this.implGroup.isLive()) {
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.removedChildren.clear();
                this.implGroup.removeAllChildren();
            }
        }
        super.clearChildren();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        Object object;
        Node node;
        super.addChildNode(vRMLNodeType);
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        if (!this.inSetup) {
            node = (Node)oGLVRMLNode.getSceneGraphObject();
            this.oglChildMap.put(vRMLNodeType, node);
            if (this.implGroup.isLive()) {
                this.addedChildren.add(node);
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.implGroup.addChild(node);
            }
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            if (this.inSetup) {
                this.sensorList.add(node);
            } else {
                object = (OGLUserData)((Object)this.implGroup.getUserData());
                if (object == null) {
                    object = new OGLUserData();
                    this.implGroup.setUserData(object);
                }
                if (object.sensors == null) {
                    object.sensors = new VRMLPointingDeviceSensorNodeType[1];
                    object.sensors[0] = node;
                } else {
                    int n = object.sensors.length;
                    VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n + 1];
                    System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n);
                    vRMLPointingDeviceSensorNodeTypeArray[n] = node;
                    object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
                }
            }
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) {
        Object object;
        Node node;
        if (!this.oglChildMap.containsKey(vRMLNodeType)) {
            return;
        }
        if (!this.inSetup) {
            node = (Node)this.oglChildMap.get(vRMLNodeType);
            this.oglChildMap.remove(vRMLNodeType);
            if (this.implGroup.isLive()) {
                this.removedChildren.add(node);
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.implGroup.removeChild(node);
            }
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            object = (OGLUserData)((Object)this.oglImplGroup.getUserData());
            int n = object.sensors.length;
            if (n == 1) {
                object.sensors = null;
            } else {
                int n2;
                for (n2 = 0; n2 < n && object.sensors[n2] != node; ++n2) {
                }
                while (n2 < n - 1) {
                    object.sensors[n2] = object.sensors[n2 + 1];
                    ++n2;
                }
                VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n - 1];
                System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n - 1);
                object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
            }
        }
        super.removeChildNode(vRMLNodeType);
    }

    private void init() {
        this.sensorList = new ArrayList();
    }
}

