/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.navigation;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.navigation.BaseViewpoint;
import org.web3d.vrml.renderer.ogl.nodes.OGLTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLViewpointNodeType;

public class OGLViewpoint
extends BaseViewpoint
implements OGLViewpointNodeType,
NodeUpdateListener,
OGLTransformNodeType {
    private TransformGroup transform;
    private boolean matrixChanged;
    private AxisAngle4f axis;
    private Vector3f trans;
    private Matrix4f implTrans;
    private Matrix4f tmpMatrix;
    private float worldScale;
    private boolean scaleChanged;
    private boolean updateMatrix;

    public OGLViewpoint() {
        this.init();
    }

    public OGLViewpoint(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.transform;
    }

    protected void setPosition(float[] fArray) {
        super.setPosition(fArray);
        if (!this.inSetup) {
            this.updateMatrix = true;
            this.updateViewTrans();
            if (this.transform.isLive()) {
                this.transform.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.transform);
            }
        }
    }

    protected void setOrientation(float[] fArray) {
        super.setOrientation(fArray);
        if (!this.inSetup) {
            this.updateMatrix = true;
            this.updateViewTrans();
            if (this.transform.isLive()) {
                this.transform.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.transform);
            }
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        OGLUserData oGLUserData = new OGLUserData();
        this.transform.setUserData((Object)oGLUserData);
        oGLUserData.owner = this;
        this.updateViewTrans();
        this.transform.setTransform(this.implTrans);
    }

    public void updateNodeBoundsChanges(Object object) {
        if (this.updateMatrix) {
            this.transform.setTransform(this.implTrans);
            this.scaleChanged = false;
            this.updateMatrix = false;
        } else if (this.scaleChanged) {
            this.transform.getTransform(this.tmpMatrix);
            this.tmpMatrix.setScale(1.0f / this.worldScale);
            this.transform.setTransform(this.tmpMatrix);
            this.scaleChanged = false;
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public Matrix4f getTransform() {
        return this.implTrans;
    }

    public Matrix4f getViewTransform() {
        this.updateMatrix = true;
        this.updateViewTrans();
        return this.implTrans;
    }

    public void setNavigationTransform(Matrix4f matrix4f) {
        this.implTrans.set(matrix4f);
    }

    public TransformGroup getPlatformGroup() {
        return this.transform;
    }

    public void setWorldScale(float f) {
        this.worldScale = f;
        this.transform.getTransform(this.tmpMatrix);
        if (!this.inSetup) {
            this.scaleChanged = true;
            if (this.transform.isLive()) {
                this.transform.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.transform);
            }
        }
    }

    private void updateViewTrans() {
        this.axis.x = this.vfOrientation[0];
        this.axis.y = this.vfOrientation[1];
        this.axis.z = this.vfOrientation[2];
        double d = this.axis.x * this.axis.x + this.axis.y * this.axis.y + this.axis.z * this.axis.z;
        if (d != 0.0) {
            if (d != 1.0) {
                d = 1.0 / Math.sqrt(d);
            }
            this.axis.x = (float)((double)this.axis.x * d);
            this.axis.y = (float)((double)this.axis.y * d);
            this.axis.z = (float)((double)this.axis.z * d);
        } else {
            this.axis.x = 0.0f;
            this.axis.y = 1.0f;
            this.axis.z = 0.0f;
        }
        this.axis.angle = (float)Math.IEEEremainder(this.vfOrientation[3], Math.PI * 2);
        this.implTrans.setIdentity();
        this.implTrans.set(this.axis);
        this.trans.x = this.vfPosition[0];
        this.trans.y = this.vfPosition[1];
        this.trans.z = this.vfPosition[2];
        this.implTrans.setTranslation(this.trans);
        this.implTrans.setScale(1.0f / this.worldScale);
    }

    private void init() {
        this.axis = new AxisAngle4f();
        this.trans = new Vector3f();
        this.implTrans = new Matrix4f();
        this.tmpMatrix = new Matrix4f();
        this.implTrans.setIdentity();
        this.worldScale = 1.0f;
        this.transform = new TransformGroup();
        this.transform.setPickMask(0);
        this.transform.setTransform(this.implTrans);
        this.transform.setBounds((BoundingVolume)new BoundingVoid());
    }
}

