/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.navigation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.geom.GeometryData;
import org.j3d.renderer.aviatrix3d.nodes.LODGroup;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPointingDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.navigation.BaseLOD;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLLOD
extends BaseLOD
implements OGLVRMLNode,
NodeUpdateListener {
    private static final String BAD_PROTO_MSG = "The resolved proto instance is not a X3DChildNode type. Grouping nodes may only use ChildNode types for the children field.";
    private Group oglImplGroup;
    private LODGroup implLod;
    private HashMap oglChildMap;
    private LinkedList addedChildren;
    private LinkedList removedChildren;
    private ArrayList sensorList;
    private GeometryData geomData;
    private boolean activeChildChanged;
    private int activeObject;
    private Vector3f translation;

    public OGLLOD() {
        this.init();
    }

    public OGLLOD(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.oglImplGroup;
    }

    public void setupFinished() {
        Node node;
        Object object;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.oglChildMap = new HashMap();
        this.implLod = new LODGroup();
        this.oglImplGroup = this.isStatic && this.shareCount == 0 ? new Group() : new SharedGroup();
        this.oglImplGroup.addChild((Node)this.implLod);
        if (!this.isStatic && this.sensorList.size() != 0) {
            OGLUserData oGLUserData = new OGLUserData();
            oGLUserData.collidable = false;
            oGLUserData.isTerrain = false;
            this.implLod.setUserData((Object)oGLUserData);
            oGLUserData.sensors = new VRMLPointingDeviceSensorNodeType[this.sensorList.size()];
            this.sensorList.toArray(oGLUserData.sensors);
        }
        this.sensorList = null;
        for (int i = 0; i < this.childCount; ++i) {
            object = (OGLVRMLNode)this.vfChildren.get(i);
            node = (Node)object.getSceneGraphObject();
            if (node != null) {
                this.implLod.addChild(node);
            }
            this.oglChildMap.put(object, node);
        }
        int n = this.activeObject = this.rangeLen > this.childCount ? this.childCount : this.rangeLen;
        if (!this.isStatic) {
            this.removedChildren = new LinkedList();
            this.addedChildren = new LinkedList();
        }
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f && this.vfBboxSize[2] != -1.0f) {
            float[] fArray = new float[]{this.vfBboxCenter[0] - this.vfBboxSize[0] / 2.0f, this.vfBboxCenter[1] - this.vfBboxSize[1] / 2.0f, this.vfBboxCenter[2] - this.vfBboxSize[2] / 2.0f};
            object = new float[3];
            object[0] = this.vfBboxCenter[0] + this.vfBboxSize[0] / 2.0f;
            object[1] = this.vfBboxCenter[1] + this.vfBboxSize[1] / 2.0f;
            object[2] = this.vfBboxCenter[2] + this.vfBboxSize[2] / 2.0f;
            node = new BoundingBox(fArray, (float[])object);
            this.oglImplGroup.setBounds((BoundingVolume)node);
        }
        this.updateNodeDataChanges(this.implLod);
    }

    public void allEventsComplete() {
        if (this.oglImplGroup.isLive()) {
            this.oglImplGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.oglImplGroup);
        }
        super.allEventsComplete();
    }

    public void updateNodeBoundsChanges(Object object) {
        if (object == this.implLod) {
            Node node;
            int n;
            int n2 = this.addedChildren == null ? 0 : this.addedChildren.size();
            for (n = 0; n < n2; ++n) {
                node = (Node)this.addedChildren.get(n);
                this.implLod.addChild(node);
            }
            n2 = this.removedChildren == null ? 0 : this.removedChildren.size();
            for (n = 0; n < n2; ++n) {
                node = (Node)this.removedChildren.get(n);
                this.implLod.removeChild(node);
            }
        }
    }

    public void updateNodeDataChanges(Object object) {
        if (object != this.implLod) {
            return;
        }
        int n = this.rangeLen < this.childCount ? this.rangeLen : this.childCount;
        for (int i = 0; i < n; ++i) {
            this.implLod.setRange(i, this.vfRange[i]);
        }
        this.implLod.setCenter(this.vfCenter);
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLChildNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException(BAD_PROTO_MSG);
        }
        if (this.inSetup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        oGLVRMLNode.setupFinished();
        Node node = (Node)oGLVRMLNode.getSceneGraphObject();
        this.oglChildMap.put(vRMLNodeType, node);
        if (node != null) {
            if (this.oglImplGroup.isLive()) {
                if (this.addedChildren == null) {
                    this.addedChildren = new LinkedList();
                }
                this.addedChildren.add(node);
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            } else {
                this.implLod.addChild(node);
            }
        }
    }

    protected void setCenter(float[] fArray) throws InvalidFieldValueException {
        super.setCenter(fArray);
        if (!this.inSetup) {
            this.implLod.dataChanged((NodeUpdateListener)this);
        }
    }

    protected void setRange(float[] fArray, int n) throws InvalidFieldValueException {
        super.setRange(fArray, n);
        if (!this.inSetup) {
            this.implLod.dataChanged((NodeUpdateListener)this);
        }
    }

    protected void clearChildren() {
        OGLUserData oGLUserData;
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(i);
            Node node = (Node)this.oglChildMap.get(oGLVRMLNode);
            this.removedChildren.add(node);
            this.oglChildMap.remove(oGLVRMLNode);
        }
        if (!this.inSetup) {
            if (this.implLod.isLive()) {
                this.implLod.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implLod);
            }
        }
        if (this.sensorList != null) {
            this.sensorList.clear();
        }
        if ((oGLUserData = (OGLUserData)((Object)this.implLod.getUserData())) != null) {
            oGLUserData.sensors = null;
        }
        super.clearChildren();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        Object object;
        Node node;
        super.addChildNode(vRMLNodeType);
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        if (!this.inSetup) {
            node = (Node)oGLVRMLNode.getSceneGraphObject();
            this.addedChildren.add(node);
            this.oglChildMap.put(vRMLNodeType, node);
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            if (this.inSetup) {
                this.sensorList.add(node);
            } else {
                object = (OGLUserData)((Object)this.implLod.getUserData());
                if (object.sensors == null) {
                    object.sensors = new VRMLPointingDeviceSensorNodeType[1];
                    object.sensors[0] = node;
                } else {
                    int n = object.sensors.length;
                    VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n + 1];
                    System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n);
                    vRMLPointingDeviceSensorNodeTypeArray[n] = node;
                    object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
                }
            }
        }
        if (!this.inSetup) {
            if (this.implLod.isLive()) {
                this.implLod.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implLod);
            }
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (!this.oglChildMap.containsKey(vRMLNodeType)) {
            return;
        }
        if (!this.inSetup) {
            Node node = (Node)this.oglChildMap.get(vRMLNodeType);
            this.removedChildren.add(node);
            this.oglChildMap.remove(vRMLNodeType);
            if (this.implLod.isLive()) {
                this.implLod.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implLod);
            }
        }
        super.removeChildNode(vRMLNodeType);
    }

    private void init() {
        this.activeChildChanged = false;
        this.sensorList = new ArrayList();
        this.translation = new Vector3f();
    }
}

