/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.marker;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.ByteBufferTextureComponent2D;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.IndexedTriangleArray;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.QuadArray;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.Texture2D;
import org.j3d.aviatrix3d.TextureComponent;
import org.j3d.aviatrix3d.TextureComponent2D;
import org.j3d.aviatrix3d.TextureSource;
import org.j3d.aviatrix3d.TextureUnit;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.geom.GeometryData;
import org.j3d.renderer.aviatrix3d.nodes.MarkerGroup;
import org.j3d.util.MatrixUtils;
import org.web3d.image.NIOBufferImage;
import org.web3d.image.NIOBufferImageType;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.marker.BaseScreenMarker;
import org.web3d.vrml.renderer.ogl.nodes.OGLAreaListener;
import org.web3d.vrml.renderer.ogl.nodes.OGLGlobalStatus;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLScreenMarker
extends BaseScreenMarker
implements OGLVRMLNode,
OGLAreaListener,
NodeUpdateListener {
    private static final float DEFAULT_SIZE = 0.1f;
    private static final int[] SECONDARY_TYPE = new int[]{44, 88};
    private TransformGroup implGroup;
    private MarkerGroup markerGroup;
    private Texture2D texture;
    private TextureUnit textureUnit;
    private boolean iconImageChanged;
    private boolean textureChanged;
    private boolean targetChanged;
    private MatrixUtils matrixUtils;
    private boolean matrixChanged;
    private Matrix4f markerMatrix;
    private Vector3f markerVector;
    private Vector3f inVector;
    private Matrix4f viewMatrix;
    private IndexedTriangleArray geom;
    private boolean aspectRatioChanged;

    public OGLScreenMarker() {
        this.init();
    }

    public OGLScreenMarker(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public void allEventsComplete() {
        if (this.iconImageChanged) {
            if (this.textureUnit.isLive()) {
                this.textureUnit.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.textureUnit);
            }
            this.iconImageChanged = false;
        }
        if (this.aspectRatioChanged) {
            if (this.geom.isLive()) {
                this.geom.boundsChanged((NodeUpdateListener)this);
            } else {
                this.configAspectRatio();
                this.aspectRatioChanged = false;
            }
        }
        if (this.targetChanged) {
            if (this.vfRepresents != null) {
                Node node = (Node)((OGLVRMLNode)this.vfRepresents).getSceneGraphObject();
                if (node != null) {
                    this.markerGroup.setTarget(node);
                    this.targetChanged = false;
                } else {
                    this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
                }
            } else {
                this.markerGroup.setTarget(null);
                this.targetChanged = false;
            }
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGroup;
    }

    public int[] getSecondaryType() {
        return SECONDARY_TYPE;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.markerGroup.setEnabled(this.vfEnabled);
    }

    public void updateNodeBoundsChanges(Object object) {
        if (object == this.implGroup && this.matrixChanged) {
            this.implGroup.setTransform(this.markerMatrix);
            this.matrixChanged = false;
        }
        if (object == this.geom && this.aspectRatioChanged) {
            this.configAspectRatio();
            this.aspectRatioChanged = false;
        }
    }

    public void updateNodeDataChanges(Object object) {
        if (object == this.textureUnit) {
            this.textureUnit.setTexture((Texture)this.texture);
        }
    }

    public void areaEntry(Point3f point3f, Vector3f vector3f, Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (this.vfEnabled) {
            this.process(point3f, vector3f, matrix4f, matrix4f2);
        }
    }

    public void userPositionChanged(Point3f point3f, Vector3f vector3f, Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (this.vfEnabled) {
            this.process(point3f, vector3f, matrix4f, matrix4f2);
        }
    }

    public void areaExit() {
    }

    public void setContent(String string, Object object) throws IllegalArgumentException {
        if (object == null) {
            this.texture = null;
            this.iconImageChanged = true;
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        } else if (object instanceof NIOBufferImage) {
            NIOBufferImage nIOBufferImage = (NIOBufferImage)object;
            this.texture = new Texture2D();
            int n = this.getFormat(nIOBufferImage);
            TextureComponent2D[] textureComponent2DArray = new TextureComponent2D[]{new ByteBufferTextureComponent2D(n, nIOBufferImage.getWidth(), nIOBufferImage.getHeight(), nIOBufferImage.getBuffer(null))};
            int n2 = this.getTextureFormat((TextureComponent)textureComponent2DArray[0]);
            this.texture.setSources(0, n2, (TextureSource[])textureComponent2DArray, 1);
            this.iconImageChanged = true;
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
        this.loadState = 3;
        this.fireContentStateChanged();
    }

    protected void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.markerGroup.setEnabled(bl);
        this.iconImageChanged = true;
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    protected void setWidth(float f) {
        super.setWidth(f);
        this.aspectRatioChanged = true;
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    protected void setHeight(float f) {
        super.setHeight(f);
        this.aspectRatioChanged = true;
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    public void setRepresents(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.setRepresents(vRMLNodeType);
        this.targetChanged = true;
        this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
    }

    private void init() {
        this.matrixUtils = new MatrixUtils();
        this.markerVector = new Vector3f();
        this.markerMatrix = new Matrix4f();
        this.markerMatrix.setIdentity();
        this.viewMatrix = new Matrix4f();
        this.inVector = new Vector3f();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 2;
        geometryData.coordinates = new float[72];
        geometryData.vertexCount = 24;
        OGLUserData oGLUserData = new OGLUserData();
        oGLUserData.geometryData = geometryData;
        oGLUserData.collidable = false;
        oGLUserData.isTerrain = false;
        oGLUserData.areaListener = this;
        QuadArray quadArray = new QuadArray();
        this.setBounds(quadArray, geometryData);
        Shape3D shape3D = new Shape3D();
        shape3D.setAppearance(OGLGlobalStatus.invisibleAppearance);
        shape3D.setGeometry((Geometry)quadArray);
        shape3D.setUserData((Object)oGLUserData);
        shape3D.setPickMask(8);
        this.implGroup = new TransformGroup();
        oGLUserData = new OGLUserData();
        oGLUserData.isTransform = true;
        this.implGroup.setUserData((Object)oGLUserData);
        this.markerGroup = new MarkerGroup();
        oGLUserData = new OGLUserData();
        oGLUserData.collidable = false;
        oGLUserData.isTerrain = false;
        this.markerGroup.setUserData((Object)oGLUserData);
        Shape3D shape3D2 = new Shape3D();
        shape3D2.setGeometry((Geometry)this.getGeometry());
        shape3D2.setAppearance(this.getAppearance());
        this.markerGroup.addChild((Node)shape3D2);
        this.implGroup.addChild((Node)this.markerGroup);
        this.implGroup.addChild((Node)shape3D);
    }

    private IndexedTriangleArray getGeometry() {
        float[] fArray = new float[]{-0.1f, -0.1f, 0.0f, -0.1f, 0.1f, 0.0f, 0.1f, 0.1f, 0.0f, 0.1f, -0.1f, 0.0f};
        float[] fArray2 = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        float[][] fArrayArray = new float[][]{{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f}};
        int[] nArray = new int[]{2};
        int[] nArray2 = new int[]{0, 2, 1, 0, 3, 2};
        this.geom = new IndexedTriangleArray();
        this.geom.setVertices(3, fArray, 4);
        this.geom.setIndices(nArray2, 6);
        this.geom.setNormals(fArray2);
        this.geom.setTextureCoordinates(nArray, (float[][])fArrayArray, 1);
        return this.geom;
    }

    private Appearance getAppearance() {
        Material material = new Material();
        material.setDiffuseColor(new float[]{0.0f, 0.0f, 0.0f});
        material.setEmissiveColor(new float[]{0.0f, 0.0f, 0.0f});
        material.setSpecularColor(new float[]{1.0f, 1.0f, 1.0f});
        this.textureUnit = new TextureUnit();
        TextureUnit[] textureUnitArray = new TextureUnit[]{this.textureUnit};
        this.textureUnit.setTexture((Texture)this.texture);
        Appearance appearance = new Appearance();
        appearance.setMaterial(material);
        appearance.setTextureUnits(textureUnitArray, 1);
        return appearance;
    }

    private void setBounds(QuadArray quadArray, GeometryData geometryData) {
        float[] fArray = geometryData.coordinates;
        float f = 1.0E10f;
        float f2 = 1.0E10f;
        float f3 = 1.0E10f;
        fArray[0] = f;
        fArray[1] = -f2;
        fArray[2] = f3;
        fArray[3] = f;
        fArray[4] = f2;
        fArray[5] = f3;
        fArray[6] = -f;
        fArray[7] = f2;
        fArray[8] = f3;
        fArray[9] = -f;
        fArray[10] = -f2;
        fArray[11] = f3;
        fArray[12] = f;
        fArray[13] = -f2;
        fArray[14] = -f3;
        fArray[15] = f;
        fArray[16] = f2;
        fArray[17] = -f3;
        fArray[18] = f;
        fArray[19] = f2;
        fArray[20] = f3;
        fArray[21] = f;
        fArray[22] = -f2;
        fArray[23] = f3;
        fArray[24] = -f;
        fArray[25] = -f2;
        fArray[26] = -f3;
        fArray[27] = -f;
        fArray[28] = f2;
        fArray[29] = -f3;
        fArray[30] = f;
        fArray[31] = f2;
        fArray[32] = -f3;
        fArray[33] = f;
        fArray[34] = -f2;
        fArray[35] = -f3;
        fArray[36] = -f;
        fArray[37] = -f2;
        fArray[38] = f3;
        fArray[39] = -f;
        fArray[40] = f2;
        fArray[41] = f3;
        fArray[42] = -f;
        fArray[43] = f2;
        fArray[44] = -f3;
        fArray[45] = -f;
        fArray[46] = -f2;
        fArray[47] = -f3;
        fArray[48] = f;
        fArray[49] = f2;
        fArray[50] = f3;
        fArray[51] = f;
        fArray[52] = f2;
        fArray[53] = -f3;
        fArray[54] = -f;
        fArray[55] = f2;
        fArray[56] = -f3;
        fArray[57] = -f;
        fArray[58] = f2;
        fArray[59] = f3;
        fArray[60] = -f;
        fArray[61] = -f2;
        fArray[62] = -f3;
        fArray[63] = -f;
        fArray[64] = -f2;
        fArray[65] = f3;
        fArray[66] = f;
        fArray[67] = -f2;
        fArray[68] = f3;
        fArray[69] = f;
        fArray[70] = -f2;
        fArray[71] = -f3;
        quadArray.setVertices(3, geometryData.coordinates, geometryData.vertexCount);
    }

    private void process(Point3f point3f, Vector3f vector3f, Matrix4f matrix4f, Matrix4f matrix4f2) {
        this.matrixUtils.inverse(matrix4f, this.viewMatrix);
        this.inVector.set(this.viewMatrix.m02, this.viewMatrix.m12, this.viewMatrix.m22);
        this.inVector.scale(-10.0f);
        this.viewMatrix.get(this.markerVector);
        this.markerVector.add((Tuple3f)this.inVector);
        this.markerMatrix.setTranslation(this.markerVector);
        if (this.implGroup.isLive()) {
            this.matrixChanged = true;
            this.implGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.implGroup.setTransform(this.markerMatrix);
        }
    }

    private int getTextureFormat(TextureComponent textureComponent) {
        int n = 6407;
        switch (textureComponent.getFormat(0)) {
            case 6: {
                n = 6409;
                break;
            }
            case 5: {
                n = 6410;
                break;
            }
            case 1: {
                n = 6407;
                break;
            }
            case 2: {
                n = 6408;
            }
        }
        return n;
    }

    private int getFormat(NIOBufferImage nIOBufferImage) {
        int n = 0;
        NIOBufferImageType nIOBufferImageType = nIOBufferImage.getType();
        if (nIOBufferImageType == NIOBufferImageType.INTENSITY) {
            n = 6;
        } else if (nIOBufferImageType == NIOBufferImageType.INTENSITY_ALPHA) {
            n = 5;
        } else if (nIOBufferImageType == NIOBufferImageType.RGB) {
            n = 1;
        } else if (nIOBufferImageType == NIOBufferImageType.RGBA) {
            n = 2;
        } else {
            System.out.println("Unknown NIOBufferImageType: " + nIOBufferImageType.name);
        }
        return n;
    }

    private void configAspectRatio() {
        float f = 0.1f * this.vfWidth;
        float f2 = 0.1f * this.vfHeight;
        float[] fArray = new float[]{-f, -f2, 0.0f, -f, f2, 0.0f, f, f2, 0.0f, f, -f2, 0.0f};
        this.geom.setVertices(3, fArray, 4);
    }
}

