/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.lighting;

import org.j3d.aviatrix3d.BoundingSphere;
import org.j3d.aviatrix3d.Light;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.PointLight;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.lighting.BasePointLight;
import org.web3d.vrml.renderer.ogl.nodes.OGLLightNodeType;

public class OGLPointLight
extends BasePointLight
implements OGLLightNodeType,
NodeUpdateListener {
    private PointLight implLight;
    private float[] flScratch;
    private BoundingSphere radiusBounds;

    public OGLPointLight() {
        this.init();
    }

    public OGLPointLight(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public Light getLight() {
        return this.implLight;
    }

    public void updateNodeBoundsChanges(Object object) {
        this.radiusBounds.setRadius(this.vfRadius);
        this.implLight.setEffectBounds((BoundingVolume)this.radiusBounds);
    }

    public void updateNodeDataChanges(Object object) {
        this.flScratch[0] = this.vfColor[0] * this.vfAmbientIntensity;
        this.flScratch[1] = this.vfColor[1] * this.vfAmbientIntensity;
        this.flScratch[2] = this.vfColor[2] * this.vfAmbientIntensity;
        this.implLight.setAmbientColor(this.flScratch);
        this.flScratch[0] = this.vfColor[0] * this.vfIntensity;
        this.flScratch[1] = this.vfColor[1] * this.vfIntensity;
        this.flScratch[2] = this.vfColor[2] * this.vfIntensity;
        this.implLight.setDiffuseColor(this.flScratch);
        this.implLight.setSpecularColor(this.flScratch);
        this.implLight.setEnabled(this.vfOn);
        this.implLight.setGlobalOnly(this.vfGlobal);
        this.implLight.setPosition(this.vfLocation);
        if (this.vfAttenuation[0] == 0.0f && this.vfAttenuation[1] == 0.0f && this.vfAttenuation[2] == 0.0f) {
            this.flScratch[0] = 1.0f;
            this.flScratch[1] = 0.0f;
            this.flScratch[2] = 0.0f;
            this.implLight.setAttenuation(this.flScratch);
        } else {
            this.implLight.setAttenuation(this.vfAttenuation);
        }
    }

    public void setAmbientIntensity(float f) throws InvalidFieldValueException {
        super.setAmbientIntensity(f);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public void setColor(float[] fArray) throws InvalidFieldValueException {
        super.setColor(fArray);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public void setIntensity(float f) throws InvalidFieldValueException {
        super.setIntensity(f);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public void setOn(boolean bl) {
        super.setOn(bl);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public void setGlobal(boolean bl) throws InvalidFieldException {
        super.setGlobal(bl);
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implLight;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        if (this.vrmlMajorVersion < 3 || this.vrmlMajorVersion == 3 && this.vrmlMinorVersion == 0) {
            this.vfGlobal = true;
        }
        this.updateNodeDataChanges(null);
        this.updateNodeBoundsChanges(null);
    }

    protected void setLocation(float[] fArray) {
        super.setLocation(fArray);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    protected void setRadius(float f) throws InvalidFieldValueException {
        super.setRadius(f);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implLight);
        }
    }

    protected void setAttenuation(float[] fArray) {
        super.setAttenuation(fArray);
        if (this.inSetup) {
            return;
        }
        if (this.implLight.isLive()) {
            this.implLight.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implLight);
        }
    }

    private void init() {
        this.flScratch = new float[3];
        this.implLight = new PointLight();
        this.radiusBounds = new BoundingSphere(this.vfRadius);
    }
}

