/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.hanim;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.geom.hanim.HAnimFactory;
import org.j3d.geom.hanim.HAnimObject;
import org.j3d.renderer.aviatrix3d.geom.hanim.AVHumanoid;
import org.j3d.renderer.aviatrix3d.geom.hanim.AVShaderHAnimFactory;
import org.j3d.renderer.aviatrix3d.geom.hanim.AVSoftwareHAnimFactory;
import org.j3d.renderer.aviatrix3d.geom.hanim.SoftwareHumanoid;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLHAnimNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.VRMLShapeNodeType;
import org.web3d.vrml.renderer.common.nodes.hanim.BaseHAnimHumanoid;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLHAnimHumanoid
extends BaseHAnimHumanoid
implements OGLVRMLNode {
    private static final String HARDWARE_RENDER_PROP = "org.web3d.vrml.renderer.ogl.nodes.hanim.allowHardwareHumanoid";
    private static final String BAD_PROTO_MSG = "The resolved proto instance is not a X3DChildNode type. Grouping nodes may only use ChildNode types for the children field.";
    private static final String HARDWARE_USED_MSG = "Skin nodes provided to the HAnimHumanoid allows the use of hardware accelarated shader techniques";
    private static final String SOFTWARE_USED_MSG = "Skin nodes provided prevent the use hardware accelerated rendering techniques";
    private static final String USING_HARDWARE_MSG = "HAnimHumanoids are allowed to use the hardware-accelerated shader implementation where possible";
    private static HashSet hardwareCapableGeom = new HashSet();
    private static final boolean allowHardwareRender;
    private static boolean hardwarePropNotice;
    private boolean hardwareRendered;

    public OGLHAnimHumanoid() {
    }

    public OGLHAnimHumanoid(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void updateMesh() {
        super.updateMesh();
        if (!this.hardwareRendered) {
            Object object;
            int n;
            if (this.vfSkinCoord != null) {
                n = this.hanimImpl.numSkinCoord();
                object = ((SoftwareHumanoid)this.hanimImpl).getUpdatedSkinCoords();
                if (object instanceof float[]) {
                    this.vfSkinCoord.setPoint((float[])object, n * 3);
                }
            }
            if (this.vfSkinNormal != null) {
                n = this.hanimImpl.numSkinNormal();
                object = ((SoftwareHumanoid)this.hanimImpl).getUpdatedSkinNormals();
                if (object instanceof float[]) {
                    this.vfSkinNormal.setVector((float[])object, n * 3);
                }
            }
        }
    }

    public void setHAnimFactory(HAnimFactory hAnimFactory) {
        super.setHAnimFactory(hAnimFactory);
        int n = this.vfViewpoints.size();
        Object[] objectArray = new Node[n];
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfViewpoints.get(i);
            objectArray[i] = (Node)oGLVRMLNode.getSceneGraphObject();
        }
        this.hanimImpl.setViewpoints(objectArray, n);
    }

    public void setupFinished() {
        Object[] objectArray;
        int n;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.checkFactoryChoice();
        int n2 = this.vfSkin.size();
        Node[] nodeArray = new Node[n2];
        for (n = 0; n < n2; ++n) {
            objectArray = (Object[])this.vfSkin.get(n);
            nodeArray[n] = (Node)objectArray.getSceneGraphObject();
        }
        ((AVHumanoid)this.hanimImpl).setSkin(nodeArray, n2);
        n = this.vfViewpoints.size();
        objectArray = new Node[n];
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfViewpoints.get(i);
            objectArray[i] = (Node)oGLVRMLNode.getSceneGraphObject();
        }
        this.hanimImpl.setViewpoints(objectArray, n);
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLChildNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException(BAD_PROTO_MSG);
        }
        if (this.inSetup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        oGLVRMLNode.setupFinished();
        switch (n) {
            case 12: {
                int n2 = this.vfSkin.size();
                Node[] nodeArray = new Node[n2];
                for (int i = 0; i < n2; ++i) {
                    OGLVRMLNode oGLVRMLNode2 = (OGLVRMLNode)this.vfSkin.get(i);
                    nodeArray[i] = (Node)oGLVRMLNode2.getSceneGraphObject();
                }
                ((AVHumanoid)this.hanimImpl).setSkin(nodeArray, n2);
                break;
            }
            case 16: {
                int n3 = this.vfViewpoints.size();
                Object[] objectArray = new Node[n3];
                for (int i = 0; i < n3; ++i) {
                    OGLVRMLNode oGLVRMLNode3 = (OGLVRMLNode)this.vfViewpoints.get(i);
                    objectArray[i] = (Node)oGLVRMLNode3.getSceneGraphObject();
                }
                this.hanimImpl.setViewpoints(objectArray, n3);
                break;
            }
            case 11: {
                int n4 = this.vfSkeleton.size();
                HAnimObject[] hAnimObjectArray = new HAnimObject[n4];
                for (int i = 0; i < n4; ++i) {
                    VRMLHAnimNodeType vRMLHAnimNodeType = (VRMLHAnimNodeType)this.vfSkeleton.get(i);
                    hAnimObjectArray[i] = vRMLHAnimNodeType.getHAnimObject();
                }
                this.hanimImpl.setSkeleton(hAnimObjectArray, n4);
                break;
            }
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        super.setErrorReporter(errorReporter);
        if (!hardwarePropNotice && allowHardwareRender) {
            this.errorReporter.messageReport(USING_HARDWARE_MSG);
            hardwarePropNotice = true;
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return ((AVHumanoid)this.hanimImpl).getSceneGraphObject();
    }

    protected void clearSkin() {
        ((AVHumanoid)this.hanimImpl).setSkin(null, 0);
    }

    protected void addSkinNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.addSkinNode(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        int n = this.vfSkin.size();
        Node[] nodeArray = new Node[n];
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfSkin.get(i);
            nodeArray[i] = (Node)oGLVRMLNode.getSceneGraphObject();
        }
        ((AVHumanoid)this.hanimImpl).setSkin(nodeArray, n);
        this.checkFactoryChoice();
    }

    protected void addViewpointNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.addViewpointNode(vRMLNodeType);
        if (this.inSetup) {
            return;
        }
        int n = this.vfViewpoints.size();
        Object[] objectArray = new Node[n];
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfViewpoints.get(i);
            objectArray[i] = (Node)oGLVRMLNode.getSceneGraphObject();
        }
        this.hanimImpl.setViewpoints(objectArray, n);
    }

    private void checkFactoryChoice() {
        int n = this.vfSkin.size();
        this.hardwareRendered = true;
        block5: for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)this.vfSkin.get(i);
            switch (vRMLNodeType.getPrimaryType()) {
                case 43: {
                    String string;
                    VRMLShapeNodeType vRMLShapeNodeType = (VRMLShapeNodeType)vRMLNodeType;
                    VRMLNodeType vRMLNodeType2 = vRMLShapeNodeType.getGeometry();
                    if (vRMLNodeType2 instanceof VRMLProtoInstance || hardwareCapableGeom.contains((Object)(string = vRMLNodeType2.getVRMLNodeName()))) continue block5;
                    this.hardwareRendered = false;
                    continue block5;
                }
                case 38: {
                    continue block5;
                }
                case 22: {
                    continue block5;
                }
            }
        }
        boolean bl = this.hardwareRendered = this.hardwareRendered && allowHardwareRender;
        if (this.hardwareRendered) {
            this.setHAnimFactory((HAnimFactory)new AVShaderHAnimFactory());
            this.errorReporter.messageReport(HARDWARE_USED_MSG);
        } else {
            this.setHAnimFactory((HAnimFactory)new AVSoftwareHAnimFactory(true));
            if (allowHardwareRender) {
                this.errorReporter.messageReport(SOFTWARE_USED_MSG);
            }
        }
    }

    static {
        hardwareCapableGeom.add((Object)"PointSet");
        hardwareCapableGeom.add((Object)"LineSet");
        hardwareCapableGeom.add((Object)"IndexedLineSet");
        hardwareCapableGeom.add((Object)"TriangleSet");
        hardwareCapableGeom.add((Object)"TriangleStripSet");
        hardwareCapableGeom.add((Object)"TriangleFanSet");
        hardwareCapableGeom.add((Object)"IndexedTriangleSet");
        hardwareCapableGeom.add((Object)"IndexedTriangleStripSet");
        hardwareCapableGeom.add((Object)"IndexedTriangleFanSet");
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                boolean bl = Boolean.getBoolean(OGLHAnimHumanoid.HARDWARE_RENDER_PROP);
                return bl;
            }
        });
        allowHardwareRender = bl;
        hardwarePropNotice = !allowHardwareRender;
    }
}

