/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.group;

import java.util.ArrayList;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.picking.PickableObject;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.group.BaseStaticGroup;
import org.web3d.vrml.renderer.ogl.nodes.OGLPickableTargetNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLPickingFlagConvertor;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLStaticGroup
extends BaseStaticGroup
implements OGLVRMLNode,
OGLPickableTargetNodeType,
NodeUpdateListener {
    private static final String BAD_PROTO_MSG = "The resolved proto instance is not a X3DChildNode type. Grouping nodes may only use ChildNode types for the children field.";
    private SharedGroup implGroup = new SharedGroup();
    private ArrayList addedChildren;

    public OGLStaticGroup() {
        this.addedChildren = new ArrayList();
    }

    public OGLStaticGroup(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void setTypeConvertor(OGLPickingFlagConvertor oGLPickingFlagConvertor) {
    }

    public PickableObject getPickableObject() {
        return this.implGroup;
    }

    public SceneGraphObject getSceneGraphObject() {
        if (this.inSetup) {
            throw new RuntimeException();
        }
        return this.implGroup;
    }

    public void setupFinished() {
        Node node;
        Object object;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            object = (OGLVRMLNode)this.vfChildren.get(i);
            node = (Node)object.getSceneGraphObject();
            if (node == null) continue;
            this.implGroup.addChild(node);
        }
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f && this.vfBboxSize[2] != -1.0f) {
            float[] fArray = new float[]{this.vfBboxCenter[0] - this.vfBboxSize[0] / 2.0f, this.vfBboxCenter[1] - this.vfBboxSize[1] / 2.0f, this.vfBboxCenter[2] - this.vfBboxSize[2] / 2.0f};
            object = new float[3];
            object[0] = this.vfBboxCenter[0] + this.vfBboxSize[0] / 2.0f;
            object[1] = this.vfBboxCenter[1] + this.vfBboxSize[1] / 2.0f;
            object[2] = this.vfBboxCenter[2] + this.vfBboxSize[2] / 2.0f;
            node = new BoundingBox(fArray, (float[])object);
            this.implGroup.setBounds((BoundingVolume)node);
        }
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLChildNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException(BAD_PROTO_MSG);
        }
        if (this.inSetup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        oGLVRMLNode.setupFinished();
        Node node = (Node)oGLVRMLNode.getSceneGraphObject();
        if (node != null) {
            if (this.implGroup.isLive()) {
                if (this.addedChildren == null) {
                    this.addedChildren = new ArrayList();
                }
                this.addedChildren.add(node);
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            } else {
                this.implGroup.addChild(node);
            }
        }
    }

    public void updateNodeBoundsChanges(Object object) {
        int n = this.addedChildren == null ? 0 : this.addedChildren.size();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)this.addedChildren.get(i);
            this.implGroup.addChild(node);
        }
        this.addedChildren = null;
    }

    public void updateNodeDataChanges(Object object) {
    }
}

