/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.geospatial;

import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoViewpoint;
import org.web3d.vrml.renderer.ogl.nodes.OGLTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLViewpointNodeType;

public class OGLGeoViewpoint
extends BaseGeoViewpoint
implements OGLViewpointNodeType,
NodeUpdateListener,
OGLTransformNodeType {
    private static final String FACTORY_ERR_MSG = "Unable to create an appropriate set of operations for the defined geoSystem setup. May be either user or tools setup error";
    private static final String TRANSFORM_ERR_MSG = "Unable to transform the geoCoord value for some reason.";
    private TransformGroup transform;
    private boolean matrixChanged;
    private Vector3f trans;
    private Matrix4f implTrans;
    private Matrix4f tmpMatrix;
    private float worldScale;
    private boolean scaleChanged;
    private boolean updateMatrix;

    public OGLGeoViewpoint() {
        this.init();
    }

    public OGLGeoViewpoint(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.transform;
    }

    protected void setPosition(double[] dArray) {
        super.setPosition(dArray);
        if (this.inSetup) {
            return;
        }
        this.updateMatrix = true;
        this.updateViewTrans();
        if (this.transform.isLive()) {
            this.transform.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.transform);
        }
    }

    protected void setOrientation(float[] fArray) {
        super.setOrientation(fArray);
        if (this.inSetup) {
            return;
        }
        this.updateMatrix = true;
        this.updateViewTrans();
        if (this.transform.isLive()) {
            this.transform.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.transform);
        }
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        OGLUserData oGLUserData = new OGLUserData();
        this.transform.setUserData((Object)oGLUserData);
        oGLUserData.owner = this;
        this.updateViewTrans();
        this.transform.setTransform(this.implTrans);
    }

    public void updateNodeBoundsChanges(Object object) {
        if (this.updateMatrix) {
            this.transform.setTransform(this.implTrans);
            this.scaleChanged = false;
            this.updateMatrix = false;
        } else if (this.scaleChanged) {
            this.scaleChanged = false;
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public Matrix4f getTransform() {
        return this.implTrans;
    }

    public Matrix4f getViewTransform() {
        this.updateMatrix = true;
        this.updateViewTrans();
        return this.implTrans;
    }

    public TransformGroup getPlatformGroup() {
        return this.transform;
    }

    public void setNavigationTransform(Matrix4f matrix4f) {
        this.implTrans.set(matrix4f);
    }

    public void setWorldScale(float f) {
        this.worldScale = f;
        if (!this.inSetup) {
            this.scaleChanged = true;
            if (this.transform.isLive()) {
                this.transform.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.transform);
            }
        }
    }

    private void updateViewTrans() {
        this.convOriToAxisAngle();
        this.implTrans.setIdentity();
        this.implTrans.set(this.axis);
        this.trans.x = (float)this.localPosition[0];
        this.trans.y = (float)this.localPosition[1];
        this.trans.z = (float)this.localPosition[2];
        this.implTrans.setTranslation(this.trans);
        this.implTrans.setScale(1.0f / this.worldScale);
    }

    private void init() {
        this.trans = new Vector3f();
        this.implTrans = new Matrix4f();
        this.tmpMatrix = new Matrix4f();
        this.implTrans.setIdentity();
        this.worldScale = 1.0f;
        this.transform = new TransformGroup();
        this.transform.setPickMask(0);
        this.transform.setTransform(this.implTrans);
        this.transform.setBounds((BoundingVolume)new BoundingVoid());
    }
}

