/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.geospatial;

import java.util.ArrayList;
import java.util.HashMap;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.opengis.referencing.FactoryException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPickingSensorNodeType;
import org.web3d.vrml.nodes.VRMLPointingDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.geospatial.GTTransformUtils;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoLocation;
import org.web3d.vrml.renderer.common.nodes.geospatial.BaseGeoOrigin;
import org.web3d.vrml.renderer.ogl.nodes.OGLPickingSensorNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;

public class OGLGeoLocation
extends BaseGeoLocation
implements OGLVRMLNode,
OGLTransformNodeType,
NodeUpdateListener {
    private static final String BAD_PROTO_MSG = "The resolved proto instance is not a X3DChildNode type. Grouping nodes may only use ChildNode types for the children field.";
    private static final String FACTORY_ERR_MSG = "Unable to create an appropriate set of operations for the defined geoSystem setup. May be either user or tools setup error";
    private TransformGroup implGroup;
    private Node oglImplGroup;
    private HashMap oglChildMap;
    private ArrayList addedChildren;
    private ArrayList removedChildren;
    private boolean matrixChanged;
    protected ArrayList sensorList;
    private boolean epLoaded;
    private Matrix4f locationMatrix;
    private Vector3d YUP = new Vector3d(0.0, 1.0, 0.0);
    private Vector3d XUP = new Vector3d(1.0, 0.0, 0.0);
    private Vector3d ZUP = new Vector3d(0.0, 0.0, 1.0);
    private Vector3f trans;
    private AxisAngle4f axis;
    private Vector3d posVec;

    public OGLGeoLocation() {
        this.init();
    }

    public OGLGeoLocation(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.oglImplGroup;
    }

    public void allEventsComplete() {
        if (this.epLoaded) {
            this.epLoaded = false;
            if (this.implGroup.isLive()) {
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.implGroup);
            }
        }
        super.allEventsComplete();
    }

    public void updateNodeBoundsChanges(Object object) {
        Node node;
        int n;
        if (this.matrixChanged) {
            this.implGroup.setTransform(this.locationMatrix);
            this.matrixChanged = false;
        }
        int n2 = this.removedChildren == null ? 0 : this.removedChildren.size();
        for (n = 0; n < n2; ++n) {
            node = (Node)this.removedChildren.get(n);
            this.implGroup.removeChild(node);
        }
        n2 = this.addedChildren == null ? 0 : this.addedChildren.size();
        for (n = 0; n < n2; ++n) {
            node = (Node)this.addedChildren.get(n);
            this.implGroup.addChild(node);
        }
        if (this.addedChildren != null) {
            this.addedChildren.clear();
            this.removedChildren.clear();
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void setupFinished() {
        Node node;
        Object object;
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.oglChildMap = new HashMap();
        if (this.isStatic && this.shareCount == 0) {
            this.oglImplGroup = this.implGroup;
        } else {
            this.oglImplGroup = new SharedNode();
            ((SharedNode)this.oglImplGroup).setChild((Node)this.implGroup);
        }
        OGLUserData oGLUserData = new OGLUserData();
        this.implGroup.setUserData((Object)oGLUserData);
        oGLUserData.owner = this;
        if (!this.isStatic && this.sensorList.size() != 0) {
            oGLUserData.sensors = new VRMLPointingDeviceSensorNodeType[this.sensorList.size()];
            this.sensorList.toArray(oGLUserData.sensors);
        }
        this.sensorList = null;
        for (int i = 0; i < this.childCount; ++i) {
            object = (OGLVRMLNode)this.vfChildren.get(i);
            node = (Node)object.getSceneGraphObject();
            if (node != null) {
                this.implGroup.addChild(node);
            }
            this.oglChildMap.put(object, node);
        }
        if (!this.isStatic) {
            this.removedChildren = new ArrayList();
            this.addedChildren = new ArrayList();
        }
        this.updateMatrix();
        this.implGroup.setTransform(this.locationMatrix);
        if (this.vfBboxSize[0] != -1.0f && this.vfBboxSize[1] != -1.0f && this.vfBboxSize[2] != -1.0f) {
            float[] fArray = new float[]{this.vfBboxCenter[0] - this.vfBboxSize[0] / 2.0f, this.vfBboxCenter[1] - this.vfBboxSize[1] / 2.0f, this.vfBboxCenter[2] - this.vfBboxSize[2] / 2.0f};
            object = new float[3];
            object[0] = this.vfBboxCenter[0] + this.vfBboxSize[0] / 2.0f;
            object[1] = this.vfBboxCenter[1] + this.vfBboxSize[1] / 2.0f;
            object[2] = this.vfBboxCenter[2] + this.vfBboxSize[2] / 2.0f;
            node = new BoundingBox(fArray, (float[])object);
            this.implGroup.setBounds((BoundingVolume)node);
        }
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLChildNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException(BAD_PROTO_MSG);
        }
        if (this.inSetup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        oGLVRMLNode.setupFinished();
        Node node = (Node)oGLVRMLNode.getSceneGraphObject();
        this.oglChildMap.put(vRMLNodeType, node);
        if (node != null) {
            if (this.implGroup.isLive()) {
                this.addedChildren.add(node);
                this.epLoaded = true;
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            } else {
                this.implGroup.addChild(node);
            }
        }
    }

    public Matrix4f getTransform() {
        return this.locationMatrix;
    }

    protected void clearChildren() {
        OGLUserData oGLUserData;
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(i);
            Node node = (Node)this.oglChildMap.get(oGLVRMLNode);
            this.removedChildren.add(node);
            this.oglChildMap.remove(oGLVRMLNode);
        }
        if (!this.inSetup) {
            if (this.implGroup.isLive()) {
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.removedChildren.clear();
                this.implGroup.removeAllChildren();
            }
        }
        if (this.sensorList != null) {
            this.sensorList.clear();
        }
        if ((oGLUserData = (OGLUserData)((Object)this.implGroup.getUserData())) != null) {
            oGLUserData.sensors = null;
        }
        super.clearChildren();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        Object object;
        Node node;
        super.addChildNode(vRMLNodeType);
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        if (!this.inSetup) {
            node = (Node)oGLVRMLNode.getSceneGraphObject();
            this.oglChildMap.put(vRMLNodeType, node);
            if (this.implGroup.isLive()) {
                this.addedChildren.add(node);
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.implGroup.addChild(node);
            }
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLPickingSensorNodeType) {
            ((OGLPickingSensorNodeType)vRMLNodeType).setParentGroup((Group)this.implGroup);
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode();
            while (object != null && object instanceof VRMLProtoInstance) {
                object = ((VRMLProtoInstance)object).getImplementationNode();
            }
            if (object instanceof VRMLPointingDeviceSensorNodeType) {
                node = (VRMLPointingDeviceSensorNodeType)object;
            } else if (object instanceof VRMLPickingSensorNodeType) {
                ((OGLPickingSensorNodeType)object).setParentGroup((Group)this.implGroup);
            }
        }
        if (node != null) {
            if (this.inSetup) {
                this.sensorList.add(node);
            } else {
                object = (OGLUserData)((Object)this.implGroup.getUserData());
                if (object == null) {
                    object = new OGLUserData();
                    this.implGroup.setUserData(object);
                }
                if (object.sensors == null) {
                    object.sensors = new VRMLPointingDeviceSensorNodeType[1];
                    object.sensors[0] = node;
                } else {
                    int n = object.sensors.length;
                    VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n + 1];
                    System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n);
                    vRMLPointingDeviceSensorNodeTypeArray[n] = node;
                    object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
                }
            }
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) {
        Object object;
        Node node;
        if (!this.oglChildMap.containsKey(vRMLNodeType)) {
            return;
        }
        if (!this.inSetup) {
            node = (Node)this.oglChildMap.get(vRMLNodeType);
            this.oglChildMap.remove(vRMLNodeType);
            if (this.implGroup.isLive()) {
                this.removedChildren.add(node);
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.implGroup.removeChild(node);
            }
        }
        node = null;
        if (vRMLNodeType instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)vRMLNodeType;
        } else if (vRMLNodeType instanceof VRMLProtoInstance && (object = ((VRMLProtoInstance)vRMLNodeType).getImplementationNode()) instanceof VRMLPointingDeviceSensorNodeType) {
            node = (VRMLPointingDeviceSensorNodeType)object;
        }
        if (node != null) {
            object = (OGLUserData)((Object)this.oglImplGroup.getUserData());
            int n = object.sensors.length;
            if (n == 1) {
                object.sensors = null;
            } else {
                int n2;
                for (n2 = 0; n2 < n && object.sensors[n2] != node; ++n2) {
                }
                while (n2 < n - 1) {
                    object.sensors[n2] = object.sensors[n2 + 1];
                    ++n2;
                }
                VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = new VRMLPointingDeviceSensorNodeType[n - 1];
                System.arraycopy(object.sensors, 0, vRMLPointingDeviceSensorNodeTypeArray, 0, n - 1);
                object.sensors = vRMLPointingDeviceSensorNodeTypeArray;
            }
        }
        super.removeChildNode(vRMLNodeType);
    }

    protected void setGeoCoords(double[] dArray) {
        super.setGeoCoords(dArray);
        this.updateMatrix();
        this.matrixChanged = true;
        if (this.implGroup.isLive()) {
            this.implGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGroup);
        }
    }

    private void getLocalOrientation(double[] dArray, AxisAngle4f axisAngle4f) {
        this.posVec.x = dArray[0];
        this.posVec.y = dArray[1];
        this.posVec.z = dArray[2];
        double d = this.posVec.x * this.posVec.x + this.posVec.y * this.posVec.y + this.posVec.z * this.posVec.z;
        if (d != 0.0) {
            d = 1.0 / Math.sqrt(d);
            this.posVec.x *= d;
            this.posVec.y *= d;
            this.posVec.z *= d;
        } else {
            this.posVec.x = 0.0;
            this.posVec.y = 1.0;
            this.posVec.z = 0.0;
        }
        double d2 = this.YUP.angle(this.posVec);
        this.posVec.cross(this.YUP, this.posVec);
        this.posVec.normalize();
        axisAngle4f.x = (float)this.posVec.x;
        axisAngle4f.y = (float)this.posVec.y;
        axisAngle4f.z = (float)this.posVec.z;
        axisAngle4f.angle = (float)d2;
        d2 = this.XUP.angle(this.posVec);
        this.posVec.cross(this.XUP, this.posVec);
        this.posVec.normalize();
        Quat4d quat4d = new Quat4d();
        quat4d.set(axisAngle4f);
        Quat4d quat4d2 = new Quat4d();
        quat4d2.set(new AxisAngle4d(this.posVec.x, this.posVec.y, this.posVec.z, d2));
        quat4d.set(quat4d.w * quat4d2.x + quat4d.x * quat4d2.w + quat4d.y * quat4d2.z - quat4d.z * quat4d2.y, quat4d.w * quat4d2.y + quat4d.y * quat4d2.w + quat4d.z * quat4d2.x - quat4d.x * quat4d2.z, quat4d.w * quat4d2.z + quat4d.z * quat4d2.w + quat4d.x * quat4d2.y - quat4d.y * quat4d2.x, quat4d.w * quat4d2.w - quat4d.x * quat4d2.x - quat4d.y * quat4d2.y - quat4d.z * quat4d2.z);
        axisAngle4f.set(quat4d);
    }

    private void updateMatrix() {
        try {
            double[] dArray;
            GTTransformUtils gTTransformUtils = GTTransformUtils.getInstance();
            if (this.vfGeoOrigin != null) {
                dArray = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
                this.localCoords[0] = this.localCoords[0] + dArray[0];
                this.localCoords[1] = this.localCoords[1] + dArray[1];
                this.localCoords[2] = this.localCoords[2] + dArray[2];
            }
            this.getLocalOrientation(this.localCoords, this.axis);
            if (this.vfGeoOrigin != null) {
                dArray = ((BaseGeoOrigin)this.vfGeoOrigin).getConvertedCoordRef();
                this.localCoords[0] = this.localCoords[0] - dArray[0];
                this.localCoords[1] = this.localCoords[1] - dArray[1];
                this.localCoords[2] = this.localCoords[2] - dArray[2];
            }
        }
        catch (FactoryException factoryException) {
            this.errorReporter.errorReport(FACTORY_ERR_MSG, (Exception)((Object)factoryException));
        }
        this.locationMatrix.setIdentity();
        this.locationMatrix.set(this.axis);
        this.trans.x = (float)this.localCoords[0];
        this.trans.y = (float)this.localCoords[1];
        this.trans.z = (float)this.localCoords[2];
        this.locationMatrix.setTranslation(this.trans);
    }

    private void init() {
        this.sensorList = new ArrayList();
        this.implGroup = new TransformGroup();
        this.locationMatrix = new Matrix4f();
        this.locationMatrix.setIdentity();
        this.trans = new Vector3f();
        this.axis = new AxisAngle4f();
        this.posVec = new Vector3d();
    }
}

