/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.geom3d;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TriangleArray;
import org.j3d.geom.GeometryData;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.GeometryHolder;
import org.web3d.vrml.renderer.common.nodes.GeometryUtils;
import org.web3d.vrml.renderer.common.nodes.geom3d.BaseExtrusion;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;

public class OGLExtrusion
extends BaseExtrusion
implements OGLGeometryNodeType,
NodeUpdateListener {
    private static final String SOR_ERR = "Invalid Extrusion data; looks like a solid of revolution";
    private static final String Y_NORM_MSG = "Error normalizing Y in Extrusion";
    private Geometry implGeom;
    private float[] coords;
    private int[] coordIndex;
    private Point3f[] spines;
    private Vector3f[] scales;
    private AxisAngle4f[] orientations;
    private Matrix3f[] rotations;
    private Matrix4f[] transforms;
    private boolean collinear;
    private boolean normalsChanged;
    private boolean texCoordsChanged;
    private boolean colorsChanged;
    private boolean vboChanged;
    private boolean spineClosed;
    boolean crossSectionClosed;
    protected GeometryData geomData;
    int uniqueCrossSectionPoints;

    public OGLExtrusion() {
    }

    public OGLExtrusion(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public void updateNodeBoundsChanges(Object object) {
        ((TriangleArray)this.implGeom).setVertices(3, this.geomData.coordinates, this.geomData.vertexCount);
    }

    public void updateNodeDataChanges(Object object) {
        ((TriangleArray)this.implGeom).setNormals(this.geomData.normals);
    }

    private void buildImplTriangleArray() {
        this.initSetup();
        if (!this.calculateSCP()) {
            return;
        }
        this.createExtrusionCoordinates();
        this.createIndicesTriangleArray();
        GeometryUtils geometryUtils = new GeometryUtils();
        GeometryHolder geometryHolder = new GeometryHolder();
        geometryUtils.generateTriangleArrays(this.coords, null, null, null, 1, true, true, this.coordIndex, this.coordIndex.length, null, null, null, true, this.vfConvex, false, true, this.vfCreaseAngle, true, geometryHolder);
        this.geomData = new GeometryData();
        this.geomData.geometryType = 1;
        geometryUtils.copyData(geometryHolder, this.geomData);
        if (this.implGeom.isLive()) {
            this.implGeom.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGeom);
        }
        if (this.implGeom.isLive()) {
            this.implGeom.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.implGeom);
        }
    }

    private void createExtrusionCoordinates() {
        this.coords = new float[this.numSpine * this.uniqueCrossSectionPoints * 3];
        for (int i = 0; i < this.numSpine; ++i) {
            Matrix4f matrix4f = this.transforms[i];
            for (int j = 0; j < this.uniqueCrossSectionPoints; ++j) {
                int n = (i * this.uniqueCrossSectionPoints + j) * 3;
                float f = this.vfCrossSection[j * 2];
                float f2 = this.vfCrossSection[j * 2 + 1];
                float f3 = f * matrix4f.m00 + f2 * matrix4f.m02 + matrix4f.m03;
                float f4 = f * matrix4f.m10 + f2 * matrix4f.m12 + matrix4f.m13;
                float f5 = f * matrix4f.m20 + f2 * matrix4f.m22 + matrix4f.m23;
                this.coords[n] = f3;
                this.coords[n + 1] = f4;
                this.coords[n + 2] = f5;
            }
        }
    }

    private void createIndicesTriangleArray() {
        int n;
        int n2 = 5 * (this.numCrossSection - 1) * (this.numSpine - 1);
        if (this.vfBeginCap) {
            n2 += this.uniqueCrossSectionPoints + 1;
        }
        if (this.vfEndCap) {
            n2 += this.uniqueCrossSectionPoints + 1;
        }
        this.coordIndex = new int[n2];
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.numSpine - 1; ++n) {
            n4 = n * this.uniqueCrossSectionPoints;
            for (int i = 0; i < this.numCrossSection - 1; ++i) {
                if (this.vfCCW) {
                    this.coordIndex[n3++] = i + n4;
                    this.coordIndex[n3++] = i + n4 + 1;
                    this.coordIndex[n3++] = i + n4 + this.uniqueCrossSectionPoints + 1;
                    this.coordIndex[n3++] = i + n4 + this.uniqueCrossSectionPoints;
                } else {
                    this.coordIndex[n3++] = i + n4 + this.uniqueCrossSectionPoints;
                    this.coordIndex[n3++] = i + n4 + this.uniqueCrossSectionPoints + 1;
                    this.coordIndex[n3++] = i + n4 + 1;
                    this.coordIndex[n3++] = i + n4;
                }
                this.coordIndex[n3++] = -1;
            }
            if (!this.crossSectionClosed) continue;
            int n5 = n3 - 4;
            this.coordIndex[n5] = this.coordIndex[n5] - this.uniqueCrossSectionPoints;
            int n6 = n3 - 3;
            this.coordIndex[n6] = this.coordIndex[n6] - this.uniqueCrossSectionPoints;
        }
        if (this.vfBeginCap) {
            for (n = 0; n < this.uniqueCrossSectionPoints; ++n) {
                this.coordIndex[n3++] = this.vfCCW ? this.uniqueCrossSectionPoints - n - 1 : n;
            }
            this.coordIndex[n3++] = -1;
        }
        if (this.vfEndCap) {
            for (n = 0; n < this.uniqueCrossSectionPoints; ++n) {
                this.coordIndex[n3++] = this.vfCCW ? (this.numSpine - 1) * this.uniqueCrossSectionPoints + n : this.numSpine * this.uniqueCrossSectionPoints - n - 1;
            }
            this.coordIndex[n3] = -1;
        }
    }

    public Geometry getGeometry() {
        return this.implGeom;
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        super.setValue(n, fArray, n2);
        if (!this.inSetup) {
            this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
        }
    }

    public void allEventsComplete() {
        this.buildImplTriangleArray();
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.implGeom = new TriangleArray(true, 35044);
        this.buildImplTriangleArray();
    }

    private void initSetup() {
        int n;
        this.normalsChanged = false;
        this.texCoordsChanged = false;
        this.colorsChanged = false;
        this.vboChanged = false;
        this.collinear = false;
        this.spineClosed = this.vfSpine[0] == this.vfSpine[this.vfSpine.length - 3] && this.vfSpine[1] == this.vfSpine[this.vfSpine.length - 2] && this.vfSpine[2] == this.vfSpine[this.vfSpine.length - 1];
        this.uniqueCrossSectionPoints = this.numCrossSection;
        boolean bl = this.crossSectionClosed = this.vfCrossSection[0] == this.vfCrossSection[this.vfCrossSection.length - 2] && this.vfCrossSection[1] == this.vfCrossSection[this.vfCrossSection.length - 1];
        if (this.crossSectionClosed) {
            --this.uniqueCrossSectionPoints;
        }
        this.spines = new Point3f[this.numSpine];
        for (n = 0; n < this.spines.length; ++n) {
            this.spines[n] = new Point3f(this.vfSpine[n * 3], this.vfSpine[n * 3 + 1], this.vfSpine[n * 3 + 2]);
        }
        this.orientations = new AxisAngle4f[this.numSpine];
        for (n = 0; n < this.orientations.length; ++n) {
            this.orientations[n] = n * 4 + 3 < this.vfOrientation.length ? new AxisAngle4f(this.vfOrientation[n * 4], this.vfOrientation[n * 4 + 1], this.vfOrientation[n * 4 + 2], this.vfOrientation[n * 4 + 3]) : new AxisAngle4f(this.orientations[n - 1]);
        }
        this.scales = new Vector3f[this.numSpine];
        for (n = 0; n < this.scales.length; ++n) {
            this.scales[n] = n * 2 + 1 < this.vfScale.length ? new Vector3f(this.vfScale[n * 2], 1.0f, this.vfScale[n * 2 + 1]) : new Vector3f(this.scales[n - 1]);
        }
        this.rotations = new Matrix3f[this.vfSpine.length / 3];
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        double d = 0.0;
        for (int i = 1; i < this.spines.length - 1; ++i) {
            vector3d.set((Tuple3f)this.spines[i + 1]);
            vector3d2.set((Tuple3f)this.spines[i]);
            vector3d3.set((Tuple3f)this.spines[i - 1]);
            vector3d.sub((Tuple3d)vector3d2);
            vector3d2.sub((Tuple3d)vector3d3);
            vector3d3.cross(vector3d, vector3d2);
            d += vector3d3.dot(vector3d3);
        }
        this.collinear = d == 0.0;
    }

    private boolean calculateSCP() {
        int n;
        int n2 = this.numSpine - 1;
        Vector3f[] vector3fArray = new Vector3f[this.numSpine];
        Vector3f[] vector3fArray2 = new Vector3f[this.numSpine];
        Vector3f[] vector3fArray3 = new Vector3f[this.numSpine];
        if (this.collinear) {
            if (this.spineClosed) {
                this.errorReporter.warningReport(SOR_ERR, null);
                StringBuffer stringBuffer = new StringBuffer("Spine data:");
                for (int i = 0; i < this.spines.length; ++i) {
                    stringBuffer.append(this.spines[i]);
                    stringBuffer.append(' ');
                }
                this.errorReporter.messageReport(stringBuffer.toString());
                return false;
            }
            Vector3f vector3f = null;
            for (n = 0; n < this.spines.length; ++n) {
                if (this.spines[0].equals((Tuple3f)this.spines[n])) continue;
                vector3f = new Vector3f((Tuple3f)this.spines[n]);
            }
            vector3fArray2[0] = new Vector3f();
            vector3fArray2[0].sub(vector3f, (Tuple3f)this.spines[0]);
            if (!this.norm(vector3fArray2[0])) {
                this.errorReporter.warningReport(Y_NORM_MSG, null);
            }
            vector3fArray[0] = vector3fArray2[0].x == 1.0f ? new Vector3f(0.0f, -1.0f, 0.0f) : (vector3fArray2[0].x == -1.0f ? new Vector3f(0.0f, 1.0f, 0.0f) : new Vector3f(1.0f, 0.0f, 0.0f));
            vector3fArray3[0] = new Vector3f();
            vector3fArray3[0].cross(vector3fArray[0], vector3fArray2[0]);
            vector3fArray[0].cross(vector3fArray2[0], vector3fArray3[0]);
            for (n = 1; n < this.spines.length; ++n) {
                vector3fArray[n] = new Vector3f(vector3fArray[0]);
                vector3fArray2[n] = new Vector3f(vector3fArray2[0]);
                vector3fArray3[n] = new Vector3f(vector3fArray3[0]);
            }
        } else {
            Vector3f vector3f;
            Vector3f vector3f2;
            int n3;
            int n4;
            for (n4 = 1; n4 < n2; ++n4) {
                vector3fArray2[n4] = new Vector3f();
                vector3fArray2[n4].sub((Tuple3f)this.spines[n4 + 1], (Tuple3f)this.spines[n4 - 1]);
                if (this.norm(vector3fArray2[n4])) continue;
                vector3fArray2[n4].sub((Tuple3f)this.spines[n4 + 1], (Tuple3f)this.spines[n4]);
                if (this.norm(vector3fArray2[n4])) continue;
                vector3fArray2[n4].sub((Tuple3f)this.spines[n4], (Tuple3f)this.spines[n4 - 1]);
                if (this.norm(vector3fArray2[n4])) continue;
                for (n3 = n4 + 2; n3 < n2 + 1 && this.spines[n4 - 1].equals((Tuple3f)this.spines[n3]); ++n3) {
                }
                if (n3 < n2 + 1) {
                    vector3fArray2[n4].sub((Tuple3f)this.spines[n3], (Tuple3f)this.spines[n4 - 1]);
                    this.norm(vector3fArray2[n4]);
                    continue;
                }
                vector3fArray2[n4] = new Vector3f(0.0f, 1.0f, 0.0f);
            }
            if (this.spineClosed) {
                vector3fArray2[0] = new Vector3f();
                vector3fArray2[0].sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[n2 - 1]);
                if (!this.norm(vector3fArray2[0])) {
                    for (n4 = n2 - 2; n4 > 1 && this.spines[1].equals((Tuple3f)this.spines[n4]); --n4) {
                    }
                    if (n4 > 1) {
                        vector3fArray2[0].sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[n4]);
                        this.norm(vector3fArray2[0]);
                    } else {
                        vector3fArray2[0].set(0.0f, 0.0f, 1.0f);
                    }
                }
                vector3fArray2[n2] = new Vector3f(vector3fArray2[0]);
            } else {
                vector3fArray2[0] = new Vector3f();
                vector3fArray2[n2] = new Vector3f();
                vector3fArray2[0].sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[0]);
                if (!this.norm(vector3fArray2[0])) {
                    for (n4 = 2; n4 < n2 && this.spines[0].equals((Tuple3f)this.spines[n4]); ++n4) {
                    }
                    if (n4 < n2) {
                        vector3fArray2[0].sub((Tuple3f)this.spines[n4], (Tuple3f)this.spines[0]);
                        this.norm(vector3fArray2[0]);
                    } else {
                        vector3fArray2[0].set(0.0f, 0.0f, 1.0f);
                    }
                }
                vector3fArray2[n2] = new Vector3f();
                vector3fArray2[n2].sub((Tuple3f)this.spines[n2], (Tuple3f)this.spines[n2 - 1]);
                if (!this.norm(vector3fArray2[n2])) {
                    for (n4 = n2 - 2; n4 > -1 && this.spines[n2].equals((Tuple3f)this.spines[n4]); --n4) {
                    }
                    if (n4 > -1) {
                        vector3fArray2[n2].sub((Tuple3f)this.spines[n2], (Tuple3f)this.spines[n4]);
                        this.norm(vector3fArray2[n2]);
                    } else {
                        vector3fArray2[n2].set(0.0f, 0.0f, 1.0f);
                    }
                }
            }
            n4 = 0;
            for (n3 = 1; n3 < n2; ++n3) {
                vector3f2 = new Vector3f();
                vector3f = new Vector3f();
                vector3fArray3[n3] = new Vector3f();
                vector3f2.sub((Tuple3f)this.spines[n3 - 1], (Tuple3f)this.spines[n3]);
                vector3f.sub((Tuple3f)this.spines[n3 + 1], (Tuple3f)this.spines[n3]);
                vector3fArray3[n3].cross(vector3f2, vector3f);
                if (this.norm(vector3fArray3[n3])) continue;
                n4 = 1;
            }
            if (this.spineClosed) {
                vector3fArray3[0] = vector3fArray3[n2] = new Vector3f();
                vector3f2 = new Vector3f();
                vector3f = new Vector3f();
                vector3f2.sub((Tuple3f)this.spines[n2 - 1], (Tuple3f)this.spines[0]);
                vector3f.sub((Tuple3f)this.spines[1], (Tuple3f)this.spines[0]);
                try {
                    vector3fArray3[0].cross(vector3f2, vector3f);
                }
                catch (ArithmeticException arithmeticException) {
                    n4 = 1;
                }
            } else {
                vector3fArray3[0] = new Vector3f(vector3fArray3[1]);
                vector3fArray3[n2] = new Vector3f(vector3fArray3[n2 - 1]);
            }
            if (n4 != 0) {
                if (vector3fArray3[0].dot(vector3fArray3[0]) == 0.0f) {
                    for (int i = 1; i < this.spines.length; ++i) {
                        if (!(vector3fArray3[i].dot(vector3fArray3[i]) > 0.0f)) continue;
                        vector3fArray3[0] = new Vector3f(vector3fArray3[i]);
                    }
                    if (vector3fArray3[0].dot(vector3fArray3[0]) == 0.0f) {
                        vector3fArray3[0] = new Vector3f(0.0f, 0.0f, 1.0f);
                    }
                }
                for (int i = 1; i < n2 + 1; ++i) {
                    if (vector3fArray3[i].dot(vector3fArray3[i]) != 0.0f) continue;
                    vector3fArray3[i] = new Vector3f(vector3fArray3[i - 1]);
                }
            }
            for (n = 0; n < this.spines.length; ++n) {
                if (n > 0 && vector3fArray3[n].dot(vector3fArray3[n - 1]) < 0.0f) {
                    vector3fArray3[n].negate();
                }
                vector3fArray[n] = new Vector3f();
                vector3fArray[n].cross(vector3fArray2[n], vector3fArray3[n]);
                this.norm(vector3fArray[n]);
            }
        }
        Matrix3f matrix3f = new Matrix3f();
        this.transforms = new Matrix4f[this.spines.length];
        for (n = 0; n < this.spines.length; ++n) {
            this.rotations[n] = new Matrix3f();
            this.rotations[n].setColumn(0, vector3fArray[n]);
            this.rotations[n].setColumn(1, vector3fArray2[n]);
            this.rotations[n].setColumn(2, vector3fArray3[n]);
        }
        Matrix3f[] matrix3fArray = this.createCorrectionRotations(vector3fArray3);
        Vector3f vector3f = new Vector3f();
        for (int i = 0; i < this.spines.length; ++i) {
            this.rotations[i].mul(matrix3fArray[i]);
            matrix3f.set(this.orientations[i]);
            this.rotations[i].mul(matrix3f);
            this.transforms[i] = new Matrix4f();
            this.transforms[i].setIdentity();
            matrix3f.m00 = this.scales[i].x;
            matrix3f.m11 = this.scales[i].y;
            matrix3f.m22 = this.scales[i].z;
            matrix3f.mul(this.rotations[i]);
            this.transforms[i].setRotationScale(matrix3f);
            vector3f.set((Tuple3f)this.spines[i]);
            this.transforms[i].setTranslation(vector3f);
        }
        return true;
    }

    private Matrix3f[] createCorrectionRotations(Vector3f[] vector3fArray) {
        int n;
        Matrix3f[] matrix3fArray = new Matrix3f[this.spines.length];
        matrix3fArray[0] = new Matrix3f();
        matrix3fArray[0].setIdentity();
        AxisAngle4f axisAngle4f = new AxisAngle4f();
        Point3f point3f = new Point3f(this.vfCrossSection[0], 0.0f, this.vfCrossSection[1]);
        for (n = 0; n < this.numCrossSection; ++n) {
            if (this.vfCrossSection[n * 2] == 0.0f && this.vfCrossSection[n * 2 + 1] == 0.0f) continue;
            point3f = new Point3f(this.vfCrossSection[n * 2], 0.0f, this.vfCrossSection[n * 2 + 1]);
            break;
        }
        for (n = 1; n < this.spines.length; ++n) {
            float f = vector3fArray[n].angle(vector3fArray[n - 1]);
            matrix3fArray[n] = matrix3fArray[n - 1];
            if (f == 0.0f) continue;
            matrix3fArray[n] = new Matrix3f(matrix3fArray[n - 1]);
            Point3f point3f2 = new Point3f();
            Matrix3f matrix3f = new Matrix3f(this.rotations[n - 1]);
            matrix3f.mul(matrix3fArray[n - 1]);
            matrix3f.transform((Tuple3f)point3f, (Tuple3f)point3f2);
            Matrix3f matrix3f2 = new Matrix3f();
            matrix3f2.setIdentity();
            matrix3f2.rotY(-f);
            matrix3fArray[n].mul(matrix3f2);
            Matrix3f matrix3f3 = new Matrix3f(this.rotations[n]);
            matrix3f3.mul(matrix3fArray[n]);
            Point3f point3f3 = new Point3f();
            matrix3f3.transform((Tuple3f)point3f, (Tuple3f)point3f3);
            float f2 = point3f3.distance(point3f2);
            matrix3f2.rotY(f * 2.0f);
            matrix3fArray[n].mul(matrix3f2);
            Matrix3f matrix3f4 = new Matrix3f(this.rotations[n]);
            matrix3f4.mul(matrix3fArray[n]);
            Point3f point3f4 = new Point3f();
            matrix3f4.transform((Tuple3f)point3f4);
            float f3 = point3f4.distance(point3f2);
            if (f3 > f2) {
                matrix3f2.rotY(-f * 2.0f);
                matrix3fArray[n].mul(matrix3f2);
            }
            axisAngle4f.set(matrix3fArray[n]);
            if (!((double)((float)Math.PI - axisAngle4f.angle) < 0.001)) continue;
            matrix3fArray[n].rotY((float)((double)axisAngle4f.angle - Math.PI));
        }
        return matrix3fArray;
    }

    private boolean norm(Vector3f vector3f) {
        float f = vector3f.x * vector3f.x + vector3f.y * vector3f.y + vector3f.z * vector3f.z;
        if (f == 0.0f) {
            return false;
        }
        f = 1.0f / (float)Math.sqrt(f);
        vector3f.x *= f;
        vector3f.y *= f;
        vector3f.z *= f;
        return true;
    }

    private void printCrossSectionPoints() {
        for (int i = 0; i < this.vfCrossSection.length; ++i) {
            if (this.vfCrossSection[i] >= 0.0f) {
                System.out.print(" ");
            }
            System.out.print(this.vfCrossSection[i++]);
            System.out.print(", " + this.vfCrossSection[i]);
            if (i / 2 % this.numCrossSection == this.numCrossSection - 1) {
                System.out.println();
                continue;
            }
            System.out.print("\t");
        }
        System.out.println("=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~");
    }

    private void printCoords() {
        for (int i = 0; i < this.coords.length; ++i) {
            if (this.coords[i] >= 0.0f) {
                System.out.print(" ");
            }
            System.out.print(this.coords[i]);
            if (i % (this.uniqueCrossSectionPoints * 3) == this.uniqueCrossSectionPoints * 3 - 1) {
                System.out.println();
            } else if (i % 3 == 2) {
                System.out.print("\t");
            } else {
                System.out.print(", ");
            }
            if (i % 3 != 0) continue;
            ++i;
        }
        System.out.println("=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~");
    }

    private void printIndices() {
        for (int i = 0; i < this.coordIndex.length; ++i) {
            if (this.coordIndex[i] == -1) {
                System.out.println(this.coordIndex[i]);
                continue;
            }
            System.out.print(this.coordIndex[i] + ",\t");
        }
        System.out.println("=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~=~");
    }
}

