/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.geom2d;

import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.TriangleArray;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.geom2d.BaseTriangleSet2D;
import org.web3d.vrml.renderer.ogl.nodes.OGLGeometryNodeType;

public class OGLTriangleSet2D
extends BaseTriangleSet2D
implements OGLGeometryNodeType,
NodeUpdateListener {
    private TriangleArray implGeom;
    private float[] normals;

    public OGLTriangleSet2D() {
    }

    public OGLTriangleSet2D(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
    }

    public Geometry getGeometry() {
        return this.implGeom;
    }

    public int getNumSets() {
        return 0;
    }

    public String getTexCoordGenMode(int n) {
        return null;
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGeom;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.normals = new float[this.numVertices * 3 / 2];
        for (int i = 0; i < this.numVertices / 2; ++i) {
            this.normals[i * 3 + 2] = 1.0f;
        }
        this.implGeom = new TriangleArray();
        this.implGeom.setVertices(2, this.vfVertices, this.numVertices / 2);
        this.implGeom.setNormals(this.normals);
    }

    public void updateNodeBoundsChanges(Object object) {
        this.implGeom.setVertices(2, this.vfVertices, this.numVertices / 2);
    }

    public void updateNodeDataChanges(Object object) {
        this.implGeom.setNormals(this.normals);
    }

    protected void setVertices(float[] fArray, int n) {
        super.setVertices(fArray, n);
        if (!this.inSetup) {
            if (this.normals.length < n * 3 / 2) {
                this.normals = new float[this.numVertices * 3 / 2];
                for (int i = 0; i < this.numVertices / 2; ++i) {
                    this.normals[i * 3 + 1] = 1.0f;
                }
            }
            if (this.implGeom.isLive()) {
                this.implGeom.boundsChanged((NodeUpdateListener)this);
                this.implGeom.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.implGeom);
                this.updateNodeBoundsChanges(this.implGeom);
            }
        }
    }
}

