/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.enveffects;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import org.j3d.aviatrix3d.ByteBufferTextureComponent2D;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Texture2D;
import org.j3d.aviatrix3d.TextureSource;
import org.web3d.image.NIOBufferImage;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.renderer.common.nodes.enveffects.BaseTextureBackground;
import org.web3d.vrml.renderer.ogl.nodes.OGLBackgroundNodeType;

public class OGLTextureBackground
extends BaseTextureBackground
implements OGLBackgroundNodeType {
    private static final String MINFILTER_PROP = "org.web3d.vrml.nodes.loader.minfilter";
    private static final String MAGFILTER_PROP = "org.web3d.vrml.nodes.loader.maxfilter";
    private static final String RESCALE_PROP = "org.web3d.vrml.nodes.loader.rescale";
    private static final int DEFAULT_MAGFILTER = 1;
    private static final int DEFAULT_MINFILTER = 1;
    private static final int DEFAULT_RESCALE = 2;
    private static final int magfilter;
    private static final int minfilter;
    private static final int rescale;
    private Texture2D[] textureList;
    private boolean[] textureChangeFlags;
    private Group implGroup;

    public OGLTextureBackground() {
        this.init();
    }

    public OGLTextureBackground(VRMLNodeType vRMLNodeType) {
        super(vRMLNodeType);
        this.init();
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGroup;
    }

    public boolean getChangedTextures(Texture2D[] texture2DArray, boolean[] blArray) {
        boolean bl = false;
        for (int i = 0; i < 6; ++i) {
            blArray[i] = this.textureChangeFlags[i];
            if (!this.textureChangeFlags[i]) continue;
            texture2DArray[i] = this.textureList[i];
            bl = true;
            this.textureChangeFlags[i] = false;
        }
        return bl;
    }

    public Texture2D[] getBackgroundTextures() {
        return this.textureList;
    }

    private void init() {
        this.implGroup = new Group();
        this.textureList = new Texture2D[6];
        this.textureChangeFlags = new boolean[6];
    }

    private void buildTexture(Object object, int n) {
        NIOBufferImage nIOBufferImage = null;
        if (!(object instanceof NIOBufferImage)) {
            return;
        }
        nIOBufferImage = (NIOBufferImage)object;
        int n2 = nIOBufferImage.getWidth();
        int n3 = nIOBufferImage.getHeight();
        int n4 = 1;
        ByteBufferTextureComponent2D byteBufferTextureComponent2D = new ByteBufferTextureComponent2D(n4, n2, n3, nIOBufferImage.getBuffer());
        if (byteBufferTextureComponent2D != null) {
            Texture2D texture2D = new Texture2D();
            texture2D.setMinFilter(1);
            texture2D.setMagFilter(1);
            texture2D.setBoundaryModeS(33071);
            texture2D.setBoundaryModeT(33071);
            texture2D.setSources(0, 6407, new TextureSource[]{byteBufferTextureComponent2D}, 1);
            this.textureList[n] = texture2D;
        }
    }

    static {
        final HashMap<String, Integer> hashMap = new HashMap<String, Integer>(8);
        final HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>(8);
        hashMap2.put("NICEST", new Integer(1));
        hashMap2.put("FASTEST", new Integer(0));
        hashMap2.put("BASE_LEVEL_POINT", new Integer(2));
        hashMap2.put("BASE_LEVEL_LINEAR", new Integer(3));
        hashMap2.put("LINEAR_SHARPEN", new Integer(4));
        hashMap2.put("LINEAR_SHARPEN_RGB", new Integer(5));
        hashMap2.put("LINEAR_SHARPEN_ALPHA", new Integer(6));
        hashMap.put("NICEST", new Integer(1));
        hashMap.put("FASTEST", new Integer(0));
        hashMap.put("BASE_LEVEL_POINT", new Integer(2));
        hashMap.put("BASE_LEVEL_LINEAR", new Integer(3));
        final HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>(2);
        hashMap3.put("BILINEAR", new Integer(2));
        hashMap3.put("NEAREST_NEIGHBOR", new Integer(1));
        int[] nArray = (int[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Integer n;
                int[] nArray = new int[3];
                String string = System.getProperty(OGLTextureBackground.MINFILTER_PROP);
                nArray[0] = string != null ? ((n = (Integer)hashMap.get(string)) != null ? n : 1) : 1;
                string = System.getProperty(OGLTextureBackground.MAGFILTER_PROP);
                nArray[1] = string != null ? ((n = (Integer)hashMap2.get(string)) != null ? n : 1) : 1;
                string = System.getProperty(OGLTextureBackground.RESCALE_PROP);
                nArray[2] = string != null ? ((n = (Integer)hashMap3.get(string)) != null ? n : 2) : 2;
                return nArray;
            }
        });
        minfilter = nArray[0];
        magfilter = nArray[1];
        rescale = nArray[2];
    }
}

