/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes.core;

import java.util.HashMap;
import java.util.LinkedList;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.nodes.FrameStateListener;
import org.web3d.vrml.nodes.VRMLChildNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.common.nodes.core.BaseWorldRoot;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.renderer.ogl.nodes.OGLWorldRootNodeType;

public class OGLWorldRoot
extends BaseWorldRoot
implements OGLWorldRootNodeType {
    private static final String BAD_PROTO_MSG = "The resolved proto instance is not a X3DChildNode type. Grouping nodes may only use ChildNode types for the children field.";
    private HashMap oglChildMap;
    private Group implGroup = new Group();
    private LinkedList addedChildren;
    private LinkedList removedChildren = new LinkedList();

    public OGLWorldRoot() {
        this.addedChildren = new LinkedList();
    }

    public void updateNodeBoundsChanges(Object object) {
        Node node;
        int n;
        int n2 = this.removedChildren == null ? 0 : this.removedChildren.size();
        for (n = 0; n < n2; ++n) {
            node = (Node)this.removedChildren.get(0);
            this.removedChildren.remove(0);
            this.implGroup.removeChild(node);
        }
        n2 = this.addedChildren == null ? 0 : this.addedChildren.size();
        for (n = 0; n < n2; ++n) {
            node = (Node)this.addedChildren.get(0);
            this.addedChildren.remove(0);
            this.implGroup.addChild(node);
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void allEventsComplete() {
        if (this.implGroup.isLive()) {
            this.implGroup.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.implGroup);
        }
    }

    public SceneGraphObject getSceneGraphObject() {
        return this.implGroup;
    }

    public void setupFinished() {
        if (!this.inSetup) {
            return;
        }
        super.setupFinished();
        this.oglChildMap = new HashMap();
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(i);
            oGLVRMLNode.setupFinished();
            Node node = (Node)oGLVRMLNode.getSceneGraphObject();
            if (node == null) continue;
            this.oglChildMap.put(oGLVRMLNode, node);
            this.implGroup.addChild(node);
        }
    }

    protected void clearChildren() {
        OGLUserData oGLUserData;
        int n = this.vfChildren.size();
        for (int i = 0; i < n; ++i) {
            OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)this.vfChildren.get(i);
            Node node = (Node)this.oglChildMap.get(oGLVRMLNode);
            this.removedChildren.add(node);
            this.oglChildMap.remove(oGLVRMLNode);
        }
        if (!this.inSetup) {
            if (this.implGroup.isLive()) {
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.removedChildren.clear();
                this.implGroup.removeAllChildren();
            }
        }
        if ((oGLUserData = (OGLUserData)((Object)this.implGroup.getUserData())) != null) {
            oGLUserData.sensors = null;
        }
        super.clearChildren();
    }

    protected void addChildNode(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        super.addChildNode(vRMLNodeType);
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        if (!this.inSetup) {
            Node node = (Node)oGLVRMLNode.getSceneGraphObject();
            this.oglChildMap.put(vRMLNodeType, node);
            if (this.implGroup.isLive()) {
                this.addedChildren.add(node);
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.implGroup.addChild(node);
            }
        }
    }

    protected void removeChildNode(VRMLNodeType vRMLNodeType) {
        if (!this.oglChildMap.containsKey(vRMLNodeType)) {
            return;
        }
        if (!this.inSetup) {
            Node node = (Node)this.oglChildMap.get(vRMLNodeType);
            this.oglChildMap.remove(vRMLNodeType);
            if (this.implGroup.isLive()) {
                this.removedChildren.add(node);
                this.implGroup.boundsChanged((NodeUpdateListener)this);
            } else {
                this.implGroup.removeChild(node);
            }
        }
        super.removeChildNode(vRMLNodeType);
    }

    public synchronized void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) {
        if (!(vRMLNodeType instanceof VRMLChildNodeType) && !(vRMLNodeType instanceof VRMLProtoInstance)) {
            throw new InvalidFieldValueException(BAD_PROTO_MSG);
        }
        if (this.inSetup) {
            return;
        }
        OGLVRMLNode oGLVRMLNode = (OGLVRMLNode)vRMLNodeType;
        oGLVRMLNode.setupFinished();
        Node node = (Node)oGLVRMLNode.getSceneGraphObject();
        this.oglChildMap.put(vRMLNodeType, node);
        if (node != null) {
            if (this.implGroup.isLive()) {
                this.addedChildren.add(node);
                this.stateManager.addEndOfThisFrameListener((FrameStateListener)this);
            } else {
                this.implGroup.addChild(node);
            }
        }
    }
}

