/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.nodes;

import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.Texture2D;
import org.j3d.aviatrix3d.Texture3D;

public class TextureCache {
    protected HashMap<String, ArrayList<WeakReference<Texture>>> textureMap = new HashMap();
    protected boolean enabled = true;
    protected static TextureCache cache;

    protected TextureCache() {
    }

    public static TextureCache getInstance() {
        if (cache == null) {
            cache = new TextureCache();
        }
        return cache;
    }

    public synchronized void release(String string, Texture texture) {
        ArrayList<WeakReference<Texture>> arrayList;
        if (this.enabled && string != null && texture != null && (arrayList = this.textureMap.get(string)) != null) {
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                WeakReference<Texture> weakReference = arrayList.get(i);
                if (weakReference == null) {
                    arrayList.remove(i);
                    continue;
                }
                Texture texture2 = (Texture)weakReference.get();
                if (texture2 == null) {
                    arrayList.remove(i);
                    continue;
                }
                if (!this.isMatch(texture2, texture)) continue;
                arrayList.remove(i);
                break;
            }
        }
    }

    public void release(URL uRL, Texture texture) {
        if (uRL != null) {
            this.release(uRL.toExternalForm(), texture);
        }
    }

    public void clear() {
        this.textureMap.clear();
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public Texture register(URL uRL, Texture texture) {
        Texture texture2 = texture;
        if (uRL != null) {
            texture2 = this.register(uRL.toExternalForm(), texture);
        }
        return texture2;
    }

    public synchronized Texture register(String string, Texture texture) {
        Texture texture2 = texture;
        if (this.enabled && string != null && texture != null) {
            ArrayList<WeakReference<Object>> arrayList = this.textureMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList(1);
                arrayList.add(new WeakReference<Texture>(texture));
                this.textureMap.put(string, arrayList);
            } else {
                boolean bl = false;
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    WeakReference<Object> weakReference = arrayList.get(i);
                    if (weakReference == null) {
                        arrayList.remove(i);
                        continue;
                    }
                    Texture texture3 = (Texture)weakReference.get();
                    if (texture3 == null) {
                        arrayList.remove(i);
                        continue;
                    }
                    if (!this.isMatch(texture3, texture)) continue;
                    texture2 = texture3;
                    bl = true;
                    break;
                }
                if (!bl) {
                    arrayList.add(new WeakReference<Texture>(texture));
                }
            }
        }
        return texture2;
    }

    private boolean isMatch(Texture texture, Texture texture2) {
        boolean bl = texture.getTextureType() == texture2.getTextureType() & texture.getFormat() == texture2.getFormat() & texture.getWidth() == texture2.getWidth() & texture.getBoundaryModeS() == texture2.getBoundaryModeS() & texture.getMinFilter() == texture2.getMinFilter() & texture.getMagFilter() == texture2.getMagFilter() & texture.getAnisotropicFilterMode() == texture2.getAnisotropicFilterMode() & texture.getAnisotropicFilterDegree() == texture2.getAnisotropicFilterDegree();
        if (texture instanceof Texture2D && texture2 instanceof Texture2D) {
            Texture2D texture2D = (Texture2D)texture;
            Texture2D texture2D2 = (Texture2D)texture2;
            bl &= texture2D.getHeight() == texture2D2.getHeight() & texture2D.getBoundaryModeT() == texture2D2.getBoundaryModeT();
        } else if (texture instanceof Texture3D && texture2 instanceof Texture3D) {
            Texture3D texture3D = (Texture3D)texture;
            Texture3D texture3D2 = (Texture3D)texture2;
            bl &= texture3D.getHeight() == texture3D2.getHeight() & texture3D.getBoundaryModeT() != texture3D2.getBoundaryModeT() & texture3D.getDepth() == texture3D2.getDepth() & texture3D.getBoundaryModeR() == texture3D2.getBoundaryModeR();
        }
        return bl;
    }
}

