/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.input;

import java.util.ArrayList;
import java.util.Arrays;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.SceneGraphPath;
import org.j3d.aviatrix3d.ViewEnvironment;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.util.MatrixUtils;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVisibilityListener;

class VisibilityManager {
    private static final Vector3f NEG_Z_VEC = new Vector3f(0.0f, 0.0f, -1.0f);
    private static final int LIST_START_SIZE = 25;
    private static final int LIST_INCREMENT = 25;
    private static final float ZEROISH = 1.0E-6f;
    private Group worldRoot;
    private ViewEnvironment viewEnv;
    private double[] viewFrustum;
    private HashSet activeVisSensors;
    private HashSet newVisSensors;
    private OGLVisibilityListener[] list;
    private int lastListener;
    private PickRequest picker = new PickRequest();
    private Point3f endPoint;
    private Matrix4f localTx;
    private Matrix4f prjMatrix;
    private AxisAngle4f viewAngle;
    private MatrixUtils matrixUtils;
    private float invWorldScale;

    VisibilityManager() {
        this.picker.pickType = 4;
        this.picker.pickGeometryType = 10;
        this.picker.pickSortType = 1;
        this.picker.generateVWorldMatrix = true;
        this.picker.origin = new float[24];
        this.viewFrustum = new double[6];
        this.endPoint = new Point3f();
        this.viewAngle = new AxisAngle4f();
        this.localTx = new Matrix4f();
        this.prjMatrix = new Matrix4f();
        this.activeVisSensors = new HashSet();
        this.newVisSensors = new HashSet();
        this.matrixUtils = new MatrixUtils();
        this.invWorldScale = 1.0f;
        this.list = new OGLVisibilityListener[25];
        this.lastListener = 0;
    }

    void addSensor(VRMLSensorNodeType vRMLSensorNodeType) {
    }

    void removeSensor(VRMLSensorNodeType vRMLSensorNodeType) {
    }

    void setWorldRoot(Group group) {
        this.worldRoot = group;
    }

    void setViewEnvironment(ViewEnvironment viewEnvironment) {
        this.viewEnv = viewEnvironment;
    }

    void clear() {
        this.activeVisSensors.clear();
        this.newVisSensors.clear();
        ArrayList arrayList = (ArrayList)this.picker.foundPaths;
        if (arrayList != null) {
            arrayList.clear();
        }
    }

    void processFrame(Point3f point3f, AxisAngle4f axisAngle4f, Matrix4f matrix4f) {
        Object object;
        int n;
        if (this.worldRoot == null) {
            return;
        }
        this.generateFrustumPlanes(matrix4f);
        ArrayList arrayList = (ArrayList)this.picker.foundPaths;
        if (arrayList != null) {
            arrayList.clear();
        }
        this.worldRoot.pickSingle(this.picker);
        if (this.picker.pickCount != 0) {
            this.newVisSensors.clear();
            arrayList = (ArrayList)this.picker.foundPaths;
            for (n = 0; n < this.picker.pickCount; ++n) {
                SceneGraphPath sceneGraphPath = (SceneGraphPath)arrayList.get(n);
                object = sceneGraphPath.getTerminalNode();
                OGLUserData oGLUserData = (OGLUserData)((Object)object.getUserData());
                if (oGLUserData == null || oGLUserData.visibilityListener == null) continue;
                OGLVisibilityListener oGLVisibilityListener = oGLUserData.visibilityListener;
                sceneGraphPath.getTransform(this.localTx);
                if (this.activeVisSensors.contains((Object)oGLVisibilityListener)) {
                    oGLVisibilityListener.viewPositionChanged(point3f, axisAngle4f, this.localTx);
                    this.activeVisSensors.remove((Object)oGLVisibilityListener);
                } else {
                    oGLVisibilityListener.visibilityStateChange(true, point3f, axisAngle4f, this.localTx);
                }
                this.newVisSensors.add((Object)oGLVisibilityListener);
            }
        }
        if ((n = this.activeVisSensors.size()) != 0) {
            this.resizeList(n);
            this.activeVisSensors.toArray((Object[])this.list);
            for (int i = 0; i < n && this.list[i] != null; ++i) {
                object = this.list[i];
                object.visibilityStateChange(false, point3f, axisAngle4f, null);
                this.activeVisSensors.remove(object);
            }
        } else {
            Arrays.fill(this.list, null);
        }
        HashSet hashSet = this.activeVisSensors;
        this.activeVisSensors = this.newVisSensors;
        this.newVisSensors = hashSet;
    }

    void setWorldScale(float f) {
        this.invWorldScale = 1.0f / f;
    }

    private final void resizeList(int n) {
        if (this.list.length < n) {
            int n2 = this.list.length;
            int n3 = n2 + 25;
            OGLVisibilityListener[] oGLVisibilityListenerArray = new OGLVisibilityListener[n3];
            System.arraycopy(this.list, 0, oGLVisibilityListenerArray, 0, n2);
            this.list = oGLVisibilityListenerArray;
        } else {
            Arrays.fill(this.list, n - 1, this.list.length - 1, null);
        }
    }

    private void generateFrustumPlanes(Matrix4f matrix4f) {
        float[] fArray = this.picker.origin;
        this.viewEnv.generateViewFrustum(this.viewFrustum);
        float f = (float)this.viewFrustum[0];
        float f2 = (float)this.viewFrustum[1];
        float f3 = (float)this.viewFrustum[2];
        float f4 = (float)this.viewFrustum[3];
        float f5 = (float)this.viewFrustum[4];
        float f6 = (float)this.viewFrustum[5];
        float f7 = 2.0f * f5 / (f2 - f);
        float f8 = 2.0f * f5 / (f4 - f3);
        float f9 = (f2 + f) / (f2 - f);
        float f10 = (f4 + f3) / (f4 - f3);
        float f11 = -(f6 + f5) / (f6 - f5);
        float f12 = -(2.0f * f6 * f5) / (f6 - f5);
        this.prjMatrix.m00 = f7;
        this.prjMatrix.m01 = 0.0f;
        this.prjMatrix.m02 = f9;
        this.prjMatrix.m03 = 0.0f;
        this.prjMatrix.m10 = 0.0f;
        this.prjMatrix.m11 = f8;
        this.prjMatrix.m12 = f10;
        this.prjMatrix.m13 = 0.0f;
        this.prjMatrix.m20 = 0.0f;
        this.prjMatrix.m21 = 0.0f;
        this.prjMatrix.m22 = f11;
        this.prjMatrix.m23 = f12;
        this.prjMatrix.m30 = 0.0f;
        this.prjMatrix.m31 = 0.0f;
        this.prjMatrix.m32 = -1.0f;
        this.prjMatrix.m33 = 0.0f;
        this.matrixUtils.inverse(matrix4f, this.localTx);
        this.localTx.mul(this.prjMatrix, this.localTx);
        this.prjMatrix.m00 = this.localTx.m00;
        this.prjMatrix.m01 = this.localTx.m10;
        this.prjMatrix.m02 = this.localTx.m20;
        this.prjMatrix.m03 = this.localTx.m30;
        this.prjMatrix.m10 = this.localTx.m01;
        this.prjMatrix.m11 = this.localTx.m11;
        this.prjMatrix.m12 = this.localTx.m21;
        this.prjMatrix.m13 = this.localTx.m31;
        this.prjMatrix.m20 = this.localTx.m02;
        this.prjMatrix.m21 = this.localTx.m12;
        this.prjMatrix.m22 = this.localTx.m22;
        this.prjMatrix.m23 = this.localTx.m32;
        this.prjMatrix.m30 = this.localTx.m03;
        this.prjMatrix.m31 = this.localTx.m13;
        this.prjMatrix.m32 = this.localTx.m23;
        this.prjMatrix.m33 = this.localTx.m33;
        f7 = this.prjMatrix.m03 - this.prjMatrix.m00;
        f8 = this.prjMatrix.m13 - this.prjMatrix.m10;
        float f13 = this.prjMatrix.m23 - this.prjMatrix.m20;
        float f14 = this.prjMatrix.m33 - this.prjMatrix.m30;
        float f15 = (float)Math.sqrt(f7 * f7 + f8 * f8 + f13 * f13);
        float f16 = f15 > 1.0E-6f ? 1.0f / f15 : 1.0f;
        fArray[0] = f7 * f16;
        fArray[1] = f8 * f16;
        fArray[2] = f13 * f16;
        fArray[3] = f14 * f16;
        f7 = this.prjMatrix.m03 + this.prjMatrix.m00;
        f8 = this.prjMatrix.m13 + this.prjMatrix.m10;
        f13 = this.prjMatrix.m23 + this.prjMatrix.m20;
        f14 = this.prjMatrix.m33 + this.prjMatrix.m30;
        f15 = (float)Math.sqrt(f7 * f7 + f8 * f8 + f13 * f13);
        f16 = f15 > 1.0E-6f ? 1.0f / f15 : 1.0f;
        fArray[4] = f7 * f16;
        fArray[5] = f8 * f16;
        fArray[6] = f13 * f16;
        fArray[7] = f14 * f16;
        f7 = this.prjMatrix.m03 + this.prjMatrix.m01;
        f8 = this.prjMatrix.m13 + this.prjMatrix.m11;
        f13 = this.prjMatrix.m23 + this.prjMatrix.m21;
        f14 = this.prjMatrix.m33 + this.prjMatrix.m31;
        f15 = (float)Math.sqrt(f7 * f7 + f8 * f8 + f13 * f13);
        f16 = f15 > 1.0E-6f ? 1.0f / f15 : 1.0f;
        fArray[8] = f7 * f16;
        fArray[9] = f8 * f16;
        fArray[10] = f13 * f16;
        fArray[11] = f14 * f16;
        f7 = this.prjMatrix.m03 - this.prjMatrix.m01;
        f8 = this.prjMatrix.m13 - this.prjMatrix.m11;
        f13 = this.prjMatrix.m23 - this.prjMatrix.m21;
        f14 = this.prjMatrix.m33 - this.prjMatrix.m31;
        f15 = (float)Math.sqrt(f7 * f7 + f8 * f8 + f13 * f13);
        f16 = f15 > 1.0E-6f ? 1.0f / f15 : 1.0f;
        fArray[12] = f7 * f16;
        fArray[13] = f8 * f16;
        fArray[14] = f13 * f16;
        fArray[15] = f14 * f16;
        f7 = this.prjMatrix.m03 - this.prjMatrix.m02;
        f8 = this.prjMatrix.m13 - this.prjMatrix.m12;
        f13 = this.prjMatrix.m23 - this.prjMatrix.m22;
        f14 = this.prjMatrix.m33 - this.prjMatrix.m32;
        f15 = (float)Math.sqrt(f7 * f7 + f8 * f8 + f13 * f13);
        f16 = f15 > 1.0E-6f ? 1.0f / f15 : 1.0f;
        fArray[16] = f7 * f16;
        fArray[17] = f8 * f16;
        fArray[18] = f13 * f16;
        fArray[19] = f14 * f16;
        f7 = this.prjMatrix.m03 + this.prjMatrix.m02;
        f8 = this.prjMatrix.m13 + this.prjMatrix.m12;
        f13 = this.prjMatrix.m23 + this.prjMatrix.m22;
        f14 = this.prjMatrix.m33 + this.prjMatrix.m32;
        f15 = (float)Math.sqrt(f7 * f7 + f8 * f8 + f13 * f13);
        f16 = f15 > 1.0E-6f ? 1.0f / f15 : 1.0f;
        fArray[20] = f7 * f16;
        fArray[21] = f8 * f16;
        fArray[22] = f13 * f16;
        fArray[23] = f14 * f16;
    }
}

