/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.input;

import java.util.ArrayList;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphPath;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.geom.GeometryData;
import org.j3d.renderer.aviatrix3d.util.AVIntersectionUtils;
import org.j3d.ui.navigation.HeightDataSource;
import org.j3d.util.MatrixUtils;
import org.j3d.util.UserSupplementData;
import org.web3d.vrml.renderer.ogl.input.CollisionListener;
import org.web3d.vrml.renderer.ogl.nodes.OGLTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLViewpointNodeType;

public class NavigationProcessor
implements NodeUpdateListener,
OGLTransformNodeType {
    public static final int AVATAR_POINT = 1;
    public static final int AVATAR_CYLINDER = 2;
    public static final int AVATAR_SHOULDERS = 3;
    private static final float DEFAULT_AVATAR_HEIGHT = 1.8f;
    private static final float DEFAULT_AVATAR_SIZE = 0.25f;
    private static final float DEFAULT_STEP_HEIGHT = 0.4f;
    private static final float DEFAULT_ORBIT_TIME = 5.0f;
    private static final double ZEROEPS = 1.0E-6;
    private static final Vector3f Y_DOWN = new Vector3f(0.0f, -1.0f, 0.0f);
    private static final Vector3f Y_UP = new Vector3f(0.0f, 1.0f, 0.0f);
    private static final Vector3f COLLISION_DIRECTION = new Vector3f(0.0f, 0.0f, -1.0f);
    private AVIntersectionUtils terrainIntersect = new AVIntersectionUtils();
    private AVIntersectionUtils collideIntersect = new AVIntersectionUtils();
    private MatrixUtils matrixUtils = new MatrixUtils();
    private TransformGroup viewTg = new TransformGroup();
    private TransformGroup newViewTg;
    private OGLViewpointNodeType currentViewpoint;
    private OGLViewpointNodeType newViewpoint;
    private Matrix4f viewTx;
    private SceneGraphPath viewPath;
    private CollisionListener collisionListener;
    private int navigationState = 0;
    private boolean movementInProgress = false;
    private float speed;
    private float scaledSpeed;
    private Group terrain;
    private Group collidables;
    private PickRequest terrainPicker;
    private PickRequest collidePicker;
    private Vector3f downVector;
    private Vector3f collisionVector;
    private Vector3f movementDirection;
    private Vector3f lookDirection;
    private Vector3f lastLookDirection;
    private float avatarHeight;
    private float avatarSize;
    private float avatarStep;
    private float origAvatarHeight;
    private float origAvatarSize;
    private float origAvatarStep;
    private float worldScale;
    private float lastTerrainHeight;
    private Vector3f locationVector;
    private Point3f locationPoint;
    private Point3f locationEndPoint;
    private Point3f kneePoint;
    private Point3f wkPoint;
    private Vector3f diffVec;
    private Vector3f currentPosVec;
    private Point3f intersectionPoint;
    private Point3f centerOfRotation;
    private float orbitTime;
    private float lastAngle;
    private float rotationRadius;
    private Vector3f dragTranslationAmt;
    private Vector3f oneFrameTranslation;
    private Matrix4f oneFrameRotation;
    private Vector3f viewTranslation;
    private Matrix4f worldEyeTransform;
    private Matrix4f vwTransform;
    private float inputRotationY;
    private float inputRotationX;
    private boolean allowCollisions;
    private boolean allowTerrainFollowing;
    private float angle;
    private long startFrameDurationCalc;
    private long frameDuration;
    private SceneGraphPath collidedObject;
    private int avatarRep;
    private Matrix4f tmpMatrix;
    private Vector3f tmpVector;
    private Vector3f upVector;
    private Vector3f rightVector;
    private AxisAngle4f vrtRot;
    private AxisAngle4f hrzRot;
    private Matrix3f rotMat1;
    private Matrix3f rotMat2;

    public NavigationProcessor() {
        OGLUserData oGLUserData = new OGLUserData();
        this.viewTg.setUserData((Object)oGLUserData);
        oGLUserData.owner = this;
        this.viewTx = new Matrix4f();
        this.tmpMatrix = new Matrix4f();
        this.vwTransform = new Matrix4f();
        this.worldEyeTransform = new Matrix4f();
        this.downVector = new Vector3f();
        this.terrainPicker = new PickRequest();
        this.terrainPicker.pickType = 2;
        this.terrainPicker.pickGeometryType = 2;
        this.terrainPicker.pickSortType = 1;
        this.terrainPicker.generateVWorldMatrix = true;
        this.terrainPicker.foundPaths = new ArrayList();
        this.collidePicker = new PickRequest();
        this.collidePicker.pickType = 2;
        this.collidePicker.pickGeometryType = 3;
        this.collidePicker.pickSortType = 1;
        this.collidePicker.generateVWorldMatrix = true;
        this.collidePicker.foundPaths = new ArrayList();
        this.movementDirection = new Vector3f();
        this.lookDirection = new Vector3f();
        this.lastLookDirection = new Vector3f();
        this.lastLookDirection.x = 0.0f;
        this.lastLookDirection.y = 0.0f;
        this.lastLookDirection.z = 0.0f;
        this.centerOfRotation = new Point3f();
        this.collisionVector = new Vector3f();
        this.intersectionPoint = new Point3f();
        this.wkPoint = new Point3f();
        this.diffVec = new Vector3f();
        this.currentPosVec = new Vector3f();
        this.avatarRep = 1;
        this.locationVector = new Vector3f();
        this.locationPoint = new Point3f();
        this.locationEndPoint = new Point3f();
        this.kneePoint = new Point3f();
        this.dragTranslationAmt = new Vector3f();
        this.oneFrameTranslation = new Vector3f();
        this.oneFrameRotation = new Matrix4f();
        this.viewTranslation = new Vector3f();
        this.inputRotationY = 0.0f;
        this.inputRotationX = 0.0f;
        this.allowCollisions = false;
        this.allowTerrainFollowing = false;
        this.orbitTime = 5.0f;
        this.avatarHeight = 1.8f;
        this.avatarSize = 0.25f;
        this.avatarStep = 0.4f;
        this.origAvatarHeight = this.avatarHeight;
        this.origAvatarSize = this.avatarSize;
        this.origAvatarStep = this.avatarStep;
        this.worldScale = 1.0f;
        this.lastTerrainHeight = 0.0f;
        this.speed = 0.0f;
        this.centerOfRotation = new Point3f(0.0f, 0.0f, 0.0f);
        this.tmpVector = new Vector3f();
        this.upVector = new Vector3f();
        this.rightVector = new Vector3f();
        this.vrtRot = new AxisAngle4f();
        this.hrzRot = new AxisAngle4f();
        this.rotMat1 = new Matrix3f();
        this.rotMat2 = new Matrix3f();
    }

    public void setCenterOfRotation(float[] fArray, float[] fArray2) {
        this.setCenterOfRotation(fArray, fArray2, false);
    }

    public void setCenterOfRotation(float[] fArray, float[] fArray2, boolean bl) {
        this.centerOfRotation.x = fArray[0];
        this.centerOfRotation.y = fArray[1];
        this.centerOfRotation.z = fArray[2];
        if (this.navigationState == 5 || this.navigationState == 6 || this.navigationState == 10 || this.navigationState == 11) {
            if (fArray2 == null) {
                if (this.currentViewpoint != null) {
                    Matrix4f matrix4f = this.currentViewpoint.getViewTransform();
                    matrix4f.get(this.viewTranslation);
                    this.locationPoint.set((Tuple3f)this.viewTranslation);
                } else {
                    this.locationPoint.x = 0.0f;
                    this.locationPoint.y = 0.0f;
                    this.locationPoint.z = 10.0f;
                }
            } else {
                this.locationPoint.x = fArray2[0];
                this.locationPoint.y = fArray2[1];
                this.locationPoint.z = fArray2[2];
            }
            double d = this.locationPoint.x - this.centerOfRotation.x;
            double d2 = this.locationPoint.z - this.centerOfRotation.z;
            this.rotationRadius = (float)Math.sqrt(d * d + d2 * d2);
            this.lastAngle = (float)Math.atan2(d2, d);
            if (bl) {
                this.viewTg.getTransform(this.viewTx);
                this.upVector.x = this.viewTx.m01;
                this.upVector.y = this.viewTx.m11;
                this.upVector.z = this.viewTx.m21;
                this.upVector.normalize();
                this.matrixUtils.lookAt(this.locationPoint, this.centerOfRotation, this.upVector, this.viewTx);
            } else {
                this.matrixUtils.lookAt(this.locationPoint, this.centerOfRotation, Y_UP, this.viewTx);
            }
            this.matrixUtils.inverse(this.viewTx, this.viewTx);
            if (this.currentViewpoint != null) {
                this.currentViewpoint.setNavigationTransform(this.viewTx);
            }
            if (this.viewTg.isLive()) {
                this.viewTg.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.viewTg);
            }
        }
    }

    public void setViewInfo(OGLViewpointNodeType oGLViewpointNodeType, TransformGroup transformGroup, SceneGraphPath sceneGraphPath) throws IllegalArgumentException {
        this.viewPath = sceneGraphPath;
        if (this.newViewTg == null) {
            this.viewTg = transformGroup;
            this.currentViewpoint = oGLViewpointNodeType;
        }
        this.newViewTg = transformGroup;
        this.newViewpoint = oGLViewpointNodeType;
    }

    public void setWorldInfo(Group group, Group group2) {
        this.terrain = group;
        this.collidables = group2;
    }

    public void setAvatarInfo(float f, float f2, float f3) {
        this.avatarHeight = f * this.worldScale;
        this.avatarSize = f2 * this.worldScale;
        this.avatarStep = f3 * this.worldScale;
        this.origAvatarHeight = this.avatarHeight;
        this.origAvatarSize = this.avatarSize;
        this.origAvatarStep = this.avatarStep;
    }

    public void setNavigationSpeed(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Negative speed value");
        }
        this.speed = f;
    }

    public void setOrbitTime(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Orbit time <= 0");
        }
        this.orbitTime = f;
    }

    public void setNavigationState(int n) {
        this.navigationState = n;
    }

    public void setCollisionListener(CollisionListener collisionListener) {
        this.collisionListener = collisionListener;
    }

    public int getNavigationState() {
        return this.navigationState;
    }

    public void processNextFrame() {
        this.frameDuration = System.currentTimeMillis() - this.startFrameDurationCalc;
        if (this.frameDuration == 0L) {
            this.frameDuration = 1L;
        }
        this.processClockTick();
    }

    public void startMove() {
        if (this.movementInProgress || this.viewTg == null || this.navigationState == 0 || this.navigationState == 6) {
            return;
        }
        this.viewTg.getTransform(this.viewTx);
        this.viewTx.get(this.viewTranslation);
        this.inputRotationY = 0.0f;
        this.inputRotationX = 0.0f;
        this.oneFrameRotation.setIdentity();
        this.dragTranslationAmt.scale(0.0f);
        this.startFrameDurationCalc = System.currentTimeMillis();
        switch (this.navigationState) {
            case 4: {
                this.allowCollisions = this.collidables != null;
                this.allowTerrainFollowing = false;
                break;
            }
            case 3: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 2: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 1: {
                this.allowCollisions = this.collidables != null;
                this.allowTerrainFollowing = this.terrain != null;
                break;
            }
            case 5: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 10: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 11: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 12: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 0: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
            }
        }
        if (this.navigationState == 1 && this.allowTerrainFollowing) {
            this.setInitialTerrainHeight();
        }
        if (this.navigationState == 10) {
            double d = this.viewTranslation.x - this.centerOfRotation.x;
            double d2 = this.viewTranslation.z - this.centerOfRotation.z;
            this.rotationRadius = (float)Math.sqrt(d * d + d2 * d2);
            this.lastAngle = (float)Math.atan2(d2, d);
            this.locationPoint.set((Tuple3f)this.viewTranslation);
            this.matrixUtils.lookAt(this.locationPoint, this.centerOfRotation, Y_UP, this.viewTx);
            this.matrixUtils.inverse(this.viewTx, this.viewTx);
            if (this.currentViewpoint != null) {
                this.currentViewpoint.setNavigationTransform(this.viewTx);
            }
            if (this.viewTg.isLive()) {
                this.viewTg.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.viewTg);
            }
        }
    }

    public void stopMove() {
        this.movementInProgress = false;
        this.allowCollisions = false;
        this.allowTerrainFollowing = false;
        this.viewTx.setIdentity();
        this.inputRotationY = 0.0f;
        this.inputRotationX = 0.0f;
        this.oneFrameRotation.setIdentity();
        this.dragTranslationAmt.scale(0.0f);
        if (this.viewTg != null) {
            this.viewTg.getTransform(this.viewTx);
        }
    }

    public void move(float[] fArray, float f) {
        if (this.viewTg == null) {
            return;
        }
        if (this.speed == 0.0f) {
            f = 0.0f;
        }
        this.scaledSpeed = this.speed * f * this.worldScale;
        switch (this.navigationState) {
            case 4: {
                this.dragTranslationAmt.set(0.0f, 0.0f, fArray[2] * this.scaledSpeed);
                this.inputRotationY = fArray[0] * f;
                this.inputRotationX = fArray[1] * this.scaledSpeed;
                this.allowCollisions = this.collidables != null;
                this.allowTerrainFollowing = false;
                break;
            }
            case 3: {
                this.dragTranslationAmt.set(fArray[0] * this.scaledSpeed, fArray[1] * this.scaledSpeed, fArray[2] * this.scaledSpeed);
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 2: {
                this.inputRotationX = fArray[1] * f;
                this.inputRotationY = fArray[0] * f;
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 1: {
                this.dragTranslationAmt.set(0.0f, 0.0f, fArray[2] * this.scaledSpeed);
                this.inputRotationY = fArray[0] * f;
                this.allowCollisions = this.collidables != null;
                this.allowTerrainFollowing = this.terrain != null;
                break;
            }
            case 5: {
                this.dragTranslationAmt.set(0.0f, 0.0f, fArray[2]);
                this.inputRotationY = fArray[0] * f;
                this.inputRotationX = fArray[1] * f;
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 10: {
                this.dragTranslationAmt.set(0.0f, 0.0f, fArray[2] * this.scaledSpeed);
                this.inputRotationY = fArray[0] * f;
                this.inputRotationX = fArray[1] * f;
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 11: {
                this.dragTranslationAmt.set(0.0f, 0.0f, fArray[2] * this.scaledSpeed * 16.0f);
                this.inputRotationY = fArray[0] * f;
                this.inputRotationX = fArray[1] * f;
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 12: {
                this.dragTranslationAmt.set(fArray[0] * this.scaledSpeed * 16.0f, fArray[1] * this.scaledSpeed * 16.0f, 0.0f);
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 0: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
            }
        }
    }

    public void orient(float[] fArray) {
        if (this.viewTg == null) {
            return;
        }
        this.lookDirection.x = fArray[0];
        this.lookDirection.y = fArray[1];
        this.lookDirection.z = fArray[2];
        this.viewTg.getTransform(this.viewTx);
        this.viewTx.get(this.viewTranslation);
        this.inputRotationY = 0.0f;
        this.inputRotationX = 0.0f;
        this.oneFrameRotation.setIdentity();
        this.dragTranslationAmt.scale(0.0f);
        this.frameDuration = 0L;
        this.processClockTick();
    }

    public Matrix4f getTransform() {
        return this.viewTx;
    }

    public void updateNodeBoundsChanges(Object object) {
        if (object == this.viewTg) {
            this.viewTg.setTransform(this.viewTx);
        }
    }

    public void updateNodeDataChanges(Object object) {
    }

    public void getOrientation(AxisAngle4f axisAngle4f) {
        Quat4f quat4f = new Quat4f();
        if (this.viewPath != null) {
            this.getLocalToVworld();
            this.viewTg.getTransform(this.tmpMatrix);
            this.worldEyeTransform.mul(this.tmpMatrix);
            this.worldEyeTransform.get(quat4f);
            axisAngle4f.set(quat4f);
        } else {
            axisAngle4f.x = 0.0f;
            axisAngle4f.y = 1.0f;
            axisAngle4f.z = 0.0f;
            axisAngle4f.angle = 0.0f;
        }
    }

    public void getPosition(Vector3f vector3f) {
        if (this.newViewTg != null && this.newViewTg != this.viewTg) {
            this.viewTg = this.newViewTg;
            this.currentViewpoint = this.newViewpoint;
            this.viewTg.getTransform(this.viewTx);
            this.viewTx.get(this.viewTranslation);
            if (this.currentViewpoint != null) {
                this.currentViewpoint.setNavigationTransform(this.viewTx);
            }
            if (this.viewTg.isLive()) {
                this.viewTg.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.viewTg);
            }
        }
        if (this.viewPath != null) {
            this.getLocalToVworld();
            this.viewTg.getTransform(this.tmpMatrix);
            this.worldEyeTransform.mul(this.tmpMatrix);
            this.worldEyeTransform.get(this.currentPosVec);
        } else {
            this.currentPosVec.x = 0.0f;
            this.currentPosVec.y = 0.0f;
            this.currentPosVec.z = 10.0f;
        }
        vector3f.x = this.currentPosVec.x;
        vector3f.y = this.currentPosVec.y;
        vector3f.z = this.currentPosVec.z;
    }

    public void setWorldScale(float f) {
        this.worldScale = f;
        this.avatarHeight = this.origAvatarHeight * this.worldScale;
        this.avatarSize = this.origAvatarSize * this.worldScale;
        this.avatarStep = this.origAvatarStep * this.worldScale;
    }

    public void clear() {
        this.collidedObject = null;
        ArrayList arrayList = (ArrayList)this.terrainPicker.foundPaths;
        if (arrayList != null) {
            arrayList.clear();
        }
        if ((arrayList = (ArrayList)this.collidePicker.foundPaths) != null) {
            arrayList.clear();
        }
    }

    private void processClockTick() {
        if (this.navigationState == 5) {
            this.processExamineMotion();
            this.processExamineRadialMotion();
        } else if (this.navigationState == 10) {
            this.processInspectMotion();
        } else if (this.navigationState == 11) {
            this.processTrackExamineMotion();
            this.processTrackExamineRadialMotion();
        } else if (this.navigationState == 12) {
            this.processTrackPanMotion();
        } else {
            if (this.navigationState == 6) {
                return;
            }
            this.processDefaultMotion();
        }
    }

    private void processExamineRadialMotion() {
        if (this.dragTranslationAmt.z != 0.0f) {
            this.viewTg.getTransform(this.viewTx);
            this.viewTx.get(this.locationVector);
            float f = this.locationVector.x - this.centerOfRotation.x;
            float f2 = this.locationVector.y - this.centerOfRotation.y;
            float f3 = this.locationVector.z - this.centerOfRotation.z;
            double d = this.dragTranslationAmt.z / 10.0f;
            this.tmpVector.set(f, f2, f3);
            this.tmpVector.normalize();
            this.rotationRadius = (float)(Math.sqrt(f * f + f2 * f2 + f3 * f3) * (1.0 + d));
            this.locationVector.x = this.centerOfRotation.x + this.rotationRadius * this.tmpVector.x;
            this.locationVector.y = this.centerOfRotation.y + this.rotationRadius * this.tmpVector.y;
            this.locationVector.z = this.centerOfRotation.z + this.rotationRadius * this.tmpVector.z;
            this.viewTx.setTranslation(this.locationVector);
            if (this.currentViewpoint != null) {
                this.currentViewpoint.setNavigationTransform(this.viewTx);
            }
            if (this.viewTg.isLive()) {
                this.viewTg.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.viewTg);
            }
            this.dragTranslationAmt.z = 0.0f;
        }
        this.startFrameDurationCalc = System.currentTimeMillis();
    }

    private void processTrackExamineRadialMotion() {
        if (this.dragTranslationAmt.z != 0.0f) {
            this.viewTg.getTransform(this.viewTx);
            this.viewTx.get(this.locationVector);
            float f = this.locationVector.x - this.centerOfRotation.x;
            float f2 = this.locationVector.y - this.centerOfRotation.y;
            float f3 = this.locationVector.z - this.centerOfRotation.z;
            this.tmpVector.set(f, f2, f3);
            this.tmpVector.normalize();
            this.rotationRadius = (float)(Math.sqrt(f * f + f2 * f2 + f3 * f3) + (double)this.dragTranslationAmt.z);
            this.locationVector.x = this.centerOfRotation.x + this.rotationRadius * this.tmpVector.x;
            this.locationVector.y = this.centerOfRotation.y + this.rotationRadius * this.tmpVector.y;
            this.locationVector.z = this.centerOfRotation.z + this.rotationRadius * this.tmpVector.z;
            this.viewTx.setTranslation(this.locationVector);
            if (this.currentViewpoint != null) {
                this.currentViewpoint.setNavigationTransform(this.viewTx);
            }
            if (this.viewTg.isLive()) {
                this.viewTg.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.viewTg);
            }
            this.dragTranslationAmt.z = 0.0f;
        }
    }

    private void processTrackExamineMotion() {
        if (this.inputRotationY != 0.0f || this.inputRotationX != 0.0f) {
            double d = (double)this.inputRotationY * Math.PI;
            double d2 = (double)this.inputRotationX * Math.PI;
            this.viewTg.getTransform(this.viewTx);
            this.viewTx.get(this.locationVector);
            this.upVector.x = this.viewTx.m01;
            this.upVector.y = this.viewTx.m11;
            this.upVector.z = this.viewTx.m21;
            this.upVector.normalize();
            this.vrtRot.set(this.upVector, (float)(-d));
            this.rotMat1.set(this.vrtRot);
            this.rightVector.x = this.viewTx.m00;
            this.rightVector.y = this.viewTx.m10;
            this.rightVector.z = this.viewTx.m20;
            this.rightVector.normalize();
            this.hrzRot.set(this.rightVector, (float)d2);
            this.rotMat2.set(this.hrzRot);
            this.rotMat1.mul(this.rotMat2);
            this.locationVector.x -= this.centerOfRotation.x;
            this.locationVector.y -= this.centerOfRotation.y;
            this.locationVector.z -= this.centerOfRotation.z;
            this.rotMat1.transform((Tuple3f)this.locationVector);
            this.locationPoint.x = this.locationVector.x + this.centerOfRotation.x;
            this.locationPoint.y = this.locationVector.y + this.centerOfRotation.y;
            this.locationPoint.z = this.locationVector.z + this.centerOfRotation.z;
            this.matrixUtils.lookAt(this.locationPoint, this.centerOfRotation, this.upVector, this.viewTx);
            this.matrixUtils.inverse(this.viewTx, this.viewTx);
            if (this.currentViewpoint != null) {
                this.currentViewpoint.setNavigationTransform(this.viewTx);
            }
            if (this.viewTg.isLive()) {
                this.viewTg.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.viewTg);
            }
            this.inputRotationX = 0.0f;
            this.inputRotationY = 0.0f;
        }
    }

    private void processTrackPanMotion() {
        if (this.dragTranslationAmt.x != 0.0f || this.dragTranslationAmt.y != 0.0f) {
            this.viewTg.getTransform(this.viewTx);
            this.viewTx.get(this.locationVector);
            this.upVector.x = this.viewTx.m01;
            this.upVector.y = this.viewTx.m11;
            this.upVector.z = this.viewTx.m21;
            this.upVector.normalize();
            this.tmpVector.set((Tuple3f)this.upVector);
            this.tmpVector.scale(this.dragTranslationAmt.y);
            this.locationVector.add((Tuple3f)this.tmpVector);
            this.rightVector.x = this.viewTx.m00;
            this.rightVector.y = this.viewTx.m10;
            this.rightVector.z = this.viewTx.m20;
            this.rightVector.normalize();
            this.rightVector.scale(this.dragTranslationAmt.x);
            this.locationVector.add((Tuple3f)this.rightVector);
            this.centerOfRotation.add((Tuple3f)this.tmpVector);
            this.centerOfRotation.add((Tuple3f)this.rightVector);
            this.locationPoint.set((Tuple3f)this.locationVector);
            this.matrixUtils.lookAt(this.locationPoint, this.centerOfRotation, this.upVector, this.viewTx);
            this.matrixUtils.inverse(this.viewTx, this.viewTx);
            if (this.currentViewpoint != null) {
                this.currentViewpoint.setNavigationTransform(this.viewTx);
            }
            if (this.viewTg.isLive()) {
                this.viewTg.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.viewTg);
            }
            this.dragTranslationAmt.set(0.0f, 0.0f, 0.0f);
        }
    }

    private void processExamineMotion() {
        if (this.inputRotationY != 0.0f || this.inputRotationX != 0.0f) {
            double d = (double)this.inputRotationY * Math.PI * 2.0 * (double)this.frameDuration / (double)(this.orbitTime * 1000.0f);
            double d2 = (double)this.inputRotationX * Math.PI * 2.0 * (double)this.frameDuration / (double)(this.orbitTime * 1000.0f);
            this.viewTg.getTransform(this.viewTx);
            this.viewTx.get(this.locationVector);
            this.upVector.x = this.viewTx.m01;
            this.upVector.y = this.viewTx.m11;
            this.upVector.z = this.viewTx.m21;
            this.upVector.normalize();
            this.vrtRot.set(this.upVector, (float)(-d));
            this.rotMat1.set(this.vrtRot);
            this.rightVector.x = this.viewTx.m00;
            this.rightVector.y = this.viewTx.m10;
            this.rightVector.z = this.viewTx.m20;
            this.rightVector.normalize();
            this.hrzRot.set(this.rightVector, (float)d2);
            this.rotMat2.set(this.hrzRot);
            this.rotMat1.mul(this.rotMat2);
            this.locationVector.x -= this.centerOfRotation.x;
            this.locationVector.y -= this.centerOfRotation.y;
            this.locationVector.z -= this.centerOfRotation.z;
            this.rotMat1.transform((Tuple3f)this.locationVector);
            this.locationPoint.x = this.locationVector.x + this.centerOfRotation.x;
            this.locationPoint.y = this.locationVector.y + this.centerOfRotation.y;
            this.locationPoint.z = this.locationVector.z + this.centerOfRotation.z;
            this.matrixUtils.lookAt(this.locationPoint, this.centerOfRotation, this.upVector, this.viewTx);
            this.matrixUtils.inverse(this.viewTx, this.viewTx);
            if (this.currentViewpoint != null) {
                this.currentViewpoint.setNavigationTransform(this.viewTx);
            }
            if (this.viewTg.isLive()) {
                this.viewTg.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.viewTg);
            }
        }
        this.startFrameDurationCalc = System.currentTimeMillis();
    }

    private void processInspectMotion() {
        double d;
        float f;
        float f2;
        double d2;
        boolean bl = false;
        double d3 = this.lastAngle;
        this.viewTg.getTransform(this.viewTx);
        this.viewTx.get(this.locationVector);
        if (this.dragTranslationAmt.z != 0.0f) {
            d2 = 5.0E-4 * (double)this.frameDuration;
            f2 = this.locationVector.x - this.centerOfRotation.x;
            f = this.locationVector.z - this.centerOfRotation.z;
            d = this.dragTranslationAmt.z;
            this.rotationRadius = (float)(Math.sqrt(f2 * f2 + f * f) + d);
            bl = true;
        }
        if (this.inputRotationY != 0.0f) {
            d2 = this.inputRotationY;
            d = d2 * Math.PI * 2.0 * (double)this.frameDuration / (double)(this.orbitTime * 1000.0f);
            if ((d3 += d) > Math.PI * 2) {
                d3 -= Math.PI * 2;
            }
            this.lastAngle = (float)d3;
            bl = true;
        }
        if (bl) {
            f2 = (float)((double)this.rotationRadius * Math.cos(d3));
            f = (float)((double)this.rotationRadius * Math.sin(d3));
            this.locationPoint.x = this.centerOfRotation.x + f2;
            this.locationPoint.y = this.locationVector.y;
            this.locationPoint.z = this.centerOfRotation.z + f;
            this.matrixUtils.lookAt(this.locationPoint, this.centerOfRotation, Y_UP, this.viewTx);
            this.matrixUtils.inverse(this.viewTx, this.viewTx);
            if (this.currentViewpoint != null) {
                this.currentViewpoint.setNavigationTransform(this.viewTx);
            }
            if (this.viewTg.isLive()) {
                this.viewTg.boundsChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeBoundsChanges(this.viewTg);
            }
        }
        this.startFrameDurationCalc = System.currentTimeMillis();
    }

    private void processDefaultMotion() {
        float f = 0.005f * (float)this.frameDuration;
        this.viewTg.getTransform(this.viewTx);
        if (this.lastLookDirection.x != 0.0f || this.lastLookDirection.y != 0.0f || this.lastLookDirection.z != 0.0f) {
            this.matrixUtils.setEuler(this.lastLookDirection, this.oneFrameRotation);
            this.viewTx.mul(this.oneFrameRotation);
        }
        this.matrixUtils.rotateX(this.inputRotationX * f, this.oneFrameRotation);
        this.viewTx.mul(this.oneFrameRotation);
        this.matrixUtils.rotateY(this.inputRotationY * f, this.oneFrameRotation);
        this.viewTx.mul(this.oneFrameRotation);
        this.oneFrameTranslation.set((Tuple3f)this.dragTranslationAmt);
        this.oneFrameTranslation.scale(f);
        this.viewTx.transform(this.oneFrameTranslation);
        boolean bl = false;
        if (this.allowCollisions) {
            boolean bl2 = bl = !this.checkCollisions();
        }
        if (this.allowTerrainFollowing && !bl) {
            boolean bl3 = bl = !this.checkTerrainFollowing();
        }
        if (bl) {
            if (this.collisionListener != null) {
                this.collisionListener.avatarCollision(this.collidedObject);
            }
            this.collidedObject = null;
            this.oneFrameTranslation.z = 0.0f;
            this.oneFrameTranslation.x = 0.0f;
            this.oneFrameTranslation.y = 0.0f;
        }
        this.viewTranslation.add((Tuple3f)this.oneFrameTranslation);
        this.viewTx.setTranslation(this.viewTranslation);
        if (this.lookDirection.x != 0.0f || this.lookDirection.y != 0.0f || this.lookDirection.z != 0.0f) {
            this.matrixUtils.setEuler(this.lookDirection, this.oneFrameRotation);
            this.lastLookDirection.x = -this.lookDirection.x;
            this.lastLookDirection.y = -this.lookDirection.y;
            this.lastLookDirection.z = -this.lookDirection.z;
            this.viewTx.mul(this.oneFrameRotation);
        }
        if (this.currentViewpoint != null) {
            this.currentViewpoint.setNavigationTransform(this.viewTx);
        }
        if (this.viewTg.isLive()) {
            this.viewTg.boundsChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeBoundsChanges(this.viewTg);
        }
        this.startFrameDurationCalc = System.currentTimeMillis();
    }

    private boolean checkTerrainFollowing() {
        boolean bl = true;
        if (!this.allowCollisions) {
            this.getLocalToVworld();
            this.worldEyeTransform.mul(this.viewTx);
        }
        this.worldEyeTransform.get(this.locationVector);
        this.worldEyeTransform.transform(Y_DOWN, this.downVector);
        this.locationPoint.add((Tuple3f)this.locationVector, (Tuple3f)this.oneFrameTranslation);
        this.terrainPicker.origin[0] = this.locationVector.x + this.oneFrameTranslation.x;
        this.terrainPicker.origin[1] = this.locationVector.y + this.oneFrameTranslation.y;
        this.terrainPicker.origin[2] = this.locationVector.z + this.oneFrameTranslation.z;
        this.terrainPicker.destination[0] = this.downVector.x;
        this.terrainPicker.destination[1] = this.downVector.y;
        this.terrainPicker.destination[2] = this.downVector.z;
        ArrayList arrayList = (ArrayList)this.terrainPicker.foundPaths;
        this.terrain.pickSingle(this.terrainPicker);
        if (this.terrainPicker.pickCount == 0) {
            return bl;
        }
        double d = Double.POSITIVE_INFINITY;
        boolean bl2 = false;
        for (int i = 0; i < this.terrainPicker.pickCount; ++i) {
            VertexGeometry vertexGeometry;
            boolean bl3;
            UserSupplementData userSupplementData;
            SceneGraphPath sceneGraphPath = (SceneGraphPath)arrayList.get(i);
            Node node = sceneGraphPath.getTerminalNode();
            Object object = node.getUserData();
            if (object instanceof UserSupplementData && !((UserSupplementData)object).isTerrain) continue;
            int n = sceneGraphPath.getNodeCount();
            Node[] nodeArray = sceneGraphPath.getNodes();
            boolean bl4 = false;
            for (int j = 0; j < n && !bl4; ++j) {
                object = nodeArray[j].getUserData();
                if (!(object instanceof UserSupplementData)) continue;
                bl4 = !((UserSupplementData)object).isTerrain;
            }
            if (bl4) continue;
            sceneGraphPath.getTransform(this.vwTransform);
            this.vwTransform.get(this.locationVector);
            Shape3D shape3D = (Shape3D)sceneGraphPath.getTerminalNode();
            object = shape3D.getUserData();
            HeightDataSource heightDataSource = null;
            GeometryData geometryData = null;
            if (object instanceof UserSupplementData) {
                userSupplementData = (UserSupplementData)object;
                if (userSupplementData.geometryData instanceof HeightDataSource) {
                    heightDataSource = (HeightDataSource)userSupplementData.geometryData;
                } else if (userSupplementData.geometryData instanceof GeometryData) {
                    geometryData = (GeometryData)userSupplementData.geometryData;
                }
            } else if (object instanceof HeightDataSource) {
                heightDataSource = (HeightDataSource)object;
            } else if (object instanceof GeometryData) {
                geometryData = (GeometryData)object;
            }
            if (heightDataSource != null) {
                this.intersectionPoint.x = this.locationVector.x;
                this.intersectionPoint.y = this.locationVector.y;
                this.intersectionPoint.z = heightDataSource.getHeight(this.locationVector.x, this.locationVector.y);
                continue;
            }
            if (geometryData != null) {
                if (!this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryData, this.vwTransform, this.wkPoint, false)) continue;
                this.diffVec.sub((Tuple3f)this.locationPoint, (Tuple3f)this.wkPoint);
                if (d != -1.0 && !((double)this.diffVec.lengthSquared() < d)) continue;
                d = this.diffVec.lengthSquared();
                this.intersectionPoint.set((Tuple3f)this.wkPoint);
                this.collidedObject = sceneGraphPath;
                continue;
            }
            userSupplementData = shape3D.getGeometry();
            if (!(userSupplementData instanceof VertexGeometry) || !(bl3 = this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, vertexGeometry = (VertexGeometry)userSupplementData, this.vwTransform, this.wkPoint, false))) continue;
            this.diffVec.sub((Tuple3f)this.locationPoint, (Tuple3f)this.wkPoint);
            float f = this.diffVec.lengthSquared();
            if (!((double)f < d)) continue;
            d = f;
            this.intersectionPoint.set((Tuple3f)this.wkPoint);
            this.collidedObject = sceneGraphPath;
            bl2 = true;
        }
        if (!bl2) {
            return true;
        }
        float f = (this.intersectionPoint.y - this.lastTerrainHeight) * this.worldScale;
        float f2 = this.locationPoint.y - this.intersectionPoint.y;
        if (!this.floatEq(f2 - this.avatarHeight, 0.0)) {
            if (this.floatEq(f, 0.0)) {
                this.oneFrameTranslation.y = this.avatarHeight - f2;
                bl = true;
            } else if (f < this.avatarStep) {
                this.oneFrameTranslation.y = f;
                bl = true;
            } else {
                bl = false;
                return bl;
            }
        }
        this.lastTerrainHeight = this.intersectionPoint.y;
        return bl;
    }

    private boolean checkCollisions() {
        boolean bl = true;
        this.getLocalToVworld();
        this.worldEyeTransform.mul(this.viewTx);
        this.worldEyeTransform.get(this.locationVector);
        this.locationPoint.set((Tuple3f)this.locationVector);
        this.collisionVector.x = this.oneFrameTranslation.x;
        this.collisionVector.y = this.oneFrameTranslation.y;
        this.collisionVector.z = this.oneFrameTranslation.z;
        if (this.collisionVector.lengthSquared() > 0.0f) {
            this.collisionVector.normalize();
        }
        this.collisionVector.scale(this.avatarSize);
        this.locationEndPoint.add((Tuple3f)this.locationVector, (Tuple3f)this.collisionVector);
        this.locationEndPoint.add((Tuple3f)this.oneFrameTranslation);
        boolean bl2 = false;
        switch (this.avatarRep) {
            case 1: {
                this.collidePicker.pickGeometryType = 3;
                this.collidePicker.origin[0] = this.locationEndPoint.x;
                this.collidePicker.origin[1] = this.locationEndPoint.y;
                this.collidePicker.origin[2] = this.locationEndPoint.z;
                this.collidePicker.destination[0] = this.locationPoint.x;
                this.collidePicker.destination[1] = this.locationPoint.y;
                this.collidePicker.destination[2] = this.locationPoint.z;
                this.collidables.pickSingle(this.collidePicker);
                break;
            }
            case 2: {
                this.collidePicker.pickGeometryType = 5;
                this.kneePoint.x = this.locationEndPoint.x;
                this.kneePoint.y = this.locationEndPoint.y - this.avatarHeight + this.avatarStep;
                this.kneePoint.z = this.locationEndPoint.z;
                this.collidePicker.origin[0] = this.locationEndPoint.x;
                this.collidePicker.origin[1] = this.locationEndPoint.y;
                this.collidePicker.origin[2] = this.locationEndPoint.z;
                this.collidePicker.destination[0] = this.kneePoint.x;
                this.collidePicker.destination[1] = this.kneePoint.y;
                this.collidePicker.destination[2] = this.kneePoint.z;
                this.collidePicker.additionalData = this.avatarSize;
                this.collidables.pickSingle(this.collidePicker);
                break;
            }
            case 3: {
                this.collidePicker.pickGeometryType = 5;
                float f = this.locationPoint.x;
                this.locationPoint.x -= this.avatarSize;
                this.kneePoint.x = f + this.avatarSize;
                this.kneePoint.y = this.locationEndPoint.y - this.avatarSize / 2.0f;
                this.kneePoint.z = this.locationEndPoint.z;
                this.collidePicker.origin[0] = this.locationEndPoint.x;
                this.collidePicker.origin[1] = this.locationEndPoint.y;
                this.collidePicker.origin[2] = this.locationEndPoint.z;
                this.collidePicker.destination[0] = this.kneePoint.x;
                this.collidePicker.destination[1] = this.kneePoint.y;
                this.collidePicker.destination[2] = this.kneePoint.z;
                this.collidePicker.additionalData = this.avatarSize;
                this.collidables.pickSingle(this.collidePicker);
            }
        }
        if (this.collidePicker.pickCount == 0) {
            return bl;
        }
        boolean bl3 = false;
        float f = this.collisionVector.length();
        ArrayList arrayList = (ArrayList)this.collidePicker.foundPaths;
        for (int i = 0; i < this.collidePicker.pickCount && !bl3; ++i) {
            SceneGraphPath sceneGraphPath = (SceneGraphPath)arrayList.get(i);
            Node node = sceneGraphPath.getTerminalNode();
            Object object = node.getUserData();
            if (object instanceof UserSupplementData && !((UserSupplementData)object).collidable) continue;
            int n = sceneGraphPath.getNodeCount();
            Node[] nodeArray = sceneGraphPath.getNodes();
            boolean bl4 = false;
            for (int j = 0; j < n && !bl4; ++j) {
                object = nodeArray[j].getUserData();
                if (!(object instanceof UserSupplementData)) continue;
                bl4 = !((UserSupplementData)object).collidable;
            }
            if (bl4) continue;
            sceneGraphPath.getTransform(this.vwTransform);
            Shape3D shape3D = (Shape3D)sceneGraphPath.getTerminalNode();
            Geometry geometry = shape3D.getGeometry();
            if (!(geometry instanceof VertexGeometry)) continue;
            VertexGeometry vertexGeometry = (VertexGeometry)geometry;
            GeometryData geometryData = null;
            object = vertexGeometry.getUserData();
            geometryData = null;
            if (object instanceof UserSupplementData) {
                UserSupplementData userSupplementData = (UserSupplementData)object;
                if (userSupplementData.geometryData instanceof GeometryData) {
                    geometryData = (GeometryData)userSupplementData.geometryData;
                }
            } else if (object instanceof GeometryData) {
                geometryData = (GeometryData)object;
            }
            if (geometryData != null) {
                bl3 = this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.collisionVector, f, geometryData, this.vwTransform, this.wkPoint, true);
                if (!bl3 && this.avatarRep == 2 && (bl3 = this.terrainIntersect.rayUnknownGeometry(this.kneePoint, this.collisionVector, f, geometryData, this.vwTransform, this.wkPoint, true))) {
                    System.out.println("knee collided");
                }
                if (!bl3 && this.avatarRep == 3 && (bl3 = this.terrainIntersect.rayUnknownGeometry(this.kneePoint, this.collisionVector, f, geometryData, this.vwTransform, this.wkPoint, true))) {
                    System.out.println("right shoulder collided");
                }
            } else {
                bl3 = this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.collisionVector, f, vertexGeometry, this.vwTransform, this.wkPoint, true);
                if (!bl3 && this.avatarRep == 2 && (bl3 = this.terrainIntersect.rayUnknownGeometry(this.kneePoint, this.collisionVector, f, vertexGeometry, this.vwTransform, this.wkPoint, true))) {
                    System.out.println("knee collided");
                }
                if (!bl3 && this.avatarRep == 3 && (bl3 = this.terrainIntersect.rayUnknownGeometry(this.kneePoint, this.collisionVector, f, vertexGeometry, this.vwTransform, this.wkPoint, true))) {
                    System.out.println("right shoulder collided");
                }
            }
            boolean bl5 = bl = !bl3;
            if (!bl3) continue;
            this.collidedObject = sceneGraphPath;
        }
        arrayList.clear();
        return bl;
    }

    private void setInitialTerrainHeight() {
        if (this.terrain == null) {
            return;
        }
        this.getLocalToVworld();
        this.worldEyeTransform.mul(this.viewTx);
        this.worldEyeTransform.get(this.locationVector);
        this.worldEyeTransform.transform(Y_DOWN, this.downVector);
        this.terrainPicker.origin[0] = this.locationVector.x;
        this.terrainPicker.origin[1] = this.locationVector.y;
        this.terrainPicker.origin[2] = this.locationVector.z;
        this.terrainPicker.destination[0] = this.downVector.x;
        this.terrainPicker.destination[1] = this.downVector.y;
        this.terrainPicker.destination[2] = this.downVector.z;
        this.locationPoint.set((Tuple3f)this.locationVector);
        this.terrain.pickSingle(this.terrainPicker);
        if (this.terrainPicker.pickCount == 0) {
            return;
        }
        double d = Double.POSITIVE_INFINITY;
        boolean bl = false;
        ArrayList arrayList = (ArrayList)this.terrainPicker.foundPaths;
        for (int i = 0; i < this.terrainPicker.pickCount; ++i) {
            VertexGeometry vertexGeometry;
            boolean bl2;
            UserSupplementData userSupplementData;
            SceneGraphPath sceneGraphPath = (SceneGraphPath)arrayList.get(i);
            Node node = sceneGraphPath.getTerminalNode();
            Object object = node.getUserData();
            if (object instanceof UserSupplementData && !((UserSupplementData)object).isTerrain) continue;
            int n = sceneGraphPath.getNodeCount();
            Node[] nodeArray = sceneGraphPath.getNodes();
            boolean bl3 = false;
            for (int j = 0; j < n && !bl3; ++j) {
                object = nodeArray[j].getUserData();
                if (!(object instanceof UserSupplementData)) continue;
                bl3 = !((UserSupplementData)object).isTerrain;
            }
            if (bl3) continue;
            sceneGraphPath.getTransform(this.vwTransform);
            this.vwTransform.get(this.locationVector);
            Shape3D shape3D = (Shape3D)sceneGraphPath.getTerminalNode();
            object = shape3D.getUserData();
            HeightDataSource heightDataSource = null;
            GeometryData geometryData = null;
            if (object instanceof UserSupplementData) {
                userSupplementData = (UserSupplementData)object;
                if (userSupplementData.geometryData instanceof HeightDataSource) {
                    heightDataSource = (HeightDataSource)userSupplementData.geometryData;
                } else if (userSupplementData.geometryData instanceof GeometryData) {
                    geometryData = (GeometryData)userSupplementData.geometryData;
                }
            } else if (object instanceof HeightDataSource) {
                heightDataSource = (HeightDataSource)object;
            } else if (object instanceof GeometryData) {
                geometryData = (GeometryData)object;
            }
            if (heightDataSource != null) {
                this.intersectionPoint.x = this.locationVector.x;
                this.intersectionPoint.y = this.locationVector.y;
                this.intersectionPoint.z = heightDataSource.getHeight(this.locationVector.x, this.locationVector.y);
                continue;
            }
            userSupplementData = shape3D.getGeometry();
            if (!(userSupplementData instanceof VertexGeometry) || !(bl2 = this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, vertexGeometry = (VertexGeometry)userSupplementData, this.vwTransform, this.wkPoint, false))) continue;
            bl = true;
            this.diffVec.sub((Tuple3f)this.locationPoint, (Tuple3f)this.wkPoint);
            float f = this.diffVec.lengthSquared();
            if (!((double)f < d)) continue;
            d = f;
            this.intersectionPoint.set((Tuple3f)this.wkPoint);
        }
        if (bl) {
            this.lastTerrainHeight = this.intersectionPoint.y;
        }
    }

    private boolean floatEq(double d, double d2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            d3 *= -1.0;
        }
        return d3 < 1.0E-6;
    }

    private void getLocalToVworld() {
        int n = this.viewPath.getNodeCount();
        Node[] nodeArray = this.viewPath.getNodes();
        this.worldEyeTransform.setIdentity();
        for (int i = 0; i < n - 1; ++i) {
            if (!(nodeArray[i] instanceof TransformGroup)) continue;
            TransformGroup transformGroup = (TransformGroup)nodeArray[i];
            transformGroup.getTransform(this.vwTransform);
            this.worldEyeTransform.mul(this.vwTransform);
        }
    }
}

