/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.input;

import java.util.ArrayList;
import java.util.HashMap;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.SceneGraphPath;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.geom.GeometryData;
import org.j3d.renderer.aviatrix3d.geom.Text2D;
import org.j3d.renderer.aviatrix3d.util.AVIntersectionUtils;
import org.j3d.util.MatrixUtils;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.util.HashSet;
import org.web3d.util.ObjectArray;
import org.web3d.vrml.nodes.NavigationInfoChangeListener;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLDragSensorNodeType;
import org.web3d.vrml.nodes.VRMLLinkNodeType;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLPointingDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLTouchSensorNodeType;
import org.web3d.vrml.renderer.ogl.input.CollisionListener;
import org.web3d.vrml.renderer.ogl.input.NavigationProcessor;
import org.web3d.vrml.renderer.ogl.input.OGLUserInputHandler;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLViewpointNodeType;
import org.xj3d.device.TrackerState;

public class DefaultUserInputHandler
implements OGLUserInputHandler,
NavigationInfoChangeListener {
    private static final double PICK_SIZE = 0.1;
    private static final int NO_STATE = 0;
    private static final int NAVIGATION_STATE = 1;
    private static final int ANCHOR_STATE = 2;
    private static final int TOUCH_STATE = 3;
    private static final String DEFAULT_NAV_STRING = "EXAMINE";
    private static final int DEFAULT_NAV_INT = 5;
    private static final HashMap navigationTypes = new HashMap();
    private int currentState = 0;
    private int[] trackerState;
    private boolean[] lastButtonState;
    private boolean anyAllowed;
    private NavigationProcessor navHandler;
    private VRMLNavigationInfoNodeType currentNavInfo;
    private Vector3f mousePickDirection;
    private Point3f mouseEyePosition;
    private Point3f mousePosition;
    private Point3f mouseSensorPosition;
    private Matrix4f viewTransform;
    private SceneGraphPath viewPath;
    private Group pickableWorld;
    private VRMLClock clock;
    private boolean doPicking = false;
    private AVIntersectionUtils iutils;
    private VRMLLinkNodeType currentLink;
    private SceneGraphPath currentPickedPath;
    private int currentPickedNodeIndex;
    private boolean hasTouchSensor;
    private boolean hasDragSensor;
    private ArrayList navigationStateListeners;
    private ArrayList sensorStatusListeners;
    private Vector3f currentPosition;
    private Point3f wkPoint;
    private Point3f pointTrans;
    private Vector3f normalTrans;
    private Matrix4f wkTrans;
    private Vector3f wkVec;
    private HashSet activeSensors;
    private HashSet workingSensors;
    private ObjectArray activeTouchSensors;
    private ObjectArray activeDragSensors;
    private Matrix4f sensorTransform;
    private Matrix4f dragParentTransform;
    private float[] sensorHitPoint;
    private float[] sensorHitNormal;
    private float[] sensorHitTexCoord;
    private Object[] tmpSensors;
    private Vector3f diffVec;
    private boolean navigationEnabled;
    private float[] navStart;
    private float[] tmpVec1;
    private float[] tmpVec2;
    private float[] tmpVec3;
    private int[] navMode;
    private int[] boundNavModes;
    private String[] navTypes;
    private int numNavTypes;
    private int currentNavTypeIndex;
    private PickRequest rayPicker;
    private MatrixUtils matrixUtils = new MatrixUtils();
    private int prevNavMode;
    private int prevNavModeIdx;
    private boolean testPointingDevices = true;
    private boolean trackerIntersect;
    private boolean activateSensors;
    private boolean wheelEnabled;
    private boolean wheelMoved;
    private int activeNavigationTracker;
    private boolean trackExamineWithShiftMod;
    private boolean navigationDragInProgress;
    private boolean localAltModifier;

    public DefaultUserInputHandler() {
        this.mousePickDirection = new Vector3f(0.0f, 0.0f, -1.0f);
        this.mouseEyePosition = new Point3f();
        this.mousePosition = new Point3f();
        this.mouseSensorPosition = new Point3f();
        this.viewTransform = new Matrix4f();
        this.rayPicker = new PickRequest();
        this.rayPicker.pickType = 1;
        this.rayPicker.pickGeometryType = 2;
        this.rayPicker.pickSortType = 1;
        this.rayPicker.generateVWorldMatrix = true;
        this.rayPicker.foundPaths = new ArrayList();
        this.navHandler = new NavigationProcessor();
        this.activeSensors = new HashSet();
        this.workingSensors = new HashSet();
        this.activeDragSensors = new ObjectArray();
        this.activeTouchSensors = new ObjectArray();
        this.dragParentTransform = new Matrix4f();
        this.sensorTransform = new Matrix4f();
        this.sensorHitPoint = new float[3];
        this.sensorHitNormal = new float[3];
        this.sensorHitTexCoord = new float[3];
        this.tmpSensors = new Object[10];
        this.hasTouchSensor = false;
        this.hasDragSensor = false;
        this.iutils = new AVIntersectionUtils();
        this.pointTrans = new Point3f();
        this.normalTrans = new Vector3f();
        this.wkPoint = new Point3f();
        this.wkTrans = new Matrix4f();
        this.wkVec = new Vector3f();
        this.currentPosition = new Vector3f();
        this.diffVec = new Vector3f();
        this.navStart = new float[3];
        this.tmpVec1 = new float[3];
        this.tmpVec2 = new float[3];
        this.tmpVec3 = new float[3];
        this.navMode = new int[16];
        for (int i = 0; i < this.navMode.length; ++i) {
            this.navMode[i] = -1;
        }
        this.lastButtonState = new boolean[128];
        this.boundNavModes = new int[8];
        this.navTypes = new String[0];
        this.navigationStateListeners = new ArrayList(1);
        this.sensorStatusListeners = new ArrayList(1);
        this.anyAllowed = true;
        this.activeNavigationTracker = -1;
    }

    public void notifyNavigationModesChanged(String[] stringArray, int n) {
        this.navTypes = stringArray;
        this.numNavTypes = n;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.fireNavigationListChanged(this.navTypes, this.numNavTypes);
        if (this.numNavTypes > 0) {
            if (this.navTypes[0].equals("ANY")) {
                this.setNavigationMode(DEFAULT_NAV_STRING);
            } else {
                this.setNavigationMode(this.navTypes[0]);
            }
        }
        this.wheelEnabled = false;
        this.anyAllowed = false;
        for (int i = 0; i < this.numNavTypes; ++i) {
            String string = this.navTypes[i];
            Integer n2 = (Integer)navigationTypes.get(string);
            if (n2 != null) {
                int n3;
                this.boundNavModes[i] = n3 = n2.intValue();
                if (n3 != 1 && n3 != 4) continue;
                this.wheelEnabled = true;
                continue;
            }
            if (string.equals("ANY")) {
                this.boundNavModes[i] = 5;
                this.anyAllowed = true;
                this.wheelEnabled = true;
                continue;
            }
            System.out.println("Unknown navigation mode: " + string);
            this.boundNavModes[i] = 0;
        }
        this.navHandler.setNavigationState(this.boundNavModes[0]);
    }

    public void notifyAvatarSizeChanged(float[] fArray, int n) {
        if (n != 3) {
            System.err.println("Unsupported number of avatar dimensions");
        } else {
            this.navHandler.setAvatarInfo(fArray[1], fArray[0], fArray[2]);
        }
    }

    public void notifyNavigationSpeedChanged(float f) {
        this.navHandler.setNavigationSpeed(f);
    }

    public void notifyVisibilityLimitChanged(float f) {
    }

    public void notifyHeadlightChanged(boolean bl) {
    }

    public boolean getNavigationEnabled() {
        return this.navigationEnabled;
    }

    public void setNavigationEnabled(boolean bl) {
        this.navigationEnabled = bl;
    }

    public void setPickableScene(Group group) {
        this.pickableWorld = group;
        this.doPicking = this.pickableWorld != null && this.viewPath != null;
        this.navHandler.setWorldInfo(group, group);
    }

    public void setViewInfo(OGLViewpointNodeType oGLViewpointNodeType, TransformGroup transformGroup, SceneGraphPath sceneGraphPath) throws IllegalArgumentException {
        this.navHandler.setViewInfo(oGLViewpointNodeType, transformGroup, sceneGraphPath);
        if (oGLViewpointNodeType != null) {
            this.navHandler.setCenterOfRotation(oGLViewpointNodeType.getCenterOfRotation(), null);
        }
        this.viewPath = sceneGraphPath;
        this.doPicking = this.pickableWorld != null && this.viewPath != null;
    }

    public void setCenterOfRotation(float[] fArray) {
        this.navHandler.setCenterOfRotation(fArray, null);
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.clock = vRMLClock;
    }

    public void setCollisionListener(CollisionListener collisionListener) {
        this.navHandler.setCollisionListener(collisionListener);
    }

    public void setNavigationInfo(VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType) {
        if (this.currentNavInfo != null) {
            this.currentNavInfo.removeNavigationChangedListener((NavigationInfoChangeListener)this);
        }
        this.currentNavInfo = vRMLNavigationInfoNodeType;
        if (vRMLNavigationInfoNodeType == null) {
            return;
        }
        vRMLNavigationInfoNodeType.addNavigationChangedListener((NavigationInfoChangeListener)this);
        float[] fArray = vRMLNavigationInfoNodeType.getAvatarSize();
        float f = vRMLNavigationInfoNodeType.getSpeed();
        this.navHandler.setAvatarInfo(fArray[1], fArray[0], fArray[2]);
        this.navHandler.setNavigationSpeed(f);
        this.navTypes = vRMLNavigationInfoNodeType.getType();
        this.numNavTypes = vRMLNavigationInfoNodeType.getNumTypes();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.fireNavigationListChanged(this.navTypes, this.numNavTypes);
        if (this.numNavTypes > 0) {
            if (this.navTypes[0].equals("ANY")) {
                this.setNavigationMode(DEFAULT_NAV_STRING);
            } else {
                this.setNavigationMode(this.navTypes[0]);
            }
        }
        this.wheelEnabled = false;
        this.anyAllowed = false;
        for (int i = 0; i < this.numNavTypes; ++i) {
            String string = this.navTypes[i];
            Integer n = (Integer)navigationTypes.get(string);
            if (n != null) {
                int n2;
                this.boundNavModes[i] = n2 = n.intValue();
                if (n2 != 1 && n2 != 4) continue;
                this.wheelEnabled = true;
                continue;
            }
            if (string.equals("ANY")) {
                this.boundNavModes[i] = 5;
                this.anyAllowed = true;
                this.wheelEnabled = true;
                continue;
            }
            System.out.println("Unknown navigation mode: " + string);
            this.boundNavModes[i] = 0;
        }
        this.navHandler.setNavigationState(this.boundNavModes[0]);
    }

    public void setTestPointingDevices(boolean bl) {
        this.testPointingDevices = bl;
    }

    public void trackerButton(int n, TrackerState trackerState) {
        this.processButtons(n, trackerState);
    }

    public void trackerPressed(int n, TrackerState trackerState) {
        this.checkSubMode(n, trackerState.altModifier);
        if (this.navMode[n] == -1) {
            this.setNavMode(n, trackerState);
        }
        this.trackerIntersect = false;
        boolean bl = false;
        boolean bl2 = this.trackExamineWithShiftMod = trackerState.shiftModifier && this.navMode[n] == 11;
        if (!this.doPicking) {
            bl = true;
        } else {
            SceneGraphPath sceneGraphPath = null;
            boolean bl3 = false;
            for (int i = 0; i < trackerState.numButtons; ++i) {
                if (!trackerState.pickingEnabled[i] || !trackerState.buttonState[i]) continue;
                bl3 = true;
                break;
            }
            if (bl3 && this.activateSensors && this.testPointingDevices) {
                sceneGraphPath = this.doPick(trackerState);
            }
            if (sceneGraphPath == null) {
                bl = true;
            } else {
                boolean bl4;
                this.trackerIntersect = true;
                int n2 = sceneGraphPath.getNodeCount();
                Node[] nodeArray = sceneGraphPath.getNodes();
                boolean bl5 = false;
                boolean bl6 = bl4 = trackerState.shiftModifier && (this.navMode[n] == 11 || this.navMode[n] == 12);
                if (!bl4) {
                    int n3 = n2;
                    while (--n3 >= 0) {
                        Node node = nodeArray[n3];
                        if (!this.processNodePress((SceneGraphObject)node)) continue;
                        bl5 = true;
                        this.currentPickedPath = sceneGraphPath;
                        this.currentPickedNodeIndex = n3;
                        break;
                    }
                }
                if (!bl5) {
                    bl = true;
                } else {
                    if (this.hasTouchSensor) {
                        double d = this.clock.getTime();
                        int n4 = this.activeTouchSensors.size();
                        for (int i = 0; i < n4; ++i) {
                            VRMLTouchSensorNodeType vRMLTouchSensorNodeType = (VRMLTouchSensorNodeType)this.activeTouchSensors.get(i);
                            vRMLTouchSensorNodeType.notifyPressed(1, d, this.sensorHitPoint, this.sensorHitNormal, this.sensorHitTexCoord);
                            this.fireDeviceActivated(vRMLTouchSensorNodeType);
                        }
                    }
                    if (this.hasDragSensor) {
                        this.calcSensorGroupVWorld(this.currentPickedPath, this.currentPickedNodeIndex, this.dragParentTransform);
                        this.dragParentTransform.invert();
                        this.dragParentTransform.transform(this.mousePosition, this.wkPoint);
                        this.sensorHitNormal[0] = this.wkPoint.x;
                        this.sensorHitNormal[1] = this.wkPoint.y;
                        this.sensorHitNormal[2] = this.wkPoint.z;
                        this.wkPoint.x = this.sensorHitPoint[0];
                        this.wkPoint.y = this.sensorHitPoint[1];
                        this.wkPoint.z = this.sensorHitPoint[2];
                        this.dragParentTransform.transform(this.wkPoint, this.pointTrans);
                        this.sensorHitPoint[0] = this.pointTrans.x;
                        this.sensorHitPoint[1] = this.pointTrans.y;
                        this.sensorHitPoint[2] = this.pointTrans.z;
                        int n5 = this.activeDragSensors.size();
                        for (int i = 0; i < n5; ++i) {
                            VRMLDragSensorNodeType vRMLDragSensorNodeType = (VRMLDragSensorNodeType)this.activeDragSensors.get(i);
                            vRMLDragSensorNodeType.notifySensorDragStart(this.sensorHitPoint, this.sensorHitNormal);
                            this.fireDeviceActivated(vRMLDragSensorNodeType);
                        }
                    }
                }
            }
        }
        if (bl) {
            this.navStart[0] = trackerState.devicePos[0];
            this.navStart[1] = trackerState.devicePos[1];
            this.navStart[2] = trackerState.devicePos[2];
            this.setNavMode(n, trackerState);
            this.activeNavigationTracker = n;
            if (this.navMode[n] == 6) {
                this.updateCenterOfRotation(trackerState);
                this.currentState = 1;
                this.navHandler.startMove();
            } else if (this.navMode[n] != 0) {
                this.currentState = 1;
                this.navHandler.startMove();
            } else {
                this.currentState = 0;
            }
        }
    }

    public void trackerMoved(int n, TrackerState trackerState) {
        Object object;
        int n2;
        this.checkSubMode(n, trackerState.altModifier);
        this.trackerIntersect = false;
        if (!this.doPicking) {
            return;
        }
        SceneGraphPath sceneGraphPath = null;
        if (this.activateSensors && this.testPointingDevices) {
            sceneGraphPath = this.doPick(trackerState);
        }
        if (sceneGraphPath == null) {
            int n3 = this.activeSensors.size();
            if (n3 != 0) {
                this.tmpSensors = this.activeSensors.toArray(this.tmpSensors);
                for (int i = 0; i < n3; ++i) {
                    Object object2 = this.tmpSensors[i];
                    if (object2 instanceof VRMLPointingDeviceSensorNodeType) {
                        ((VRMLPointingDeviceSensorNodeType)object2).setIsOver(false);
                    }
                    this.fireDeviceNotOver(object2);
                }
                this.activeSensors.clear();
            }
            return;
        }
        this.trackerIntersect = true;
        int n4 = sceneGraphPath.getNodeCount();
        Node[] nodeArray = sceneGraphPath.getNodes();
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            int n5;
            Node node = nodeArray[n2];
            OGLUserData oGLUserData = (OGLUserData)((Object)node.getUserData());
            if (oGLUserData == null) continue;
            if (oGLUserData.linkReference != null) {
                VRMLLinkNodeType vRMLLinkNodeType = oGLUserData.linkReference;
                if (this.activeSensors.contains((Object)vRMLLinkNodeType)) {
                    this.activeSensors.remove((Object)vRMLLinkNodeType);
                } else {
                    this.fireDeviceOver(vRMLLinkNodeType);
                }
                this.activeSensors.add((Object)vRMLLinkNodeType);
                bl = true;
            }
            if (oGLUserData.sensors == null) continue;
            this.pointTrans.x = this.sensorHitPoint[0];
            this.pointTrans.y = this.sensorHitPoint[1];
            this.pointTrans.z = this.sensorHitPoint[2];
            this.calcHitPoint(sceneGraphPath, n2, this.pointTrans);
            this.sensorHitPoint[0] = this.pointTrans.x;
            this.sensorHitPoint[1] = this.pointTrans.y;
            this.sensorHitPoint[2] = this.pointTrans.z;
            for (n5 = 0; n5 < oGLUserData.sensors.length; ++n5) {
                VRMLDragSensorNodeType vRMLDragSensorNodeType;
                object = oGLUserData.sensors[n5];
                if (object instanceof VRMLDragSensorNodeType) {
                    vRMLDragSensorNodeType = (VRMLDragSensorNodeType)object;
                    if (!vRMLDragSensorNodeType.getEnabled()) continue;
                    this.workingSensors.add((Object)vRMLDragSensorNodeType);
                    if (this.activeSensors.contains((Object)vRMLDragSensorNodeType)) {
                        this.activeSensors.remove((Object)vRMLDragSensorNodeType);
                    } else {
                        vRMLDragSensorNodeType.setIsOver(true);
                        this.fireDeviceOver(vRMLDragSensorNodeType);
                    }
                    bl = true;
                    continue;
                }
                if (!(object instanceof VRMLTouchSensorNodeType) || !(vRMLDragSensorNodeType = (VRMLTouchSensorNodeType)object).getEnabled()) continue;
                bl = true;
                if (bl2) continue;
                if (this.activeSensors.contains((Object)vRMLDragSensorNodeType)) {
                    this.activeSensors.remove((Object)vRMLDragSensorNodeType);
                } else {
                    vRMLDragSensorNodeType.setIsOver(true);
                    this.fireDeviceOver(vRMLDragSensorNodeType);
                }
                vRMLDragSensorNodeType.notifyHitChanged(this.sensorHitPoint, this.sensorHitNormal, this.sensorHitTexCoord);
                bl2 = true;
                this.workingSensors.add((Object)vRMLDragSensorNodeType);
            }
            n5 = this.activeSensors.size();
            if (n5 != 0) {
                this.tmpSensors = this.activeSensors.toArray(this.tmpSensors);
                for (int i = 0; i < n5; ++i) {
                    object = this.tmpSensors[i];
                    if (object instanceof VRMLPointingDeviceSensorNodeType) {
                        ((VRMLPointingDeviceSensorNodeType)object).setIsOver(false);
                    }
                    this.fireDeviceNotOver(object);
                }
                this.activeSensors.clear();
            }
            this.activeSensors.addAll(this.workingSensors);
            this.workingSensors.clear();
            if (bl) break;
        }
        n2 = this.activeSensors.size();
        if (!bl && n2 != 0) {
            this.tmpSensors = this.activeSensors.toArray(this.tmpSensors);
            for (int i = 0; i < n2; ++i) {
                object = this.tmpSensors[i];
                if (object instanceof VRMLPointingDeviceSensorNodeType) {
                    ((VRMLPointingDeviceSensorNodeType)object).setIsOver(false);
                }
                this.fireDeviceNotOver(object);
            }
            this.activeSensors.clear();
        }
    }

    public boolean trackerIntersected() {
        return this.trackerIntersect;
    }

    public void setActivateSensors(boolean bl) {
        this.activateSensors = bl;
    }

    public void trackerDragged(int n, TrackerState trackerState) {
        this.checkSubMode(n, trackerState.altModifier);
        switch (this.currentState) {
            case 1: {
                this.navigationDragInProgress = true;
                if (n != this.activeNavigationTracker) break;
                float f = this.navStart[0] - trackerState.devicePos[0];
                float f2 = trackerState.devicePos[1] - this.navStart[1];
                switch (this.navMode[n]) {
                    case 1: {
                        this.tmpVec1[0] = f;
                        this.tmpVec1[1] = 0.0f;
                        this.tmpVec1[2] = f2;
                        break;
                    }
                    case 3: {
                        this.tmpVec1[0] = -f;
                        this.tmpVec1[1] = -f2;
                        this.tmpVec1[2] = 0.0f;
                        break;
                    }
                    case 2: {
                        this.tmpVec1[0] = f;
                        this.tmpVec1[1] = -f2;
                        this.tmpVec1[2] = 0.0f;
                        break;
                    }
                    case 4: {
                        this.tmpVec1[0] = f;
                        this.tmpVec1[1] = 0.0f;
                        this.tmpVec1[2] = f2;
                        break;
                    }
                    case 5: {
                        this.tmpVec1[0] = f;
                        this.tmpVec1[1] = f2;
                        this.tmpVec1[2] = 0.0f;
                        break;
                    }
                    case 10: {
                        this.tmpVec1[0] = f;
                        this.tmpVec1[1] = 0.0f;
                        this.tmpVec1[2] = f2;
                        break;
                    }
                    case 11: {
                        if (trackerState.altModifier) {
                            this.tmpVec1[0] = f;
                            this.tmpVec1[1] = f2;
                            this.tmpVec1[2] = 0.0f;
                        } else if (trackerState.ctrlModifier) {
                            this.tmpVec1[0] = 0.0f;
                            this.tmpVec1[1] = 0.0f;
                            this.tmpVec1[2] = f2;
                        } else {
                            this.tmpVec1[0] = -f;
                            this.tmpVec1[1] = -f2;
                            this.tmpVec1[2] = 0.0f;
                        }
                        this.navStart[0] = trackerState.devicePos[0];
                        this.navStart[1] = trackerState.devicePos[1];
                        this.navStart[2] = trackerState.devicePos[2];
                        break;
                    }
                    case 12: {
                        this.tmpVec1[0] = f;
                        this.tmpVec1[1] = f2;
                        this.tmpVec1[2] = 0.0f;
                        this.navStart[0] = trackerState.devicePos[0];
                        this.navStart[1] = trackerState.devicePos[1];
                        this.navStart[2] = trackerState.devicePos[2];
                    }
                }
                float f3 = (float)Math.sqrt(this.tmpVec1[0] * this.tmpVec1[0] + this.tmpVec1[1] * this.tmpVec1[1] + this.tmpVec1[2] * this.tmpVec1[2]);
                if (f3 != 0.0f) {
                    this.tmpVec1[0] = this.tmpVec1[0] / f3;
                    this.tmpVec1[1] = this.tmpVec1[1] / f3;
                    this.tmpVec1[2] = this.tmpVec1[2] / f3;
                } else {
                    this.tmpVec1[0] = 0.0f;
                    this.tmpVec1[1] = 1.0f;
                    this.tmpVec1[2] = 0.0f;
                }
                this.navHandler.move(this.tmpVec1, f3);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                int n2;
                VRMLPointingDeviceSensorNodeType vRMLPointingDeviceSensorNodeType;
                int n3;
                SceneGraphPath sceneGraphPath;
                this.workingSensors.clear();
                if (this.hasTouchSensor) {
                    int n4 = this.activeTouchSensors.size();
                    for (int i = 0; i < n4; ++i) {
                        this.workingSensors.add(this.activeTouchSensors.get(i));
                    }
                }
                if ((sceneGraphPath = this.doPick(trackerState)) != null) {
                    n3 = sceneGraphPath.getNodeCount();
                    vRMLPointingDeviceSensorNodeType = sceneGraphPath.getNodes();
                    for (int i = n3 - 1; i >= 0; --i) {
                        Node node = vRMLPointingDeviceSensorNodeType[i];
                        OGLUserData oGLUserData = (OGLUserData)((Object)node.getUserData());
                        if (oGLUserData == null || oGLUserData.sensors == null) continue;
                        for (int j = 0; j < oGLUserData.sensors.length; ++j) {
                            VRMLPointingDeviceSensorNodeType vRMLPointingDeviceSensorNodeType2 = oGLUserData.sensors[j];
                            if (!this.workingSensors.remove((Object)vRMLPointingDeviceSensorNodeType2) || !(vRMLPointingDeviceSensorNodeType2 instanceof VRMLTouchSensorNodeType)) continue;
                            VRMLTouchSensorNodeType vRMLTouchSensorNodeType = (VRMLTouchSensorNodeType)vRMLPointingDeviceSensorNodeType2;
                            this.pointTrans.x = this.sensorHitPoint[0];
                            this.pointTrans.y = this.sensorHitPoint[1];
                            this.pointTrans.z = this.sensorHitPoint[2];
                            this.calcHitPoint(sceneGraphPath, i, this.pointTrans);
                            this.sensorHitPoint[0] = this.pointTrans.x;
                            this.sensorHitPoint[1] = this.pointTrans.y;
                            this.sensorHitPoint[2] = this.pointTrans.z;
                            if (!vRMLTouchSensorNodeType.getIsOver()) {
                                vRMLTouchSensorNodeType.setIsOver(true);
                                this.activeSensors.add((Object)vRMLTouchSensorNodeType);
                            }
                            vRMLTouchSensorNodeType.notifyHitChanged(this.sensorHitPoint, this.sensorHitNormal, this.sensorHitTexCoord);
                        }
                    }
                }
                if (this.hasDragSensor) {
                    this.mousePosition.x = trackerState.worldPos[0];
                    this.mousePosition.y = trackerState.worldPos[1];
                    this.mousePosition.z = trackerState.worldPos[2];
                    this.mousePickDirection.x = trackerState.worldOri[0];
                    this.mousePickDirection.y = trackerState.worldOri[1];
                    this.mousePickDirection.z = trackerState.worldOri[2];
                    this.dragParentTransform.transform(this.mousePosition, this.wkPoint);
                    this.dragParentTransform.transform(this.mousePickDirection, this.diffVec);
                    this.sensorHitPoint[0] = this.wkPoint.x;
                    this.sensorHitPoint[1] = this.wkPoint.y;
                    this.sensorHitPoint[2] = this.wkPoint.z;
                    this.sensorHitNormal[0] = this.diffVec.x;
                    this.sensorHitNormal[1] = this.diffVec.y;
                    this.sensorHitNormal[2] = this.diffVec.z;
                    n3 = this.activeDragSensors.size();
                    for (int i = 0; i < n3; ++i) {
                        VRMLDragSensorNodeType vRMLDragSensorNodeType = (VRMLDragSensorNodeType)this.activeDragSensors.get(i);
                        vRMLDragSensorNodeType.notifySensorDragChange(this.sensorHitPoint, this.sensorHitNormal);
                    }
                }
                if ((n2 = this.workingSensors.size()) == 0) break;
                this.tmpSensors = this.workingSensors.toArray(this.tmpSensors);
                for (n3 = 0; n3 < n2; ++n3) {
                    vRMLPointingDeviceSensorNodeType = (VRMLPointingDeviceSensorNodeType)this.tmpSensors[n3];
                    if (!vRMLPointingDeviceSensorNodeType.getIsOver()) continue;
                    vRMLPointingDeviceSensorNodeType.setIsOver(false);
                    this.activeSensors.remove((Object)vRMLPointingDeviceSensorNodeType);
                }
                this.workingSensors.clear();
            }
        }
    }

    public void trackerWheel(int n, TrackerState trackerState) {
        if (this.wheelEnabled && this.navTypes[this.currentNavTypeIndex].equals(DEFAULT_NAV_STRING)) {
            this.tmpVec1[0] = 0.0f;
            this.tmpVec1[1] = 0.0f;
            this.tmpVec1[2] = trackerState.wheelClicks;
            this.navHandler.move(this.tmpVec1, 1.0f);
            this.wheelMoved = true;
        }
    }

    public void trackerReleased(int n, TrackerState trackerState) {
        this.checkSubMode(n, trackerState.altModifier);
        switch (this.currentState) {
            case 1: {
                if (n != this.activeNavigationTracker) break;
                this.navHandler.stopMove();
                if (this.navMode[n] == 6) {
                    this.fireNavigationStateChanged(this.prevNavModeIdx);
                    this.navHandler.setNavigationState(this.prevNavMode);
                    this.boundNavModes[0] = this.prevNavMode;
                }
                if (this.trackExamineWithShiftMod && !this.navigationDragInProgress) {
                    this.selectCenterOfRotation(trackerState);
                    this.trackExamineWithShiftMod = false;
                }
                this.currentState = 0;
                this.activeNavigationTracker = -1;
                this.navigationDragInProgress = false;
                break;
            }
            case 2: {
                this.fireLinkActivated(this.currentLink);
                this.currentLink = null;
                this.currentState = 0;
                break;
            }
            case 3: {
                VRMLTouchSensorNodeType vRMLTouchSensorNodeType;
                int n2;
                int n3 = this.activeTouchSensors.size();
                if (n3 != 0) {
                    double d = this.clock.getTime();
                    for (n2 = 0; n2 < n3; ++n2) {
                        vRMLTouchSensorNodeType = (VRMLTouchSensorNodeType)this.activeTouchSensors.get(n2);
                        vRMLTouchSensorNodeType.notifyReleased(1, d, this.sensorHitPoint, this.sensorHitNormal, this.sensorHitTexCoord);
                        if (vRMLTouchSensorNodeType.getIsOver()) continue;
                        this.fireDeviceNotOver(vRMLTouchSensorNodeType);
                    }
                }
                if ((n3 = this.activeDragSensors.size()) != 0) {
                    this.mousePosition.x = trackerState.worldPos[0];
                    this.mousePosition.y = trackerState.worldPos[1];
                    this.mousePosition.z = trackerState.worldPos[2];
                    this.mousePickDirection.x = trackerState.worldOri[0];
                    this.mousePickDirection.y = trackerState.worldOri[1];
                    this.mousePickDirection.z = trackerState.worldOri[2];
                    this.dragParentTransform.transform(this.mousePosition, this.wkPoint);
                    this.dragParentTransform.transform(this.mousePickDirection, this.diffVec);
                    this.sensorHitPoint[0] = this.wkPoint.x;
                    this.sensorHitPoint[1] = this.wkPoint.y;
                    this.sensorHitPoint[2] = this.wkPoint.z;
                    this.sensorHitNormal[0] = this.diffVec.x;
                    this.sensorHitNormal[1] = this.diffVec.y;
                    this.sensorHitNormal[2] = this.diffVec.z;
                    for (n2 = 0; n2 < n3; ++n2) {
                        vRMLTouchSensorNodeType = (VRMLDragSensorNodeType)this.activeDragSensors.get(n2);
                        vRMLTouchSensorNodeType.notifySensorDragEnd(this.sensorHitPoint, this.sensorHitNormal);
                        if (vRMLTouchSensorNodeType.getIsOver()) continue;
                        this.fireDeviceNotOver(vRMLTouchSensorNodeType);
                    }
                }
                this.currentPickedPath = null;
                this.currentPickedNodeIndex = -1;
                this.activeTouchSensors.clear();
                this.activeDragSensors.clear();
                this.hasDragSensor = false;
                this.hasTouchSensor = false;
                this.currentState = 0;
            }
        }
    }

    public void trackerClicked(int n, TrackerState trackerState) {
        if (!this.doPicking) {
            return;
        }
        this.trackerPressed(n, trackerState);
        this.trackerReleased(n, trackerState);
    }

    public void trackerOrientation(int n, TrackerState trackerState) {
        this.navHandler.orient(trackerState.deviceOri);
    }

    public void processNavigation() {
        if (this.navigationEnabled) {
            if (this.currentState == 1) {
                this.navHandler.processNextFrame();
            } else if (this.currentState == 0 && this.wheelMoved) {
                this.navHandler.processNextFrame();
                this.wheelMoved = false;
            }
        }
        this.navHandler.getPosition(this.currentPosition);
        this.currentNavInfo.setWorldLocation(this.currentPosition);
    }

    public boolean setNavigationMode(String string) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        for (int i = 0; i < this.navTypes.length; ++i) {
            if (this.navTypes[i].equals(string)) {
                bl = true;
                n2 = i;
                break;
            }
            if (!this.navTypes[i].equals("ANY")) continue;
            bl2 = true;
        }
        if (!bl && bl2) {
            String[] stringArray = new String[this.navTypes.length + 1];
            for (n = 0; n < this.navTypes.length; ++n) {
                stringArray[n] = this.navTypes[n];
            }
            stringArray[this.navTypes.length] = string;
            this.fireNavigationListChanged(stringArray, stringArray.length);
            n2 = this.navTypes.length;
            bl = true;
            this.navTypes = stringArray;
        }
        if (bl) {
            this.fireNavigationStateChanged(n2);
            Integer n3 = (Integer)navigationTypes.get(string);
            if (n3 != null) {
                n = n3;
                this.navHandler.setNavigationState(n);
                if (n == 6) {
                    this.prevNavMode = this.boundNavModes[0];
                } else {
                    this.prevNavModeIdx = n2;
                }
                this.boundNavModes[0] = n;
            } else if (bl2) {
                this.navHandler.setNavigationState(5);
            }
        }
        return bl;
    }

    public void addNavigationStateListener(NavigationStateListener navigationStateListener) {
        if (navigationStateListener != null && !this.navigationStateListeners.contains(navigationStateListener)) {
            this.navigationStateListeners.add(navigationStateListener);
        }
    }

    public void removeNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.navigationStateListeners.remove(navigationStateListener);
    }

    public void addSensorStatusListener(SensorStatusListener sensorStatusListener) {
        if (sensorStatusListener != null && !this.sensorStatusListeners.contains(sensorStatusListener)) {
            this.sensorStatusListeners.add(sensorStatusListener);
        }
    }

    public void removeSensorStatusListener(SensorStatusListener sensorStatusListener) {
        this.sensorStatusListeners.remove(sensorStatusListener);
    }

    public void getOrientation(AxisAngle4f axisAngle4f) {
        this.navHandler.getOrientation(axisAngle4f);
    }

    public void getPosition(Vector3f vector3f) {
        vector3f.x = this.currentPosition.x;
        vector3f.y = this.currentPosition.y;
        vector3f.z = this.currentPosition.z;
    }

    public void setWorldScale(float f) {
        this.navHandler.setWorldScale(f);
    }

    public void sendCurrentNavState() {
        this.fireNavigationListChanged(this.navTypes, this.numNavTypes);
        this.fireNavigationStateChanged(this.currentNavTypeIndex);
    }

    public void clear() {
        this.setWorldScale(1.0f);
        this.setPickableScene(null);
        this.setViewInfo(null, null, null);
        this.navigationStateListeners.clear();
        this.sensorStatusListeners.clear();
        this.navHandler.clear();
        ArrayList arrayList = (ArrayList)this.rayPicker.foundPaths;
        if (arrayList != null) {
            arrayList.clear();
        }
        for (int i = 0; i < this.tmpSensors.length; ++i) {
            this.tmpSensors[i] = null;
        }
    }

    private SceneGraphPath doPick(TrackerState trackerState) {
        this.mouseEyePosition.x = trackerState.worldPos[0];
        this.mouseEyePosition.y = trackerState.worldPos[1];
        this.mouseEyePosition.z = trackerState.worldPos[2];
        this.mousePickDirection.x = trackerState.worldOri[0];
        this.mousePickDirection.y = trackerState.worldOri[1];
        this.mousePickDirection.z = trackerState.worldOri[2];
        this.rayPicker.origin[0] = trackerState.worldPos[0];
        this.rayPicker.origin[1] = trackerState.worldPos[1];
        this.rayPicker.origin[2] = trackerState.worldPos[2];
        this.rayPicker.destination[0] = trackerState.worldOri[0];
        this.rayPicker.destination[1] = trackerState.worldOri[1];
        this.rayPicker.destination[2] = trackerState.worldOri[2];
        ArrayList arrayList = (ArrayList)this.rayPicker.foundPaths;
        arrayList.clear();
        this.pickableWorld.pickSingle(this.rayPicker);
        if (this.rayPicker.pickCount == 0) {
            return null;
        }
        double d = Double.POSITIVE_INFINITY;
        boolean bl = false;
        int n = -1;
        arrayList = (ArrayList)this.rayPicker.foundPaths;
        for (int i = 0; i < this.rayPicker.pickCount; ++i) {
            SceneGraphPath sceneGraphPath = (SceneGraphPath)arrayList.get(i);
            Node node = sceneGraphPath.getTerminalNode();
            if (!(node instanceof Shape3D)) continue;
            sceneGraphPath.getTransform(this.viewTransform);
            Shape3D shape3D = (Shape3D)sceneGraphPath.getTerminalNode();
            Geometry geometry = shape3D.getGeometry();
            if (geometry == null) continue;
            OGLUserData oGLUserData = (OGLUserData)((Object)geometry.getUserData());
            boolean bl2 = false;
            if (oGLUserData != null && oGLUserData.geometryData != null && oGLUserData.geometryData instanceof GeometryData) {
                GeometryData geometryData = (GeometryData)oGLUserData.geometryData;
                bl2 = this.iutils.rayUnknownGeometry(this.mouseEyePosition, this.mousePickDirection, 0.0f, geometryData, this.viewTransform, this.wkPoint, false);
            } else if (geometry instanceof VertexGeometry) {
                bl2 = this.iutils.rayUnknownGeometry(this.mouseEyePosition, this.mousePickDirection, 0.0f, (VertexGeometry)geometry, this.viewTransform, this.wkPoint, false);
            } else if (geometry instanceof Text2D) {
                this.tmpVec1[0] = this.viewTransform.m00 * this.rayPicker.origin[0] + this.viewTransform.m01 * this.rayPicker.origin[1] + this.viewTransform.m02 * this.rayPicker.origin[2] + this.viewTransform.m03;
                this.tmpVec1[1] = this.viewTransform.m10 * this.rayPicker.origin[0] + this.viewTransform.m11 * this.rayPicker.origin[1] + this.viewTransform.m12 * this.rayPicker.origin[2] + this.viewTransform.m13;
                this.tmpVec1[2] = this.viewTransform.m20 * this.rayPicker.origin[0] + this.viewTransform.m21 * this.rayPicker.origin[1] + this.viewTransform.m22 * this.rayPicker.origin[2] + this.viewTransform.m23;
                this.tmpVec2[0] = this.viewTransform.m00 * this.rayPicker.destination[0] + this.viewTransform.m01 * this.rayPicker.destination[1] + this.viewTransform.m02 * this.rayPicker.destination[2];
                this.tmpVec2[1] = this.viewTransform.m10 * this.rayPicker.destination[0] + this.viewTransform.m11 * this.rayPicker.destination[1] + this.viewTransform.m12 * this.rayPicker.destination[2];
                this.tmpVec2[2] = this.viewTransform.m20 * this.rayPicker.destination[0] + this.viewTransform.m21 * this.rayPicker.destination[1] + this.viewTransform.m22 * this.rayPicker.destination[2];
                bl2 = geometry.pickLineRay(this.tmpVec1, this.tmpVec2, true, this.tmpVec3, 0);
                if (bl2) {
                    this.wkPoint.x = this.tmpVec3[0];
                    this.wkPoint.y = this.tmpVec3[1];
                    this.wkPoint.z = this.tmpVec3[2];
                }
            } else {
                System.out.println("Unhandled geometry type in picking: " + geometry);
            }
            if (!bl2) continue;
            this.diffVec.sub((Tuple3f)this.mouseEyePosition, (Tuple3f)this.wkPoint);
            if (!((double)this.diffVec.lengthSquared() < d)) continue;
            n = i;
            d = this.diffVec.lengthSquared();
            this.sensorHitPoint[0] = this.wkPoint.x;
            this.sensorHitPoint[1] = this.wkPoint.y;
            this.sensorHitPoint[2] = this.wkPoint.z;
            bl = true;
        }
        if (!bl) {
            return null;
        }
        return (SceneGraphPath)arrayList.get(n);
    }

    private boolean processNodePress(SceneGraphObject sceneGraphObject) {
        Object object = sceneGraphObject.getUserData();
        if (object == null || !(object instanceof OGLUserData)) {
            return false;
        }
        boolean bl = false;
        double d = this.clock.getTime();
        OGLUserData oGLUserData = (OGLUserData)((Object)object);
        if (oGLUserData.linkReference != null) {
            this.currentLink = oGLUserData.linkReference;
            this.currentState = 2;
            bl = true;
        }
        if (oGLUserData.sensors != null) {
            VRMLPointingDeviceSensorNodeType[] vRMLPointingDeviceSensorNodeTypeArray = oGLUserData.sensors;
            for (int i = 0; i < vRMLPointingDeviceSensorNodeTypeArray.length; ++i) {
                if (!vRMLPointingDeviceSensorNodeTypeArray[i].getEnabled()) continue;
                if (vRMLPointingDeviceSensorNodeTypeArray[i] instanceof VRMLTouchSensorNodeType) {
                    VRMLTouchSensorNodeType vRMLTouchSensorNodeType = (VRMLTouchSensorNodeType)vRMLPointingDeviceSensorNodeTypeArray[i];
                    this.activeTouchSensors.add((Object)vRMLTouchSensorNodeType);
                    this.hasTouchSensor = true;
                    continue;
                }
                VRMLDragSensorNodeType vRMLDragSensorNodeType = (VRMLDragSensorNodeType)vRMLPointingDeviceSensorNodeTypeArray[i];
                this.activeDragSensors.add((Object)vRMLDragSensorNodeType);
                this.hasDragSensor = true;
            }
            if (this.hasTouchSensor || this.hasDragSensor) {
                this.currentState = 3;
                bl = true;
            }
        }
        return bl;
    }

    private void calcSensorGroupVWorld(SceneGraphPath sceneGraphPath, int n, Matrix4f matrix4f) {
        OGLUserData oGLUserData;
        matrix4f.setIdentity();
        int n2 = sceneGraphPath.getNodeCount();
        boolean bl = false;
        for (int i = n2 - 1; i >= n && !bl; --i) {
            Node node = sceneGraphPath.getNode(i);
            oGLUserData = (OGLUserData)((Object)node.getUserData());
            if (oGLUserData == null) continue;
            bl = oGLUserData.isTransform;
        }
        if (!bl) {
            return;
        }
        Node[] nodeArray = sceneGraphPath.getNodes();
        for (int i = 0; i <= n; ++i) {
            if (!(nodeArray[i] instanceof TransformGroup)) continue;
            oGLUserData = (TransformGroup)nodeArray[i];
            oGLUserData.getTransform(this.wkTrans);
            matrix4f.mul(this.wkTrans);
        }
    }

    private void calcHitPoint(SceneGraphPath sceneGraphPath, int n, Point3f point3f) {
        this.calcSensorGroupVWorld(sceneGraphPath, n, this.sensorTransform);
        this.matrixUtils.inverse(this.sensorTransform, this.sensorTransform);
        this.sensorTransform.transform(point3f);
    }

    private void setNavMode(int n, TrackerState trackerState) {
        block12: for (int i = 0; i < trackerState.buttonState.length; ++i) {
            if (!trackerState.buttonState[i]) continue;
            switch (trackerState.buttonMode[i]) {
                case 10: {
                    this.navMode[n] = this.boundNavModes[0];
                    continue block12;
                }
                case 11: {
                    this.navMode[n] = this.boundNavModes[1];
                    continue block12;
                }
                case 12: {
                    this.navMode[n] = this.boundNavModes[2];
                    continue block12;
                }
                default: {
                    if (!this.anyAllowed) {
                        int n2 = this.boundNavModes.length;
                        boolean bl = false;
                        for (int j = 0; j < n2; ++j) {
                            if (trackerState.buttonMode[i] == 2 && this.boundNavModes[j] == 1) {
                                bl = true;
                                break;
                            }
                            if (trackerState.buttonMode[i] == 3 && this.boundNavModes[j] == 4) {
                                bl = true;
                                break;
                            }
                            if (trackerState.buttonMode[i] == 5 && this.boundNavModes[j] == 3) {
                                bl = true;
                                break;
                            }
                            if (trackerState.buttonMode[i] != 4 || this.boundNavModes[j] != 5) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            this.navMode[n] = 0;
                            continue block12;
                        }
                    }
                    switch (trackerState.buttonMode[i]) {
                        case 2: {
                            this.navMode[n] = 1;
                            break;
                        }
                        case 3: {
                            this.navMode[n] = 4;
                            break;
                        }
                        case 5: {
                            this.navMode[n] = 3;
                            break;
                        }
                        case 6: {
                            this.navMode[n] = 2;
                            break;
                        }
                        case 0: {
                            this.navMode[n] = 0;
                        }
                    }
                    break block12;
                }
            }
        }
        if (this.navMode[n] == 11 && this.localAltModifier) {
            this.navHandler.setNavigationState(12);
        } else {
            this.navHandler.setNavigationState(this.navMode[n]);
        }
    }

    private void processButtons(int n, TrackerState trackerState) {
        for (int i = 0; i < trackerState.buttonState.length; ++i) {
            int n2 = n * 8 + i;
            if (!trackerState.buttonState[i] || trackerState.buttonState[i] == this.lastButtonState[n2]) continue;
            switch (trackerState.buttonMode[i]) {
                case 18: {
                    System.out.println("GOTO Viewpoint next");
                }
            }
            this.lastButtonState[n2] = trackerState.buttonState[i];
        }
    }

    private void fireNavigationStateChanged(int n) {
        this.currentNavTypeIndex = n;
        int n2 = this.navigationStateListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                NavigationStateListener navigationStateListener = (NavigationStateListener)this.navigationStateListeners.get(i);
                navigationStateListener.navigationStateChanged(n);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending navigation state changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireNavigationListChanged(String[] stringArray, int n) {
        int n2 = this.navigationStateListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                NavigationStateListener navigationStateListener = (NavigationStateListener)this.navigationStateListeners.get(i);
                navigationStateListener.navigationListChanged(stringArray, n);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending navigation list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireDeviceOver(Object object) {
        String string;
        int n = 0;
        if (object instanceof VRMLTouchSensorNodeType) {
            n = 1;
            string = ((VRMLTouchSensorNodeType)object).getDescription();
        } else if (object instanceof VRMLDragSensorNodeType) {
            n = 2;
            string = ((VRMLDragSensorNodeType)object).getDescription();
        } else if (object instanceof VRMLLinkNodeType) {
            n = 0;
            string = ((VRMLLinkNodeType)object).getDescription();
        } else {
            System.out.println("Unhandled sensor type in fireDeviceOver: " + object);
            return;
        }
        int n2 = this.sensorStatusListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                SensorStatusListener sensorStatusListener = (SensorStatusListener)this.sensorStatusListeners.get(i);
                sensorStatusListener.deviceOver(n, string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending navigation list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireDeviceNotOver(Object object) {
        int n = 0;
        if (object instanceof VRMLTouchSensorNodeType) {
            n = 1;
        } else if (object instanceof VRMLDragSensorNodeType) {
            n = 2;
        } else if (object instanceof VRMLLinkNodeType) {
            n = 0;
        } else {
            System.out.println("Unhandled sensor type in fireDeviceNotOver: " + object);
            return;
        }
        int n2 = this.sensorStatusListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                SensorStatusListener sensorStatusListener = (SensorStatusListener)this.sensorStatusListeners.get(i);
                sensorStatusListener.deviceNotOver(n);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending navigation list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireDeviceActivated(Object object) {
        int n = 0;
        if (object instanceof VRMLTouchSensorNodeType) {
            n = 1;
        } else if (object instanceof VRMLDragSensorNodeType) {
            n = 2;
        } else if (object instanceof VRMLLinkNodeType) {
            n = 0;
        } else {
            System.out.println("Unhandled sensor type in fireDeviceActivated: " + object);
            return;
        }
        int n2 = this.sensorStatusListeners.size();
        for (int i = 0; i < n2; ++i) {
            try {
                SensorStatusListener sensorStatusListener = (SensorStatusListener)this.sensorStatusListeners.get(i);
                sensorStatusListener.deviceActivated(n);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending navigation list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireLinkActivated(VRMLLinkNodeType vRMLLinkNodeType) {
        String[] stringArray = vRMLLinkNodeType.getUrl();
        String[] stringArray2 = vRMLLinkNodeType.getParameter();
        String string = vRMLLinkNodeType.getDescription();
        int n = this.sensorStatusListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                SensorStatusListener sensorStatusListener = (SensorStatusListener)this.sensorStatusListeners.get(i);
                sensorStatusListener.linkActivated(stringArray, stringArray2, string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending navigation list changed " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void updateCenterOfRotation(TrackerState trackerState) {
        Object object;
        SceneGraphPath sceneGraphPath = null;
        sceneGraphPath = this.doPick(trackerState);
        if (sceneGraphPath == null) {
            return;
        }
        int n = sceneGraphPath.getNodeCount();
        Node[] nodeArray = sceneGraphPath.getNodes();
        if (n < 1) {
            return;
        }
        Node node = nodeArray[n - 1];
        this.sensorTransform.setIdentity();
        for (int i = 0; i < n; ++i) {
            if (!(nodeArray[i] instanceof TransformGroup)) continue;
            object = (TransformGroup)nodeArray[i];
            object.getTransform(this.wkTrans);
            this.sensorTransform.mul(this.wkTrans);
        }
        BoundingVolume boundingVolume = node.getBounds();
        object = new float[3];
        boundingVolume.getCenter(object);
        Point3f point3f = new Point3f(object);
        Point3f point3f2 = new Point3f(this.sensorHitPoint);
        this.sensorTransform.transform(point3f);
        Vector3f vector3f = new Vector3f();
        this.navHandler.getPosition(vector3f);
        Vector3f vector3f2 = new Vector3f();
        vector3f2.sub((Tuple3f)point3f2, (Tuple3f)vector3f);
        vector3f.x += 0.5f * vector3f2.x;
        vector3f.y += 0.5f * vector3f2.y;
        vector3f.z += 0.5f * vector3f2.z;
        object[0] = point3f.x;
        object[1] = point3f.y;
        object[2] = point3f.z;
        float[] fArray = new float[]{vector3f.x, vector3f.y, vector3f.z};
        this.navHandler.setCenterOfRotation((float[])object, fArray);
    }

    private void selectCenterOfRotation(TrackerState trackerState) {
        SceneGraphPath sceneGraphPath = null;
        sceneGraphPath = this.doPick(trackerState);
        if (sceneGraphPath == null) {
            return;
        }
        int n = sceneGraphPath.getNodeCount();
        Node[] nodeArray = sceneGraphPath.getNodes();
        if (n < 1) {
            return;
        }
        Point3f point3f = new Point3f(this.sensorHitPoint);
        Vector3f vector3f = new Vector3f();
        this.navHandler.getPosition(vector3f);
        Vector3f vector3f2 = new Vector3f();
        vector3f2.sub((Tuple3f)point3f, (Tuple3f)vector3f);
        vector3f.x += 0.2f * vector3f2.x;
        vector3f.y += 0.2f * vector3f2.y;
        vector3f.z += 0.2f * vector3f2.z;
        float[] fArray = new float[]{vector3f.x, vector3f.y, vector3f.z};
        this.navHandler.setCenterOfRotation(this.sensorHitPoint, fArray, true);
    }

    private void checkSubMode(int n, boolean bl) {
        if (bl && !this.localAltModifier) {
            if (this.navMode[n] == 11) {
                this.navHandler.setNavigationState(12);
                this.navHandler.startMove();
            }
        } else if (this.localAltModifier && !bl && this.navMode[n] == 11) {
            this.navHandler.setNavigationState(11);
            this.navHandler.startMove();
        }
        this.localAltModifier = bl;
    }

    static {
        navigationTypes.put(DEFAULT_NAV_STRING, new Integer(5));
        navigationTypes.put("WALK", new Integer(1));
        navigationTypes.put("FLY", new Integer(4));
        navigationTypes.put("NONE", new Integer(0));
        navigationTypes.put("LOOKAT", new Integer(6));
        navigationTypes.put("xj3d_PAN", new Integer(3));
        navigationTypes.put("xj3d_TILT", new Integer(2));
        navigationTypes.put("xj3d_INSPECT", new Integer(10));
        navigationTypes.put("xj3d_TRACK_EXAMINE", new Integer(11));
        navigationTypes.put("xj3d_TRACK_PAN", new Integer(12));
    }
}

