/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.input;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.SceneGraphPath;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.j3d.aviatrix3d.picking.PickableObject;
import org.j3d.geom.GeometryData;
import org.j3d.renderer.aviatrix3d.util.AVIntersectionUtils;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.HashSet;
import org.web3d.util.IntArray;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.VRMLNode;
import org.web3d.vrml.nodes.VRMLComponentGeometryNodeType;
import org.web3d.vrml.nodes.VRMLCoordinateNodeType;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLGeometryNodeType;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPickingSensorNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.renderer.ogl.nodes.OGLPickableTargetNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLPickingFlagConvertor;
import org.web3d.vrml.renderer.ogl.nodes.OGLPickingSensorNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.util.NodeArray;
import org.xj3d.core.eventmodel.PickingManager;

public class DefaultPickingManager
implements PickingManager,
OGLPickingFlagConvertor {
    private static final int ARRAY_INC = 50;
    private static final int ALL_BITMASK = -1;
    private static final int NONE_BITMASK = 0;
    private static final int EXTENDED_BITMASK = Integer.MAX_VALUE;
    private IntArray availableBitmasks;
    private HashMap assignedBitmasks;
    private HashMap bitmaskCount;
    private ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private NodeArray sensorList = new NodeArray();
    private HashSet activeSensors = new HashSet();
    private HashMap activePaths = new HashMap();
    private PickRequest singlePicker;
    private PickRequest[] batchPicker;
    private Matrix4f pickMatrix;
    private Matrix4f[] matrixStack;
    private Matrix4f tmpMatrix;
    private ArrayList selectionArray = new ArrayList();
    private int lastNodeIndex;
    private int lastCoordIndex;
    private VRMLNodeType[] nodeList = new VRMLNodeType[100];
    private float[] coordList = new float[300];
    private float[] normalList = new float[300];
    private float[] textureList = new float[300];
    private Point3d tmpPoint1;
    private Point3d tmpPoint2;
    private Point3d wkPoint;
    private Vector3d wkDirection;
    private AVIntersectionUtils iutils;
    private float[] hitPoint = new float[3];
    private float[] hitNormal = new float[3];
    private float[] hitTexCoord = new float[3];
    private Vector3d diffVec;

    public DefaultPickingManager() {
        int n;
        int n2;
        this.tmpPoint1 = new Point3d();
        this.tmpPoint2 = new Point3d();
        this.wkPoint = new Point3d();
        this.wkDirection = new Vector3d();
        this.diffVec = new Vector3d();
        this.tmpMatrix = new Matrix4f();
        this.iutils = new AVIntersectionUtils();
        this.singlePicker = new PickRequest();
        this.batchPicker = new PickRequest[4];
        for (n2 = 0; n2 < 4; ++n2) {
            this.batchPicker[n2] = new PickRequest();
        }
        this.availableBitmasks = new IntArray(32);
        this.assignedBitmasks = new HashMap();
        this.bitmaskCount = new HashMap();
        n2 = 1;
        for (n = 0; n < 30; ++n) {
            this.availableBitmasks.add(n2);
            n2 <<= 1;
        }
        this.pickMatrix = new Matrix4f();
        this.matrixStack = new Matrix4f[16];
        for (n = 0; n < 16; ++n) {
            this.matrixStack[n] = new Matrix4f();
        }
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void processPickSensors(double d) {
        int n = this.sensorList.size();
        for (int i = 0; i < n; ++i) {
            Map map;
            OGLPickingSensorNodeType oGLPickingSensorNodeType = (OGLPickingSensorNodeType)this.sensorList.get(i);
            if (!oGLPickingSensorNodeType.getEnabled() || (map = oGLPickingSensorNodeType.getTargetMapping()).size() == 0) continue;
            this.checkIntersections(oGLPickingSensorNodeType, map);
        }
    }

    public void addSensor(VRMLPickingSensorNodeType vRMLPickingSensorNodeType) {
        ((OGLPickingSensorNodeType)vRMLPickingSensorNodeType).setTypeConvertor(this);
        this.sensorList.add((VRMLNode)vRMLPickingSensorNodeType);
    }

    public void removeSensor(VRMLPickingSensorNodeType vRMLPickingSensorNodeType) {
        ((OGLPickingSensorNodeType)vRMLPickingSensorNodeType).setTypeConvertor(null);
        this.sensorList.remove((VRMLNode)vRMLPickingSensorNodeType);
    }

    public void loadScene(BasicScene basicScene) {
        VRMLNodeType vRMLNodeType;
        int n;
        ArrayList arrayList = basicScene.getByPrimaryType(73);
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (OGLPickingSensorNodeType)arrayList.get(n);
            this.sensorList.add((VRMLNode)vRMLNodeType);
            vRMLNodeType.setTypeConvertor(this);
        }
        arrayList = basicScene.getBySecondaryType(80);
        n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            vRMLNodeType = (OGLPickableTargetNodeType)arrayList.get(n);
            vRMLNodeType.setTypeConvertor(this);
        }
    }

    public void unloadScene(BasicScene basicScene) {
        ArrayList arrayList = basicScene.getByPrimaryType(73);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.sensorList.remove((VRMLNode)((VRMLNodeType)arrayList.get(i)));
        }
    }

    public void clear() {
        this.sensorList.clear();
        this.activeSensors.clear();
    }

    public int addObjectType(String string) {
        int n = 0;
        Integer n2 = (Integer)this.assignedBitmasks.get(string);
        if (n2 != null) {
            Integer n3 = (Integer)this.bitmaskCount.get(string);
            this.bitmaskCount.put(string, new Integer(n3 + 1));
            n = n2;
        } else if (this.availableBitmasks.size() == 0) {
            this.assignedBitmasks.put(string, new Integer(Integer.MAX_VALUE));
            this.bitmaskCount.put(string, new Integer(1));
            n = Integer.MAX_VALUE;
        } else {
            n = this.availableBitmasks.remove(0);
            this.assignedBitmasks.put(string, new Integer(n));
            this.bitmaskCount.put(string, new Integer(1));
        }
        return n;
    }

    public void removeObjectType(String string) {
        Integer n = (Integer)this.bitmaskCount.get(string);
        if (n == 1) {
            this.bitmaskCount.remove(string);
            Integer n2 = (Integer)this.assignedBitmasks.remove(string);
            this.availableBitmasks.add(n2.intValue());
        } else {
            this.bitmaskCount.put(string, new Integer(n - 1));
        }
    }

    private void checkIntersections(OGLPickingSensorNodeType oGLPickingSensorNodeType, Map map) {
        VRMLNodeType vRMLNodeType = oGLPickingSensorNodeType.getPickingGeometry();
        VRMLGeometryNodeType vRMLGeometryNodeType = this.findRealGeometry(vRMLNodeType);
        int n = oGLPickingSensorNodeType.getSortOrder();
        int n2 = oGLPickingSensorNodeType.getIntersectionType();
        int n3 = oGLPickingSensorNodeType.getPickMask();
        PickableObject[] pickableObjectArray = oGLPickingSensorNodeType.getTargetObjects();
        this.calculatePickMatrix(oGLPickingSensorNodeType);
        this.lastNodeIndex = 0;
        this.lastCoordIndex = 0;
        switch (oGLPickingSensorNodeType.getPickingType()) {
            case 1: {
                this.processPointPicking(n2, n, n3, vRMLGeometryNodeType, pickableObjectArray, map);
                break;
            }
            case 2: {
                this.processLinePicking(n2, n, n3, vRMLGeometryNodeType, pickableObjectArray, map);
                break;
            }
            case 3: {
                this.processSpherePicking(n2, n, n3, vRMLGeometryNodeType, pickableObjectArray, map);
                break;
            }
            case 4: {
                this.processBoxPicking(n2, n, n3, vRMLGeometryNodeType, pickableObjectArray, map);
                break;
            }
            case 5: {
                this.processConePicking(n2, n, n3, vRMLGeometryNodeType, pickableObjectArray, map);
                break;
            }
            case 6: {
                this.processCylinderPicking(n2, n, n3, vRMLGeometryNodeType, pickableObjectArray, map);
                break;
            }
            case 7: {
                this.processVolumePicking(n2, n, n3, vRMLGeometryNodeType, pickableObjectArray, map);
                break;
            }
            default: {
                this.errorReporter.warningReport("Unknown picking type defined", null);
            }
        }
        try {
            if (this.lastNodeIndex != 0) {
                if (this.activeSensors.contains((Object)oGLPickingSensorNodeType)) {
                    oGLPickingSensorNodeType.notifyPickChange(this.lastNodeIndex, this.nodeList, this.coordList, this.normalList, this.textureList);
                } else {
                    this.activeSensors.add((Object)oGLPickingSensorNodeType);
                    oGLPickingSensorNodeType.notifyPickStart(this.lastNodeIndex, this.nodeList, this.coordList, this.normalList, this.textureList);
                }
            } else if (this.activeSensors.contains((Object)oGLPickingSensorNodeType)) {
                oGLPickingSensorNodeType.notifyPickEnd();
                this.activeSensors.remove((Object)oGLPickingSensorNodeType);
                this.activePaths.remove(oGLPickingSensorNodeType);
            }
        }
        catch (Exception exception) {
            this.errorReporter.errorReport("Sending output to PickingSensor", exception);
        }
    }

    private void processPointPicking(int n, int n2, int n3, VRMLGeometryNodeType vRMLGeometryNodeType, PickableObject[] pickableObjectArray, Map map) {
        VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType = (VRMLComponentGeometryNodeType)vRMLGeometryNodeType;
        VRMLNodeType[] vRMLNodeTypeArray = vRMLComponentGeometryNodeType.getComponents();
        if (vRMLNodeTypeArray == null || vRMLNodeTypeArray.length == 0) {
            return;
        }
        VRMLCoordinateNodeType vRMLCoordinateNodeType = null;
        for (int i = 0; i < vRMLNodeTypeArray.length && vRMLCoordinateNodeType == null; ++i) {
            vRMLCoordinateNodeType = this.findRealCoordinates(vRMLNodeTypeArray[i]);
        }
        if (vRMLCoordinateNodeType == null) {
            return;
        }
        float[] fArray = vRMLCoordinateNodeType.getPointRef();
        int n4 = vRMLCoordinateNodeType.getNumPoints() / 3;
        if (n4 == 1) {
            this.setupPicker(this.singlePicker, n, n2);
            this.singlePicker.pickGeometryType = 1;
            this.singlePicker.pickType = n3;
            this.singlePicker.origin[0] = fArray[0];
            this.singlePicker.origin[1] = fArray[1];
            this.singlePicker.origin[2] = fArray[2];
            this.transformPosition(this.singlePicker.origin);
            boolean bl = false;
            block9: for (int i = 0; !bl && i < pickableObjectArray.length; ++i) {
                pickableObjectArray[i].pickSingle(this.singlePicker);
                if (this.singlePicker.pickCount == 0) continue;
                VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(pickableObjectArray[i]);
                switch (n2) {
                    case 2: 
                    case 3: {
                        this.checkArraySize(1);
                        this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                        bl = false;
                        continue block9;
                    }
                    case 1: 
                    case 4: {
                        this.checkArraySize(1);
                        this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                        bl = true;
                    }
                }
            }
        } else {
            int n5;
            this.checkBatchPicker(n4);
            for (n5 = 0; n5 < n4; ++n5) {
                this.setupPicker(this.batchPicker[n5], n, n2);
                this.batchPicker[n5].pickGeometryType = 1;
                this.batchPicker[n5].pickType = n3;
                this.batchPicker[n5].origin[0] = fArray[n5 * 3];
                this.batchPicker[n5].origin[1] = fArray[n5 * 3 + 1];
                this.batchPicker[n5].origin[2] = fArray[n5 * 3 + 2];
                this.transformPosition(this.batchPicker[n5].origin);
            }
            n5 = 0;
            for (int i = 0; n5 == 0 && i < pickableObjectArray.length; ++i) {
                pickableObjectArray[i].pickBatch(this.batchPicker, n4);
                block12: for (int j = 0; n5 == 0 && j < n4; ++j) {
                    if (this.batchPicker[j].pickCount == 0) continue;
                    VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(pickableObjectArray[i]);
                    switch (n2) {
                        case 2: 
                        case 3: {
                            this.checkArraySize(1);
                            this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                            n5 = 0;
                            continue block12;
                        }
                        case 1: 
                        case 4: {
                            this.checkArraySize(1);
                            this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                            n5 = 1;
                        }
                    }
                }
            }
        }
    }

    private void processLinePicking(int n, int n2, int n3, VRMLGeometryNodeType vRMLGeometryNodeType, PickableObject[] pickableObjectArray, Map map) {
        if (vRMLGeometryNodeType.getVRMLNodeName().equals("LineSet")) {
            this.processLineSetPicking(n, n2, n3, vRMLGeometryNodeType, pickableObjectArray, map);
        } else {
            this.processIndexedLineSetPicking(n, n2, n3, vRMLGeometryNodeType, pickableObjectArray, map);
        }
    }

    private void processLineSetPicking(int n, int n2, int n3, VRMLGeometryNodeType vRMLGeometryNodeType, PickableObject[] pickableObjectArray, Map map) {
        int n4;
        VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType = (VRMLComponentGeometryNodeType)vRMLGeometryNodeType;
        VRMLNodeType[] vRMLNodeTypeArray = vRMLComponentGeometryNodeType.getComponents();
        if (vRMLNodeTypeArray == null || vRMLNodeTypeArray.length == 0) {
            return;
        }
        VRMLCoordinateNodeType vRMLCoordinateNodeType = null;
        for (n4 = 0; n4 < vRMLNodeTypeArray.length && vRMLCoordinateNodeType == null; ++n4) {
            vRMLCoordinateNodeType = this.findRealCoordinates(vRMLNodeTypeArray[n4]);
        }
        if (vRMLCoordinateNodeType == null) {
            return;
        }
        n4 = vRMLGeometryNodeType.getFieldIndex("vertexCount");
        VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n4);
        int[] nArray = vRMLFieldData.intArrayValue;
        int n5 = vRMLFieldData.numElements;
        if (n5 < 1) {
            return;
        }
        float[] fArray = vRMLCoordinateNodeType.getPointRef();
        this.setupPicker(this.singlePicker, n, n2);
        this.singlePicker.pickGeometryType = 3;
        this.singlePicker.pickType = n3;
        boolean bl = false;
        int n6 = 0;
        for (int i = 0; !bl && i < n5; ++i) {
            for (int j = 1; !bl && j < nArray[i]; ++j) {
                this.singlePicker.origin[0] = fArray[n6++];
                this.singlePicker.origin[1] = fArray[n6++];
                this.singlePicker.origin[2] = fArray[n6++];
                this.singlePicker.destination[0] = fArray[n6++];
                this.singlePicker.destination[1] = fArray[n6++];
                this.singlePicker.destination[2] = fArray[n6++];
                this.transformPosition(this.singlePicker.origin);
                this.transformPosition(this.singlePicker.destination);
                block11: for (int k = 0; !bl && k < pickableObjectArray.length; ++k) {
                    VRMLNodeType vRMLNodeType;
                    Node node;
                    int n7;
                    int n8;
                    SceneGraphPath sceneGraphPath;
                    int n9;
                    boolean bl2;
                    ArrayList arrayList;
                    pickableObjectArray[k].pickSingle(this.singlePicker);
                    if (this.singlePicker.pickCount == 0) continue;
                    if (this.singlePicker.foundPaths instanceof ArrayList) {
                        arrayList = (ArrayList)this.singlePicker.foundPaths;
                    } else {
                        arrayList = this.selectionArray;
                        this.selectionArray.clear();
                        this.selectionArray.add(this.singlePicker.foundPaths);
                    }
                    int n10 = arrayList.size();
                    if (n != 1) {
                        bl2 = false;
                        for (n9 = 0; n9 < this.singlePicker.pickCount; ++n9) {
                            sceneGraphPath = (SceneGraphPath)arrayList.get(n9);
                            n8 = sceneGraphPath.getNodeCount();
                            bl2 = false;
                            block13: for (n7 = 0; !bl2 && n7 < n8; ++n7) {
                                node = sceneGraphPath.getNode(n7);
                                vRMLNodeType = (VRMLNodeType)map.get(node);
                                if (vRMLNodeType == null) continue;
                                this.wkDirection.x = this.singlePicker.destination[0] - this.singlePicker.origin[0];
                                this.wkDirection.y = this.singlePicker.destination[1] - this.singlePicker.origin[1];
                                this.wkDirection.z = this.singlePicker.destination[2] - this.singlePicker.origin[2];
                                this.tmpPoint1.x = this.singlePicker.origin[0];
                                this.tmpPoint1.y = this.singlePicker.origin[1];
                                this.tmpPoint1.z = this.singlePicker.origin[2];
                                double d = this.detailLinePick(sceneGraphPath);
                                if (d < 0.0) {
                                    bl2 = true;
                                    continue;
                                }
                                switch (n2) {
                                    case 2: 
                                    case 3: {
                                        this.checkArraySize(1);
                                        this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                        this.coordList[this.lastCoordIndex] = this.hitPoint[0];
                                        this.coordList[this.lastCoordIndex + 1] = this.hitPoint[1];
                                        this.coordList[this.lastCoordIndex + 2] = this.hitPoint[2];
                                        this.normalList[this.lastCoordIndex] = this.hitNormal[0];
                                        this.normalList[this.lastCoordIndex + 1] = this.hitNormal[1];
                                        this.normalList[this.lastCoordIndex + 2] = this.hitNormal[2];
                                        this.textureList[this.lastCoordIndex] = this.hitTexCoord[0];
                                        this.textureList[this.lastCoordIndex + 1] = this.hitTexCoord[1];
                                        this.textureList[this.lastCoordIndex + 2] = this.hitTexCoord[2];
                                        this.lastCoordIndex += 3;
                                        bl2 = false;
                                        continue block13;
                                    }
                                    case 1: 
                                    case 4: {
                                        this.checkArraySize(1);
                                        this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                        this.coordList[this.lastCoordIndex] = this.hitPoint[0];
                                        this.coordList[this.lastCoordIndex + 1] = this.hitPoint[1];
                                        this.coordList[this.lastCoordIndex + 2] = this.hitPoint[2];
                                        this.normalList[this.lastCoordIndex] = this.hitNormal[0];
                                        this.normalList[this.lastCoordIndex + 1] = this.hitNormal[1];
                                        this.normalList[this.lastCoordIndex + 2] = this.hitNormal[2];
                                        this.textureList[this.lastCoordIndex] = this.hitTexCoord[0];
                                        this.textureList[this.lastCoordIndex + 1] = this.hitTexCoord[1];
                                        this.textureList[this.lastCoordIndex + 2] = this.hitTexCoord[2];
                                        this.lastCoordIndex += 3;
                                        bl2 = true;
                                    }
                                }
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        continue;
                    }
                    bl2 = false;
                    switch (n2) {
                        case 1: 
                        case 3: {
                            block14: for (n9 = 0; !bl2 && n9 < n10; ++n9) {
                                sceneGraphPath = (SceneGraphPath)arrayList.get(n9);
                                n8 = sceneGraphPath.getNodeCount();
                                bl2 = false;
                                for (n7 = 0; !bl2 && n7 < n8; ++n7) {
                                    node = sceneGraphPath.getNode(n7);
                                    vRMLNodeType = (VRMLNodeType)map.get(node);
                                    if (vRMLNodeType == null) continue;
                                    this.checkArraySize(1);
                                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                    if (n2 != 1) continue block14;
                                    bl2 = true;
                                    continue block14;
                                }
                            }
                            continue block11;
                        }
                        case 2: 
                        case 4: {
                            block16: for (n9 = 0; !bl2 && n9 < n10; ++n9) {
                                sceneGraphPath = (SceneGraphPath)arrayList.get(n9);
                                n8 = sceneGraphPath.getNodeCount();
                                bl2 = false;
                                for (n7 = 0; !bl2 && n7 < n8; ++n7) {
                                    node = sceneGraphPath.getNode(n7);
                                    vRMLNodeType = (VRMLNodeType)map.get(node);
                                    if (vRMLNodeType == null) continue;
                                    this.checkArraySize(1);
                                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                    bl = true;
                                    if (n2 != 4) continue block16;
                                    bl2 = true;
                                    continue block16;
                                }
                            }
                            continue block11;
                        }
                    }
                }
            }
        }
    }

    private void processIndexedLineSetPicking(int n, int n2, int n3, VRMLGeometryNodeType vRMLGeometryNodeType, PickableObject[] pickableObjectArray, Map map) {
        int n4;
        VRMLComponentGeometryNodeType vRMLComponentGeometryNodeType = (VRMLComponentGeometryNodeType)vRMLGeometryNodeType;
        VRMLNodeType[] vRMLNodeTypeArray = vRMLComponentGeometryNodeType.getComponents();
        if (vRMLNodeTypeArray == null || vRMLNodeTypeArray.length == 0) {
            return;
        }
        VRMLCoordinateNodeType vRMLCoordinateNodeType = null;
        for (n4 = 0; n4 < vRMLNodeTypeArray.length && vRMLCoordinateNodeType == null; ++n4) {
            vRMLCoordinateNodeType = this.findRealCoordinates(vRMLNodeTypeArray[n4]);
        }
        if (vRMLCoordinateNodeType == null) {
            return;
        }
        n4 = vRMLGeometryNodeType.getFieldIndex("coordIndex");
        VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n4);
        int[] nArray = vRMLFieldData.intArrayValue;
        int n5 = vRMLFieldData.numElements;
        if (n5 == 0) {
            return;
        }
        float[] fArray = vRMLCoordinateNodeType.getPointRef();
        this.setupPicker(this.singlePicker, n, n2);
        this.singlePicker.pickGeometryType = 3;
        this.singlePicker.pickType = n3;
        block9: for (int i = 0; i < n5 - 1; ++i) {
            int n6 = nArray[i] * 3;
            int n7 = nArray[i + 1] * 3;
            if (n7 < 0) {
                ++i;
                continue;
            }
            this.singlePicker.origin[0] = fArray[n6];
            this.singlePicker.origin[1] = fArray[n6 + 1];
            this.singlePicker.origin[2] = fArray[n6 + 2];
            this.singlePicker.destination[0] = fArray[n7];
            this.singlePicker.destination[1] = fArray[n7 + 1];
            this.singlePicker.destination[2] = fArray[n7 + 2];
            this.transformPosition(this.singlePicker.origin);
            this.transformPosition(this.singlePicker.destination);
            for (int j = 0; j < pickableObjectArray.length; ++j) {
                VRMLNodeType vRMLNodeType;
                Node node;
                int n8;
                int n9;
                SceneGraphPath sceneGraphPath;
                int n10;
                boolean bl;
                ArrayList arrayList;
                pickableObjectArray[j].pickSingle(this.singlePicker);
                if (this.singlePicker.pickCount == 0) continue;
                if (this.singlePicker.foundPaths instanceof ArrayList) {
                    arrayList = (ArrayList)this.singlePicker.foundPaths;
                } else {
                    arrayList = this.selectionArray;
                    this.selectionArray.clear();
                    this.selectionArray.add(this.singlePicker.foundPaths);
                }
                int n11 = arrayList.size();
                if (n != 1) {
                    bl = false;
                    for (n10 = 0; n10 < n11; ++n10) {
                        sceneGraphPath = (SceneGraphPath)arrayList.get(n10);
                        n9 = sceneGraphPath.getNodeCount();
                        bl = false;
                        block12: for (n8 = 0; !bl && n8 < n9; ++n8) {
                            node = sceneGraphPath.getNode(n8);
                            vRMLNodeType = (VRMLNodeType)map.get(node);
                            if (vRMLNodeType == null) continue;
                            this.wkDirection.x = this.singlePicker.destination[0] - this.singlePicker.origin[0];
                            this.wkDirection.y = this.singlePicker.destination[1] - this.singlePicker.origin[1];
                            this.wkDirection.z = this.singlePicker.destination[2] - this.singlePicker.origin[2];
                            this.tmpPoint1.x = this.singlePicker.origin[0];
                            this.tmpPoint1.y = this.singlePicker.origin[1];
                            this.tmpPoint1.z = this.singlePicker.origin[2];
                            double d = this.detailLinePick(sceneGraphPath);
                            if (d < 0.0) continue;
                            switch (n2) {
                                case 2: 
                                case 3: {
                                    this.checkArraySize(1);
                                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                    this.coordList[this.lastCoordIndex] = this.hitPoint[0];
                                    this.coordList[this.lastCoordIndex + 1] = this.hitPoint[1];
                                    this.coordList[this.lastCoordIndex + 2] = this.hitPoint[2];
                                    this.normalList[this.lastCoordIndex] = this.hitNormal[0];
                                    this.normalList[this.lastCoordIndex + 1] = this.hitNormal[1];
                                    this.normalList[this.lastCoordIndex + 2] = this.hitNormal[2];
                                    this.textureList[this.lastCoordIndex] = this.hitTexCoord[0];
                                    this.textureList[this.lastCoordIndex + 1] = this.hitTexCoord[1];
                                    this.textureList[this.lastCoordIndex + 2] = this.hitTexCoord[2];
                                    this.lastCoordIndex += 3;
                                    bl = false;
                                    continue block12;
                                }
                                case 1: 
                                case 4: {
                                    this.checkArraySize(1);
                                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                    this.coordList[this.lastCoordIndex] = this.hitPoint[0];
                                    this.coordList[this.lastCoordIndex + 1] = this.hitPoint[1];
                                    this.coordList[this.lastCoordIndex + 2] = this.hitPoint[2];
                                    this.normalList[this.lastCoordIndex] = this.hitNormal[0];
                                    this.normalList[this.lastCoordIndex + 1] = this.hitNormal[1];
                                    this.normalList[this.lastCoordIndex + 2] = this.hitNormal[2];
                                    this.textureList[this.lastCoordIndex] = this.hitTexCoord[0];
                                    this.textureList[this.lastCoordIndex + 1] = this.hitTexCoord[1];
                                    this.textureList[this.lastCoordIndex + 2] = this.hitTexCoord[2];
                                    this.lastCoordIndex += 3;
                                    bl = true;
                                }
                            }
                        }
                    }
                    if (!bl) continue;
                    continue block9;
                }
                bl = false;
                for (n10 = 0; n10 < n11; ++n10) {
                    sceneGraphPath = (SceneGraphPath)arrayList.get(n10);
                    n9 = sceneGraphPath.getNodeCount();
                    bl = false;
                    block14: for (n8 = 0; !bl && n8 < n9; ++n8) {
                        node = sceneGraphPath.getNode(n8);
                        vRMLNodeType = (VRMLNodeType)map.get(node);
                        if (vRMLNodeType == null) continue;
                        switch (n2) {
                            case 2: 
                            case 3: {
                                this.checkArraySize(1);
                                this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                bl = false;
                                continue block14;
                            }
                            case 1: 
                            case 4: {
                                this.checkArraySize(1);
                                this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                                bl = true;
                            }
                        }
                    }
                }
            }
        }
    }

    private void processSpherePicking(int n, int n2, int n3, VRMLGeometryNodeType vRMLGeometryNodeType, PickableObject[] pickableObjectArray, Map map) {
        int n4 = vRMLGeometryNodeType.getFieldIndex("radius");
        VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n4);
        this.lastNodeIndex = 0;
        this.lastCoordIndex = 0;
        float f = this.pickMatrix.getScale();
        this.setupPicker(this.singlePicker, n, n2);
        this.singlePicker.pickGeometryType = 9;
        this.singlePicker.pickType = n3;
        this.singlePicker.additionalData = vRMLFieldData.floatValue * f;
        this.singlePicker.origin[0] = 0.0f;
        this.singlePicker.origin[1] = 0.0f;
        this.singlePicker.origin[2] = 0.0f;
        this.transformPosition(this.singlePicker.origin);
        boolean bl = false;
        block4: for (int i = 0; !bl && i < pickableObjectArray.length; ++i) {
            pickableObjectArray[i].pickSingle(this.singlePicker);
            if (this.singlePicker.pickCount == 0) continue;
            VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(pickableObjectArray[i]);
            switch (n2) {
                case 2: 
                case 3: {
                    this.checkArraySize(1);
                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                    bl = false;
                    continue block4;
                }
                case 1: 
                case 4: {
                    this.checkArraySize(1);
                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                    bl = true;
                }
            }
        }
    }

    private void processBoxPicking(int n, int n2, int n3, VRMLGeometryNodeType vRMLGeometryNodeType, PickableObject[] pickableObjectArray, Map map) {
        int n4 = vRMLGeometryNodeType.getFieldIndex("size");
        VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n4);
        float f = vRMLFieldData.floatArrayValue[0] * 0.5f;
        float f2 = vRMLFieldData.floatArrayValue[1] * 0.5f;
        float f3 = vRMLFieldData.floatArrayValue[2] * 0.5f;
        this.setupPicker(this.singlePicker, n, n2);
        this.singlePicker.pickGeometryType = 8;
        this.singlePicker.pickType = n3;
        this.singlePicker.origin[0] = -f;
        this.singlePicker.origin[1] = -f2;
        this.singlePicker.origin[2] = -f3;
        this.singlePicker.destination[0] = f;
        this.singlePicker.destination[1] = f2;
        this.singlePicker.destination[2] = f3;
        this.transformPosition(this.singlePicker.origin);
        this.transformPosition(this.singlePicker.destination);
        boolean bl = false;
        block4: for (int i = 0; !bl && i < pickableObjectArray.length; ++i) {
            pickableObjectArray[i].pickSingle(this.singlePicker);
            if (this.singlePicker.pickCount == 0) continue;
            VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(pickableObjectArray[i]);
            switch (n2) {
                case 2: 
                case 3: {
                    this.checkArraySize(1);
                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                    bl = false;
                    continue block4;
                }
                case 1: 
                case 4: {
                    this.checkArraySize(1);
                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                    bl = true;
                }
            }
        }
    }

    private void processConePicking(int n, int n2, int n3, VRMLGeometryNodeType vRMLGeometryNodeType, PickableObject[] pickableObjectArray, Map map) {
        int n4 = vRMLGeometryNodeType.getFieldIndex("height");
        VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n4);
        float f = vRMLFieldData.floatValue;
        n4 = vRMLGeometryNodeType.getFieldIndex("bottomRadius");
        vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n4);
        double d = Math.tan(vRMLFieldData.floatValue / f);
        float f2 = this.pickMatrix.getScale();
        this.setupPicker(this.singlePicker, n, n2);
        this.singlePicker.pickGeometryType = 7;
        this.singlePicker.pickType = n3;
        this.singlePicker.additionalData = (float)d * f2;
        this.singlePicker.origin[0] = 0.0f;
        this.singlePicker.origin[1] = f * 0.5f;
        this.singlePicker.origin[2] = 0.0f;
        this.singlePicker.destination[0] = 0.0f;
        this.singlePicker.destination[1] = -f * 0.5f;
        this.singlePicker.destination[2] = 0.0f;
        this.transformPosition(this.singlePicker.origin);
        this.transformPosition(this.singlePicker.destination);
        this.lastNodeIndex = 0;
        this.lastCoordIndex = 0;
        boolean bl = false;
        block4: for (int i = 0; !bl && i < pickableObjectArray.length; ++i) {
            pickableObjectArray[i].pickSingle(this.singlePicker);
            if (this.singlePicker.pickCount == 0) continue;
            VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(pickableObjectArray[i]);
            switch (n2) {
                case 2: 
                case 3: {
                    this.checkArraySize(1);
                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                    bl = false;
                    continue block4;
                }
                case 1: 
                case 4: {
                    this.checkArraySize(1);
                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                    bl = true;
                }
            }
        }
    }

    private void processCylinderPicking(int n, int n2, int n3, VRMLGeometryNodeType vRMLGeometryNodeType, PickableObject[] pickableObjectArray, Map map) {
        int n4 = vRMLGeometryNodeType.getFieldIndex("height");
        VRMLFieldData vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n4);
        float f = vRMLFieldData.floatValue * 0.5f;
        n4 = vRMLGeometryNodeType.getFieldIndex("radius");
        vRMLFieldData = vRMLGeometryNodeType.getFieldValue(n4);
        float f2 = this.pickMatrix.getScale();
        this.setupPicker(this.singlePicker, n, n2);
        this.singlePicker.pickGeometryType = 5;
        this.singlePicker.pickType = n3;
        this.singlePicker.additionalData = vRMLFieldData.floatValue * f2;
        this.singlePicker.origin[0] = 0.0f;
        this.singlePicker.origin[1] = f;
        this.singlePicker.origin[2] = 0.0f;
        this.singlePicker.destination[0] = 0.0f;
        this.singlePicker.destination[1] = -f;
        this.singlePicker.destination[2] = 0.0f;
        this.transformPosition(this.singlePicker.origin);
        this.transformPosition(this.singlePicker.destination);
        boolean bl = false;
        block4: for (int i = 0; !bl && i < pickableObjectArray.length; ++i) {
            pickableObjectArray[i].pickSingle(this.singlePicker);
            if (this.singlePicker.pickCount == 0) continue;
            VRMLNodeType vRMLNodeType = (VRMLNodeType)map.get(pickableObjectArray[i]);
            switch (n2) {
                case 2: 
                case 3: {
                    this.checkArraySize(1);
                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                    bl = false;
                    continue block4;
                }
                case 1: 
                case 4: {
                    this.checkArraySize(1);
                    this.nodeList[this.lastNodeIndex++] = vRMLNodeType;
                    bl = true;
                }
            }
        }
    }

    private void processVolumePicking(int n, int n2, int n3, VRMLGeometryNodeType vRMLGeometryNodeType, PickableObject[] pickableObjectArray, Map map) {
    }

    private VRMLGeometryNodeType findRealGeometry(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType instanceof VRMLGeometryNodeType) {
            return (VRMLGeometryNodeType)vRMLNodeType;
        }
        VRMLGeometryNodeType vRMLGeometryNodeType = null;
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        while (vRMLGeometryNodeType == null) {
            if (vRMLNodeType2 instanceof VRMLGeometryNodeType) {
                vRMLGeometryNodeType = (VRMLGeometryNodeType)vRMLNodeType2;
                continue;
            }
            if (vRMLNodeType2 instanceof VRMLProtoInstance) {
                VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType2;
                vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
                continue;
            }
            System.out.println("Non-geometry proto found. Maybe extern proto?");
            break;
        }
        return vRMLGeometryNodeType;
    }

    private VRMLCoordinateNodeType findRealCoordinates(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType instanceof VRMLCoordinateNodeType) {
            return (VRMLCoordinateNodeType)vRMLNodeType;
        }
        VRMLCoordinateNodeType vRMLCoordinateNodeType = null;
        VRMLNodeType vRMLNodeType2 = vRMLNodeType;
        while (vRMLCoordinateNodeType == null) {
            if (vRMLNodeType2 instanceof VRMLCoordinateNodeType) {
                vRMLCoordinateNodeType = (VRMLCoordinateNodeType)vRMLNodeType2;
                continue;
            }
            if (vRMLNodeType2 instanceof VRMLProtoInstance) {
                VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType2;
                vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
                continue;
            }
            System.out.println("Non-coordinate proto found. Maybe extern proto?");
            break;
        }
        return vRMLCoordinateNodeType;
    }

    private void checkArraySize(int n) {
        if (this.lastNodeIndex + n < this.nodeList.length) {
            return;
        }
        int n2 = this.nodeList.length + 50;
        if (n2 < this.lastNodeIndex + n) {
            n2 += n;
        }
        VRMLNodeType[] vRMLNodeTypeArray = new VRMLNodeType[n2];
        float[] fArray = new float[n2 * 3];
        float[] fArray2 = new float[n2 * 3];
        float[] fArray3 = new float[n2 * 3];
        System.arraycopy(this.nodeList, 0, vRMLNodeTypeArray, 0, this.lastNodeIndex);
        System.arraycopy(this.coordList, 0, fArray, 0, this.lastCoordIndex);
        System.arraycopy(this.normalList, 0, fArray2, 0, this.lastCoordIndex);
        System.arraycopy(this.textureList, 0, fArray3, 0, this.lastCoordIndex);
        this.nodeList = vRMLNodeTypeArray;
        this.coordList = fArray;
        this.normalList = fArray2;
        this.textureList = fArray3;
    }

    private void checkBatchPicker(int n) {
        if (this.batchPicker.length >= n) {
            return;
        }
        PickRequest[] pickRequestArray = new PickRequest[n];
        System.arraycopy(this.batchPicker, 0, pickRequestArray, 0, this.batchPicker.length);
        for (int i = this.batchPicker.length; i < n; ++i) {
            pickRequestArray[i] = new PickRequest();
        }
        this.batchPicker = pickRequestArray;
    }

    private void setupPicker(PickRequest pickRequest, int n, int n2) {
        switch (n) {
            case 1: {
                pickRequest.useGeometry = false;
                break;
            }
            case 2: {
                pickRequest.useGeometry = true;
            }
        }
        switch (n2) {
            case 1: {
                pickRequest.pickSortType = 4;
                break;
            }
            case 2: {
                pickRequest.pickSortType = 1;
                break;
            }
            case 4: {
                pickRequest.pickSortType = 2;
                break;
            }
            case 3: {
                pickRequest.pickSortType = 3;
            }
        }
    }

    private void calculatePickMatrix(OGLPickingSensorNodeType oGLPickingSensorNodeType) {
        this.pickMatrix.setIdentity();
        int n = 0;
        for (Group group = oGLPickingSensorNodeType.getParentGroup(); group != null; group = group.getParent()) {
            if (!(group instanceof TransformGroup)) continue;
            if (this.matrixStack.length == n) {
                Matrix4f[] matrix4fArray = new Matrix4f[n + 16];
                System.arraycopy(this.matrixStack, 0, matrix4fArray, 0, n);
                for (int i = n; i < matrix4fArray.length; ++i) {
                    this.matrixStack[i] = new Matrix4f();
                }
                this.matrixStack = matrix4fArray;
            }
            ((TransformGroup)group).getTransform(this.matrixStack[n]);
            ++n;
        }
        int n2 = n;
        while (--n2 >= 0) {
            this.pickMatrix.mul(this.matrixStack[n2]);
        }
    }

    private void transformPosition(float[] fArray) {
        float f = this.pickMatrix.m00 * fArray[0] + this.pickMatrix.m01 * fArray[1] + this.pickMatrix.m02 * fArray[2] + this.pickMatrix.m03;
        float f2 = this.pickMatrix.m10 * fArray[0] + this.pickMatrix.m11 * fArray[1] + this.pickMatrix.m12 * fArray[2] + this.pickMatrix.m13;
        float f3 = this.pickMatrix.m20 * fArray[0] + this.pickMatrix.m21 * fArray[1] + this.pickMatrix.m22 * fArray[2] + this.pickMatrix.m23;
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
    }

    private void transformVector(float[] fArray) {
        float f = this.pickMatrix.m00 * fArray[0] + this.pickMatrix.m01 * fArray[1] + this.pickMatrix.m02 * fArray[2];
        float f2 = this.pickMatrix.m10 * fArray[0] + this.pickMatrix.m11 * fArray[1] + this.pickMatrix.m12 * fArray[2];
        float f3 = this.pickMatrix.m20 * fArray[0] + this.pickMatrix.m21 * fArray[1] + this.pickMatrix.m22 * fArray[2];
        fArray[0] = f;
        fArray[1] = f2;
        fArray[2] = f3;
    }

    private double detailLinePick(SceneGraphPath sceneGraphPath) {
        Node node = sceneGraphPath.getTerminalNode();
        double d = Double.POSITIVE_INFINITY;
        boolean bl = false;
        int n = -1;
        if (node instanceof Shape3D) {
            sceneGraphPath.getTransform(this.tmpMatrix);
            Geometry geometry = ((Shape3D)node).getGeometry();
            if (geometry instanceof VertexGeometry) {
                VertexGeometry vertexGeometry = (VertexGeometry)geometry;
                OGLUserData oGLUserData = (OGLUserData)((Object)vertexGeometry.getUserData());
                boolean bl2 = false;
                if (oGLUserData != null && oGLUserData.geometryData != null && oGLUserData.geometryData instanceof GeometryData) {
                    GeometryData geometryData = (GeometryData)oGLUserData.geometryData;
                    bl2 = this.iutils.rayUnknownGeometry(this.tmpPoint1, this.wkDirection, 0.0f, geometryData, this.tmpMatrix, this.wkPoint, true);
                } else {
                    bl2 = this.iutils.rayUnknownGeometry(this.tmpPoint1, this.wkDirection, 0.0f, vertexGeometry, this.tmpMatrix, this.wkPoint, true);
                }
                if (bl2) {
                    this.diffVec.sub((Tuple3d)this.tmpPoint1, (Tuple3d)this.wkPoint);
                    if (this.diffVec.lengthSquared() < d) {
                        d = this.diffVec.lengthSquared();
                        this.hitPoint[0] = (float)this.wkPoint.x;
                        this.hitPoint[1] = (float)this.wkPoint.y;
                        this.hitPoint[2] = (float)this.wkPoint.z;
                        bl = true;
                    }
                }
            }
        }
        return bl ? d : -1.0;
    }
}

