/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.input;

import java.util.ArrayList;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.SharedGroup;
import org.j3d.aviatrix3d.SharedNode;
import org.j3d.aviatrix3d.Texture2D;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.ViewEnvironment;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.j3d.util.MatrixUtils;
import org.web3d.vrml.nodes.VRMLBackgroundNodeType;
import org.web3d.vrml.nodes.VRMLFogNodeType;
import org.web3d.vrml.nodes.VRMLNavigationInfoNodeType;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.renderer.common.input.BaseLayerSensorManager;
import org.web3d.vrml.renderer.ogl.input.AreaManager;
import org.web3d.vrml.renderer.ogl.input.DefaultUserInputHandler;
import org.web3d.vrml.renderer.ogl.input.OGLGlobalEffectsHandler;
import org.web3d.vrml.renderer.ogl.input.VisibilityManager;
import org.web3d.vrml.renderer.ogl.nodes.OGLBackgroundNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLTransformNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;
import org.web3d.vrml.renderer.ogl.nodes.OGLVRMLNode;
import org.web3d.vrml.renderer.ogl.nodes.OGLViewpointNodeType;

public class DefaultLayerSensorManager
extends BaseLayerSensorManager {
    private static final Vector3f Z_AXIS = new Vector3f(0.0f, 0.0f, -1.0f);
    private OGLViewpointNodeType currentViewpoint;
    private OGLBackgroundNodeType currentBackground;
    private VRMLFogNodeType currentFog;
    private VRMLNavigationInfoNodeType currentNavInfo;
    private Matrix4f vpMatrix;
    private Matrix4f localMatrix;
    private Vector3f t3dPosition;
    private Point3f position;
    private Vector3f orientation;
    private AxisAngle4f oriAxisAngle;
    private VisibilityManager visibilityHandler;
    private OGLGlobalEffectsHandler globalEffects;
    private AreaManager areaHandler;
    private Texture2D[] tmpTextures;
    private boolean[] tmpTextureFlags;
    private float[] tmpColor;
    private float[] tmpAngle;
    private ArrayList pathList;
    private Node[] pathNodes;
    private MatrixUtils matrixUtils;
    private Group worldRoot;
    private ViewEnvironment viewEnvironment;
    private Vector3f posVector = new Vector3f();
    private float[] boundsMin = new float[3];
    private float[] boundsMax = new float[3];
    private float nearClip;
    private float farClip;

    public DefaultLayerSensorManager() {
        this.matrixUtils = new MatrixUtils();
        this.vpMatrix = new Matrix4f();
        this.localMatrix = new Matrix4f();
        this.t3dPosition = new Vector3f();
        this.position = new Point3f();
        this.orientation = new Vector3f();
        this.oriAxisAngle = new AxisAngle4f();
        this.inputHandler = new DefaultUserInputHandler();
        this.visibilityHandler = new VisibilityManager();
        this.areaHandler = new AreaManager();
        this.pathList = new ArrayList();
        this.pathNodes = new Node[20];
        this.tmpTextures = new Texture2D[6];
        this.tmpTextureFlags = new boolean[6];
        this.tmpColor = new float[24];
        this.tmpAngle = new float[7];
    }

    public void setGlobalEffectsHandler(OGLGlobalEffectsHandler oGLGlobalEffectsHandler) {
        this.globalEffects = oGLGlobalEffectsHandler;
    }

    public void setWorldRoot(Group group) {
        this.worldRoot = group;
        this.areaHandler.setWorldRoot(group);
        this.visibilityHandler.setWorldRoot(group);
    }

    public void setViewEnvironment(ViewEnvironment viewEnvironment) {
        this.viewEnvironment = viewEnvironment;
        this.visibilityHandler.setViewEnvironment(viewEnvironment);
    }

    public void setWorldScale(float f) {
        this.worldScale = f;
        this.invWorldScale = 1.0f / f;
        if (this.currentViewpoint != null) {
            this.currentViewpoint.setWorldScale(f);
        }
        this.visibilityHandler.setWorldScale(f);
    }

    public boolean processUserInput(long l) {
        VRMLFogNodeType vRMLFogNodeType;
        OGLBackgroundNodeType oGLBackgroundNodeType;
        VRMLNavigationInfoNodeType vRMLNavigationInfoNodeType;
        if (!this.initialised) {
            this.initialise();
        }
        if ((vRMLNavigationInfoNodeType = (VRMLNavigationInfoNodeType)this.navInfoStack.getBoundNode()) != this.currentNavInfo) {
            this.inputHandler.setNavigationInfo(vRMLNavigationInfoNodeType);
            this.currentNavInfo = vRMLNavigationInfoNodeType;
        }
        this.updateClipPlanes();
        OGLViewpointNodeType oGLViewpointNodeType = (OGLViewpointNodeType)this.viewStack.getBoundNode();
        if (oGLViewpointNodeType != this.currentViewpoint) {
            this.currentViewpoint = oGLViewpointNodeType;
            this.currentViewpoint.setWorldScale(this.worldScale);
        }
        if ((oGLBackgroundNodeType = (OGLBackgroundNodeType)this.backgroundStack.getBoundNode()) != this.currentBackground) {
            vRMLFogNodeType = oGLBackgroundNodeType.getBackgroundTextures();
            for (int i = 0; i < 6; ++i) {
                this.tmpTextureFlags[i] = true;
            }
            this.globalEffects.updateBackgroundTextures((Texture2D[])vRMLFogNodeType, this.tmpTextureFlags);
            this.backgroundSkyChanged = true;
            this.backgroundGroundChanged = true;
            this.updateBackgroundSphere(oGLBackgroundNodeType);
            if (this.currentBackground != null) {
                this.currentBackground.removeNodeListener((VRMLNodeListener)this.backgroundListener);
            }
            oGLBackgroundNodeType.addNodeListener((VRMLNodeListener)this.backgroundListener);
            this.currentBackground = oGLBackgroundNodeType;
        } else {
            if (oGLBackgroundNodeType.getChangedTextures(this.tmpTextures, this.tmpTextureFlags)) {
                this.globalEffects.updateBackgroundTextures(this.tmpTextures, this.tmpTextureFlags);
            }
            this.updateBackgroundSphere(this.currentBackground);
        }
        vRMLFogNodeType = (VRMLFogNodeType)this.fogStack.getBoundNode();
        float f = vRMLFogNodeType.getVisibilityRange();
        vRMLFogNodeType.getColor(this.tmpColor);
        int n = vRMLFogNodeType.getFogType();
        if (vRMLFogNodeType != this.currentFog) {
            this.globalEffects.enableFog(n);
            this.globalEffects.setFogDetails(f, this.tmpColor[0], this.tmpColor[1], this.tmpColor[2]);
            if (this.currentFog != null) {
                this.currentFog.removeNodeListener((VRMLNodeListener)this.fogListener);
            }
            vRMLFogNodeType.addNodeListener((VRMLNodeListener)this.fogListener);
            this.currentFog = vRMLFogNodeType;
        } else {
            if (this.fogTypeChanged) {
                this.globalEffects.enableFog(n);
            }
            if (this.fogDetailsChanged) {
                this.globalEffects.setFogDetails(f, this.tmpColor[0], this.tmpColor[1], this.tmpColor[2]);
            }
        }
        this.clearChangeFlags();
        TransformGroup transformGroup = this.currentViewpoint.getPlatformGroup();
        this.getLocalToVworld((Node)transformGroup, this.vpMatrix, true);
        this.vpMatrix.transform(Z_AXIS, this.orientation);
        this.vpMatrix.get(this.t3dPosition);
        this.position.set((Tuple3f)this.t3dPosition);
        this.oriAxisAngle.set(this.vpMatrix);
        if (this.numVisibilityListeners > 0) {
            this.visibilityHandler.processFrame(this.position, this.oriAxisAngle, this.vpMatrix);
        }
        float f2 = vRMLNavigationInfoNodeType.getVisibilityLimit();
        if (this.numAreaListeners > 0) {
            this.matrixUtils.inverse(this.vpMatrix, this.vpMatrix);
            this.areaHandler.processFrame(this.position, this.orientation, this.vpMatrix, f2);
        }
        Group group = (Group)this.currentBackground.getSceneGraphObject();
        this.getLocalToVworld((Node)group, this.vpMatrix, false);
        if (this.globalEffects != null) {
            this.globalEffects.setBackgroundMatrix(this.vpMatrix);
        }
        group = (Group)((OGLVRMLNode)this.currentFog).getSceneGraphObject();
        this.getLocalToVworld((Node)group, this.vpMatrix, false);
        if (this.globalEffects != null) {
            this.globalEffects.setFogMatrix(this.vpMatrix);
        }
        if (this.pickManager != null) {
            this.pickManager.processPickSensors((double)l);
        }
        return true;
    }

    public void updateViewMatrix() {
        if (this.globalEffects == null) {
            return;
        }
        if (this.currentViewpoint != null) {
            TransformGroup transformGroup = this.currentViewpoint.getPlatformGroup();
            this.getLocalToVworld((Node)transformGroup, this.vpMatrix, true);
            this.globalEffects.setViewMatrix(this.vpMatrix);
        }
    }

    public void clear() {
        super.clear();
        this.areaHandler.clear();
        this.visibilityHandler.clear();
        this.pathList.clear();
        for (int i = 0; i < this.pathNodes.length; ++i) {
            this.pathNodes[i] = null;
        }
        this.currentFog = null;
        this.currentNavInfo = null;
        this.currentViewpoint = null;
        this.currentBackground = null;
        this.worldRoot = null;
    }

    private void updateBackgroundSphere(VRMLBackgroundNodeType vRMLBackgroundNodeType) {
        int n;
        this.globalEffects.updateBackgroundTransparency(vRMLBackgroundNodeType.getTransparency());
        if (this.backgroundGroundChanged) {
            n = vRMLBackgroundNodeType.getNumGroundColors();
            if (n * 3 > this.tmpColor.length) {
                this.tmpColor = new float[n * 3];
                this.tmpAngle = new float[n - 1];
            }
            if (n != 0) {
                vRMLBackgroundNodeType.getGroundValues(this.tmpColor, this.tmpAngle);
            }
            this.globalEffects.updateBackgroundGround(this.tmpColor, this.tmpAngle, n);
        }
        if (this.backgroundSkyChanged) {
            n = vRMLBackgroundNodeType.getNumSkyColors();
            if (n * 3 > this.tmpColor.length) {
                this.tmpColor = new float[n * 3];
                this.tmpAngle = new float[n - 1];
            }
            if (n != 0) {
                vRMLBackgroundNodeType.getSkyValues(this.tmpColor, this.tmpAngle);
            }
            this.globalEffects.updateBackgroundSky(this.tmpColor, this.tmpAngle, n);
        }
    }

    private void getLocalToVworld(Node node, Matrix4f matrix4f, boolean bl) {
        OGLUserData oGLUserData;
        Node node2 = node.getParent();
        if (node instanceof TransformGroup) {
            if (bl) {
                oGLUserData = (OGLUserData)((Object)node.getUserData());
                if (oGLUserData != null) {
                    this.pathList.add(oGLUserData.owner);
                }
            } else {
                this.pathList.add(node);
            }
        }
        while (node2 != null) {
            int n;
            Object object;
            if (node2 instanceof SharedGroup) {
                object = (SharedGroup)node2;
                n = object.numParents();
                if (n == 0) break;
                if (n > this.pathNodes.length) {
                    this.pathNodes = new Node[n];
                }
                object.getParents(this.pathNodes);
                node2 = this.pathNodes[0];
                continue;
            }
            if (node2 instanceof SharedNode) {
                object = (SharedNode)node2;
                n = object.numParents();
                if (n == 0) break;
                if (n > this.pathNodes.length) {
                    this.pathNodes = new Node[n];
                }
                object.getParents(this.pathNodes);
                node2 = this.pathNodes[0];
                continue;
            }
            if (node2 instanceof TransformGroup) {
                ((TransformGroup)node2).getTransform(this.localMatrix);
                if (bl) {
                    object = node2.getUserData();
                    if (object instanceof OGLUserData) {
                        oGLUserData = (OGLUserData)((Object)object);
                        this.pathList.add(oGLUserData.owner);
                    } else {
                        oGLUserData = null;
                    }
                } else {
                    this.pathList.add(node2);
                }
            }
            node2 = node2.getParent();
        }
        int n = this.pathList.size();
        matrix4f.setIdentity();
        for (int i = n - 1; i >= 0; --i) {
            OGLTransformNodeType oGLTransformNodeType;
            Object e = this.pathList.get(i);
            if (e instanceof OGLTransformNodeType) {
                oGLTransformNodeType = (OGLTransformNodeType)e;
                Matrix4f matrix4f2 = oGLTransformNodeType.getTransform();
                matrix4f.mul(matrix4f2);
                continue;
            }
            oGLTransformNodeType = (TransformGroup)e;
            oGLTransformNodeType.getTransform(this.localMatrix);
            matrix4f.mul(this.localMatrix);
        }
        this.pathList.clear();
    }

    private void updateClipPlanes() {
        float f;
        float f2;
        float f3;
        if (this.viewEnvironment == null) {
            return;
        }
        this.inputHandler.getPosition(this.posVector);
        int n = 3000;
        float[] fArray = null;
        if (this.currentNavInfo != null) {
            f3 = this.currentNavInfo.getVisibilityLimit();
            fArray = this.currentNavInfo.getAvatarSize();
            f2 = fArray[0] / 2.0f;
        } else {
            f3 = 0.0f;
            f2 = 0.125f;
        }
        if ((double)f2 < 0.001) {
            f2 = 0.001f;
        }
        if (f3 == 0.0f) {
            BoundingVolume boundingVolume = this.worldRoot.getBounds();
            float f4 = this.getMaxExtent(boundingVolume, this.posVector);
            if ((f4 *= 1.1f) > Float.MAX_VALUE) {
                f4 = Float.MAX_VALUE;
            }
            f = f4 > (float)n ? f4 : (float)n;
        } else {
            f = f3;
        }
        if (f2 > f) {
            f = f2 * 3000.0f;
        }
        if ((double)Math.abs(this.nearClip - f2) >= 0.001 || (double)Math.abs(this.farClip - f) > 0.1) {
            this.viewEnvironment.setClipDistance((double)f2, (double)f);
            this.nearClip = f2;
            this.farClip = f;
        }
    }

    private float getMaxExtent(BoundingVolume boundingVolume, Vector3f vector3f) {
        double d;
        boundingVolume.getExtents(this.boundsMin, this.boundsMax);
        float f = this.boundsMax[0] - this.boundsMin[0];
        float f2 = vector3f.x - this.boundsMin[0];
        float f3 = vector3f.x - this.boundsMax[0];
        float f4 = this.boundsMax[1] - this.boundsMin[1];
        float f5 = vector3f.y - this.boundsMin[1];
        float f6 = vector3f.y - this.boundsMax[1];
        float f7 = this.boundsMax[2] - this.boundsMin[2];
        float f8 = vector3f.z - this.boundsMin[2];
        float f9 = vector3f.z - this.boundsMax[2];
        double d2 = d = (double)(f * f + f4 * f4 + f7 * f7);
        d = f * f2 + f5 * f5 + f8 * f8;
        if (d > d2) {
            d2 = d;
        }
        if ((d = (double)(f3 * f3 + f6 * f6 + f9 * f9)) > d2) {
            d2 = d;
        }
        return (float)Math.sqrt(d2);
    }
}

