/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.input;

import java.util.ArrayList;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.SceneGraphPath;
import org.j3d.aviatrix3d.picking.PickRequest;
import org.web3d.util.HashSet;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.renderer.ogl.nodes.OGLAreaListener;
import org.web3d.vrml.renderer.ogl.nodes.OGLUserData;

class AreaManager {
    private static final int LIST_START_SIZE = 25;
    private static final int LIST_INCREMENT = 25;
    private Group worldRoot;
    private HashSet activeObjects;
    private HashSet newObjects;
    private OGLAreaListener[] list;
    private int lastListener;
    private PickRequest rayPicker;
    private Matrix4f localTx;
    private PickRequest picker = new PickRequest();

    AreaManager() {
        this.picker.pickType = 8;
        this.picker.pickGeometryType = 1;
        this.picker.pickSortType = 1;
        this.picker.generateVWorldMatrix = true;
        this.picker.foundPaths = new ArrayList();
        this.localTx = new Matrix4f();
        this.activeObjects = new HashSet();
        this.newObjects = new HashSet();
        this.list = new OGLAreaListener[25];
        this.lastListener = 0;
    }

    void addSensor(VRMLSensorNodeType vRMLSensorNodeType) {
    }

    void removeSensor(VRMLSensorNodeType vRMLSensorNodeType) {
    }

    void setWorldRoot(Group group) {
        this.worldRoot = group;
    }

    void clear() {
        this.activeObjects.clear();
        this.newObjects.clear();
    }

    void processFrame(Point3f point3f, Vector3f vector3f, Matrix4f matrix4f, float f) {
        int n;
        Object object;
        int n2;
        if (this.worldRoot == null) {
            return;
        }
        this.picker.origin[0] = point3f.x;
        this.picker.origin[1] = point3f.y;
        this.picker.origin[2] = point3f.z;
        this.worldRoot.pickSingle(this.picker);
        if (this.picker.pickCount != 0) {
            this.newObjects.clear();
            ArrayList arrayList = (ArrayList)this.picker.foundPaths;
            for (n2 = 0; n2 < this.picker.pickCount; ++n2) {
                object = (SceneGraphPath)arrayList.get(n2);
                Node node = object.getTerminalNode();
                OGLUserData oGLUserData = (OGLUserData)((Object)node.getUserData());
                if (oGLUserData == null || oGLUserData.areaListener == null) continue;
                OGLAreaListener oGLAreaListener = oGLUserData.areaListener;
                object.getTransform(this.localTx);
                if (this.activeObjects.contains((Object)oGLAreaListener)) {
                    oGLAreaListener.userPositionChanged(point3f, vector3f, matrix4f, this.localTx);
                    this.activeObjects.remove((Object)oGLAreaListener);
                } else {
                    oGLAreaListener.areaEntry(point3f, vector3f, matrix4f, this.localTx);
                }
                this.newObjects.add((Object)oGLAreaListener);
            }
        }
        if ((n = this.activeObjects.size()) != 0) {
            this.resizeList(n);
            this.activeObjects.toArray((Object[])this.list);
            for (n2 = 0; n2 < n && this.list[n2] != null; ++n2) {
                object = this.list[n2];
                object.areaExit();
                this.activeObjects.remove(object);
            }
        }
        HashSet hashSet = this.activeObjects;
        this.activeObjects = this.newObjects;
        this.newObjects = hashSet;
    }

    private final void resizeList(int n) {
        if (this.list.length < n) {
            int n2 = this.list.length;
            int n3 = n2 + 25;
            OGLAreaListener[] oGLAreaListenerArray = new OGLAreaListener[n3];
            System.arraycopy(this.list, 0, oGLAreaListenerArray, 0, n2);
            this.list = oGLAreaListenerArray;
        }
    }
}

