/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import java.util.ArrayList;
import java.util.HashMap;
import org.j3d.aviatrix3d.Viewport;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;
import org.web3d.vrml.nodes.VRMLViewportNodeType;
import org.web3d.vrml.renderer.ogl.browser.CustomViewportData;
import org.web3d.vrml.renderer.ogl.browser.FixedViewportData;
import org.web3d.vrml.renderer.ogl.browser.ProportionalViewportData;

class ViewportResizeManager
implements GraphicsResizeListener {
    private ArrayList fullscreenViewports;
    private ArrayList fixedViewports;
    private ArrayList customViewports = new ArrayList();
    private ArrayList proportionalViewports;
    private HashMap viewDataMap;
    private boolean newSizeSet = false;
    private int viewX;
    private int viewY;
    private int viewCenterX;
    private int viewCenterY;
    private int viewWidth;
    private int viewHeight;
    private boolean validSizeSet = false;

    ViewportResizeManager() {
        this.fixedViewports = new ArrayList();
        this.fullscreenViewports = new ArrayList();
        this.proportionalViewports = new ArrayList();
        this.viewDataMap = new HashMap();
    }

    public void graphicsDeviceResized(int n, int n2, int n3, int n4) {
        this.viewX = n;
        this.viewY = n2;
        this.viewWidth = n3;
        this.viewHeight = n4;
        this.viewCenterX = n + n3 >> 1;
        this.viewCenterY = n2 + n4 >> 1;
        this.newSizeSet = true;
        this.validSizeSet = true;
    }

    void sendResizeUpdates() {
        Object object;
        int n;
        if (!this.newSizeSet) {
            return;
        }
        for (n = 0; n < this.fullscreenViewports.size(); ++n) {
            object = (Viewport)this.fullscreenViewports.get(n);
            object.setDimensions(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
        }
        for (n = 0; n < this.fixedViewports.size(); ++n) {
            object = (FixedViewportData)this.fixedViewports.get(n);
            this.processViewportChange((FixedViewportData)object);
        }
        for (n = 0; n < this.proportionalViewports.size(); ++n) {
            object = (ProportionalViewportData)this.proportionalViewports.get(n);
            this.processViewportChange((ProportionalViewportData)object);
        }
        for (n = 0; n < this.customViewports.size(); ++n) {
            object = (CustomViewportData)this.customViewports.get(n);
            this.processViewportChange((CustomViewportData)object);
        }
        this.newSizeSet = false;
    }

    void addFullscreenViewport(Viewport viewport) {
        if (viewport == null || this.fullscreenViewports.contains(viewport)) {
            return;
        }
        this.fullscreenViewports.add(viewport);
        if (this.validSizeSet) {
            viewport.setDimensions(this.viewX, this.viewY, this.viewWidth, this.viewHeight);
        }
    }

    void removeFullscreenViewport(Viewport viewport) {
        if (viewport == null) {
            return;
        }
        this.fullscreenViewports.remove(viewport);
    }

    void addFixedViewport(VRMLViewportNodeType vRMLViewportNodeType, Viewport viewport) {
        if (viewport == null || this.viewDataMap.containsKey(viewport)) {
            return;
        }
        FixedViewportData fixedViewportData = new FixedViewportData();
        fixedViewportData.viewport = viewport;
        fixedViewportData.viewX = (int)vRMLViewportNodeType.getViewX();
        fixedViewportData.viewY = (int)vRMLViewportNodeType.getViewY();
        fixedViewportData.viewWidth = (int)vRMLViewportNodeType.getViewWidth();
        fixedViewportData.viewHeight = (int)vRMLViewportNodeType.getViewHeight();
        this.fixedViewports.add(fixedViewportData);
        this.viewDataMap.put(viewport, fixedViewportData);
        if (this.validSizeSet) {
            this.processViewportChange(fixedViewportData);
        }
    }

    void removeFixedViewport(VRMLViewportNodeType vRMLViewportNodeType, Viewport viewport) {
        if (viewport == null) {
            return;
        }
        Object v = this.viewDataMap.remove(viewport);
        this.fixedViewports.remove(v);
    }

    void addProportionalViewport(VRMLViewportNodeType vRMLViewportNodeType, Viewport viewport) {
        if (viewport == null || this.viewDataMap.containsKey(viewport)) {
            return;
        }
        ProportionalViewportData proportionalViewportData = new ProportionalViewportData();
        proportionalViewportData.viewport = viewport;
        proportionalViewportData.viewX = vRMLViewportNodeType.getViewX();
        proportionalViewportData.viewY = vRMLViewportNodeType.getViewY();
        proportionalViewportData.viewWidth = vRMLViewportNodeType.getViewWidth();
        proportionalViewportData.viewHeight = vRMLViewportNodeType.getViewHeight();
        this.proportionalViewports.add(proportionalViewportData);
        this.viewDataMap.put(viewport, proportionalViewportData);
        if (this.validSizeSet) {
            this.processViewportChange(proportionalViewportData);
        }
    }

    void removeProportionalViewport(VRMLViewportNodeType vRMLViewportNodeType, Viewport viewport) {
        if (viewport == null) {
            return;
        }
        Object v = this.viewDataMap.remove(viewport);
        this.proportionalViewports.remove(v);
    }

    void addCustomViewport(VRMLViewportNodeType vRMLViewportNodeType, Viewport viewport) {
        if (viewport == null || this.viewDataMap.containsKey(viewport)) {
            return;
        }
        CustomViewportData customViewportData = new CustomViewportData();
        customViewportData.viewport = viewport;
        customViewportData.fixedX = vRMLViewportNodeType.isFixedX();
        customViewportData.fixedY = vRMLViewportNodeType.isFixedY();
        customViewportData.fixedWidth = vRMLViewportNodeType.isFixedWidth();
        customViewportData.fixedHeight = vRMLViewportNodeType.isFixedHeight();
        customViewportData.viewX = vRMLViewportNodeType.getViewX();
        customViewportData.viewY = vRMLViewportNodeType.getViewY();
        customViewportData.viewWidth = vRMLViewportNodeType.getViewWidth();
        customViewportData.viewHeight = vRMLViewportNodeType.getViewHeight();
        this.customViewports.add(customViewportData);
        this.viewDataMap.put(viewport, customViewportData);
        if (this.validSizeSet) {
            this.processViewportChange(customViewportData);
        }
    }

    void removeCustomViewport(VRMLViewportNodeType vRMLViewportNodeType, Viewport viewport) {
        if (viewport == null) {
            return;
        }
        Object v = this.viewDataMap.remove(viewport);
        this.customViewports.remove(v);
    }

    void clear() {
        this.customViewports.clear();
        this.fixedViewports.clear();
        this.fullscreenViewports.clear();
        this.proportionalViewports.clear();
        this.viewDataMap.clear();
    }

    private void processViewportChange(ProportionalViewportData proportionalViewportData) {
        int n = (int)((float)this.viewCenterX + proportionalViewportData.viewX * (float)this.viewWidth);
        int n2 = (int)((float)this.viewCenterY + proportionalViewportData.viewY * (float)this.viewHeight);
        int n3 = (int)(proportionalViewportData.viewWidth * (float)this.viewWidth);
        int n4 = (int)(proportionalViewportData.viewHeight * (float)this.viewHeight);
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        proportionalViewportData.viewport.setDimensions(n, n2, n3, n4);
    }

    private void processViewportChange(FixedViewportData fixedViewportData) {
        int n = this.viewCenterX + fixedViewportData.viewX;
        int n2 = this.viewCenterY + fixedViewportData.viewY;
        int n3 = fixedViewportData.viewWidth;
        int n4 = fixedViewportData.viewHeight;
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        fixedViewportData.viewport.setDimensions(n, n2, n3, n4);
    }

    private void processViewportChange(CustomViewportData customViewportData) {
        int n;
        int n2 = customViewportData.fixedX ? (int)((float)this.viewCenterX + customViewportData.viewX) : (int)((float)this.viewCenterX + customViewportData.viewX * (float)this.viewWidth);
        int n3 = customViewportData.fixedY ? (int)((float)this.viewCenterY + customViewportData.viewY) : (int)((float)this.viewCenterY + customViewportData.viewY * (float)this.viewHeight);
        int n4 = customViewportData.fixedWidth ? (int)customViewportData.viewWidth : (int)(customViewportData.viewWidth * (float)this.viewWidth);
        int n5 = n = customViewportData.fixedHeight ? (int)customViewportData.viewHeight : (int)(customViewportData.viewHeight * (float)this.viewHeight);
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n < 0) {
            n3 += n;
            n = -n;
        }
        customViewportData.viewport.setDimensions(n2, n3, n4, n);
    }
}

