/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import java.util.ArrayList;
import java.util.HashMap;
import org.j3d.aviatrix3d.ViewEnvironment;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.ViewpointListener;
import org.web3d.vrml.renderer.ogl.browser.ViewpointData;

class ViewpointResizeManager
implements GraphicsResizeListener,
ViewpointListener {
    private static final float DEG_TO_RAD = 57.29578f;
    private ArrayList perspectiveViewpoints = new ArrayList();
    private ArrayList orthoViewpoints = new ArrayList();
    private HashMap nodeDataMap = new HashMap();
    private boolean updateRequired = false;
    private int viewX;
    private int viewY;
    private int viewWidth;
    private int viewHeight;
    private float aspectRatio;
    private boolean validSizeSet = false;
    private float hardwareFOV;

    ViewpointResizeManager() {
    }

    public void graphicsDeviceResized(int n, int n2, int n3, int n4) {
        this.viewX = n;
        this.viewY = n2;
        this.viewWidth = n3;
        this.viewHeight = n4;
        this.aspectRatio = (float)n3 / (float)n4;
        this.updateRequired = true;
        this.validSizeSet = true;
    }

    public void centerOfRotationChanged(float[] fArray) {
    }

    public void fieldOfViewChanged(float[] fArray) {
        this.updateRequired = true;
    }

    protected void setHardwareFOV(float f) {
        this.hardwareFOV = f;
        this.updateRequired = true;
    }

    void sendResizeUpdates() {
        int n;
        if (!this.updateRequired) {
            return;
        }
        for (n = 0; n < this.perspectiveViewpoints.size(); ++n) {
            this.processPerspectiveViewpointChange((ViewpointData)this.perspectiveViewpoints.get(n));
        }
        for (n = 0; n < this.orthoViewpoints.size(); ++n) {
            this.processOrthoViewpointChange((ViewpointData)this.orthoViewpoints.get(n));
        }
        this.updateRequired = false;
    }

    void addViewpoint(VRMLViewpointNodeType vRMLViewpointNodeType, ViewEnvironment viewEnvironment) {
        if (viewEnvironment == null || this.nodeDataMap.containsKey(viewEnvironment)) {
            return;
        }
        ViewpointData viewpointData = new ViewpointData();
        viewpointData.viewpoint = vRMLViewpointNodeType;
        viewpointData.viewEnvironment = viewEnvironment;
        this.nodeDataMap.put(vRMLViewpointNodeType, viewpointData);
        int n = vRMLViewpointNodeType.getProjectionType();
        if (n == 0) {
            this.perspectiveViewpoints.add(viewpointData);
            if (this.validSizeSet) {
                this.processPerspectiveViewpointChange(viewpointData);
            }
        } else if (n == 1) {
            this.orthoViewpoints.add(viewpointData);
            if (this.validSizeSet) {
                this.processOrthoViewpointChange(viewpointData);
            }
        } else {
            System.out.println("Unknown projection type in ViewpointResizeManager");
        }
        vRMLViewpointNodeType.addViewpointListener((ViewpointListener)this);
    }

    void removeViewpoint(VRMLViewpointNodeType vRMLViewpointNodeType) {
        if (vRMLViewpointNodeType == null) {
            return;
        }
        ViewpointData viewpointData = (ViewpointData)this.nodeDataMap.get(vRMLViewpointNodeType);
        this.nodeDataMap.remove(vRMLViewpointNodeType);
        int n = vRMLViewpointNodeType.getProjectionType();
        if (n == 0) {
            this.perspectiveViewpoints.remove(viewpointData);
        } else if (n == 1) {
            this.orthoViewpoints.remove(viewpointData);
        } else {
            System.out.println("Unknown projection type in ViewpointResizeManager");
        }
        vRMLViewpointNodeType.removeViewpointListener((ViewpointListener)this);
    }

    void clear() {
        this.perspectiveViewpoints.clear();
        this.orthoViewpoints.clear();
        this.nodeDataMap.clear();
    }

    private void processPerspectiveViewpointChange(ViewpointData viewpointData) {
        float f = this.hardwareFOV != 0.0f ? this.hardwareFOV : viewpointData.viewpoint.getFieldOfView()[0] * 57.29578f;
        viewpointData.viewEnvironment.setFieldOfView((double)f);
    }

    private void processOrthoViewpointChange(ViewpointData viewpointData) {
        boolean bl = false;
        boolean bl2 = false;
        float[] fArray = viewpointData.viewpoint.getFieldOfView();
        double d = -1.0;
        double d2 = -1.0;
        double d3 = 1.0;
        double d4 = 1.0;
        if ((double)Math.abs(fArray[0] - fArray[2]) < 0.001) {
            bl = true;
        }
        if ((double)Math.abs(fArray[1] - fArray[3]) < 0.001) {
            bl2 = true;
        }
        if (!bl && !bl2) {
            d = fArray[0];
            d2 = fArray[2];
            d3 = fArray[1];
            d4 = fArray[3];
        } else if (bl && bl2) {
            if (this.viewWidth > this.viewHeight) {
                d3 = -1.0;
                d4 = 1.0;
                double d5 = (double)this.viewWidth / (double)this.viewHeight;
                d = -d5;
                d2 = d5;
            } else {
                d = -1.0;
                d2 = 1.0;
                double d6 = (double)this.viewHeight / (double)this.viewWidth;
                d3 = -d6;
                d4 = d6;
            }
        } else if (bl) {
            d3 = -1.0;
            d4 = 1.0;
            double d7 = (double)this.viewWidth / (double)this.viewHeight;
            d = -d7;
            d2 = d7;
        } else if (bl2) {
            d = -1.0;
            d2 = 1.0;
            double d8 = (double)this.viewHeight / (double)this.viewWidth;
            d3 = -d8;
            d4 = d8;
        }
        viewpointData.viewEnvironment.setOrthoParams(d, d2, d3, d4);
    }
}

