/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.BlendAttributes;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.TriangleStripArray;
import org.j3d.geom.GeometryData;
import org.j3d.geom.terrain.ColorRampGenerator;

class SkySphere
extends Shape3D
implements NodeUpdateListener {
    private static final int DEFAULT_NUM_SPHERE_FACES = 32;
    private static final float[] SIN_TABLE;
    private static final float[] COS_TABLE;
    private Appearance appearance;
    private Material material;
    private int currentNumSkyColors = 0;
    private ColorRampGenerator skyColorCreator;
    private GeometryData skyData;
    private int maxSkyColors = 0;
    private float[] skyHeights;
    private float[][] skyColors = new float[1][4];
    private int numSkyColors;
    private float transparency = 1.0f;
    private TriangleStripArray skyGeometry;

    SkySphere() {
        this.skyData = new GeometryData();
        this.skyData.geometryType = 3;
        this.skyData.geometryComponents = 2;
        this.generateSphereGeom(32);
        this.skyData.colors = new float[this.skyData.vertexCount * 4];
        this.material = new Material();
        this.material.setLightingEnabled(false);
        BlendAttributes blendAttributes = new BlendAttributes();
        blendAttributes.setSourceBlendFactor(770);
        blendAttributes.setDestinationBlendFactor(771);
        this.appearance = new Appearance();
        this.appearance.setMaterial(this.material);
        this.appearance.setBlendAttributes(blendAttributes);
        this.appearance.setVisible(false);
        this.skyGeometry = new TriangleStripArray(true, 35044);
        this.skyGeometry.setVertices(3, this.skyData.coordinates, this.skyData.vertexCount);
        this.skyGeometry.setStripCount(this.skyData.stripCounts, this.skyData.numStrips);
        this.setAppearance(this.appearance);
        this.setGeometry((Geometry)this.skyGeometry);
    }

    public void updateNodeBoundsChanges(Object object) {
    }

    public void updateNodeDataChanges(Object object) {
        if (object == this.appearance) {
            boolean bl = this.numSkyColors > 1 || this.transparency != 0.0f;
            this.appearance.setVisible(bl);
        } else if (object == this.skyGeometry) {
            this.skyGeometry.setColors(true, this.skyData.colors);
        } else if (object == this.material) {
            this.material.setTransparency(this.transparency);
        }
    }

    void updateBackgroundTransparency(float f) {
        this.transparency = 1.0f - f;
        if (this.material.isLive()) {
            this.material.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.material);
        }
        if (this.numSkyColors > 1) {
            if (this.appearance.isLive()) {
                this.appearance.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.appearance);
            }
        }
    }

    void updateSkyColors(float[] fArray, float[] fArray2, int n) {
        if (n != 0) {
            this.updateSkySphereGeom(fArray, fArray2, n);
        }
        this.numSkyColors = n;
        if (this.appearance.isLive()) {
            this.appearance.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.appearance);
        }
    }

    private void updateSkySphereGeom(float[] fArray, float[] fArray2, int n) {
        int n2;
        if (this.skyColorCreator == null) {
            this.skyColorCreator = new ColorRampGenerator();
        }
        boolean bl = (double)fArray2[n - 1] < Math.PI;
        int n3 = n;
        if (bl) {
            ++n3;
        }
        if (this.skyHeights == null || this.skyHeights.length != n3) {
            this.skyHeights = new float[n3];
            this.skyColors = new float[n3][4];
        }
        int n4 = 0;
        this.skyHeights[0] = 1.0f;
        this.skyColors[0][0] = fArray[n4++];
        this.skyColors[0][1] = fArray[n4++];
        this.skyColors[0][2] = fArray[n4++];
        this.skyColors[0][3] = this.transparency;
        for (n2 = 1; n2 < n3 - 1; ++n2) {
            this.skyHeights[n2] = (float)Math.cos(fArray2[n2 - 1]);
            this.skyColors[n2][0] = fArray[n4++];
            this.skyColors[n2][1] = fArray[n4++];
            this.skyColors[n2][2] = fArray[n4++];
            this.skyColors[n2][3] = this.transparency;
        }
        n2 = n3 - 1;
        this.skyHeights[n2] = -1.0f;
        if (bl) {
            this.skyColors[n2][0] = fArray[n4 - 3];
            this.skyColors[n2][1] = fArray[n4 - 2];
            this.skyColors[n2][2] = fArray[n4 - 1];
            this.skyColors[n2][3] = this.transparency;
        } else {
            this.skyColors[n2][0] = fArray[n4++];
            this.skyColors[n2][1] = fArray[n4++];
            this.skyColors[n2][2] = fArray[n4++];
            this.skyColors[n2][3] = this.transparency;
        }
        this.skyColorCreator.setColorRamp(this.skyHeights, this.skyColors);
        this.skyColorCreator.generate(this.skyData);
        if (this.skyGeometry.isLive()) {
            this.skyGeometry.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.skyGeometry);
        }
    }

    private void generateSphereGeom(int n) {
        int n2;
        int n3 = n + 1 << 1;
        this.skyData.numStrips = n >> 1;
        int n4 = (n + 1) * n;
        this.skyData.stripCounts = new int[n];
        for (int i = 0; i < n; ++i) {
            this.skyData.stripCounts[i] = n3;
        }
        this.skyData.vertexCount = n4;
        this.skyData.coordinates = new float[n4 * 3];
        this.skyData.normals = new float[n4 * 3];
        double d = Math.PI * 2 / (double)n;
        float f = 1.0f / (float)n;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        for (n2 = 0; n2 < n; ++n2) {
            fArray2[n2] = (float)Math.cos(d * (double)n2);
            fArray3[n2] = (float)Math.sin(d * (double)n2);
            fArray[n2] = (float)n2 * f;
        }
        n2 = n / 2;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            float f2;
            float f3;
            float f4;
            float f5 = (float)Math.cos(d * (double)i);
            float f6 = (float)Math.sin(d * (double)i);
            float f7 = (float)Math.cos(d * (double)(i + 1));
            float f8 = (float)Math.sin(d * (double)(i + 1));
            for (int j = 0; j < n; ++j) {
                f4 = -fArray3[j] * f6;
                f3 = f5;
                f2 = fArray2[j] * f6;
                this.skyData.coordinates[n5++] = f4;
                this.skyData.coordinates[n5++] = f3;
                this.skyData.coordinates[n5++] = f2;
                this.skyData.normals[n6++] = -f4;
                this.skyData.normals[n6++] = -f3;
                this.skyData.normals[n6++] = -f2;
                f4 = -fArray3[j] * f8;
                f3 = f7;
                f2 = fArray2[j] * f8;
                this.skyData.coordinates[n5++] = f4;
                this.skyData.coordinates[n5++] = f3;
                this.skyData.coordinates[n5++] = f2;
                this.skyData.normals[n6++] = -f4;
                this.skyData.normals[n6++] = -f3;
                this.skyData.normals[n6++] = -f2;
            }
            f4 = -fArray3[0] * f6;
            f3 = f5;
            f2 = fArray2[0] * f6;
            this.skyData.coordinates[n5++] = f4;
            this.skyData.coordinates[n5++] = f3;
            this.skyData.coordinates[n5++] = f2;
            this.skyData.normals[n6++] = -f4;
            this.skyData.normals[n6++] = -f3;
            this.skyData.normals[n6++] = -f2;
            f4 = -fArray3[0] * f8;
            f3 = f7;
            f2 = fArray2[0] * f8;
            this.skyData.coordinates[n5++] = f4;
            this.skyData.coordinates[n5++] = f3;
            this.skyData.coordinates[n5++] = f2;
            this.skyData.normals[n6++] = -f4;
            this.skyData.normals[n6++] = -f3;
            this.skyData.normals[n6++] = -f2;
        }
    }

    static {
        COS_TABLE = new float[32];
        SIN_TABLE = new float[32];
        double d = 0.19634954084936207;
        for (int i = 0; i < 32; ++i) {
            SkySphere.COS_TABLE[i] = (float)Math.cos(d * (double)i + 1.5707963267948966);
            SkySphere.SIN_TABLE[i] = (float)Math.sin(d * (double)i + 1.5707963267948966);
        }
    }
}

