/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.ApplicationUpdateObserver;
import org.j3d.aviatrix3d.Layer;
import org.j3d.aviatrix3d.SimpleLayer;
import org.j3d.aviatrix3d.SimpleViewport;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.Viewport;
import org.j3d.aviatrix3d.management.DisplayCollection;
import org.j3d.aviatrix3d.management.RenderManager;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.browser.EventModelStatusListener;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.NodeObserver;
import org.web3d.browser.ProfilingListener;
import org.web3d.browser.ScreenCaptureListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.nodes.VRMLViewportNodeType;
import org.web3d.vrml.renderer.ogl.browser.ApplicationFrameManager;
import org.web3d.vrml.renderer.ogl.browser.OGLLayerManager;
import org.web3d.vrml.renderer.ogl.browser.ViewpointResizeManager;
import org.web3d.vrml.renderer.ogl.browser.ViewportResizeManager;
import org.xj3d.core.eventmodel.EventModelEvaluator;
import org.xj3d.core.eventmodel.EventModelInitListener;
import org.xj3d.core.eventmodel.LayerManager;
import org.xj3d.core.eventmodel.LayerRenderingManager;

public class OGLStandardBrowserCore
implements BrowserCore,
EventModelInitListener,
LayerRenderingManager {
    private static final String DISPOSE_EVENT_ERR_MSG = "Error sending dispose event ";
    private static final String SHUTDOWN_EVENT_ERR_MSG = "Error sending shutdown event ";
    private static final String FAILED_URL_ERR_MSG = "URL failed to load ";
    private static final String INIT_EVENT_ERR_MSG = "Error sending init event ";
    private static final int PAUSED_FPS = 4;
    private String worldDescription;
    private VRMLScene currentScene;
    private VRMLScene nextScene;
    private VRMLExecutionSpace currentSpace;
    private Map defMap;
    private ApplicationFrameManager frameManager;
    private RenderManager sceneManager;
    private DisplayCollection displayManager;
    private EventModelEvaluator eventModel;
    private ArrayList coreListeners;
    private ArrayList<ProfilingListener> profilingListeners;
    private TransformGroup vpTransformGroup;
    private long lastRenderTime;
    private float hardwareFOV;
    private ArrayList viewpointStatusListeners;
    private ArrayList sensorStatusListeners;
    private ArrayList navigationStateListeners;
    private SimpleLayer[] activeLayers;
    private int[] renderOrder;
    private SimpleLayer[] allLayers;
    private OGLLayerManager[] allManagers;
    private int numActiveLayers;
    private ViewportResizeManager viewportManager;
    private ViewpointResizeManager viewpointManager;
    private ErrorReporter errorReporter;
    private int globalRenderingStyle;
    private boolean stereoEnabled;
    private String nextNavigationMode;
    private boolean fitToWorldChanged;
    private boolean animateFitToWorld;
    private boolean hardwareFOVChanged;
    private float nextHardwareFOV;
    private boolean stereoEnabledChanged;
    private boolean nextStereoEnabled;
    private boolean screenCaptureOnceChanged;
    private boolean screenCaptureStartChanged;
    private boolean screenCaptureEndChanged;
    private ScreenCaptureListener screenCaptureListener;
    private int frameCycleTime;
    private int userCycleTime;
    private int internalCycleTime;

    public OGLStandardBrowserCore(EventModelEvaluator eventModelEvaluator, RenderManager renderManager, DisplayCollection displayCollection) {
        this.eventModel = eventModelEvaluator;
        this.eventModel.setInitListener((EventModelInitListener)this);
        this.sceneManager = renderManager;
        this.displayManager = displayCollection;
        SimpleViewport simpleViewport = new SimpleViewport();
        this.allManagers = new OGLLayerManager[1];
        this.activeLayers = new SimpleLayer[1];
        this.activeLayers[0] = new SimpleLayer();
        this.activeLayers[0].setViewport((Viewport)simpleViewport);
        this.allLayers = new SimpleLayer[1];
        this.allLayers[0] = this.activeLayers[0];
        this.numActiveLayers = 0;
        this.viewportManager = new ViewportResizeManager();
        this.viewportManager.addFullscreenViewport((Viewport)simpleViewport);
        this.viewpointManager = new ViewpointResizeManager();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.defMap = Collections.EMPTY_MAP;
        this.coreListeners = new ArrayList();
        this.sensorStatusListeners = new ArrayList(1);
        this.viewpointStatusListeners = new ArrayList(1);
        this.navigationStateListeners = new ArrayList(1);
        this.profilingListeners = new ArrayList(1);
        this.hardwareFOV = 0.0f;
        this.globalRenderingStyle = 4;
        this.frameManager = new ApplicationFrameManager(this.eventModel, this, this.viewportManager, this.viewpointManager);
        this.sceneManager.setApplicationObserver((ApplicationUpdateObserver)this.frameManager);
        this.frameCycleTime = 0;
        this.userCycleTime = 0;
        this.internalCycleTime = 0;
        this.sceneManager.setMinimumFrameInterval(2000);
    }

    public void worldInitComplete() {
        if (this.frameCycleTime < 0) {
            this.sceneManager.setMinimumFrameInterval(0);
        } else {
            this.sceneManager.setMinimumFrameInterval(this.frameCycleTime);
        }
        this.fireInitEvent();
    }

    public void changeWorld() {
        if (this.currentScene != null) {
            this.sceneManager.setMinimumFrameInterval(250);
            this.fireShutdownEvent();
        }
        this.currentScene = this.nextScene;
        if (this.currentScene != null) {
            this.currentSpace = (VRMLExecutionSpace)this.currentScene.getRootNode();
        }
        this.nextScene = null;
    }

    public int getRendererType() {
        return 3;
    }

    public String getIDString() {
        return "aviatrix3d";
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (this.errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void setMinimumFrameInterval(int n, boolean bl) {
        if (bl) {
            this.userCycleTime = n;
        } else {
            this.internalCycleTime = n;
        }
        int n2 = this.frameCycleTime;
        int n3 = this.frameCycleTime = this.userCycleTime >= this.internalCycleTime ? this.userCycleTime : this.internalCycleTime;
        if (this.frameCycleTime != n2) {
            this.sceneManager.setMinimumFrameInterval(this.frameCycleTime);
        }
    }

    public int getMinimumFrameInterval() {
        return this.sceneManager.getMinimumFrameInterval();
    }

    public VRMLClock getVRMLClock() {
        return this.eventModel.getVRMLClock();
    }

    public Map getDEFMappings() {
        return this.defMap;
    }

    public VRMLExecutionSpace getWorldExecutionSpace() {
        return this.currentSpace;
    }

    public String getDescription() {
        return this.worldDescription;
    }

    public void setDescription(String string) {
        this.worldDescription = string;
    }

    public float getCurrentSpeed() {
        return 0.0f;
    }

    public float getCurrentFrameRate() {
        float f = (float)this.lastRenderTime / 1000.0f;
        return 1.0f / f;
    }

    public void setLastRenderTime(long l) {
        this.lastRenderTime = l;
    }

    public void setEventModelStatusListener(EventModelStatusListener eventModelStatusListener) {
        this.frameManager.setEventModelStatusListener(eventModelStatusListener);
    }

    public void addNavigationStateListener(NavigationStateListener navigationStateListener) {
        if (navigationStateListener == null) {
            return;
        }
        if (!this.navigationStateListeners.contains(navigationStateListener)) {
            this.navigationStateListeners.add(navigationStateListener);
        }
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].addNavigationStateListener(navigationStateListener);
        }
    }

    public void removeNavigationStateListener(NavigationStateListener navigationStateListener) {
        if (navigationStateListener == null) {
            return;
        }
        this.navigationStateListeners.remove(navigationStateListener);
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].removeNavigationStateListener(navigationStateListener);
        }
    }

    public void addSensorStatusListener(SensorStatusListener sensorStatusListener) {
        if (sensorStatusListener == null) {
            return;
        }
        if (!this.sensorStatusListeners.contains(sensorStatusListener)) {
            this.sensorStatusListeners.add(sensorStatusListener);
        }
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].addSensorStatusListener(sensorStatusListener);
        }
    }

    public void removeSensorStatusListener(SensorStatusListener sensorStatusListener) {
        if (sensorStatusListener == null) {
            return;
        }
        this.sensorStatusListeners.remove(sensorStatusListener);
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].removeSensorStatusListener(sensorStatusListener);
        }
    }

    public void addViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        if (viewpointStatusListener == null) {
            return;
        }
        if (!this.viewpointStatusListeners.contains(viewpointStatusListener)) {
            this.viewpointStatusListeners.add(viewpointStatusListener);
        }
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].addViewpointStatusListener(viewpointStatusListener);
        }
    }

    public void removeViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        if (viewpointStatusListener == null) {
            return;
        }
        this.viewpointStatusListeners.remove(viewpointStatusListener);
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].removeViewpointStatusListener(viewpointStatusListener);
        }
    }

    public void addNodeObserver(int n, NodeObserver nodeObserver) {
        this.eventModel.addNodeObserver(n, nodeObserver);
    }

    public void removeNodeObserver(int n, NodeObserver nodeObserver) {
        this.eventModel.removeNodeObserver(n, nodeObserver);
    }

    public void dispose() {
        this.fireDisposeEvent();
    }

    public String getWorldURL() {
        String string = null;
        string = this.currentScene != null ? this.currentScene.getWorldRootURL() : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("user.dir");
                string = string.replace('\\', '/');
                string = "file:///" + string;
                return string;
            }
        });
        return string;
    }

    public void setScene(VRMLScene vRMLScene, String string) {
        this.nextScene = vRMLScene;
        this.eventModel.setScene(vRMLScene, string);
    }

    public void changeViewpoint(VRMLViewpointNodeType vRMLViewpointNodeType) {
        this.eventModel.changeViewpoint(vRMLViewpointNodeType);
    }

    public void addCoreListener(BrowserCoreListener browserCoreListener) {
        if (browserCoreListener != null && !this.coreListeners.contains(browserCoreListener)) {
            this.coreListeners.add(browserCoreListener);
        }
    }

    public void removeCoreListener(BrowserCoreListener browserCoreListener) {
        this.coreListeners.remove(browserCoreListener);
    }

    public void addProfilingListener(ProfilingListener profilingListener) {
        if (profilingListener == null) {
            return;
        }
        if (!this.profilingListeners.contains(profilingListener)) {
            this.profilingListeners.add(profilingListener);
        }
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].addProfilingListener(profilingListener);
        }
    }

    public void removeProfilingListener(ProfilingListener profilingListener) {
        if (profilingListener == null) {
            return;
        }
        if (!this.profilingListeners.contains(profilingListener)) {
            this.profilingListeners.remove(profilingListener);
        }
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].removeProfilingListener(profilingListener);
        }
    }

    public void sendURLFailEvent(String string) {
        this.fireFailedURL(string);
    }

    public void setNavigationMode(String string) {
        this.nextNavigationMode = string;
    }

    public void getUserPosition(Vector3f vector3f, AxisAngle4f axisAngle4f) {
        LayerManager layerManager = this.getActiveNavLayer();
        layerManager.getUserPosition(vector3f, axisAngle4f);
    }

    public void fitToWorld(boolean bl) {
        this.fitToWorldChanged = true;
        this.animateFitToWorld = bl;
    }

    public void syncUIUpdates() {
        LayerManager layerManager;
        if (this.nextNavigationMode != null) {
            layerManager = this.getActiveNavLayer();
            layerManager.setNavigationMode(this.nextNavigationMode);
            this.nextNavigationMode = null;
        }
        if (this.fitToWorldChanged) {
            layerManager = this.getActiveNavLayer();
            layerManager.fitToWorld(this.animateFitToWorld);
            this.fitToWorldChanged = false;
        }
        if (this.hardwareFOVChanged) {
            this.hardwareFOV = this.nextHardwareFOV;
            for (int i = 0; i < this.numActiveLayers; ++i) {
                this.allManagers[i].setHardwareFOV(this.hardwareFOV);
            }
            this.hardwareFOVChanged = false;
        }
        if (this.stereoEnabledChanged) {
            this.stereoEnabled = this.nextStereoEnabled;
            for (int i = 0; i < this.numActiveLayers; ++i) {
                this.allManagers[i].setStereoEnabled(this.stereoEnabled);
            }
            this.stereoEnabledChanged = false;
        }
        if (this.screenCaptureOnceChanged || this.screenCaptureStartChanged || this.screenCaptureEndChanged) {
            OGLLayerManager oGLLayerManager = this.allManagers[this.renderOrder[this.renderOrder.length - 1]];
            Viewport viewport = this.allLayers[this.renderOrder[this.renderOrder.length - 1]].getViewport();
            int n = viewport.getWidth();
            int n2 = viewport.getHeight();
            if (this.screenCaptureOnceChanged) {
                oGLLayerManager.captureScreenOnce(this.screenCaptureListener, n, n2);
                this.screenCaptureOnceChanged = false;
                this.screenCaptureListener = null;
            }
            if (this.screenCaptureStartChanged) {
                oGLLayerManager.captureScreenStart(this.screenCaptureListener, n, n2);
                this.screenCaptureStartChanged = false;
                this.screenCaptureListener = null;
            }
            if (this.screenCaptureEndChanged) {
                oGLLayerManager.captureScreenEnd();
                this.screenCaptureEndChanged = false;
            }
        }
    }

    public void setRenderingStyle(int n) throws IllegalArgumentException {
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].setRenderingStyle(n);
        }
        this.globalRenderingStyle = n;
    }

    public int getRenderingStyle() {
        return this.globalRenderingStyle;
    }

    public void setRenderingStyle(int n, int n2) throws IllegalArgumentException {
        this.allManagers[n2].setRenderingStyle(n);
    }

    public int getRenderingStyle(int n) {
        return this.allManagers[n].getRenderingStyle();
    }

    public void setActiveLayers(LayerManager[] layerManagerArray, int n) {
        if (this.allLayers.length < n) {
            this.allManagers = new OGLLayerManager[n];
            this.activeLayers = new SimpleLayer[n];
            this.allLayers = new SimpleLayer[n];
        }
        this.viewportManager.clear();
        for (int i = 0; i < n; ++i) {
            SensorStatusListener sensorStatusListener;
            int n2;
            OGLLayerManager oGLLayerManager = (OGLLayerManager)layerManagerArray[i];
            oGLLayerManager.setViewpointResizeManager(this.viewpointManager);
            oGLLayerManager.setHardwareFOV(this.hardwareFOV);
            oGLLayerManager.setStereoEnabled(this.stereoEnabled);
            this.allManagers[i] = oGLLayerManager;
            this.allLayers[i] = oGLLayerManager.getLayer();
            oGLLayerManager.setRenderingStyle(this.globalRenderingStyle);
            Viewport viewport = this.allLayers[i].getViewport();
            VRMLViewportNodeType vRMLViewportNodeType = oGLLayerManager.getViewport();
            switch (oGLLayerManager.getViewportType()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.viewportManager.addFullscreenViewport(viewport);
                    break;
                }
                case 2: {
                    this.viewportManager.addProportionalViewport(vRMLViewportNodeType, viewport);
                    break;
                }
                case 3: {
                    this.viewportManager.addFixedViewport(vRMLViewportNodeType, viewport);
                    break;
                }
                case 4: {
                    this.viewportManager.addCustomViewport(vRMLViewportNodeType, viewport);
                }
            }
            for (n2 = 0; n2 < this.sensorStatusListeners.size(); ++n2) {
                sensorStatusListener = (SensorStatusListener)this.sensorStatusListeners.get(n2);
                oGLLayerManager.addSensorStatusListener(sensorStatusListener);
            }
            for (n2 = 0; n2 < this.navigationStateListeners.size(); ++n2) {
                sensorStatusListener = (NavigationStateListener)this.navigationStateListeners.get(n2);
                oGLLayerManager.addNavigationStateListener((NavigationStateListener)sensorStatusListener);
            }
            for (n2 = 0; n2 < this.profilingListeners.size(); ++n2) {
                sensorStatusListener = this.profilingListeners.get(n2);
                oGLLayerManager.addProfilingListener((ProfilingListener)sensorStatusListener);
            }
            for (n2 = 0; n2 < this.viewpointStatusListeners.size(); ++n2) {
                sensorStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(n2);
                oGLLayerManager.addViewpointStatusListener((ViewpointStatusListener)sensorStatusListener);
            }
        }
        this.numActiveLayers = n;
    }

    public void setRenderOrder(int[] nArray, int n) {
        int n2 = 0;
        this.renderOrder = nArray;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] >= this.activeLayers.length) continue;
            this.activeLayers[n2++] = this.allLayers[nArray[i]];
        }
        this.displayManager.setLayers((Layer[])this.activeLayers, n2);
    }

    public void shutdown() {
    }

    public void clear() {
        int n;
        this.displayManager.setLayers(null, 0);
        for (n = 0; n < this.allManagers.length; ++n) {
            this.allManagers[n] = null;
        }
        for (n = 0; n < this.activeLayers.length; ++n) {
            this.activeLayers[n] = null;
            this.allLayers[n] = null;
        }
        this.viewpointManager.clear();
        this.viewportManager.clear();
    }

    public DisplayCollection getDisplayManager() {
        return this.displayManager;
    }

    public void captureScreenOnce(ScreenCaptureListener screenCaptureListener) {
        this.screenCaptureOnceChanged = true;
        this.screenCaptureListener = screenCaptureListener;
    }

    public void captureScreenStart(ScreenCaptureListener screenCaptureListener) {
        this.screenCaptureStartChanged = true;
        this.screenCaptureListener = screenCaptureListener;
    }

    public void captureScreenEnd() {
        this.screenCaptureEndChanged = true;
    }

    public GraphicsResizeListener[] getGraphicsResizeListeners() {
        return new GraphicsResizeListener[]{this.viewportManager, this.viewpointManager};
    }

    public void setHardwareFOV(float f) {
        this.hardwareFOVChanged = true;
        this.nextHardwareFOV = f;
    }

    public void setStereoEnabled(boolean bl) {
        this.nextStereoEnabled = bl;
        this.stereoEnabledChanged = true;
    }

    public VRMLScene getScene() {
        return this.currentScene;
    }

    public VRMLViewpointNodeType getViewpoint() {
        VRMLViewpointNodeType vRMLViewpointNodeType = null;
        LayerManager layerManager = this.getActiveNavLayer();
        return vRMLViewpointNodeType;
    }

    private LayerManager getActiveNavLayer() {
        OGLLayerManager oGLLayerManager = null;
        for (int i = 0; i < this.allManagers.length; ++i) {
            if (!this.allManagers[i].isActiveNavigationLayer()) continue;
            oGLLayerManager = this.allManagers[i];
            break;
        }
        return oGLLayerManager;
    }

    private void fireInitEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserInitialized(this.currentScene);
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(INIT_EVENT_ERR_MSG, exception);
            }
        }
    }

    private void fireFailedURL(String string) {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.urlLoadFailed(string);
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(FAILED_URL_ERR_MSG, exception);
            }
        }
    }

    private void fireShutdownEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserShutdown();
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(SHUTDOWN_EVENT_ERR_MSG, exception);
            }
        }
    }

    private void fireDisposeEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserDisposed();
                continue;
            }
            catch (Exception exception) {
                this.errorReporter.errorReport(DISPOSE_EVENT_ERR_MSG, exception);
            }
        }
    }
}

