/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import javax.media.opengl.GL;
import org.j3d.aviatrix3d.SimpleScene;
import org.j3d.aviatrix3d.rendering.ProfilingData;
import org.j3d.aviatrix3d.rendering.RenderEffectsProcessor;
import org.web3d.browser.ProfilingInfo;
import org.web3d.browser.ProfilingListener;
import org.web3d.browser.ScreenCaptureListener;
import org.web3d.vrml.renderer.ogl.browser.OGLProfilingInfo;

public class OGLRenderingEffects
implements RenderEffectsProcessor {
    private static final String INVALID_STYLE_MSG = "An invalid rendering style was provided to the rendering effects processor. Must be one of RENDER_*";
    private int polygonMode;
    private int renderStyle;
    private ScreenCaptureListener screenCaptureListener;
    private boolean movieMode;
    private SimpleScene globalScene;
    private ByteBuffer captureBuffer;
    private ArrayList<ProfilingListener> profilingListeners;
    private int viewWidth;
    private int viewHeight;
    private int lastWidth;
    private int lastHeight;
    private boolean sizeChanged;

    public OGLRenderingEffects(SimpleScene simpleScene) {
        this.globalScene = simpleScene;
        this.renderStyle = 4;
        this.polygonMode = 6914;
        this.movieMode = false;
        this.sizeChanged = false;
        this.profilingListeners = new ArrayList(1);
    }

    public void preDraw(GL gL, Object object) {
        if (this.polygonMode != 6914) {
            gL.glPolygonMode(1028, this.polygonMode);
            gL.glPolygonMode(1029, this.polygonMode);
        }
    }

    public void postDraw(GL gL, ProfilingData profilingData, Object object) {
        if (this.polygonMode != 6914) {
            gL.glPolygonMode(1028, 6914);
            gL.glPolygonMode(1029, 6914);
        }
        if (this.screenCaptureListener != null) {
            if (this.captureBuffer == null || this.lastWidth != this.viewWidth || this.lastHeight != this.lastHeight) {
                this.captureBuffer = ByteBuffer.allocate(this.viewWidth * this.viewHeight * 3);
                this.lastWidth = this.viewWidth;
                this.lastHeight = this.viewHeight;
            } else {
                this.captureBuffer.rewind();
            }
            gL.glFlush();
            gL.glReadBuffer(1029);
            gL.glPixelStorei(3333, 1);
            gL.glReadPixels(0, 0, this.viewWidth, this.viewHeight, 6407, 5121, (Buffer)this.captureBuffer);
            this.screenCaptureListener.screenCaptured((Buffer)this.captureBuffer, this.viewWidth, this.viewHeight);
            if (!this.movieMode) {
                this.captureBuffer = null;
                this.screenCaptureListener = null;
            }
        }
        int n = this.profilingListeners.size();
        OGLProfilingInfo oGLProfilingInfo = new OGLProfilingInfo(profilingData);
        for (int i = 0; i < n; ++i) {
            ProfilingListener profilingListener = this.profilingListeners.get(i);
            profilingListener.profilingDataChanged((ProfilingInfo)oGLProfilingInfo);
        }
    }

    public void addProfilingListener(ProfilingListener profilingListener) {
        if (profilingListener == null) {
            return;
        }
        if (!this.profilingListeners.contains(profilingListener)) {
            this.profilingListeners.add(profilingListener);
        }
    }

    public void removeProfilingListener(ProfilingListener profilingListener) {
        if (profilingListener == null) {
            return;
        }
        this.profilingListeners.remove(profilingListener);
    }

    public void setRenderingStyle(int n) throws IllegalArgumentException {
        switch (n) {
            case 1: {
                this.polygonMode = 6912;
                break;
            }
            case 2: {
                this.polygonMode = 6913;
                break;
            }
            case 3: {
                this.polygonMode = 6914;
                break;
            }
            case 4: {
                this.polygonMode = 6914;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_STYLE_MSG);
            }
        }
        this.renderStyle = n;
    }

    public int getRenderingStyle() {
        return this.renderStyle;
    }

    public void captureScreenOnce(ScreenCaptureListener screenCaptureListener, int n, int n2) {
        this.screenCaptureListener = screenCaptureListener;
        this.viewWidth = n;
        this.viewHeight = n2;
    }

    public void captureScreenStart(ScreenCaptureListener screenCaptureListener, int n, int n2) {
        this.screenCaptureListener = screenCaptureListener;
        this.viewWidth = n;
        this.viewHeight = n2;
        this.movieMode = true;
    }

    public void captureScreenEnd() {
        this.movieMode = false;
        this.screenCaptureListener = null;
    }
}

