/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Vector3f;
import org.j3d.aviatrix3d.TransformGroup;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.browser.EventModelStatusListener;
import org.web3d.browser.NavigationStateListener;
import org.web3d.browser.NodeObserver;
import org.web3d.browser.ProfilingListener;
import org.web3d.browser.ScreenCaptureListener;
import org.web3d.browser.SensorStatusListener;
import org.web3d.browser.ViewpointStatusListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.VRMLExecutionSpace;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.nodes.VRMLViewpointNodeType;
import org.web3d.vrml.renderer.ogl.browser.OGLLayerManager;
import org.web3d.vrml.renderer.ogl.browser.PerFrameManager;
import org.web3d.vrml.renderer.ogl.browser.ViewpointResizeManager;
import org.xj3d.core.eventmodel.EventModelEvaluator;
import org.xj3d.core.eventmodel.EventModelInitListener;
import org.xj3d.core.eventmodel.LayerManager;
import org.xj3d.core.eventmodel.LayerRenderingManager;

public class OGLMinimalBrowserCore
implements BrowserCore,
LayerRenderingManager,
EventModelInitListener {
    private String worldDescription;
    private VRMLScene currentScene;
    private VRMLScene nextScene;
    private VRMLExecutionSpace currentSpace;
    private PerFrameManager frameManager;
    private ViewpointResizeManager viewpointManager;
    private EventModelEvaluator eventModel;
    private ArrayList coreListeners;
    private ArrayList<ProfilingListener> profilingListeners;
    private TransformGroup vpTransformGroup;
    private long lastRenderTime;
    private float hardwareFOV;
    private ArrayList viewpointStatusListeners;
    private ArrayList sensorStatusListeners;
    private ArrayList navigationStateListeners;
    private LayerManager[] allManagers;
    private int numActiveLayers;
    private ErrorReporter errorReporter;
    private int globalRenderingStyle;
    private boolean stereoEnabled;
    private int frameCycleTime;
    private int userCycleTime;
    private int internalCycleTime;
    private String nextNavigationMode;
    private boolean fitToWorldChanged;
    private boolean animateFitToWorld;
    private boolean hardwareFOVChanged;
    private boolean stereoEnabledChanged;
    private boolean nextStereoEnabled;
    private float nextHardwareFOV;

    public OGLMinimalBrowserCore(EventModelEvaluator eventModelEvaluator) {
        this.eventModel = eventModelEvaluator;
        this.eventModel.setInitListener((EventModelInitListener)this);
        this.allManagers = new LayerManager[1];
        this.numActiveLayers = 0;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.coreListeners = new ArrayList();
        this.sensorStatusListeners = new ArrayList(1);
        this.viewpointStatusListeners = new ArrayList(1);
        this.navigationStateListeners = new ArrayList(1);
        this.viewpointManager = new ViewpointResizeManager();
        this.frameCycleTime = 0;
        this.userCycleTime = 0;
        this.internalCycleTime = 0;
        this.hardwareFOV = 0.0f;
        this.globalRenderingStyle = 4;
    }

    public void worldInitComplete() {
        this.fireInitEvent();
    }

    public void changeWorld() {
        if (this.currentScene != null) {
            this.fireShutdownEvent();
        }
        this.currentScene = this.nextScene;
    }

    public int getRendererType() {
        return 3;
    }

    public String getIDString() {
        return "aviatrix3d";
    }

    public void setRenderingStyle(int n) throws IllegalArgumentException {
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].setRenderingStyle(n);
        }
        this.globalRenderingStyle = n;
    }

    public int getRenderingStyle() {
        return this.globalRenderingStyle;
    }

    public int getRenderingStyle(int n) {
        return this.globalRenderingStyle;
    }

    public void setMinimumFrameInterval(int n, boolean bl) {
        if (bl) {
            this.userCycleTime = n;
        } else {
            this.internalCycleTime = n;
        }
        this.frameCycleTime = this.userCycleTime >= this.internalCycleTime ? this.userCycleTime : this.internalCycleTime;
    }

    public int getMinimumFrameInterval() {
        return this.frameCycleTime;
    }

    public VRMLClock getVRMLClock() {
        return this.eventModel.getVRMLClock();
    }

    public Map getDEFMappings() {
        return Collections.EMPTY_MAP;
    }

    public VRMLExecutionSpace getWorldExecutionSpace() {
        return this.currentSpace;
    }

    public String getDescription() {
        return this.worldDescription;
    }

    public void setDescription(String string) {
        this.worldDescription = string;
    }

    public float getCurrentSpeed() {
        return 0.0f;
    }

    public float getCurrentFrameRate() {
        float f = (float)this.lastRenderTime / 1000.0f;
        return 1.0f / f;
    }

    public void setLastRenderTime(long l) {
        this.lastRenderTime = l;
    }

    public void setEventModelStatusListener(EventModelStatusListener eventModelStatusListener) {
        this.frameManager.setEventModelStatusListener(eventModelStatusListener);
    }

    public void addNavigationStateListener(NavigationStateListener navigationStateListener) {
        if (navigationStateListener == null) {
            return;
        }
        if (!this.navigationStateListeners.contains(navigationStateListener)) {
            this.navigationStateListeners.add(navigationStateListener);
        }
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].addNavigationStateListener(navigationStateListener);
        }
    }

    public void removeNavigationStateListener(NavigationStateListener navigationStateListener) {
        if (navigationStateListener == null) {
            return;
        }
        this.navigationStateListeners.remove(navigationStateListener);
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].removeNavigationStateListener(navigationStateListener);
        }
    }

    public void addSensorStatusListener(SensorStatusListener sensorStatusListener) {
        if (sensorStatusListener == null) {
            return;
        }
        if (!this.sensorStatusListeners.contains(sensorStatusListener)) {
            this.sensorStatusListeners.add(sensorStatusListener);
        }
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].addSensorStatusListener(sensorStatusListener);
        }
    }

    public void removeSensorStatusListener(SensorStatusListener sensorStatusListener) {
        if (sensorStatusListener == null) {
            return;
        }
        this.sensorStatusListeners.remove(sensorStatusListener);
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].removeSensorStatusListener(sensorStatusListener);
        }
    }

    public void addViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        if (viewpointStatusListener == null) {
            return;
        }
        if (!this.viewpointStatusListeners.contains(viewpointStatusListener)) {
            this.viewpointStatusListeners.add(viewpointStatusListener);
        }
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].addViewpointStatusListener(viewpointStatusListener);
        }
    }

    public void removeViewpointStatusListener(ViewpointStatusListener viewpointStatusListener) {
        if (viewpointStatusListener == null) {
            return;
        }
        this.viewpointStatusListeners.remove(viewpointStatusListener);
        for (int i = 0; i < this.numActiveLayers; ++i) {
            this.allManagers[i].removeViewpointStatusListener(viewpointStatusListener);
        }
    }

    public void addNodeObserver(int n, NodeObserver nodeObserver) {
        this.eventModel.addNodeObserver(n, nodeObserver);
    }

    public void removeNodeObserver(int n, NodeObserver nodeObserver) {
        this.eventModel.removeNodeObserver(n, nodeObserver);
    }

    public void dispose() {
        this.fireDisposeEvent();
    }

    public String getWorldURL() {
        String string = null;
        string = this.currentScene != null ? this.currentScene.getWorldRootURL() : (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("user.dir");
                string = string.replace('\\', '/');
                string = "file:///" + string;
                return string;
            }
        });
        return string;
    }

    public void setScene(VRMLScene vRMLScene, String string) {
        this.nextScene = vRMLScene;
        this.eventModel.setScene(vRMLScene, string);
    }

    public void changeViewpoint(VRMLViewpointNodeType vRMLViewpointNodeType) {
        this.eventModel.changeViewpoint(vRMLViewpointNodeType);
    }

    public void addCoreListener(BrowserCoreListener browserCoreListener) {
        if (browserCoreListener != null && !this.coreListeners.contains(browserCoreListener)) {
            this.coreListeners.add(browserCoreListener);
        }
    }

    public void removeCoreListener(BrowserCoreListener browserCoreListener) {
        this.coreListeners.remove(browserCoreListener);
    }

    public void addProfilingListener(ProfilingListener profilingListener) {
    }

    public void removeProfilingListener(ProfilingListener profilingListener) {
    }

    public void sendURLFailEvent(String string) {
        this.fireFailedURL(string);
    }

    public void setNavigationMode(String string) {
        this.nextNavigationMode = string;
    }

    public void getUserPosition(Vector3f vector3f, AxisAngle4f axisAngle4f) {
        LayerManager layerManager = this.getActiveNavLayer();
        layerManager.getUserPosition(vector3f, axisAngle4f);
    }

    public void fitToWorld(boolean bl) {
        this.fitToWorldChanged = true;
        this.animateFitToWorld = bl;
    }

    public void syncUIUpdates() {
        LayerManager layerManager;
        if (this.nextNavigationMode != null) {
            layerManager = this.getActiveNavLayer();
            layerManager.setNavigationMode(this.nextNavigationMode);
        }
        if (this.fitToWorldChanged) {
            layerManager = this.getActiveNavLayer();
            layerManager.fitToWorld(this.animateFitToWorld);
            this.fitToWorldChanged = false;
        }
        if (this.hardwareFOVChanged) {
            this.hardwareFOV = this.nextHardwareFOV;
            for (int i = 0; i < this.numActiveLayers; ++i) {
                this.allManagers[i].setHardwareFOV(this.hardwareFOV);
            }
        }
        if (this.stereoEnabledChanged) {
            this.stereoEnabled = this.nextStereoEnabled;
            for (int i = 0; i < this.numActiveLayers; ++i) {
                this.allManagers[i].setStereoEnabled(this.stereoEnabled);
            }
            this.stereoEnabledChanged = false;
        }
    }

    public void captureScreenOnce(ScreenCaptureListener screenCaptureListener) {
    }

    public void captureScreenStart(ScreenCaptureListener screenCaptureListener) {
    }

    public void captureScreenEnd() {
    }

    public void setActiveLayers(LayerManager[] layerManagerArray, int n) {
        this.allManagers = new LayerManager[n];
        for (int i = 0; i < n; ++i) {
            SensorStatusListener sensorStatusListener;
            int n2;
            OGLLayerManager oGLLayerManager = (OGLLayerManager)layerManagerArray[i];
            oGLLayerManager.setViewpointResizeManager(this.viewpointManager);
            oGLLayerManager.setHardwareFOV(this.hardwareFOV);
            oGLLayerManager.setStereoEnabled(this.stereoEnabled);
            this.allManagers[i] = oGLLayerManager;
            switch (oGLLayerManager.getViewportType()) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
            }
            for (n2 = 0; n2 < this.sensorStatusListeners.size(); ++n2) {
                sensorStatusListener = (SensorStatusListener)this.sensorStatusListeners.get(n2);
                oGLLayerManager.addSensorStatusListener(sensorStatusListener);
            }
            for (n2 = 0; n2 < this.navigationStateListeners.size(); ++n2) {
                sensorStatusListener = (NavigationStateListener)this.navigationStateListeners.get(n2);
                oGLLayerManager.addNavigationStateListener((NavigationStateListener)sensorStatusListener);
            }
            for (n2 = 0; n2 < this.profilingListeners.size(); ++n2) {
            }
            for (n2 = 0; n2 < this.viewpointStatusListeners.size(); ++n2) {
                sensorStatusListener = (ViewpointStatusListener)this.viewpointStatusListeners.get(n2);
                oGLLayerManager.addViewpointStatusListener((ViewpointStatusListener)sensorStatusListener);
            }
        }
        this.numActiveLayers = n;
    }

    public void setRenderOrder(int[] nArray, int n) {
    }

    public void setRenderingStyle(int n, int n2) throws IllegalArgumentException {
    }

    public void shutdown() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (this.errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public void clear() {
        for (int i = 0; i < this.allManagers.length; ++i) {
            this.allManagers[i] = null;
        }
    }

    public void setPerFrameManager(PerFrameManager perFrameManager) {
        this.frameManager = perFrameManager;
    }

    public void setHardwareFOV(float f) {
        this.hardwareFOVChanged = true;
        this.nextHardwareFOV = f;
    }

    public void setStereoEnabled(boolean bl) {
        this.nextStereoEnabled = bl;
        this.stereoEnabledChanged = true;
    }

    public VRMLScene getScene() {
        return this.currentScene;
    }

    public VRMLViewpointNodeType getViewpoint() {
        VRMLViewpointNodeType vRMLViewpointNodeType = null;
        LayerManager layerManager = this.getActiveNavLayer();
        return vRMLViewpointNodeType;
    }

    private LayerManager getActiveNavLayer() {
        LayerManager layerManager = null;
        for (int i = 0; i < this.allManagers.length; ++i) {
            if (!this.allManagers[i].isActiveNavigationLayer()) continue;
            layerManager = this.allManagers[i];
            break;
        }
        return layerManager;
    }

    private void fireInitEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserInitialized(this.currentScene);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireFailedURL(String string) {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.urlLoadFailed(string);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireShutdownEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserShutdown();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }

    private void fireDisposeEvent() {
        int n = this.coreListeners.size();
        for (int i = 0; i < n; ++i) {
            try {
                BrowserCoreListener browserCoreListener = (BrowserCoreListener)this.coreListeners.get(i);
                browserCoreListener.browserDisposed();
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending init event " + exception);
                exception.printStackTrace();
            }
        }
    }
}

