/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.j3d.aviatrix3d.management.DisplayCollection;
import org.j3d.aviatrix3d.management.RenderManager;
import org.j3d.aviatrix3d.management.SingleDisplayCollection;
import org.j3d.aviatrix3d.management.SingleThreadRenderManager;
import org.j3d.aviatrix3d.output.audio.OpenALAudioDevice;
import org.j3d.aviatrix3d.output.graphics.ElumensAWTSurface;
import org.j3d.aviatrix3d.output.graphics.ElumensSWTSurface;
import org.j3d.aviatrix3d.pipeline.RenderPipeline;
import org.j3d.aviatrix3d.pipeline.audio.AudioCullStage;
import org.j3d.aviatrix3d.pipeline.audio.AudioOutputDevice;
import org.j3d.aviatrix3d.pipeline.audio.AudioSortStage;
import org.j3d.aviatrix3d.pipeline.audio.DefaultAudioPipeline;
import org.j3d.aviatrix3d.pipeline.audio.NullAudioCullStage;
import org.j3d.aviatrix3d.pipeline.audio.NullAudioSortStage;
import org.j3d.aviatrix3d.pipeline.graphics.DefaultGraphicsPipeline;
import org.j3d.aviatrix3d.pipeline.graphics.FrustumCullStage;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsCullStage;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsOutputDevice;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsResizeListener;
import org.j3d.aviatrix3d.pipeline.graphics.GraphicsSortStage;
import org.j3d.aviatrix3d.pipeline.graphics.NullCullStage;
import org.j3d.aviatrix3d.pipeline.graphics.StateAndTransparencyDepthSortStage;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.BrowserCoreListener;
import org.web3d.browser.InvalidConfigurationException;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.VRMLScene;
import org.web3d.vrml.parser.FactoryConfigurationError;
import org.web3d.vrml.parser.VRMLParserFactory;
import org.web3d.vrml.renderer.common.input.dis.DISProtocolHandler;
import org.web3d.vrml.renderer.ogl.OGLSceneBuilderFactory;
import org.web3d.vrml.renderer.ogl.browser.OGLLayerManagerFactory;
import org.web3d.vrml.renderer.ogl.browser.OGLStandardBrowserCore;
import org.web3d.vrml.sav.InputSource;
import org.xj3d.core.eventmodel.DeviceFactory;
import org.xj3d.core.eventmodel.EventModelEvaluator;
import org.xj3d.core.eventmodel.InputDeviceManager;
import org.xj3d.core.eventmodel.KeyDeviceSensorManager;
import org.xj3d.core.eventmodel.LayerManagerFactory;
import org.xj3d.core.eventmodel.LayerRenderingManager;
import org.xj3d.core.eventmodel.NetworkManager;
import org.xj3d.core.eventmodel.NetworkProtocolHandler;
import org.xj3d.core.eventmodel.NodeManager;
import org.xj3d.core.eventmodel.PickingManager;
import org.xj3d.core.eventmodel.RouteManager;
import org.xj3d.core.eventmodel.RouterFactory;
import org.xj3d.core.eventmodel.ScriptManager;
import org.xj3d.core.eventmodel.SensorManager;
import org.xj3d.core.eventmodel.ViewpointManager;
import org.xj3d.core.loading.ContentLoadManager;
import org.xj3d.core.loading.SceneBuilderFactory;
import org.xj3d.core.loading.ScriptLoader;
import org.xj3d.core.loading.WorldLoader;
import org.xj3d.core.loading.WorldLoaderManager;
import org.xj3d.impl.core.eventmodel.DefaultViewpointManager;
import org.xj3d.impl.core.loading.DefaultWorldLoaderManager;
import org.xj3d.sai.BrowserConfig;

public class OGLBrowserCanvas
implements BrowserCoreListener,
Runnable {
    public static final String SCRIPT_LOADER_PROP = "org.xj3d.script.loader.class";
    public static final String SCRIPT_MANAGER_PROP = "org.xj3d.script.manager.class";
    public static final String FILE_LOADER_PROP = "org.xj3d.file.loader.class";
    public static final String ROUTER_FACTORY_PROP = "org.xj3d.router.factory.class";
    public static final String ROUTER_MANAGER_PROP = "org.xj3d.router.manager.class";
    public static final String STATE_MANAGER_PROP = "org.xj3d.state.manager.class";
    public static final String SENSOR_MANAGER_PROP = "org.xj3d.sensor.manager.class";
    public static final String PICKING_MANAGER_PROP = "org.xj3d.sensor.manager.class";
    public static final String NETWORK_MANAGER_PROP = "org.xj3d.network.manager.class";
    private static final String DEFAULT_NETWORK_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultNetworkManager";
    public static final String HANIM_MANAGER_PROP = "org.xj3d.hanim.manager.class";
    private static final String DEFAULT_HANIM_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultHumanoidManager";
    public static final String PHYSICS_MANAGER_PROP = "org.xj3d.physics.manager.class";
    private static final String DEFAULT_PHYSICS_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultRigidBodyPhysicsManager";
    public static final String PARTICLE_MANAGER_PROP = "org.xj3d.particle.manager.class";
    private static final String DEFAULT_PARTICLE_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultParticleSystemManager";
    public static final String EVENT_MODEL_PROP = "org.xj3d.eventmodel.evaluator.class";
    private static final String DEFAULT_SCRIPT_LOADER = "org.xj3d.impl.core.loading.DefaultScriptLoader";
    private static final String DEFAULT_SCRIPT_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultScriptManager";
    private static final String DEFAULT_EXTERNAL = "org.xj3d.impl.core.loading.MemCacheLoadManager";
    private static final String DEFAULT_ROUTER_FACTORY = "org.xj3d.impl.core.eventmodel.ListsRouterFactory";
    private static final String DEFAULT_ROUTER_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultRouteManager";
    private static final String DEFAULT_STATE_MANAGER = "org.xj3d.impl.core.eventmodel.DefaultFrameStateManager";
    private static final String DEFAULT_PICKING_MANAGER = "org.web3d.vrml.renderer.ogl.input.DefaultPickingManager";
    private static final String DEFAULT_SENSOR_MANAGER = "org.web3d.vrml.renderer.common.input.DefaultSensorManager";
    private static final String DEFAULT_EVENT_MODEL = "org.xj3d.impl.core.eventmodel.DefaultEventModelEvaluator";
    private static final String NO_SCRIPT_LOAD_MSG = "The class that you specificed for the script loader is not a  valid instance of ScriptLoader";
    private static final String NO_SCRIPT_MGR_MSG = "The class that you specificed for the script manager is not a valid instance of ScriptManager";
    private static final String NO_LOADER_LOAD_MSG = "The class that you specificed for the load manager is not a valid instance of ContentLoadManager";
    private static final String NO_ROUTER_LOAD_MSG = "The class that you specificed for the router factory is not a valid instance of RouterFactory";
    private static final String NO_ROUTER_MGR_MSG = "The class that you specificed for the router manager is not a valid instance of RouteManager";
    private static final String NO_STATE_MGR_MSG = "The class that you specificed for the frame state manager is not a valid instance of FrameStateManager";
    private static final String NO_SENSOR_MGR_MSG = "The class that you specificed for the sensor manager is not a valid instance of SensorManager";
    private static final String NO_EVENT_MODEL_MSG = "The class that you specificed for the event model is not a valid instance of EventModelEvaluator";
    private static final String NO_PICKING_MGR_MSG = "The class that you specificed for the sensor manager is not a valid instance of OGLPickingManager";
    private static final String NO_NETWORK_MGR_MSG = "The class that you specificed for the sensor manager is not a valid instance of NetworkManager";
    private static final String NO_HANIM_MGR_MSG = "The class that you specificed for the hanim manager is not a valid instance of HAnimManager";
    private static final String NO_PHYSICS_MGR_MSG = "The class that you specificed for the physics manager is not a valid instance of PhysicsManager";
    private static final String NO_PARTICLE_MGR_MSG = "The class that you specificed for the particle manager is not a valid instance of ParticleManager";
    private static final String SEND_LINK_MSG = "There was an error sending the link changed notification";
    private static final String FAILED_TO_LOAD_ERR_MSG = "Error during the load process for the following world URL: ";
    private static final String DIS_PROTOCOL_HANDLER_NOT_FOUND_ERR_MSG = "DISProtocol handler not found";
    private OGLStandardBrowserCore universe;
    private ScriptManager scriptManager;
    private FrameStateManager stateManager;
    private ContentLoadManager loadManager;
    private ScriptLoader s_loader;
    private NetworkManager networkManager;
    private NodeManager hanimManager;
    private NodeManager physicsManager;
    private NodeManager particleManager;
    private RouteManager routeManager;
    private SensorManager sensorManager;
    private PickingManager pickingManager;
    private EventModelEvaluator eventModel;
    private WorldLoaderManager worldLoader;
    private ErrorReporter errorReporter;
    private BrowserConfig configParams;
    private GraphicsOutputDevice surface;
    private DeviceFactory deviceFactory;
    private SingleThreadRenderManager sceneManager;
    private SingleDisplayCollection displayManager;
    private DefaultGraphicsPipeline pipeline;
    private AudioOutputDevice adevice;
    private DefaultAudioPipeline audioPipeline;
    private ViewpointManager viewpointManager;
    private Thread shutdownThread;

    public OGLBrowserCanvas(GraphicsOutputDevice graphicsOutputDevice, DeviceFactory deviceFactory, BrowserConfig browserConfig) {
        this.surface = graphicsOutputDevice;
        this.deviceFactory = deviceFactory;
        this.configParams = browserConfig;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.shutdownThread = new Thread((Runnable)this, "Xj3D Canvas Shutdown");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime runtime = Runtime.getRuntime();
                runtime.addShutdownHook(OGLBrowserCanvas.this.shutdownThread);
                return null;
            }
        });
    }

    public void setSurface(GraphicsOutputDevice graphicsOutputDevice, DeviceFactory deviceFactory) {
        InputDeviceManager inputDeviceManager;
        this.surface = graphicsOutputDevice;
        this.deviceFactory = deviceFactory;
        this.pipeline.setGraphicsOutputDevice(graphicsOutputDevice);
        if (graphicsOutputDevice instanceof ElumensAWTSurface || graphicsOutputDevice instanceof ElumensSWTSurface) {
            this.universe.setHardwareFOV(180.0f);
        } else {
            this.universe.setHardwareFOV(0.0f);
        }
        if (this.sensorManager != null && deviceFactory != null) {
            inputDeviceManager = new InputDeviceManager(deviceFactory);
            KeyDeviceSensorManager keyDeviceSensorManager = new KeyDeviceSensorManager(deviceFactory);
            this.sensorManager.setInputManager(inputDeviceManager);
            this.sensorManager.setKeyDeviceSensorManager(keyDeviceSensorManager);
        }
        inputDeviceManager = this.universe.getGraphicsResizeListeners();
        for (int i = 0; i < ((InputDeviceManager)inputDeviceManager).length; ++i) {
            graphicsOutputDevice.addGraphicsResizeListener((GraphicsResizeListener)inputDeviceManager[i]);
        }
    }

    public void run() {
        this.shutdownApp(true);
    }

    public void browserShutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void browserDisposed() {
        OGLBrowserCanvas oGLBrowserCanvas = this;
        synchronized (oGLBrowserCanvas) {
            if (this.shutdownThread != null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        Runtime runtime = Runtime.getRuntime();
                        runtime.removeShutdownHook(OGLBrowserCanvas.this.shutdownThread);
                        return null;
                    }
                });
                this.shutdownThread = null;
            }
        }
        this.sceneManager.disableInternalShutdown();
        this.shutdownApp(false);
    }

    public void urlLoadFailed(String string) {
    }

    public void browserInitialized(VRMLScene vRMLScene) {
    }

    public void initialize() {
        Object object;
        DISProtocolHandler dISProtocolHandler;
        String[] stringArray = (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String[] stringArray = new String[]{System.getProperty(OGLBrowserCanvas.SCRIPT_LOADER_PROP, OGLBrowserCanvas.DEFAULT_SCRIPT_LOADER), System.getProperty(OGLBrowserCanvas.SCRIPT_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_SCRIPT_MANAGER), System.getProperty(OGLBrowserCanvas.FILE_LOADER_PROP, OGLBrowserCanvas.DEFAULT_EXTERNAL), System.getProperty(OGLBrowserCanvas.ROUTER_FACTORY_PROP, OGLBrowserCanvas.DEFAULT_ROUTER_FACTORY), System.getProperty(OGLBrowserCanvas.ROUTER_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_ROUTER_MANAGER), System.getProperty(OGLBrowserCanvas.STATE_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_STATE_MANAGER), System.getProperty("org.xj3d.sensor.manager.class", OGLBrowserCanvas.DEFAULT_SENSOR_MANAGER), System.getProperty("org.xj3d.sensor.manager.class", OGLBrowserCanvas.DEFAULT_PICKING_MANAGER), System.getProperty(OGLBrowserCanvas.EVENT_MODEL_PROP, OGLBrowserCanvas.DEFAULT_EVENT_MODEL), System.getProperty(OGLBrowserCanvas.NETWORK_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_NETWORK_MANAGER), System.getProperty(OGLBrowserCanvas.HANIM_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_HANIM_MANAGER), System.getProperty(OGLBrowserCanvas.PHYSICS_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_PHYSICS_MANAGER), System.getProperty(OGLBrowserCanvas.PARTICLE_MANAGER_PROP, OGLBrowserCanvas.DEFAULT_PARTICLE_MANAGER)};
                return stringArray;
            }
        });
        RouterFactory routerFactory = null;
        int n = 0;
        this.s_loader = (ScriptLoader)this.loadClass(stringArray[0], true, NO_SCRIPT_LOAD_MSG);
        this.scriptManager = (ScriptManager)this.loadClass(stringArray[1], true, NO_SCRIPT_MGR_MSG);
        this.loadManager = (ContentLoadManager)this.loadClass(stringArray[2], true, NO_LOADER_LOAD_MSG);
        routerFactory = (RouterFactory)this.loadClass(stringArray[3], true, NO_ROUTER_LOAD_MSG);
        this.routeManager = (RouteManager)this.loadClass(stringArray[4], true, NO_ROUTER_MGR_MSG);
        this.stateManager = (FrameStateManager)this.loadClass(stringArray[5], true, NO_STATE_MGR_MSG);
        this.sensorManager = (SensorManager)this.loadClass(stringArray[6], true, NO_SENSOR_MGR_MSG);
        this.pickingManager = (PickingManager)this.loadClass(stringArray[7], false, NO_PICKING_MGR_MSG);
        this.eventModel = (EventModelEvaluator)this.loadClass(stringArray[8], true, NO_EVENT_MODEL_MSG);
        this.networkManager = (NetworkManager)this.loadClass(stringArray[9], false, NO_NETWORK_MGR_MSG);
        if (this.networkManager != null) {
            ++n;
        }
        this.hanimManager = (NodeManager)this.loadClass(stringArray[10], false, NO_HANIM_MGR_MSG);
        if (this.hanimManager != null) {
            ++n;
        }
        this.physicsManager = (NodeManager)this.loadClass(stringArray[11], false, NO_PHYSICS_MGR_MSG);
        if (this.physicsManager != null) {
            ++n;
        }
        this.particleManager = (NodeManager)this.loadClass(stringArray[12], false, NO_PARTICLE_MGR_MSG);
        if (this.particleManager != null) {
            ++n;
        }
        this.setupAviatrix();
        if (this.surface != null) {
            if (this.sensorManager != null && this.deviceFactory != null) {
                dISProtocolHandler = new InputDeviceManager(this.deviceFactory);
                object = new KeyDeviceSensorManager(this.deviceFactory);
                this.sensorManager.setInputManager((InputDeviceManager)dISProtocolHandler);
                this.sensorManager.setKeyDeviceSensorManager(object);
                this.sensorManager.setPickingManager(this.pickingManager);
            }
        } else if (this.sensorManager != null) {
            this.sensorManager.setPickingManager(this.pickingManager);
        }
        if (this.networkManager != null) {
            try {
                dISProtocolHandler = new DISProtocolHandler();
                this.networkManager.addProtocolHandler((NetworkProtocolHandler)dISProtocolHandler);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                this.errorReporter.warningReport(DIS_PROTOCOL_HANDLER_NOT_FOUND_ERR_MSG, null);
            }
        }
        dISProtocolHandler = new NodeManager[n];
        n = 0;
        if (this.networkManager != null) {
            dISProtocolHandler[n++] = this.networkManager;
        }
        if (this.hanimManager != null) {
            dISProtocolHandler[n++] = this.hanimManager;
        }
        if (this.physicsManager != null) {
            dISProtocolHandler[n++] = this.physicsManager;
        }
        if (this.particleManager != null) {
            dISProtocolHandler[n++] = this.particleManager;
        }
        this.routeManager.setRouterFactory(routerFactory);
        this.scriptManager.setScriptLoader(this.s_loader);
        if (this.scriptManager == null || this.routeManager == null || this.sensorManager == null || this.stateManager == null || this.loadManager == null) {
            throw new InvalidConfigurationException("Missing required Manager");
        }
        object = new OGLLayerManagerFactory();
        object.setErrorReporter(this.errorReporter);
        this.universe = new OGLStandardBrowserCore(this.eventModel, (RenderManager)this.sceneManager, (DisplayCollection)this.displayManager);
        this.universe.addCoreListener(this);
        this.universe.setErrorReporter(this.errorReporter);
        this.viewpointManager = new DefaultViewpointManager((BrowserCore)this.universe);
        this.eventModel.initialize(this.scriptManager, this.routeManager, this.sensorManager, this.stateManager, this.loadManager, this.viewpointManager, (LayerManagerFactory)object, (LayerRenderingManager)this.universe, (NodeManager[])dISProtocolHandler);
        GraphicsResizeListener[] graphicsResizeListenerArray = this.universe.getGraphicsResizeListeners();
        for (int i = 0; i < graphicsResizeListenerArray.length; ++i) {
            this.surface.addGraphicsResizeListener(graphicsResizeListenerArray[i]);
        }
        OGLSceneBuilderFactory oGLSceneBuilderFactory = new OGLSceneBuilderFactory(this.configParams.vrml97Only, true, true, true, true, true, true);
        VRMLParserFactory vRMLParserFactory = null;
        try {
            vRMLParserFactory = VRMLParserFactory.newVRMLParserFactory();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new RuntimeException("Failed to load factory");
        }
        this.worldLoader = new DefaultWorldLoaderManager((BrowserCore)this.universe, this.stateManager, this.routeManager);
        this.worldLoader.setErrorReporter(this.errorReporter);
        this.worldLoader.registerBuilderFactory(3, (SceneBuilderFactory)oGLSceneBuilderFactory);
        this.worldLoader.registerParserFactory(3, vRMLParserFactory);
    }

    public void setEnabled(boolean bl) {
        this.sceneManager.setEnabled(bl);
    }

    public void setMinimumFrameInterval(int n, boolean bl) {
        this.universe.setMinimumFrameInterval(n, bl);
    }

    public void enableRenderPipeline(boolean bl) {
        this.displayManager.setEnabled(bl);
    }

    public void loadWorld(String string) {
        Object object;
        WorldLoader worldLoader = this.worldLoader.fetchLoader();
        VRMLScene vRMLScene = null;
        try {
            object = new InputSource(string);
            vRMLScene = worldLoader.loadNow((BrowserCore)this.universe, object);
        }
        catch (Exception exception) {
            String string2 = FAILED_TO_LOAD_ERR_MSG + string;
            this.errorReporter.errorReport(string2, exception);
        }
        this.worldLoader.releaseLoader(worldLoader);
        object = null;
        int n = string.indexOf("#");
        if (n > -1) {
            object = string.substring(n + 1);
        }
        this.universe.setScene(vRMLScene, (String)object);
    }

    public LayerRenderingManager getLayerRenderingManager() {
        return this.universe;
    }

    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    public ViewpointManager getViewpointManager() {
        return this.viewpointManager;
    }

    public ContentLoadManager getContentLoadManager() {
        return this.loadManager;
    }

    public RouteManager getRouteManager() {
        return this.routeManager;
    }

    public SensorManager getSensorManager() {
        return this.sensorManager;
    }

    public WorldLoaderManager getWorldLoaderManager() {
        return this.worldLoader;
    }

    public FrameStateManager getFrameStateManager() {
        return this.stateManager;
    }

    public EventModelEvaluator getEventModelEvaluator() {
        return this.eventModel;
    }

    public OGLStandardBrowserCore getUniverse() {
        return this.universe;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        this.eventModel.setErrorReporter(this.errorReporter);
        this.universe.setErrorReporter(this.errorReporter);
    }

    private void setupAviatrix() {
        StateAndTransparencyDepthSortStage stateAndTransparencyDepthSortStage = new StateAndTransparencyDepthSortStage();
        Object object = null;
        String string = this.configParams.cullingMode;
        object = string.equals("none") ? new NullCullStage() : (string.equals("frustum") ? new FrustumCullStage() : new FrustumCullStage());
        object.setOffscreenCheckEnabled(true);
        this.pipeline = new DefaultGraphicsPipeline();
        this.pipeline.setCuller((GraphicsCullStage)object);
        this.pipeline.setSorter((GraphicsSortStage)stateAndTransparencyDepthSortStage);
        this.pipeline.setGraphicsOutputDevice(this.surface);
        this.adevice = new OpenALAudioDevice();
        NullAudioCullStage nullAudioCullStage = new NullAudioCullStage();
        NullAudioSortStage nullAudioSortStage = new NullAudioSortStage();
        this.audioPipeline = new DefaultAudioPipeline();
        this.audioPipeline.setCuller((AudioCullStage)nullAudioCullStage);
        this.audioPipeline.setSorter((AudioSortStage)nullAudioSortStage);
        this.audioPipeline.setAudioOutputDevice(this.adevice);
        this.displayManager = new SingleDisplayCollection();
        this.displayManager.addPipeline((RenderPipeline)this.pipeline);
        this.displayManager.addPipeline((RenderPipeline)this.audioPipeline);
        this.sceneManager = new SingleThreadRenderManager();
        this.sceneManager.addDisplay((DisplayCollection)this.displayManager);
    }

    private Object loadClass(final String string, final boolean bl, final String string2) {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class<?> clazz = Class.forName(string);
                    return clazz.newInstance();
                }
                catch (Error error) {
                    if (bl) {
                        Exception exception = new Exception(error.getMessage(), error);
                        OGLBrowserCanvas.this.errorReporter.errorReport(string2, exception);
                    } else {
                        OGLBrowserCanvas.this.errorReporter.warningReport(string2, null);
                    }
                }
                catch (Exception exception) {
                    if (bl) {
                        OGLBrowserCanvas.this.errorReporter.errorReport(string2, exception);
                    }
                    OGLBrowserCanvas.this.errorReporter.warningReport(string2, null);
                }
                return null;
            }
        });
        return t;
    }

    private void shutdownApp(boolean bl) {
        this.loadManager.shutdown();
        if (this.s_loader != null) {
            this.s_loader.shutdown();
        }
        this.eventModel.shutdown();
        if (!bl) {
            this.sceneManager.shutdown();
        }
    }
}

