/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.ogl.browser;

import java.util.HashMap;
import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.Background;
import org.j3d.aviatrix3d.BlendAttributes;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.Fog;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.QuadArray;
import org.j3d.aviatrix3d.Shape3D;
import org.j3d.aviatrix3d.ShapeBackground;
import org.j3d.aviatrix3d.SimpleScene;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.Texture2D;
import org.j3d.aviatrix3d.TextureAttributes;
import org.j3d.aviatrix3d.TextureUnit;
import org.j3d.aviatrix3d.TransformGroup;
import org.j3d.aviatrix3d.VertexGeometry;
import org.j3d.aviatrix3d.Viewpoint;
import org.j3d.aviatrix3d.rendering.BoundingVolume;
import org.web3d.vrml.renderer.ogl.browser.GroundSphere;
import org.web3d.vrml.renderer.ogl.browser.SkySphere;
import org.web3d.vrml.renderer.ogl.input.OGLGlobalEffectsHandler;

public class GlobalEffectsGroup
extends Group
implements OGLGlobalEffectsHandler,
NodeUpdateListener {
    private static final int DEFAULT_NUM_SPHERE_FACES = 32;
    private static final int BOX_SIDE_VERTEX_COUNT = 4;
    private static final int[] BOX_STRIP_COUNTS = new int[]{4};
    private static final float BOX_SIZE = 0.62f;
    private static final float[] SIN_TABLE;
    private static final float[] COS_TABLE;
    private static final float[][] BOX_TEX_COORDS;
    private static final int[] BOX_TEX_COORD_TYPES;
    private static final int BACK = 0;
    private static final int FRONT = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private static final int TOP = 4;
    private static final int BOTTOM = 5;
    private SimpleScene globalScene;
    private TransformGroup cameraTransform;
    private Matrix4f cameraMatrix;
    private Viewpoint viewpoint;
    private boolean headlightState;
    private int activeFog;
    private TransformGroup fogTransform;
    private Matrix4f fogMatrix;
    private float[] fogColor;
    private float fogVisLimit;
    private Fog exponentialFog;
    private Fog linearFog;
    private TransformGroup backgroundTransform;
    private Matrix4f backgroundMatrix;
    private ShapeBackground geomBackground;
    private Appearance[] backgroundAppearances;
    private Material backgroundMaterial;
    private boolean[] bgAppVisibility;
    private int currentNumSkyColors;
    private int currentNumGroundColors;
    private HashMap texUnitToTexture;
    private float bgTransparency;
    private float[] tmpArray;
    private GroundSphere ground;
    private SkySphere sky;
    private float[] clearColor;
    private int layerId;

    public GlobalEffectsGroup(SimpleScene simpleScene) {
        this.globalScene = simpleScene;
        this.bgTransparency = 0.0f;
        this.layerId = -1;
        this.setPickMask(0);
        this.texUnitToTexture = new HashMap();
        this.tmpArray = new float[4];
        this.fogColor = new float[3];
        this.clearColor = new float[3];
        this.cameraMatrix = new Matrix4f();
        this.backgroundMatrix = new Matrix4f();
        this.fogMatrix = new Matrix4f();
        this.viewpoint = new Viewpoint();
        this.viewpoint.setHeadlightEnabled(true);
        this.viewpoint.setGlobalAmbientLightEnabled(true);
        this.viewpoint.setGlobalAmbientColor(new float[]{0.0f, 0.0f, 0.0f, 1.0f});
        this.headlightState = true;
        this.cameraTransform = new TransformGroup();
        this.cameraTransform.setBounds((BoundingVolume)new BoundingVoid());
        this.cameraTransform.addChild((Node)this.viewpoint);
        this.sky = new SkySphere();
        this.ground = new GroundSphere();
        this.backgroundTransform = new TransformGroup();
        this.geomBackground = new ShapeBackground();
        this.geomBackground.addShape((Shape3D)this.sky);
        this.geomBackground.addShape((Shape3D)this.ground);
        this.constructBackgroundBox(this.geomBackground);
        this.backgroundTransform.addChild((Node)this.geomBackground);
        this.activeFog = 0;
        this.exponentialFog = new Fog(2048);
        this.exponentialFog.setGlobalOnly(true);
        this.linearFog = new Fog(9729);
        this.linearFog.setGlobalOnly(true);
        this.fogTransform = new TransformGroup();
        this.fogTransform.addChild((Node)this.exponentialFog);
        this.fogTransform.addChild((Node)this.linearFog);
        this.addChild((Node)this.cameraTransform);
        this.addChild((Node)this.backgroundTransform);
        this.addChild((Node)this.fogTransform);
    }

    public void setLayerId(int n) {
        this.layerId = n;
        if (this.geomBackground.isLive()) {
            this.geomBackground.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.geomBackground);
        }
    }

    public void setViewMatrix(Matrix4f matrix4f) {
        if (this.cameraTransform.isLive()) {
            if (!this.isSameMatrix(matrix4f, this.cameraMatrix)) {
                this.cameraMatrix.set(matrix4f);
                this.cameraTransform.boundsChanged((NodeUpdateListener)this);
            }
        } else {
            this.cameraTransform.setTransform(matrix4f);
        }
    }

    public void setBackgroundMatrix(Matrix4f matrix4f) {
        if (this.cameraTransform.isLive()) {
            if (!this.isSameMatrix(matrix4f, this.backgroundMatrix)) {
                this.backgroundMatrix.set(matrix4f);
                this.backgroundTransform.boundsChanged((NodeUpdateListener)this);
            }
        } else {
            this.backgroundTransform.setTransform(matrix4f);
        }
    }

    public void setFogMatrix(Matrix4f matrix4f) {
        if (this.fogTransform.isLive()) {
            if (!this.isSameMatrix(matrix4f, this.fogMatrix)) {
                this.fogMatrix.set(matrix4f);
                this.fogTransform.boundsChanged((NodeUpdateListener)this);
            }
        } else {
            this.fogTransform.setTransform(matrix4f);
        }
    }

    public void updateBackgroundTransparency(float f) {
        if (f == this.bgTransparency) {
            return;
        }
        boolean bl = this.bgTransparency == 1.0f;
        this.bgTransparency = f;
        if (f == 1.0f) {
            this.globalScene.setActiveBackground(null);
        } else {
            if (bl) {
                this.globalScene.setActiveBackground((Background)this.geomBackground);
            }
            if (this.backgroundMaterial.isLive()) {
                this.backgroundMaterial.dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(this.backgroundMaterial);
            }
        }
        this.sky.updateBackgroundTransparency(f);
        this.ground.updateBackgroundTransparency(f);
    }

    public void updateBackgroundTextures(Texture2D[] texture2DArray, boolean[] blArray) {
        TextureUnit[] textureUnitArray = new TextureUnit[1];
        for (int i = 0; i < 6; ++i) {
            if (!blArray[i]) continue;
            this.backgroundAppearances[i].getTextureUnits(textureUnitArray);
            if (textureUnitArray[0].isLive()) {
                textureUnitArray[0].dataChanged((NodeUpdateListener)this);
            } else {
                this.updateNodeDataChanges(textureUnitArray[0]);
            }
            this.texUnitToTexture.put(textureUnitArray[0], texture2DArray[i]);
            boolean bl = this.bgAppVisibility[i] = texture2DArray[i] != null;
            if (this.backgroundAppearances[i].isLive()) {
                this.backgroundAppearances[i].dataChanged((NodeUpdateListener)this);
                continue;
            }
            this.updateNodeDataChanges(this.backgroundAppearances[i]);
        }
    }

    public void updateBackgroundGround(float[] fArray, float[] fArray2, int n) {
        this.ground.updateGroundColors(fArray, fArray2, n);
    }

    public void updateBackgroundSky(float[] fArray, float[] fArray2, int n) {
        if (n == 1) {
            this.clearColor[0] = fArray[0];
            this.clearColor[1] = fArray[1];
            this.clearColor[2] = fArray[2];
            if (this.geomBackground.isLive()) {
                this.geomBackground.dataChanged((NodeUpdateListener)this);
            } else {
                this.geomBackground.setColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], 1.0f);
            }
        } else if (n == 0) {
            this.clearColor[0] = 0.0f;
            this.clearColor[1] = 0.0f;
            this.clearColor[2] = 0.0f;
            if (this.geomBackground.isLive()) {
                this.geomBackground.dataChanged((NodeUpdateListener)this);
            } else {
                this.geomBackground.setColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], 1.0f);
            }
        }
        this.sky.updateSkyColors(fArray, fArray2, n);
    }

    public void enableFog(int n) {
        switch (n) {
            case 0: {
                this.globalScene.setActiveFog(null);
                if (n == 1) {
                    if (this.linearFog.isLive()) {
                        this.linearFog.dataChanged((NodeUpdateListener)this);
                        break;
                    }
                    this.linearFog.setEnabled(true);
                    break;
                }
                if (n != 2) break;
                if (this.exponentialFog.isLive()) {
                    this.exponentialFog.dataChanged((NodeUpdateListener)this);
                    break;
                }
                this.exponentialFog.setEnabled(true);
                break;
            }
            case 1: {
                this.globalScene.setActiveFog(this.linearFog);
                if (this.linearFog.isLive()) {
                    this.linearFog.dataChanged((NodeUpdateListener)this);
                } else {
                    this.linearFog.setEnabled(true);
                }
                if (n != 2) break;
                if (this.exponentialFog.isLive()) {
                    this.exponentialFog.dataChanged((NodeUpdateListener)this);
                    break;
                }
                this.exponentialFog.setEnabled(true);
                break;
            }
            case 2: {
                this.globalScene.setActiveFog(this.exponentialFog);
                if (this.exponentialFog.isLive()) {
                    this.exponentialFog.dataChanged((NodeUpdateListener)this);
                } else {
                    this.exponentialFog.setEnabled(true);
                }
                if (n != 1) break;
                if (this.linearFog.isLive()) {
                    this.linearFog.dataChanged((NodeUpdateListener)this);
                    break;
                }
                this.linearFog.setEnabled(true);
            }
        }
        this.activeFog = n;
    }

    public void setFogDetails(float f, float f2, float f3, float f4) {
        this.fogColor[0] = f2;
        this.fogColor[1] = f3;
        this.fogColor[2] = f4;
        this.fogVisLimit = f;
        switch (this.activeFog) {
            case 0: {
                break;
            }
            case 1: {
                if (this.isLive()) {
                    this.linearFog.dataChanged((NodeUpdateListener)this);
                    break;
                }
                this.linearFog.setColor(this.fogColor);
                this.linearFog.setLinearDistance(0.0f, this.fogVisLimit);
                break;
            }
            case 2: {
                if (this.isLive()) {
                    this.exponentialFog.dataChanged((NodeUpdateListener)this);
                    break;
                }
                this.linearFog.setColor(this.fogColor);
                this.linearFog.setLinearDistance(0.0f, this.fogVisLimit);
            }
        }
    }

    public void updateNodeBoundsChanges(Object object) {
        if (object == this.cameraTransform) {
            this.cameraTransform.setTransform(this.cameraMatrix);
        } else if (object == this.backgroundTransform) {
            this.backgroundTransform.setTransform(this.backgroundMatrix);
        } else if (object == this.fogTransform) {
            this.fogTransform.setTransform(this.fogMatrix);
        }
    }

    public void updateNodeDataChanges(Object object) {
        if (object == this.linearFog) {
            this.linearFog.setColor(this.fogColor);
            this.linearFog.setLinearDistance(0.0f, this.fogVisLimit);
            this.linearFog.setEnabled(this.activeFog == 1);
        } else if (object == this.exponentialFog) {
            this.exponentialFog.setColor(this.fogColor);
            this.exponentialFog.setDensityRate(this.fogVisLimit);
            this.exponentialFog.setEnabled(this.activeFog == 2);
        } else if (object == this.geomBackground) {
            this.geomBackground.setColor(this.clearColor[0], this.clearColor[1], this.clearColor[2], 1.0f);
            boolean bl = this.layerId == 0 || this.bgTransparency == 0.0f;
            this.geomBackground.setColorClearEnabled(bl);
        } else if (object == this.viewpoint) {
            this.viewpoint.setHeadlightEnabled(this.headlightState);
        } else if (object instanceof Appearance) {
            for (int i = 0; i < 6; ++i) {
                if (object != this.backgroundAppearances[i]) continue;
                this.backgroundAppearances[i].setVisible(this.bgAppVisibility[i]);
            }
        } else if (object instanceof TextureUnit) {
            Texture texture = (Texture)this.texUnitToTexture.remove(object);
            ((TextureUnit)object).setTexture(texture);
        } else if (object == this.backgroundMaterial) {
            this.backgroundMaterial.setTransparency(this.bgTransparency);
        }
    }

    public void initialize() {
        this.globalScene.setActiveView(this.viewpoint);
        this.globalScene.setActiveBackground((Background)this.geomBackground);
    }

    public Viewpoint getViewpoint() {
        return this.viewpoint;
    }

    public void useHeadlight(boolean bl) {
        this.headlightState = bl;
        if (this.viewpoint.isLive()) {
            this.viewpoint.dataChanged((NodeUpdateListener)this);
        } else {
            this.updateNodeDataChanges(this.viewpoint);
        }
    }

    public void addViewDependentChild(Group group) {
        this.cameraTransform.addChild((Node)group);
    }

    private void constructBackgroundBox(ShapeBackground shapeBackground) {
        TextureAttributes textureAttributes = new TextureAttributes();
        textureAttributes.setTextureMode(7681);
        this.backgroundAppearances = new Appearance[6];
        this.bgAppVisibility = new boolean[6];
        TextureUnit[] textureUnitArray = new TextureUnit[1];
        float[] fArray = new float[]{0.62f, 0.62f, 0.62f, 0.62f, -0.62f, 0.62f, -0.62f, -0.62f, 0.62f, -0.62f, 0.62f, 0.62f};
        float[] fArray2 = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f};
        textureUnitArray[0] = new TextureUnit();
        textureUnitArray[0].setTextureAttributes(textureAttributes);
        this.backgroundMaterial = new Material();
        this.backgroundMaterial.setLightingEnabled(false);
        BlendAttributes blendAttributes = new BlendAttributes();
        blendAttributes.setSourceBlendFactor(770);
        blendAttributes.setDestinationBlendFactor(771);
        Appearance appearance = new Appearance();
        appearance.setTextureUnits(textureUnitArray, 1);
        appearance.setVisible(false);
        appearance.setBlendAttributes(blendAttributes);
        appearance.setMaterial(this.backgroundMaterial);
        this.backgroundAppearances[0] = appearance;
        this.bgAppVisibility[0] = false;
        Shape3D shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)this.createSideGeom(fArray, fArray2));
        shapeBackground.addShape(shape3D);
        float[] fArray3 = new float[]{-0.62f, 0.62f, -0.62f, -0.62f, -0.62f, -0.62f, 0.62f, -0.62f, -0.62f, 0.62f, 0.62f, -0.62f};
        float[] fArray4 = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
        textureUnitArray[0] = new TextureUnit();
        textureUnitArray[0].setTextureAttributes(textureAttributes);
        appearance = new Appearance();
        appearance.setTextureUnits(textureUnitArray, 1);
        appearance.setVisible(false);
        appearance.setBlendAttributes(blendAttributes);
        appearance.setMaterial(this.backgroundMaterial);
        this.backgroundAppearances[1] = appearance;
        this.bgAppVisibility[1] = false;
        shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)this.createSideGeom(fArray3, fArray4));
        shapeBackground.addShape(shape3D);
        float[] fArray5 = new float[]{-0.62f, 0.62f, 0.62f, -0.62f, -0.62f, 0.62f, -0.62f, -0.62f, -0.62f, -0.62f, 0.62f, -0.62f};
        float[] fArray6 = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        textureUnitArray[0] = new TextureUnit();
        textureUnitArray[0].setTextureAttributes(textureAttributes);
        appearance = new Appearance();
        appearance.setTextureUnits(textureUnitArray, 1);
        appearance.setVisible(false);
        appearance.setBlendAttributes(blendAttributes);
        appearance.setMaterial(this.backgroundMaterial);
        this.backgroundAppearances[2] = appearance;
        this.bgAppVisibility[2] = false;
        shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)this.createSideGeom(fArray5, fArray6));
        shapeBackground.addShape(shape3D);
        float[] fArray7 = new float[]{0.62f, 0.62f, -0.62f, 0.62f, -0.62f, -0.62f, 0.62f, -0.62f, 0.62f, 0.62f, 0.62f, 0.62f};
        float[] fArray8 = new float[]{-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f};
        textureUnitArray[0] = new TextureUnit();
        textureUnitArray[0].setTextureAttributes(textureAttributes);
        appearance = new Appearance();
        appearance.setTextureUnits(textureUnitArray, 1);
        appearance.setVisible(false);
        appearance.setBlendAttributes(blendAttributes);
        appearance.setMaterial(this.backgroundMaterial);
        this.backgroundAppearances[3] = appearance;
        this.bgAppVisibility[3] = false;
        shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)this.createSideGeom(fArray7, fArray8));
        shapeBackground.addShape(shape3D);
        float[] fArray9 = new float[]{-0.62f, 0.62f, 0.62f, -0.62f, 0.62f, -0.62f, 0.62f, 0.62f, -0.62f, 0.62f, 0.62f, 0.62f};
        float[] fArray10 = new float[]{0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f};
        textureUnitArray[0] = new TextureUnit();
        textureUnitArray[0].setTextureAttributes(textureAttributes);
        appearance = new Appearance();
        appearance.setBlendAttributes(blendAttributes);
        appearance.setTextureUnits(textureUnitArray, 1);
        appearance.setVisible(false);
        appearance.setMaterial(this.backgroundMaterial);
        this.backgroundAppearances[4] = appearance;
        this.bgAppVisibility[4] = false;
        shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        appearance.setBlendAttributes(blendAttributes);
        shape3D.setGeometry((Geometry)this.createSideGeom(fArray9, fArray10));
        shapeBackground.addShape(shape3D);
        float[] fArray11 = new float[]{-0.62f, -0.62f, -0.62f, -0.62f, -0.62f, 0.62f, 0.62f, -0.62f, 0.62f, 0.62f, -0.62f, -0.62f};
        float[] fArray12 = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        textureUnitArray[0] = new TextureUnit();
        textureUnitArray[0].setTextureAttributes(textureAttributes);
        appearance = new Appearance();
        appearance.setTextureUnits(textureUnitArray, 1);
        appearance.setVisible(false);
        appearance.setBlendAttributes(blendAttributes);
        appearance.setMaterial(this.backgroundMaterial);
        this.backgroundAppearances[5] = appearance;
        this.bgAppVisibility[5] = false;
        shape3D = new Shape3D();
        shape3D.setAppearance(appearance);
        shape3D.setGeometry((Geometry)this.createSideGeom(fArray11, fArray12));
        shapeBackground.addShape(shape3D);
    }

    private VertexGeometry createSideGeom(float[] fArray, float[] fArray2) {
        QuadArray quadArray = new QuadArray();
        quadArray.setVertices(3, fArray, 4);
        quadArray.setNormals(fArray2);
        quadArray.setTextureCoordinates(BOX_TEX_COORD_TYPES, BOX_TEX_COORDS);
        return quadArray;
    }

    private boolean isSameMatrix(Matrix4f matrix4f, Matrix4f matrix4f2) {
        return matrix4f.m00 == matrix4f2.m00 && matrix4f.m01 == matrix4f2.m01 && matrix4f.m02 == matrix4f2.m02 && matrix4f.m03 == matrix4f2.m03 && matrix4f.m10 == matrix4f2.m10 && matrix4f.m11 == matrix4f2.m11 && matrix4f.m12 == matrix4f2.m12 && matrix4f.m13 == matrix4f2.m13 && matrix4f.m20 == matrix4f2.m20 && matrix4f.m21 == matrix4f2.m21 && matrix4f.m22 == matrix4f2.m22 && matrix4f.m23 == matrix4f2.m23 && matrix4f.m30 == matrix4f2.m30 && matrix4f.m31 == matrix4f2.m31 && matrix4f.m32 == matrix4f2.m32 && matrix4f.m33 == matrix4f2.m33;
    }

    static {
        BOX_TEX_COORDS = new float[][]{{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f}};
        BOX_TEX_COORD_TYPES = new int[]{2};
        COS_TABLE = new float[32];
        SIN_TABLE = new float[32];
        double d = 0.19634954084936207;
        for (int i = 0; i < 32; ++i) {
            GlobalEffectsGroup.COS_TABLE[i] = (float)Math.cos(d * (double)i + 1.5707963267948966);
            GlobalEffectsGroup.SIN_TABLE[i] = (float)Math.sin(d * (double)i + 1.5707963267948966);
        }
    }
}

