/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;
import org.ietf.uri.event.ProgressEvent;
import org.ietf.uri.event.ProgressListener;
import org.web3d.browser.BrowserCore;
import org.web3d.browser.ProfilingInfo;
import org.web3d.browser.ProfilingListener;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.scripting.external.sai.StatusListenerMulticaster;
import org.xj3d.sai.Xj3DStatusListener;

class StatusAdapter
implements ProfilingListener,
ProgressListener {
    private static final String LOAD_STARTED_MSG = "Load Started";
    private static final String LOADING_MSG = "Loading";
    private static final String LOAD_COMPLETE_MSG = "Load Complete";
    private BrowserCore browserCore;
    private ErrorReporter errorReporter;
    private Xj3DStatusListener statusListener;

    StatusAdapter(BrowserCore browserCore, ErrorReporter errorReporter) {
        this.browserCore = browserCore;
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
        browserCore.addProfilingListener(this);
        ResourceConnection.addGlobalProgressListener((ProgressListener)this);
    }

    public void profilingDataChanged(ProfilingInfo profilingInfo) {
        this.statusListener.updateFramesPerSecond(this.browserCore.getCurrentFrameRate());
    }

    public void connectionEstablished(ProgressEvent progressEvent) {
        this.statusListener.updateStatusMessage(progressEvent.getMessage());
    }

    public void handshakeInProgress(ProgressEvent progressEvent) {
        this.statusListener.updateStatusMessage(progressEvent.getMessage());
    }

    public void downloadStarted(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        if (resourceConnection != null) {
            URI uRI = resourceConnection.getURI();
            String string = uRI.toExternalForm();
            this.statusListener.progressUpdate(string, LOAD_STARTED_MSG, 0.0f);
        }
        this.statusListener.updateStatusMessage(progressEvent.getMessage());
    }

    public void downloadUpdate(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        if (resourceConnection != null) {
            String string = resourceConnection.getURI().toExternalForm();
            if (this.isFile(resourceConnection)) {
                float f = resourceConnection.getContentLength();
                float f2 = progressEvent.getValue();
                float f3 = 100.0f * f2 / f;
                this.statusListener.progressUpdate(string, LOADING_MSG, f3);
            }
        }
    }

    public void downloadEnded(ProgressEvent progressEvent) {
        ResourceConnection resourceConnection = progressEvent.getSource();
        if (resourceConnection != null) {
            String string = resourceConnection.getURI().toExternalForm();
            String string2 = string + " complete.";
            this.statusListener.updateStatusMessage(string2);
            this.statusListener.progressUpdate(string, LOAD_COMPLETE_MSG, 100.0f);
            this.errorReporter.messageReport(string2);
        }
    }

    public void downloadError(ProgressEvent progressEvent) {
        this.statusListener.updateStatusMessage(progressEvent.getMessage());
        this.errorReporter.errorReport(progressEvent.getMessage(), null);
    }

    void sendStatusMessage(String string) {
        this.statusListener.updateStatusMessage(string);
    }

    void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter == null ? DefaultErrorReporter.getDefaultReporter() : errorReporter;
    }

    void shutdown() {
        ResourceConnection.removeGlobalProgressListener((ProgressListener)this);
    }

    void addStatusListener(Xj3DStatusListener xj3DStatusListener) {
        this.statusListener = StatusListenerMulticaster.add(this.statusListener, xj3DStatusListener);
    }

    void removeStatusListener(Xj3DStatusListener xj3DStatusListener) {
        this.statusListener = StatusListenerMulticaster.remove(this.statusListener, xj3DStatusListener);
    }

    private boolean isFile(ResourceConnection resourceConnection) {
        boolean bl = false;
        if (resourceConnection != null) {
            URI uRI = resourceConnection.getURI();
            String string = uRI.toExternalForm();
            bl = URI.getScheme((String)string).equals("file");
        }
        return bl;
    }
}

