/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.scripting.external.sai;

import java.awt.image.RenderedImage;
import java.awt.image.WritableRenderedImage;
import org.web3d.util.SFImageUtils;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.scripting.external.buffer.ExternalEvent;
import org.web3d.vrml.scripting.external.buffer.ExternalEventQueue;
import org.web3d.vrml.scripting.external.buffer.ExternalOutputBuffer;
import org.web3d.vrml.scripting.external.sai.BaseFieldWrapper;
import org.web3d.vrml.scripting.external.sai.SAIEventAdapterFactory;
import org.web3d.x3d.sai.InvalidFieldException;
import org.web3d.x3d.sai.InvalidFieldValueException;
import org.web3d.x3d.sai.InvalidOperationTimingException;
import org.web3d.x3d.sai.InvalidWritableFieldException;
import org.web3d.x3d.sai.SFImage;

class SFImageWrapper
extends BaseFieldWrapper
implements SFImage,
ExternalEvent,
ExternalOutputBuffer {
    boolean isSetOneValue;
    int[] storedInputValue;
    int[] storedOutputValue;

    SFImageWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory) {
        super(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
    }

    SFImageWrapper(VRMLNodeType vRMLNodeType, int n, ExternalEventQueue externalEventQueue, SAIEventAdapterFactory sAIEventAdapterFactory, boolean bl) {
        this(vRMLNodeType, n, externalEventQueue, sAIEventAdapterFactory);
        if (bl) {
            this.loadInputValue();
        } else {
            this.loadOutputValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doEvent() {
        try {
            this.theNode.setValue(this.fieldIndex, this.storedInputValue, this.storedInputValue.length);
        }
        finally {
            this.storedInput = false;
            this.isSetOneValue = false;
        }
    }

    public int getComponents() {
        if (this.storedOutput) {
            return this.storedOutputValue[2];
        }
        this.checkReadAccess();
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (vRMLFieldData.intArrayValue != null) {
            return vRMLFieldData.intArrayValue[2];
        }
        return 0;
    }

    public int getHeight() {
        if (this.storedOutput) {
            return this.storedOutputValue[1];
        }
        this.checkReadAccess();
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (vRMLFieldData.intArrayValue != null) {
            return vRMLFieldData.intArrayValue[1];
        }
        return 0;
    }

    public WritableRenderedImage getImage() {
        this.checkReadAccess();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = this.getComponents();
        int[] nArray = new int[n * n2];
        this.getPixels(nArray);
        return SFImageUtils.convertDataToRenderedImage(n, n2, n3, nArray);
    }

    public void getPixels(int[] nArray) {
        if (this.storedOutput) {
            int n = this.storedOutputValue[0] * this.storedOutputValue[1];
            if (n > 0) {
                System.arraycopy(this.storedOutputValue, 3, nArray, 0, n);
            }
        } else {
            int n;
            this.checkReadAccess();
            VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
            if (vRMLFieldData.intArrayValue != null && (n = vRMLFieldData.intArrayValue[0] * vRMLFieldData.intArrayValue[1]) > 0) {
                System.arraycopy(vRMLFieldData.intArrayValue, 3, nArray, 0, n);
            }
        }
    }

    public int getWidth() {
        if (this.storedOutput) {
            return this.storedOutputValue[0];
        }
        this.checkReadAccess();
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (vRMLFieldData.intArrayValue != null) {
            return vRMLFieldData.intArrayValue[0];
        }
        return 0;
    }

    public void initialize(VRMLNodeType vRMLNodeType, int n) {
        this.theNode = vRMLNodeType;
        this.fieldIndex = n;
    }

    public boolean isConglomerating() {
        return false;
    }

    private void loadInputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        if (this.storedInputValue == null || this.storedInputValue.length < vRMLFieldData.numElements) {
            this.storedInputValue = new int[vRMLFieldData.numElements];
        }
        System.arraycopy(vRMLFieldData.intArrayValue, 0, this.storedInputValue, 0, vRMLFieldData.numElements);
        this.storedInput = true;
    }

    public void loadOutputValue() {
        VRMLFieldData vRMLFieldData = this.theNode.getFieldValue(this.fieldIndex);
        int n = vRMLFieldData.intArrayValue[0];
        int n2 = vRMLFieldData.intArrayValue[1];
        if (this.storedOutputValue == null || this.storedOutputValue.length < vRMLFieldData.numElements) {
            this.storedOutputValue = new int[vRMLFieldData.numElements];
        }
        System.arraycopy(vRMLFieldData.intArrayValue, 0, this.storedOutputValue, 0, vRMLFieldData.numElements);
        this.storedOutput = true;
    }

    public void reset() {
        this.theNode = null;
        this.fieldIndex = -1;
        this.storedOutput = false;
    }

    public void setImage(RenderedImage renderedImage) throws InvalidOperationTimingException, InvalidFieldValueException, InvalidWritableFieldException, InvalidFieldException {
        this.checkWriteAccess();
        int n = renderedImage.getHeight() * renderedImage.getWidth() + 3;
        SFImageWrapper sFImageWrapper = this;
        if (sFImageWrapper.storedInput) {
            sFImageWrapper = new SFImageWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        if (sFImageWrapper.storedInputValue == null || sFImageWrapper.storedInputValue.length != n) {
            sFImageWrapper.storedInputValue = new int[n];
        }
        SFImageUtils.convertRenderedImageToData(renderedImage, sFImageWrapper.storedInputValue, 0);
        sFImageWrapper.storedInput = true;
        this.theEventQueue.processEvent(sFImageWrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSubImage(RenderedImage renderedImage, int n, int n2, int n3, int n4, int n5, int n6) throws InvalidOperationTimingException, InvalidFieldValueException, InvalidWritableFieldException, InvalidFieldException {
        this.checkWriteAccess();
        Object object = this.theEventQueue.eventLock;
        synchronized (object) {
            SFImageWrapper sFImageWrapper = (SFImageWrapper)this.theEventQueue.getLast(this);
            if (sFImageWrapper == null || !sFImageWrapper.isSetOneValue) {
                if (!this.storedInput && !this.storedOutput) {
                    sFImageWrapper = this;
                    this.loadInputValue();
                    this.isSetOneValue = true;
                } else {
                    sFImageWrapper = new SFImageWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
                }
            }
            sFImageWrapper.loadInputValue();
            if (sFImageWrapper.getComponents() != renderedImage.getColorModel().getNumComponents() || sFImageWrapper.getWidth() < n || sFImageWrapper.getHeight() < n2) {
                sFImageWrapper.storedInput = false;
                throw new IllegalArgumentException("Subimage either too large or differs in components");
            }
            SFImageUtils.convertSubRenderedImageToData(renderedImage, sFImageWrapper.storedInputValue, 0, n, n2, n3, n4, n5, n6);
            this.theEventQueue.processEvent(sFImageWrapper);
        }
    }

    public void setValue(int n, int n2, int n3, int[] nArray) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid width");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid height");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Invalid components");
        }
        this.checkWriteAccess();
        SFImageWrapper sFImageWrapper = this;
        if (this.storedInput || this.storedOutput) {
            sFImageWrapper = new SFImageWrapper(this.theNode, this.fieldIndex, this.theEventQueue, this.theEventAdapterFactory);
        }
        sFImageWrapper.storedInput = true;
        if (sFImageWrapper.storedInputValue == null || sFImageWrapper.storedInputValue.length != n * n2 + 3) {
            sFImageWrapper.storedInputValue = new int[n * n2 + 3];
        }
        if (sFImageWrapper.storedInputValue.length > 3) {
            System.arraycopy(nArray, 0, sFImageWrapper.storedInputValue, 3, n * n2);
        }
        sFImageWrapper.storedInputValue[0] = n;
        sFImageWrapper.storedInputValue[1] = n2;
        sFImageWrapper.storedInputValue[2] = n3;
        this.theEventQueue.processEvent(sFImageWrapper);
    }
}

